/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.placeholder;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.api.data.CollectionData;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import gg.auroramc.collections.config.ConfigManager;
import gg.auroramc.collections.config.menu.CollectionMenuConfig;
import gg.auroramc.collections.util.RomanNumber;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.entity.Player;

public class CollectionsPlaceholderHandler
implements PlaceholderHandler {
    private final AuroraCollections plugin;

    public CollectionsPlaceholderHandler(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "collections";
    }

    public String onPlaceholderRequest(Player player, String[] args) {
        if (args.length < 3) {
            return null;
        }
        CollectionManager manager = this.plugin.getCollectionManager();
        ConfigManager config = this.plugin.getConfigManager();
        List<Collection> allCollections = manager.getAllCollections();
        long unlockedCollections = allCollections.stream().filter(c -> c.isUnlocked(player)).count();
        int totalCollections = allCollections.size();
        double unlockedPercent = totalCollections > 0 ? (double)unlockedCollections / (double)totalCollections : 0.0;
        CollectionMenuConfig.ProgressBar bar = config.getCategoriesMenuConfig().getProgressBar();
        Integer pcs = bar.getLength();
        int completedPcs = (int)Math.floor((double)pcs.intValue() * unlockedPercent);
        int remainingPcs = pcs - completedPcs;
        Boolean romanNumeral = config.getCollectionMenuConfig().getForceRomanNumerals();
        String full = String.join((CharSequence)"_", args);
        if (args[0].equals("category")) {
            if (full.endsWith("completed_percent_raw")) {
                String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - 3));
                return String.valueOf(manager.getCategoryCompletionPercent(category, player));
            }
            if (full.endsWith("completed_percent")) {
                String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - 2));
                return AuroraAPI.formatNumber((double)(manager.getCategoryCompletionPercent(category, player) * 100.0));
            }
            if (full.endsWith("level_raw")) {
                String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - 2));
                return String.valueOf(manager.getCategoryLevel(category, player));
            }
            if (full.endsWith("max_level")) {
                String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - 2));
                int maxLevel = manager.getMaxCategoryLevel(category);
                return romanNumeral != false ? RomanNumber.toRoman(Long.valueOf(maxLevel)) : AuroraAPI.formatNumber((long)maxLevel);
            }
            if (full.endsWith("level")) {
                String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - 1));
                int level = manager.getCategoryLevel(category, player);
                return romanNumeral != false ? RomanNumber.toRoman(Long.valueOf(level)) : AuroraAPI.formatNumber((long)level);
            }
            if (full.endsWith("count_raw")) {
                return String.valueOf(this.getCategoryCount(player, args, 2));
            }
            if (full.endsWith("count_short")) {
                return AuroraAPI.formatNumberShort((double)this.getCategoryCount(player, args, 2));
            }
            if (full.endsWith("count")) {
                return AuroraAPI.formatNumber((double)this.getCategoryCount(player, args, 1));
            }
        } else {
            if (full.endsWith("next_count_raw")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 3));
                if (collection == null) {
                    return null;
                }
                long nextCount = collection.getRequiredAmount(collection.getPlayerLevel(player) + 1);
                return String.valueOf(nextCount);
            }
            if (full.endsWith("next_count")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 2));
                if (collection == null) {
                    return null;
                }
                long nextCount = collection.getRequiredAmount(collection.getPlayerLevel(player) + 1);
                return AuroraAPI.formatNumber((long)nextCount);
            }
            if (full.endsWith("count_raw")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 2));
                if (collection == null) {
                    return null;
                }
                Long count = ((CollectionData)AuroraAPI.getUserManager().getUser(player).getData(CollectionData.class)).getCollectionCount(collection.getCategory(), collection.getId());
                return String.valueOf(count);
            }
            if (full.endsWith("count")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 1));
                if (collection == null) {
                    return null;
                }
                Long count = ((CollectionData)AuroraAPI.getUserManager().getUser(player).getData(CollectionData.class)).getCollectionCount(collection.getCategory(), collection.getId());
                return AuroraAPI.formatNumber((long)count);
            }
            if (full.endsWith("level_raw")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 2));
                if (collection == null) {
                    return null;
                }
                return String.valueOf(collection.getPlayerLevel(player));
            }
            if (full.endsWith("level")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 1));
                if (collection == null) {
                    return null;
                }
                int level = collection.getPlayerLevel(player);
                return romanNumeral != false ? RomanNumber.toRoman(Long.valueOf(level)) : AuroraAPI.formatNumber((long)level);
            }
            if (full.endsWith("name")) {
                Collection collection = this.getCollection(Arrays.copyOf(args, args.length - 1));
                if (collection == null) {
                    return null;
                }
                return collection.getConfig().getName();
            }
            if (args[0].equals("unlocked")) {
                if (full.endsWith("count_total")) {
                    return AuroraAPI.formatNumber((long)unlockedCollections);
                }
                if (full.endsWith("count_total_all_collection")) {
                    return AuroraAPI.formatNumber((long)totalCollections);
                }
                if (full.endsWith("total_progressbar")) {
                    return bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r";
                }
                if (full.endsWith("total_percent")) {
                    return AuroraAPI.formatNumber((double)(unlockedPercent * 100.0));
                }
            }
        }
        return null;
    }

    private double getCategoryCount(Player player, String[] args, int length) {
        String category = String.join((CharSequence)"_", Arrays.copyOfRange(args, 1, args.length - length));
        AuroraUser user = AuroraAPI.getUserManager().getUser(player);
        return this.plugin.getCollectionManager().getCollectionsByCategory(category).stream().mapToDouble(collection -> ((CollectionData)user.getData(CollectionData.class)).getCollectionCount(collection.getCategory(), collection.getId()).longValue()).sum();
    }

    public Collection getCollection(String[] args) {
        CollectionManager manager = this.plugin.getCollectionManager();
        if (manager.getCollection(args[0], args[1]) != null) {
            return manager.getCollection(args[0], args[1]);
        }
        for (int i = 0; i < args.length; ++i) {
            String id;
            String category = String.join((CharSequence)"_", Arrays.copyOf(args, i));
            if (manager.getCollection(category, id = String.join((CharSequence)"_", Arrays.copyOfRange(args, i, args.length))) == null) continue;
            return manager.getCollection(category, id);
        }
        return null;
    }

    public List<String> getPatterns() {
        CollectionManager manager = this.plugin.getCollectionManager();
        return Stream.concat(manager.getAllCollections().stream().flatMap(c -> Stream.of("category_" + c.getCategory() + "_level", "category_" + c.getCategory() + "_level_raw", "category_" + c.getCategory() + "_max_level", "category_" + c.getCategory() + "_completed_percent", "category_" + c.getCategory() + "_completed_percent_raw", c.getCategory() + "_" + c.getId() + "_name", c.getCategory() + "_" + c.getId() + "_level", c.getCategory() + "_" + c.getId() + "_level_raw", c.getCategory() + "_" + c.getId() + "_count", c.getCategory() + "_" + c.getId() + "_count_raw", c.getCategory() + "_" + c.getId() + "_next_count", c.getCategory() + "_" + c.getId() + "_next_count_raw")), Stream.of("unlocked_count_total", "unlocked_count_total_all_collection", "unlocked_total_progressbar", "unlocked_total_percent")).toList();
    }

    public record Pair(String category, String id) {
    }
}

