/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.collections.reward.corrector;

import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.CommandReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.collections.AuroraCollections;
import gg.auroramc.collections.collection.Collection;
import gg.auroramc.collections.collection.CollectionManager;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandCorrector
implements RewardCorrector {
    private final AuroraCollections plugin;

    public CommandCorrector(AuroraCollections plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        CollectionManager manager = this.plugin.getCollectionManager();
        HashMap<Integer, CommandPair> rewards = new HashMap<Integer, CommandPair>();
        for (Collection collection : manager.getAllCollections()) {
            int level = collection.getPlayerLevel(player);
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = collection.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                for (Reward reward : matcher.computeRewards(i)) {
                    CommandReward commandReward;
                    if (!(reward instanceof CommandReward) || !(commandReward = (CommandReward)reward).shouldBeCorrected(player, (long)i)) continue;
                    rewards.put(i, new CommandPair(commandReward, collection.getPlaceholders(player, i)));
                }
            }
        }
        if (rewards.isEmpty()) {
            return;
        }
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, task -> {
            rewards.forEach((lvl, reward) -> {
                if (!player.isOnline()) {
                    return;
                }
                reward.reward().execute(player, (long)lvl.intValue(), reward.placeholders());
            });
            AuroraCollections.logger().debug("Corrected %d command rewards for player %s".formatted(rewards.size(), player.getName()));
        });
    }

    private record CommandPair(CommandReward reward, List<Placeholder<?>> placeholders) {
    }
}

