/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.config.OreClusterConfig;
import com.holybuckets.orecluster.config.OreClusterConfigData;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.config.model.OreClusterJsonConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class ModRealTimeConfig {
    public static final String CLASS_ID = "000";
    private static final Set<class_1936> levelInit = new HashSet<class_1936>();
    private OreClusterConfigModel defaultConfig;
    private Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> oreConfigs;
    private List<OreClusterConfigModel> baseOreConfigs;
    private Map<String, OreClusterConfigModel.OreClusterId> baseConfigIds;
    private Set<class_2680> validOreClusterBlocks;
    public static final Integer CHUNK_NORMALIZATION_TOTAL = 1000;
    public static final Function<Integer, Double> CHUNK_DISTRIBUTION_STDV_FUNC = mean -> {
        if (mean < 8) {
            return (double)mean.intValue() / 2.0;
        }
        return (double)mean.intValue() / (Math.log(mean.intValue()) * 3.0);
    };
    public static final Integer ORE_CLUSTER_DTRM_BATCH_SIZE_TOTAL = 1000;
    public static final Integer ORE_CLUSTER_DTRM_RADIUS_STRATEGY_CHANGE = 128;
    public static Long CLUSTER_SEED = null;

    public ModRealTimeConfig(EventRegistrar reg) {
        reg.registerOnBeforeServerStarted(this::onBeforeServerStart, EventPriority.High);
        reg.registerOnLevelLoad(this::onLevelLoad, EventPriority.High);
        reg.registerOnServerStopped(this::onServerStopped, EventPriority.Low);
        this.oreConfigs = new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>();
        this.baseConfigIds = new HashMap<String, OreClusterConfigModel.OreClusterId>();
        this.baseOreConfigs = new ArrayList<OreClusterConfigModel>();
        this.validOreClusterBlocks = new HashSet<class_2680>();
        LoggerProject.logInit("000000", this.getClass().getName());
    }

    public void onBeforeServerStart(ServerStartingEvent event) {
        this.oreConfigs = new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>();
        this.baseConfigIds = new HashMap<String, OreClusterConfigModel.OreClusterId>();
        this.baseOreConfigs = new ArrayList<OreClusterConfigModel>();
        this.validOreClusterBlocks = new HashSet<class_2680>();
        OreClusterConfigData.COreClusters clusterConfig = OreClusterConfig.getActive().cOreClusters;
        this.defaultConfig = new OreClusterConfigModel(clusterConfig);
        this.defaultConfig.setConfigId();
        File configFile = new File(clusterConfig.oreClusterFileConfigPath);
        File defaultConfigFile = new File("config/HBOreClustersAndRegenConfigs.json");
        String jsonOreConfigData = HBUtil.FileIO.loadJsonConfigs((File)configFile, (File)defaultConfigFile, (IStringSerializable)OreClusterJsonConfig.DEFAULT_CONFIG);
        OreClusterJsonConfig jsonOreConfigs = new OreClusterJsonConfig(jsonOreConfigData);
        for (class_2248 validOreClusterBlock : this.defaultConfig.validOreClusterOreBlocks.stream().toList()) {
            this.defaultConfig.setOreClusterType(validOreClusterBlock.method_9564());
            OreClusterConfigModel oreConfig = new OreClusterConfigModel(OreClusterConfigModel.serialize(this.defaultConfig));
            this.baseOreConfigs.add(oreConfig);
        }
        this.defaultConfig.setOreClusterType((class_2680)null);
        if (!jsonOreConfigs.getOreClusterConfigs().isEmpty()) {
            this.baseOreConfigs.clear();
        }
        for (OreClusterConfigModel oreConfig : jsonOreConfigs.getOreClusterConfigs()) {
            oreConfig.setConfigId();
            this.baseOreConfigs.add(oreConfig);
        }
        this.validateClusterSpacingAndMinBlocks();
        CLUSTER_SEED = this.defaultConfig.subSeed != null ? this.defaultConfig.subSeed : GeneralConfig.getInstance().getWorldSeed();
        OreClusterJsonConfig newJsonOreConfigs = new OreClusterJsonConfig(this.baseOreConfigs);
        HBUtil.FileIO.serializeJsonConfigs((File)configFile, (String)newJsonOreConfigs.serialize());
    }

    private void onLevelLoad(LevelLoadingEvent.Load event) {
        if (!(event.getLevel() instanceof class_3218)) {
            return;
        }
        if (levelInit.contains(event.getLevel())) {
            return;
        }
        class_3218 level = (class_3218)event.getLevel();
        List<OreClusterConfigModel> levelConfigs = this.baseOreConfigs.stream().filter(model -> model.inLevel((class_1936)level)).toList();
        for (OreClusterConfigModel config : levelConfigs) {
            this.baseConfigIds.put(config.configId, OreClusterConfigModel.OreClusterId.createBaseConfigId(config));
            this.oreConfigs.put(this.baseConfigIds.get(config.configId), config);
            List<OreClusterConfigModel.OreClusterId> ids = OreClusterConfigModel.getIds(level, config);
            ids.forEach(id -> this.oreConfigs.put((OreClusterConfigModel.OreClusterId)id, config));
            this.validOreClusterBlocks.add(config.oreClusterType);
        }
        levelInit.add((class_1936)level);
    }

    private void onServerStopped(ServerStoppedEvent event) {
        levelInit.clear();
        OreClusterConfigModel.OreClusterId.shutdown();
        this.oreConfigs.clear();
        this.baseConfigIds.clear();
        this.baseOreConfigs.clear();
        this.validOreClusterBlocks.clear();
    }

    public List<OreClusterConfigModel> getBaseOreConfigs() {
        return this.baseOreConfigs;
    }

    public Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> getOreConfigs() {
        return new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>(this.oreConfigs);
    }

    @Nullable
    public OreClusterConfigModel getOreConfigByOre(class_2960 ore) {
        OreClusterConfigModel.OreClusterId id = OreClusterConfigModel.OreClusterId.getId(null, null, ore);
        return this.oreConfigs.get(id);
    }

    public List<OreClusterConfigModel> getAllOreConfigByOre(class_2248 b) {
        HashSet<OreClusterConfigModel> configs = new HashSet<OreClusterConfigModel>();
        for (OreClusterConfigModel config : this.baseOreConfigs) {
            if (config.oreClusterType == null || !config.oreClusterType.equals(b.method_9564())) continue;
            configs.add(config);
        }
        return configs.stream().toList();
    }

    public OreClusterConfigModel getOreConfigModel(OreClusterConfigModel.OreClusterId id) {
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel.OreClusterId getOreConfigId(class_1937 l, class_1959 b, class_2248 bl) {
        return OreClusterConfigModel.OreClusterId.getId(l, b, bl);
    }

    public OreClusterConfigModel.OreClusterId getOreConfigId(int id) {
        if (this.oreConfigs == null) {
            return null;
        }
        for (OreClusterConfigModel.OreClusterId oreId : this.oreConfigs.keySet()) {
            if (oreId.getId() != id) continue;
            return oreId;
        }
        return null;
    }

    public OreClusterConfigModel getBaseOreConfig(String configId) {
        for (OreClusterConfigModel config : this.baseOreConfigs) {
            if (!config.configId.equals(configId)) continue;
            return config;
        }
        return null;
    }

    public OreClusterConfigModel.OreClusterId getBaseOreConfigId(String configId) {
        return this.baseConfigIds.get(configId);
    }

    public Set<OreClusterConfigModel.OreClusterId> getAllOreConfigIdsByOre(class_2248 b) {
        return this.oreConfigs.keySet().stream().filter(id -> id.filter(b)).collect(Collectors.toSet());
    }

    public Set<OreClusterConfigModel.OreClusterId> getAllOreConfigIdsByBiome(class_1937 l, class_1959 b) {
        return this.oreConfigs.keySet().stream().filter(id -> id.filter(l, b)).collect(Collectors.toSet());
    }

    public OreClusterConfigModel getDefaultConfigModel() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(OreClusterConfigModel defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    private void validateClusterSpacingAndMinBlocks() {
        int totalSpawnRatePerAreaSquared = 0;
        for (OreClusterConfigModel oreConfig : this.baseOreConfigs) {
            totalSpawnRatePerAreaSquared += oreConfig.oreClusterSpawnRate.intValue();
        }
        int reservedBlocksSquaredPerCluster = (int)Math.pow(this.defaultConfig.minChunksBetweenOreClusters.intValue(), 2.0);
        if (reservedBlocksSquaredPerCluster == 0 || totalSpawnRatePerAreaSquared == 0) {
            return;
        }
        int maxClustersPerAreaSquared = CHUNK_NORMALIZATION_TOTAL / reservedBlocksSquaredPerCluster;
        if (totalSpawnRatePerAreaSquared > maxClustersPerAreaSquared) {
            int newMinChunks = (int)Math.sqrt(CHUNK_NORMALIZATION_TOTAL / totalSpawnRatePerAreaSquared);
            StringBuilder warn = new StringBuilder();
            warn.append("The net ore cluster spawn rate exceeds the expected maximum number of clusters in a ");
            warn.append(CHUNK_NORMALIZATION_TOTAL);
            warn.append(" square chunk area: ");
            warn.append(maxClustersPerAreaSquared);
            warn.append(" square chunks alloted by ");
            warn.append(this.defaultConfig.minChunksBetweenOreClusters);
            warn.append(" chunks between clusters. While ");
            warn.append(totalSpawnRatePerAreaSquared);
            warn.append(" clusters are would be observed on average. minClustersBetweenChunks reduced to ");
            this.defaultConfig.minChunksBetweenOreClusters = (int)Math.sqrt(newMinChunks) - 1;
            warn.append(this.defaultConfig.minChunksBetweenOreClusters);
        }
    }

    public OreClusterConfigModel getOreConfig(class_1937 l, class_1959 b, class_2248 bl) {
        OreClusterConfigModel.OreClusterId id = OreClusterConfigModel.OreClusterId.getId(l, b, bl);
        if (id == null) {
            return null;
        }
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel getOreConfig(OreClusterConfigModel.OreClusterId id) {
        if (id == null) {
            return null;
        }
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel getOreConfig(int id) {
        OreClusterConfigModel.OreClusterId oreId = this.getOreConfigId(id);
        if (oreId == null) {
            return null;
        }
        return this.oreConfigs.get(oreId);
    }

    public boolean testValidYSpawn(OreClusterConfigModel config, int sectionY) {
        if (config == null) {
            return true;
        }
        class_2338 pos = new class_2338(0, sectionY * 16 + 8, 0);
        return ModRealTimeConfig.testValidYSpawn(config, pos);
    }

    public boolean testValidYSpawn(OreClusterConfigModel.OreClusterId id, int sectionY) {
        if (id == null || !this.oreConfigs.containsKey(id)) {
            return false;
        }
        return this.testValidYSpawn(this.oreConfigs.get(id), sectionY);
    }

    public static boolean testValidYSpawn(OreClusterConfigModel config, class_2338 pos) {
        if (config == null) {
            return true;
        }
        if (config.oreClusterMaxYLevelSpawn == null) {
            return true;
        }
        if (pos.method_10264() > config.oreClusterMaxYLevelSpawn) {
            return false;
        }
        return pos.method_10264() >= config.oreClusterMinYLevelSpawn;
    }

    public boolean clustersDoSpawn(class_1937 l, class_1959 b, class_2680 state) {
        return ModRealTimeConfig.clustersDoSpawn(this.getOreConfig(l, b, state.method_26204()));
    }

    public static boolean clustersDoSpawn(OreClusterConfigModel config) {
        if (config == null) {
            return false;
        }
        return config.oreClusterSpawnRate > 0;
    }

    public static boolean doesLevelMatch(OreClusterConfigModel config, class_1936 level) {
        if (config == null) {
            return false;
        }
        if (config.oreClusterDimensionId == null) {
            return false;
        }
        if (level == null) {
            return false;
        }
        class_1937 oreLevel = HBUtil.LevelUtil.toLevel((HBUtil.LevelUtil.LevelNameSpace)HBUtil.LevelUtil.LevelNameSpace.SERVER, (String)config.oreClusterDimensionId);
        return level.equals(oreLevel);
    }

    public boolean clustersDoSpawn(OreClusterConfigModel.OreClusterId id) {
        if (id == null) {
            return false;
        }
        OreClusterConfigModel config = this.oreConfigs.get(id);
        return ModRealTimeConfig.clustersDoSpawn(config);
    }

    public boolean doesLevelMatch(OreClusterConfigModel.OreClusterId id, class_1936 level) {
        if (id == null) {
            return false;
        }
        OreClusterConfigModel config = this.oreConfigs.get(id);
        return ModRealTimeConfig.doesLevelMatch(config, level);
    }

    public boolean maybeHasBlock(class_2680 defaultState) {
        return this.validOreClusterBlocks.contains(defaultState);
    }
}

