/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster;

import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.command.CommandList;
import com.holybuckets.orecluster.config.OreClusterConfig;
import com.holybuckets.orecluster.core.OreClusterApi;
import com.holybuckets.orecluster.core.OreClusterBlockStateTracker;
import com.holybuckets.orecluster.core.OreClusterHealthCheck;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.OreClusterRegenManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import java.util.Map;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;

public class OreClustersAndRegenMain {
    public static final String CLASS_ID = "001";
    public static final String MODID = "hbs_ore_cluster_and_regen";
    public static final String NAME = "HBs Ore Clusters and Regen";
    public static final String VERSION = "1.0.0f";
    public static final Boolean DEBUG = false;
    public static OreClustersAndRegenMain INSTANCE;
    public ModRealTimeConfig modRealTimeConfig;
    public Map<class_1936, OreClusterManager> oreClusterManagers;
    public OreClusterRegenManager regenManager;
    public OreClusterApi oreClusterApi;
    public OreClusterHealthCheck oreClusterHealthCheck;

    public OreClustersAndRegenMain() {
        this.init();
        INSTANCE = this;
        LoggerProject.logInit("001000", this.getClass().getName());
    }

    private void init() {
        OreClusterConfig.initialize();
        ManagedOreClusterChunk.registerManagedChunkData();
        CommandList.register();
        EventRegistrar eventRegistrar = EventRegistrar.getInstance();
        OreClusterManager.init(eventRegistrar);
        this.oreClusterManagers = OreClusterManager.MANAGERS;
        this.modRealTimeConfig = new ModRealTimeConfig(eventRegistrar);
        this.regenManager = new OreClusterRegenManager(eventRegistrar, this.modRealTimeConfig, this.oreClusterManagers);
        this.oreClusterApi = new OreClusterApi(this.oreClusterManagers, this.modRealTimeConfig, this.regenManager);
        this.oreClusterHealthCheck = new OreClusterHealthCheck(eventRegistrar, this.oreClusterApi, this.oreClusterManagers);
        eventRegistrar.registerOnLevelLoad(this::onLoadWorld, EventPriority.Normal);
        eventRegistrar.registerOnServerStopped(this::onServerStopped, EventPriority.Low);
        OreClusterBlockStateTracker.init(this.modRealTimeConfig);
    }

    public static Map<class_1936, OreClusterManager> getManagers() {
        return OreClustersAndRegenMain.INSTANCE.oreClusterManagers;
    }

    public void onLoadWorld(LevelLoadingEvent.Load event) {
        LoggerProject.logDebug("001003", "**** WORLD LOAD EVENT ****");
        class_1937 level = (class_1937)event.getLevel();
        if (level.method_8608()) {
            return;
        }
        if (!this.oreClusterManagers.containsKey(level)) {
            this.oreClusterManagers.put((class_1936)level, new OreClusterManager(level, this.modRealTimeConfig));
        }
    }

    public void onUnloadWorld(LevelLoadingEvent.Unload event) {
        LoggerProject.logDebug("001004", "**** WORLD UNLOAD EVENT ****");
    }

    public void onServerStopped(ServerStoppedEvent event) {
        LoggerProject.logDebug("001005", "**** SERVER STOPPED EVENT ****");
        for (OreClusterManager manager : this.oreClusterManagers.values()) {
            manager.shutdown();
        }
        this.oreClusterManagers.clear();
        this.regenManager.shutdown();
        this.oreClusterHealthCheck.shutdown();
    }
}

