/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.CommandRegistry;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.core.OreClusterApi;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.OreClusterInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandList {
    public static final String CLASS_ID = "010";
    private static final String PREFIX = "hbOreClusters";

    public static void register() {
        CommandRegistry.register(LocateClusters::noArgs);
        CommandRegistry.register(LocateClusters::limitCount);
        CommandRegistry.register(LocateClusters::limitCountSpecifyBlockType);
        CommandRegistry.register(GetConfig::noArgs);
        CommandRegistry.register(GetConfig::withConfigId);
        CommandRegistry.register(GetConfig::withConfigIdAndBiomes);
        CommandRegistry.register(AddCluster::register);
        CommandRegistry.register(TriggerRegen::register);
        CommandRegistry.register(HealthCheck::register);
    }

    private static String s(JsonObject object, String property) {
        if (!object.has(property) || object.get(property) == null || !object.get(property).isJsonPrimitive()) {
            return "null";
        }
        return object.getAsJsonPrimitive(property).getAsString();
    }

    private static class HealthCheck {
        private HealthCheck() {
        }

        private static LiteralArgumentBuilder<class_2168> register() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"healthCheck").executes(context -> HealthCheck.execute((class_2168)context.getSource(), null))).then(class_2170.method_9244((String)"dimensionId", (ArgumentType)StringArgumentType.string()).executes(context -> HealthCheck.execute((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"dimensionId")))));
        }

        private static int execute(class_2168 source, String dimensionId) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                source.method_9226(() -> class_2561.method_43470((String)"Health Check Results:"), true);
                List levelIds = GeneralConfig.getInstance().getLevels().keySet().stream().toList();
                if (dimensionId != null) {
                    class_1937 level = HBUtil.LevelUtil.toLevel((HBUtil.LevelUtil.LevelNameSpace)HBUtil.LevelUtil.LevelNameSpace.SERVER, (String)dimensionId);
                    if (level == null) {
                        source.method_9213((class_2561)class_2561.method_43470((String)("Dimension ID not found: " + dimensionId)));
                        source.method_9226(() -> class_2561.method_43470((String)("Available dimensions: \n  " + String.join((CharSequence)"\n  ", levelIds))), false);
                        return 1;
                    }
                    OreClusterManager manager = OreClusterManager.getManager((class_1936)level);
                    JsonObject healthCheck = api.healthCheckStatistics(manager);
                    if (healthCheck != null) {
                        source.method_9226(() -> class_2561.method_43470((String)("Statistics for dimension " + dimensionId + ":")), false);
                        source.method_9226(() -> class_2561.method_43470((String)healthCheck.toString()), false);
                        LoggerProject.logInfo("010012", healthCheck.toString());
                    }
                } else {
                    for (OreClusterManager manager : OreClustersAndRegenMain.getManagers().values()) {
                        JsonObject healthCheck;
                        if (manager == null || (healthCheck = api.healthCheckStatistics(manager)) == null) continue;
                        String levelId = HBUtil.LevelUtil.toLevelId((class_1936)manager.getLevel());
                        source.method_9226(() -> class_2561.method_43470((String)("Statistics for dimension " + levelId + ":")), false);
                        source.method_9226(() -> class_2561.method_43470((String)healthCheck.toString()), false);
                        LoggerProject.logInfo("010013", healthCheck.toString());
                    }
                }
                LoggerProject.logInfo("010011", "Health Check command completed successfully");
            }
            catch (Exception e) {
                LoggerProject.logError("010009", "Health Check Command exception: " + e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010010", "Health Check Command executed successfully");
            return 0;
        }
    }

    private static class AddCluster {
        private AddCluster() {
        }

        private static LiteralArgumentBuilder<class_2168> register() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"addCluster").then(class_2170.method_9244((String)"clusterConfigId", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> AddCluster.execute((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"clusterConfigId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), IntegerArgumentType.getInteger((CommandContext)context, (String)"y"), IntegerArgumentType.getInteger((CommandContext)context, (String)"z"))))))));
        }

        private static int execute(class_2168 source, String configId, int x, int y, int z) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                class_3222 player = source.method_9207();
                class_2338 pos = new class_2338(x, y, z);
                boolean success = api.addCluster((class_1936)player.method_37908(), configId, pos);
                if (!success) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Failed to add cluster, check logs for more info"));
                    return 1;
                }
                source.method_9226(() -> class_2561.method_43470((String)"Successfully added cluster"), true);
            }
            catch (Exception e) {
                LoggerProject.logError("010005", "Add Cluster Command exception: " + e.getMessage());
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to add cluster, check logs for more info"));
                return 1;
            }
            LoggerProject.logDebug("010006", "Add Cluster Command executed successfully");
            return 0;
        }
    }

    private static class TriggerRegen {
        private TriggerRegen() {
        }

        private static LiteralArgumentBuilder<class_2168> register() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"triggerRegen").executes(context -> TriggerRegen.execute((class_2168)context.getSource(), null, null))).then(class_2170.method_9244((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TriggerRegen.execute((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ"))))));
        }

        private static int execute(class_2168 source, Integer chunkX, Integer chunkZ) {
            block6: {
                try {
                    OreClusterApi api = OreClusterApi.getInstance();
                    if (api == null) {
                        source.method_9213((class_2561)class_2561.method_43470((String)"oreClusterApi not initialized at this time"));
                        return 1;
                    }
                    if (chunkX == null || chunkZ == null) {
                        api.triggerRegen();
                        source.method_9226(() -> class_2561.method_43470((String)"Global regeneration triggered"), true);
                        break block6;
                    }
                    class_3222 player = source.method_9207();
                    String chunkId = HBUtil.ChunkUtil.getId((int)chunkX, (int)chunkZ);
                    try {
                        api.triggerRegen((class_1936)player.method_37908(), chunkId);
                        source.method_9226(() -> class_2561.method_43470((String)("Regeneration triggered for chunk: " + chunkId)), true);
                    }
                    catch (Exception e) {
                        source.method_9213((class_2561)class_2561.method_43470((String)("Failed to trigger regeneration for chunk: " + chunkId)));
                        return 1;
                    }
                }
                catch (Exception e) {
                    LoggerProject.logError("010007", "Trigger Regen Command exception: " + e.getMessage());
                    return 1;
                }
            }
            LoggerProject.logDebug("010008", "Trigger Regen Command executed successfully");
            return 0;
        }
    }

    private static class GetConfig {
        private GetConfig() {
        }

        private static LiteralArgumentBuilder<class_2168> noArgs() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"config").executes(context -> GetConfig.execute((class_2168)context.getSource(), null, false)));
        }

        private static LiteralArgumentBuilder<class_2168> withConfigId() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"config").then(class_2170.method_9244((String)"configId", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String configId = StringArgumentType.getString((CommandContext)context, (String)"configId");
                return GetConfig.execute((class_2168)context.getSource(), configId, false);
            })));
        }

        private static LiteralArgumentBuilder<class_2168> withConfigIdAndBiomes() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"config").then(class_2170.method_9244((String)"configId", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"showBiomes", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
                String configId = StringArgumentType.getString((CommandContext)context, (String)"configId");
                boolean showBiomes = BoolArgumentType.getBool((CommandContext)context, (String)"showBiomes");
                return GetConfig.execute((class_2168)context.getSource(), configId, showBiomes);
            }))));
        }

        private static int execute(class_2168 source, String configId, boolean showBiomes) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                JsonObject config = api.getConfig(configId, showBiomes);
                if (config == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("No config found" + (String)(configId != null ? " for id: " + configId : ""))));
                    return 1;
                }
                String header = config.getAsJsonPrimitive("header").getAsString();
                source.method_45068((class_2561)class_2561.method_43470((String)header));
                for (JsonElement elem : config.getAsJsonArray("value")) {
                    JsonObject obj = elem.getAsJsonObject();
                    StringBuilder s = new StringBuilder(CommandList.s(obj, "header"));
                    for (String key : obj.keySet()) {
                        if (key.equals("header")) continue;
                        s.append("\n  ").append(key).append(": ").append(CommandList.s(obj, key));
                    }
                    s.append("\n");
                    source.method_45068((class_2561)class_2561.method_43470((String)s.toString()));
                }
                source.method_45068((class_2561)class_2561.method_43470((String)"---\n"));
                class_5250 response = class_2561.method_43470((String)"command /hbOreClusters config terminated succesfully: \n");
                source.method_9226(() -> response, true);
            }
            catch (Exception e) {
                LoggerProject.logError("010003", "Get Config Command exception: " + e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010004", "Get Config Command executed successfully");
            return 0;
        }
    }

    private static class LocateClusters {
        private LocateClusters() {
        }

        private static LiteralArgumentBuilder<class_2168> noArgs() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"locateClusters").executes(context -> LocateClusters.execute((class_2168)context.getSource(), -1, null)));
        }

        private static LiteralArgumentBuilder<class_2168> limitCount() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(class_2170.method_9247((String)"locateClusters").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                return LocateClusters.execute((class_2168)context.getSource(), count, null);
            })));
        }

        private static LiteralArgumentBuilder<class_2168> limitCountSpecifyBlockType() {
            return (LiteralArgumentBuilder)class_2170.method_9247((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"locateClusters").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"blockType", (ArgumentType)StringArgumentType.string()).executes(context -> {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                String blockType = StringArgumentType.getString((CommandContext)context, (String)"blockType");
                return LocateClusters.execute((class_2168)context.getSource(), count, blockType);
            })))).then(class_2170.method_9244((String)"blockType", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String blockType = StringArgumentType.getString((CommandContext)context, (String)"blockType");
                return LocateClusters.execute((class_2168)context.getSource(), -1, blockType);
            })));
        }

        private static int execute(class_2168 source, int count, String blockType) {
            OreClusterApi api = OreClusterApi.getInstance();
            if (api == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"oreClusterApi not initialized at this time"));
                return 1;
            }
            if (count == -1) {
                count = 5;
            }
            class_2248 block = null;
            if (blockType != null && !blockType.isEmpty() && ((block = HBUtil.BlockUtil.blockNameToBlock((String)blockType)) == null || block.equals(class_2246.field_10124))) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Invalid block type: " + blockType)));
                return 1;
            }
            try {
                class_3222 player = source.method_9207();
                class_2338 playerPos = player.method_24515();
                List<OreClusterInfo> data = api.locateOreClusters((class_1936)player.method_37908(), playerPos, block, count);
                class_5250 response = class_2561.method_43470((String)"Found Clusters: ");
                for (OreClusterInfo cluster : data) {
                    response.method_27693(LocateClusters.formatClusterMessage(cluster));
                }
                source.method_9226(() -> response, true);
            }
            catch (Exception e) {
                LoggerProject.logError((String)"010002", (String)"Locate Clusters Command exception: ", (String)e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010001", "Locate Clusters Command");
            return 0;
        }

        private static String formatClusterMessage(OreClusterInfo cluster) {
            String ore = HBUtil.BlockUtil.blockToString((class_2248)cluster.oreType.getBlock());
            ore = ore.substring(ore.lastIndexOf(":") + 1);
            String pos = HBUtil.BlockUtil.positionToString((class_2382)cluster.position);
            return "\n" + ore + " at " + pos;
        }

        private static Object getArgument(CommandContext<class_2168> context, String name, Class<?> type) {
            try {
                return context.getArgument(name, type);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

