/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.config.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class OreClusterJsonConfig
implements IStringSerializable {
    public static final String CLASS_ID = "006";
    public static final OreClusterJsonConfig DEFAULT_CONFIG = new OreClusterJsonConfig();
    private List<JsonObject> oreClusterConfigs;
    private static final Set<class_2680> baseListNonReplaceable = Set.of(OreClusterJsonConfig.bs(class_2246.field_10398), OreClusterJsonConfig.bs(class_2246.field_9987));

    private OreClusterJsonConfig() {
    }

    public OreClusterJsonConfig(List<OreClusterConfigModel> configs) {
        this.initFromMap(configs);
    }

    public OreClusterJsonConfig(String jsonString) {
        this.initDefaults();
        this.deserialize(jsonString);
    }

    public List<OreClusterConfigModel> getOreClusterConfigs() {
        ArrayList<OreClusterConfigModel> oreClusterConfigModels = new ArrayList<OreClusterConfigModel>();
        for (JsonObject clusterConfig : this.oreClusterConfigs) {
            try {
                oreClusterConfigModels.add(new OreClusterConfigModel(clusterConfig.toString()));
            }
            catch (Exception e) {
                LoggerProject.logError("006000", "Error getting OreClusterConfigs: " + e.getMessage());
            }
        }
        return oreClusterConfigModels;
    }

    private void initFromMap(List<OreClusterConfigModel> configs) {
        this.oreClusterConfigs = new ArrayList<JsonObject>();
        for (OreClusterConfigModel model : configs) {
            this.oreClusterConfigs.add(model.serializeJson());
        }
    }

    private static class_2680 bs(class_2248 b) {
        return b.method_9564();
    }

    private void initDefaults() {
        final OreClusterConfigModel IRON = new OreClusterConfigModel(class_2246.field_10212.method_9564());
        IRON.oreClusterSpawnRate = 8;
        IRON.oreClusterVolume = new HBUtil.TripleInt(16, 12, 16);
        IRON.oreClusterDensity = Float.valueOf(0.25f);
        IRON.oreClusterMaxYLevelSpawn = 64;
        IRON.oreClusterReplaceableEmptyBlocks = new ArrayList<class_2680>();
        IRON.oreClusterNonReplaceableBlocks = new HashSet<class_2680>(baseListNonReplaceable);
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10124));
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10566));
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10479));
        IRON.biomeWhitelist = Set.of(new class_2960("minecraft:plains"), new class_2960("minecraft:forest"), new class_2960("minecraft:dark_forest"), new class_2960("minecraft:sunflower_plains"), new class_2960("minecraft:flower_forest"), new class_2960("minecraft:birch_forest"), new class_2960("minecraft:old_growth_birch_forest"), new class_2960("minecraft:wooded_hills"), new class_2960("minecraft:wooded_mountains"), new class_2960("minecraft:taiga"), new class_2960("minecraft:old_growth_pine_taiga"), new class_2960("minecraft:old_growth_spruce_taiga"), new class_2960("minecraft:snowy_taiga"), new class_2960("minecraft:snowy_tundra"), new class_2960("minecraft:snowy_mountains"));
        IRON.oreClusterDimensionId = "overworld";
        final OreClusterConfigModel COAL = new OreClusterConfigModel(class_2246.field_10418.method_9564());
        COAL.oreClusterSpawnRate = 32;
        COAL.oreClusterVolume = new HBUtil.TripleInt(8, 8, 8);
        COAL.oreClusterShape = "SPHERE";
        COAL.oreClusterDensity = Float.valueOf(0.4f);
        COAL.oreClusterMaxYLevelSpawn = 64;
        COAL.oreClusterReplaceableEmptyBlocks = List.of(OreClusterJsonConfig.bs(class_2246.field_10340), OreClusterJsonConfig.bs(class_2246.field_10340), OreClusterJsonConfig.bs(class_2246.field_10124));
        COAL.oreClusterDoesRegenerate = false;
        COAL.oreClusterNonReplaceableBlocks = new HashSet<class_2680>(baseListNonReplaceable);
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10124));
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10566));
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10479));
        final OreClusterConfigModel DPSLT_DIAMOND = new OreClusterConfigModel(class_2246.field_29029.method_9564());
        DPSLT_DIAMOND.oreClusterSpawnRate = 2;
        DPSLT_DIAMOND.oreClusterVolume = new HBUtil.TripleInt(5, 4, 5);
        DPSLT_DIAMOND.oreClusterDensity = Float.valueOf(0.32f);
        DPSLT_DIAMOND.oreClusterMaxYLevelSpawn = -16;
        DPSLT_DIAMOND.oreClusterMinYLevelSpawn = -56;
        DPSLT_DIAMOND.oreClusterReplaceableEmptyBlocks = new ArrayList<class_2680>();
        DPSLT_DIAMOND.oreClusterReplaceableEmptyBlocks.add(class_2246.field_28888.method_9564());
        DPSLT_DIAMOND.oreClusterNonReplaceableBlocks = new HashSet<class_2680>(baseListNonReplaceable);
        DPSLT_DIAMOND.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10124));
        final OreClusterConfigModel DPSLT_LAPIS = new OreClusterConfigModel(class_2246.field_29028.method_9564());
        DPSLT_LAPIS.oreClusterSpawnRate = 10;
        DPSLT_LAPIS.oreClusterShape = "SPHERE";
        DPSLT_LAPIS.oreClusterVolume = new HBUtil.TripleInt(4, 6, 4);
        DPSLT_LAPIS.oreClusterDensity = Float.valueOf(0.1f);
        DPSLT_LAPIS.oreClusterMaxYLevelSpawn = 0;
        DPSLT_LAPIS.oreClusterMinYLevelSpawn = -56;
        DPSLT_LAPIS.oreClusterReplaceableEmptyBlocks = List.of(OreClusterJsonConfig.bs(class_2246.field_29030), OreClusterJsonConfig.bs(class_2246.field_29029), OreClusterJsonConfig.bs(class_2246.field_29220), OreClusterJsonConfig.bs(class_2246.field_28888), OreClusterJsonConfig.bs(class_2246.field_28888), OreClusterJsonConfig.bs(class_2246.field_28888), OreClusterJsonConfig.bs(class_2246.field_28888), OreClusterJsonConfig.bs(class_2246.field_28888), OreClusterJsonConfig.bs(class_2246.field_28888));
        DPSLT_LAPIS.oreClusterDoesRegenerate = false;
        DPSLT_LAPIS.oreClusterNonReplaceableBlocks = new HashSet<class_2680>(baseListNonReplaceable);
        DPSLT_LAPIS.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(class_2246.field_10124));
        this.oreClusterConfigs = new ArrayList<JsonObject>(){
            {
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(IRON)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(COAL)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(DPSLT_DIAMOND)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(DPSLT_LAPIS)).getAsJsonObject());
            }
        };
    }

    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    public void deserialize(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
        try {
            ArrayList<JsonObject> oreClusterConfigs = new ArrayList<JsonObject>();
            if (!jsonObject.has("oreClusterConfigs")) {
                return;
            }
            JsonArray clusterConfigs = jsonObject.getAsJsonArray("oreClusterConfigs");
            for (int i = 0; i < clusterConfigs.size(); ++i) {
                try {
                    oreClusterConfigs.add(clusterConfigs.get(i).getAsJsonObject());
                    continue;
                }
                catch (Exception e) {
                    LoggerProject.logError("006001", "Error deserializing OreClusterJsonConfig: " + e.getMessage());
                }
            }
            this.oreClusterConfigs = oreClusterConfigs;
        }
        catch (Exception e) {
            LoggerProject.logError("006002", "Error deserializing OreClusterJsonConfig: " + e.getMessage());
        }
    }
}

