/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.exception.InvalidId;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.OreClusterRegenManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import com.holybuckets.orecluster.core.model.OreClusterInfo;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class OreClusterApi {
    public static final String CLASS_ID = "008";
    private static OreClusterApi INSTANCE;
    private final ModRealTimeConfig modConfig;
    private final Map<class_1936, OreClusterManager> managers;
    private final OreClusterRegenManager regenManager;

    public static boolean isInit() {
        return INSTANCE != null;
    }

    public static OreClusterApi getInstance() {
        if (INSTANCE == null) {
            return null;
        }
        return INSTANCE;
    }

    public OreClusterApi(Map<class_1936, OreClusterManager> managers, ModRealTimeConfig modConfig, OreClusterRegenManager regenManager) {
        this.modConfig = modConfig;
        this.managers = managers;
        this.regenManager = regenManager;
        INSTANCE = this;
    }

    public JsonObject getConfigSummary() {
        JsonObject resp = new JsonObject();
        OreClusterConfigModel config = this.modConfig.getDefaultConfigModel();
        JsonArray allOresArray = new JsonArray();
        List<OreClusterConfigModel> ores = this.modConfig.getBaseOreConfigs().stream().sorted(Comparator.comparingInt(a -> Integer.parseInt(a.configId))).toList();
        for (OreClusterConfigModel oreConfig : ores) {
            JsonObject oreObj = new JsonObject();
            oreObj.addProperty("header", "Ore With ConfigId: " + oreConfig.configId + ":");
            oreObj.addProperty("dimension", oreConfig.oreClusterDimensionId);
            oreObj.addProperty("clusterType", HBUtil.BlockUtil.blockToString((class_2248)oreConfig.oreClusterType.method_26204()));
            oreObj.addProperty("clusterSpawnRate", (Number)oreConfig.oreClusterSpawnRate);
            oreObj.addProperty("clusterRegenerates", oreConfig.oreClusterDoesRegenerate != false ? "yes" : "no");
            oreObj.addProperty("biomesWhiteListed", (Number)oreConfig.biomeWhitelist.size());
            oreObj.addProperty("biomesBlackListed", (Number)oreConfig.biomeBlacklist.size());
            allOresArray.add((JsonElement)oreObj);
        }
        JsonObject oreObj = new JsonObject();
        oreObj.addProperty("header", "Summary stats:");
        oreObj.addProperty("randomSubseed", (Number)config.subSeed);
        oreObj.addProperty("totalConfigs", (Number)this.modConfig.getOreConfigs().size());
        oreObj.addProperty("periodRegenLengths", config.oreClusterRegenPeriods.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue() + " days").toList().toString());
        int daysIn = this.regenManager.getDaysIntoPeriod();
        int totalDays = this.regenManager.getDayPeriodLength();
        oreObj.addProperty("currentPeriod", daysIn + " of " + totalDays + " days");
        allOresArray.add((JsonElement)oreObj);
        JsonObject levelIds = new JsonObject();
        levelIds.addProperty("header", "Active Dimension Ids:");
        List<String> levelids = this.managers.keySet().stream().map(HBUtil.LevelUtil::toLevelId).map(id -> id.replaceAll("CLIENT:", "").replaceAll("SERVER:", "")).toList();
        int i = 0;
        for (String id2 : levelids) {
            levelIds.addProperty("" + i++, id2);
        }
        allOresArray.add((JsonElement)levelIds);
        resp.addProperty("header", "Configured ores:\n");
        resp.add("value", (JsonElement)allOresArray);
        return resp;
    }

    public JsonObject getConfig(String configId, boolean showBiomesList) {
        if (configId == null) {
            return this.getConfigSummary();
        }
        OreClusterConfigModel targetConfig = this.modConfig.getBaseOreConfig(configId);
        if (targetConfig == null) {
            return null;
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("header", "Config summary for cluster config id: " + configId);
        JsonArray configArray = new JsonArray();
        JsonObject configObj = new JsonObject();
        configObj.addProperty("header", "");
        configObj.addProperty("oreClusterType", HBUtil.BlockUtil.blockToString((class_2248)targetConfig.oreClusterType.method_26204()));
        configObj.addProperty("configId", targetConfig.configId);
        configObj.addProperty("dimensionId", targetConfig.oreClusterDimensionId);
        configObj.addProperty("spawnRate", (Number)targetConfig.oreClusterSpawnRate);
        configObj.addProperty("size", targetConfig.oreClusterVolume.toString());
        configObj.addProperty("density", targetConfig.oreClusterDensity.toString());
        configObj.addProperty("shape", targetConfig.oreClusterShape);
        configObj.addProperty("oreClusterDoesRegenerate", targetConfig.oreClusterDoesRegenerate);
        configObj.addProperty("maxYLevelSpawnAllowed", (Number)targetConfig.oreClusterMaxYLevelSpawn);
        configObj.addProperty("minYLevelSpawnAllowed", (Number)targetConfig.oreClusterMinYLevelSpawn);
        configObj.addProperty("nonReplaceableBlocks", targetConfig.oreClusterNonReplaceableBlocks.toString());
        configObj.addProperty("alternativeClusterBlocks", targetConfig.oreClusterReplaceableEmptyBlocks.toString());
        JsonObject biomeObj = new JsonObject();
        biomeObj.addProperty("header", showBiomesList ? "Biomes:" : "Show biomes list disabled");
        int i = 0;
        for (Map.Entry<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> entry : this.modConfig.getOreConfigs().entrySet()) {
            class_1959 b;
            if (entry.getValue() != targetConfig || (b = entry.getKey().getBiome()) == null || HBUtil.LevelUtil.getBiomeName((class_1959)b) == null) continue;
            String name = HBUtil.LevelUtil.getBiomeName((class_1959)b).toString();
            biomeObj.addProperty("" + ++i, name);
        }
        configArray.add((JsonElement)configObj);
        if (showBiomesList) {
            configArray.add((JsonElement)biomeObj);
        }
        resp.add("value", (JsonElement)configArray);
        return resp;
    }

    public List<OreClusterInfo> locateOreClusters(class_1936 level, class_2338 pos, class_2248 oreType, int limit) {
        if (level == null) {
            return null;
        }
        if (pos == null) {
            return null;
        }
        if (limit <= 0) {
            return null;
        }
        OreClusterManager manager = this.managers.get(level);
        if (manager == null) {
            return null;
        }
        ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> clusters = manager.getExistingClustersByType();
        LoggerProject.logInfo(null, (String)"008000", (String)("Found " + clusters.size() + " clusters in level: " + HBUtil.LevelUtil.toLevelId((class_1936)level) + " with oreType: " + (oreType == null ? "any" : oreType)));
        HashSet validClusterChunkIds = new HashSet();
        if (oreType == null) {
            for (Iterator clusterType : clusters.keySet()) {
                validClusterChunkIds.addAll((Collection)clusters.get(clusterType));
            }
        } else {
            Set<OreClusterConfigModel.OreClusterId> idsForOre = this.modConfig.getAllOreConfigIdsByOre(oreType);
            clusters.forEach((k, v) -> {
                if (v == null) {
                    return;
                }
                if (idsForOre.contains(k)) {
                    validClusterChunkIds.addAll(v);
                }
            });
        }
        ArrayList clusterInfo = new ArrayList();
        for (String chunkId : validClusterChunkIds) {
            ManagedOreClusterChunk clusterChunk = manager.getManagedOreClusterChunk(chunkId);
            if (clusterChunk == null || !clusterChunk.hasClusters()) continue;
            clusterChunk.getClusterTypes().forEach((k, v) -> {
                if (v == null) {
                    return;
                }
                if (oreType != null && !k.getBlock().equals(oreType)) {
                    return;
                }
                clusterInfo.add(new OreClusterInfo(clusterChunk, (OreClusterConfigModel.OreClusterId)k));
            });
        }
        LoggerProject.logInfo(null, (String)"008001", (String)("Found " + clusterInfo.size() + " clusters of type: " + oreType));
        for (OreClusterInfo cluster : clusterInfo) {
            cluster.calcPointDistance((class_2382)pos);
        }
        Comparator<OreClusterInfo> clusterComparator = Comparator.comparing(c -> c.pointDistance);
        List<OreClusterInfo> sortedClusters = clusterInfo.stream().sorted(clusterComparator).limit(limit).toList();
        LoggerProject.logInfo(null, (String)"008002", (String)("Sorted clusters by distance from: " + pos + " with limit  " + limit));
        return sortedClusters;
    }

    public JsonObject getManagedChunkDetails(class_1936 level, String chunkId) {
        OreClusterManager manager = this.managers.get(level);
        if (manager == null) {
            return null;
        }
        ManagedOreClusterChunk chunk = manager.getManagedOreClusterChunk(chunkId);
        if (chunk == null) {
            return null;
        }
        String id = chunk.getId();
        JsonObject chunkDetails = new JsonObject();
        chunkDetails.addProperty("id", id);
        chunkDetails.addProperty("status", chunk.getStatus().toString());
        if (chunk.hasClusters()) {
            JsonArray clusterArray = new JsonArray();
            chunk.getClusterTypes().entrySet().forEach(e -> {
                String block = HBUtil.BlockUtil.blockToString((class_2248)((OreClusterConfigModel.OreClusterId)e.getKey()).getBlock());
                String pos = ((class_2338)e.getValue()).toString();
                clusterArray.add(block + ": " + pos);
            });
            chunkDetails.add("clusters", (JsonElement)clusterArray);
        } else {
            chunkDetails.addProperty("clusters", "No clusters found");
        }
        return chunkDetails;
    }

    public boolean forceChunkReload(class_1936 level, String chunkId) {
        OreClusterManager manager = this.managers.get(level);
        if (manager == null) {
            return false;
        }
        return manager.forceProcessChunk(chunkId);
    }

    public boolean addCluster(class_1936 level, String configId, class_2338 pos) {
        OreClusterConfigModel.OreClusterId id;
        block3: {
            try {
                id = this.modConfig.getOreConfigId(Integer.parseInt(configId));
                if (id == null) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                id = this.modConfig.getBaseOreConfigId(configId);
                if (id != null) break block3;
                LoggerProject.logWarning("008003", "Could not find config for id: " + configId);
                return false;
            }
        }
        return this.addCluster(level, id, pos);
    }

    public boolean addCluster(class_1936 level, OreClusterConfigModel.OreClusterId oreType, class_2338 pos) {
        if (oreType == null || pos == null) {
            return false;
        }
        OreClusterManager manager = this.managers.get(level);
        if (manager == null) {
            return false;
        }
        String chunkId = HBUtil.ChunkUtil.getId((class_2338)pos);
        return manager.addNewCluster(oreType, chunkId, pos);
    }

    public void triggerRegen() {
        this.regenManager.triggerRegen();
    }

    public void triggerRegen(class_1936 level, String chunkId) throws InvalidId {
        if (level == null || chunkId == null) {
            return;
        }
        if (!this.managers.containsKey(level)) {
            return;
        }
        this.regenManager.triggerRegen(level, chunkId);
    }

    public JsonObject healthCheckStatistics(OreClusterManager m) {
        JsonObject health = new JsonObject();
        JsonObject queueSizes = new JsonObject();
        queueSizes.addProperty("pendingHandling", (Number)m.chunksPendingHandling.size());
        queueSizes.addProperty("pendingDeterminations", (Number)m.chunksPendingDeterminations.size());
        queueSizes.addProperty("pendingCleaning", (Number)m.chunksPendingCleaning.size());
        queueSizes.addProperty("pendingPreGeneration", (Number)m.chunksPendingPreGeneration.size());
        queueSizes.addProperty("pendingGeneration", (Number)m.chunksPendingGeneration.size());
        queueSizes.addProperty("pendingRegeneration", (Number)m.chunksPendingRegeneration.size());
        health.add("queueSizes", (JsonElement)queueSizes);
        JsonObject threadTimes = new JsonObject();
        m.THREAD_TIMES.forEach((threadName, times) -> {
            if (!times.isEmpty()) {
                double avg = times.stream().mapToLong(Long::valueOf).average().orElse(0.0);
                threadTimes.addProperty(threadName, (Number)avg);
            }
        });
        health.add("averageThreadTimes", (JsonElement)threadTimes);
        JsonObject chunkTracking = new JsonObject();
        String[] determinedSourceChunks = (String[])m.determinedSourceChunks.toArray((Object[])new String[0]);
        chunkTracking.add("determinedSourceChunks", HBUtil.FileIO.arrayToJson((String[])determinedSourceChunks));
        chunkTracking.addProperty("determinedChunks", (Number)m.determinedChunks.size());
        chunkTracking.addProperty("loadedOreClusterChunks", (Number)m.loadedOreClusterChunks.size());
        chunkTracking.addProperty("expiredChunks", (Number)m.expiredChunks.size());
        chunkTracking.addProperty("completeChunks", (Number)m.completeChunks.size());
        health.add("chunkTracking", (JsonElement)chunkTracking);
        return health;
    }

    public Set<String> getIncompleteChunks(OreClusterManager m) {
        Set loaded = m.loadedOreClusterChunks.values().stream().filter(c -> !ManagedOreClusterChunk.isFinished(c)).map(c -> c.getId()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        Set unloaded = m.determinedChunks.stream().filter(c -> !m.completeChunks.contains(c)).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        loaded.addAll(unloaded);
        Set incompleteChunks = loaded.stream().filter(c -> !m.forceLoadedChunks.containsKey(c)).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        return incompleteChunks;
    }

    public boolean debugForceLoadChunk(OreClusterManager m, String chunkId, AtomicBoolean succeeded) {
        if (m.forceProcessChunk(chunkId)) {
            succeeded.set(true);
        } else {
            LoggerProject.logWarning("016004", "Chunk: " + chunkId + " failed to reload properly, maybe try restarting the server");
        }
        return succeeded.get();
    }
}

