/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3218;

public class OreClusterBlockStateTracker {
    class_2791 currentChunk;
    Map<class_2826, Integer> chunkSections;
    String chunkId;
    class_3218 currentLevel;
    ManagedOreClusterChunk currentManagedOreClusterChunk;
    static ModRealTimeConfig CONFIG;
    static Map<Integer, class_3218> LEVELCHUNKSECTION_LEVEL_REF_MAP;
    static Map<class_3218, OreClusterBlockStateTracker> LEVEL_TRACKERS;
    static Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> trackingOreConfig;
    private static final int MAX_CHUNK_REFS;
    private static final int MAX_CHUNK_REFS_CLEAR;
    private static int chunkCount;
    private static long blockCount;

    public static void init(ModRealTimeConfig modRealTimeConfig) {
        LEVEL_TRACKERS = new ConcurrentHashMap<class_3218, OreClusterBlockStateTracker>();
        LEVELCHUNKSECTION_LEVEL_REF_MAP = Collections.synchronizedMap(new LinkedHashMap());
        CONFIG = modRealTimeConfig;
    }

    public static void setTrackingChunk(class_3218 level, class_2791 chunk, class_2338 pos) {
        if (!LEVEL_TRACKERS.containsKey(level)) {
            LEVEL_TRACKERS.put(level, new OreClusterBlockStateTracker(level));
        }
        LEVEL_TRACKERS.get(level).setLevelTrackingChunk(chunk, pos);
    }

    public static void trackBlockState(class_2826 section, class_2680 state, int x, int y, int z) {
        if (!LEVELCHUNKSECTION_LEVEL_REF_MAP.containsKey(section.hashCode())) {
            return;
        }
        class_3218 level = LEVELCHUNKSECTION_LEVEL_REF_MAP.get(section.hashCode());
        LEVEL_TRACKERS.get(level).trackLevelBlockState(section, state, x, y, z);
    }

    public OreClusterBlockStateTracker(class_3218 level) {
        this.currentLevel = level;
        this.chunkSections = new ConcurrentHashMap<class_2826, Integer>();
        if (trackingOreConfig == null) {
            trackingOreConfig = CONFIG.getOreConfigs();
        }
    }

    public void setLevelTrackingChunk(class_2791 chunk, class_2338 pos) {
        OreClusterManager manager;
        this.currentChunk = chunk;
        this.chunkSections.clear();
        AtomicInteger count = new AtomicInteger(0);
        Arrays.stream(chunk.method_12006()).forEach(section -> {
            this.chunkSections.put((class_2826)section, count.getAndIncrement());
            LEVELCHUNKSECTION_LEVEL_REF_MAP.put(section.hashCode(), this.currentLevel);
        });
        if (++chunkCount > MAX_CHUNK_REFS) {
            chunkCount = 0;
            Iterator<Map.Entry<Integer, class_3218>> it = LEVELCHUNKSECTION_LEVEL_REF_MAP.entrySet().iterator();
            for (int clearCount = 0; it.hasNext() && clearCount < MAX_CHUNK_REFS_CLEAR; ++clearCount) {
                it.next();
                it.remove();
            }
        }
        if ((manager = OreClusterManager.getManager((class_1936)this.currentLevel)) == null) {
            return;
        }
        this.chunkId = HBUtil.ChunkUtil.getId((class_2791)this.currentChunk);
        this.currentManagedOreClusterChunk = manager.getManagedOreClusterChunk(this.chunkId);
        if (this.currentManagedOreClusterChunk != null) {
            this.currentManagedOreClusterChunk.loadBiomes(chunk);
        }
    }

    public void trackLevelBlockState(class_2826 section, class_2680 state, int x, int y, int z) {
        if (trackingOreConfig == null) {
            return;
        }
        if (this.currentManagedOreClusterChunk == null) {
            return;
        }
        class_2680 defaultState = state.method_26204().method_9564();
        if (!CONFIG.maybeHasBlock(defaultState)) {
            return;
        }
        ManagedOreClusterChunk chunk = this.currentManagedOreClusterChunk;
        class_1959 localBiome = (class_1959)section.method_38293(x, 0, z).comp_349();
        OreClusterConfigModel.OreClusterId configId = chunk.chooseConfigId((class_1937)this.currentLevel, localBiome, defaultState, CONFIG);
        if (configId == null) {
            return;
        }
        OreClusterConfigModel config = trackingOreConfig.get(configId);
        if (!ModRealTimeConfig.doesLevelMatch(config, (class_1936)this.currentLevel)) {
            return;
        }
        if (!ModRealTimeConfig.clustersDoSpawn(config)) {
            return;
        }
        ++blockCount;
        int secIndex = 0;
        if (!this.chunkSections.containsKey(section)) {
            return;
        }
        secIndex = this.chunkSections.get(section);
        int secY = this.currentLevel.method_31604(secIndex);
        if (!chunk.sampleAddOre(configId, secY)) {
            return;
        }
        HBUtil.TripleInt relativePos = new HBUtil.TripleInt(x, y, z);
        HBUtil.WorldPos pos = new HBUtil.WorldPos(relativePos, secIndex, this.currentChunk);
        chunk.addOre(configId, pos.getWorldPos(), true);
    }

    static {
        MAX_CHUNK_REFS = (int)Math.pow(2.0, 12.0);
        MAX_CHUNK_REFS_CLEAR = (int)Math.pow(2.0, 10.0);
        chunkCount = 0;
        blockCount = 0L;
    }
}

