/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.config.OreClusterConfigData;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_3532;
import net.minecraft.class_5216;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7243;
import org.apache.commons.lang3.tuple.Pair;

public class OreClusterCalculator {
    public static final String CLASS_ID = "003";
    private OreClusterManager manager;
    private class_1937 level;
    private ModRealTimeConfig C;
    private Set<String> determinedChunks;
    private ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> localAreaClustersByType;

    public OreClusterCalculator(OreClusterManager manager) {
        this.manager = manager;
        this.level = manager.getLevel();
        this.C = manager.getConfig();
        this.determinedChunks = manager.getDeterminedChunks();
        this.localAreaClustersByType = manager.getTentativeClustersByType();
    }

    @Deprecated
    public Map<String, List<OreClusterConfigModel.OreClusterId>> calculateClusterLocations(List<String> chunks, Random rng) {
        HashMap<OreClusterConfigModel.OreClusterId, Object> clusterConfigs = new HashMap<OreClusterConfigModel.OreClusterId, Object>();
        for (OreClusterConfigModel.OreClusterId oreType : this.C.getOreConfigs().keySet()) {
            OreClusterConfigModel config = this.C.getOreConfigs().get(oreType);
            if (!ModRealTimeConfig.clustersDoSpawn(config)) continue;
            if (!ModRealTimeConfig.doesLevelMatch(config, (class_1936)this.level)) continue;
            clusterConfigs.put(oreType, config);
        }
        HashMap<String, List<OreClusterConfigModel.OreClusterId>> clusterPositions = new HashMap<String, List<OreClusterConfigModel.OreClusterId>>();
        ArrayList oreClusterTypes = new ArrayList(clusterConfigs.keySet());
        if (oreClusterTypes.isEmpty()) {
            for (String chunkId : chunks) {
                clusterPositions.put(chunkId, null);
            }
            return clusterPositions;
        }
        HashMap<OreClusterConfigModel.OreClusterId, Integer> clusterCounts = new HashMap<OreClusterConfigModel.OreClusterId, Integer>();
        for (OreClusterConfigModel.OreClusterId oreType : oreClusterTypes) {
            int normalizedSpawnRate = ((OreClusterConfigModel)clusterConfigs.get((Object)oreType)).oreClusterSpawnRate;
            if (normalizedSpawnRate == 0) continue;
            double sigma = ModRealTimeConfig.CHUNK_DISTRIBUTION_STDV_FUNC.apply(normalizedSpawnRate);
            int numClusters = (int)Math.round(rng.nextGaussian() * sigma + (double)normalizedSpawnRate);
            clusterCounts.put(oreType, numClusters);
        }
        long step1Time = System.nanoTime();
        String startChunk = chunks.get(0);
        int minSpacing = this.C.getDefaultConfigModel().minChunksBetweenOreClusters;
        int MIN_SPACING_VALIDATOR_CUTOFF_RADIUS = Math.min(this.determinedChunks.size(), (int)Math.pow(minSpacing, 2.0));
        LinkedHashSet<String> chunksInRadiusOfStart = this.getChunkIdsInRadius(startChunk, Math.min(minSpacing, MIN_SPACING_VALIDATOR_CUTOFF_RADIUS));
        String closestToCenter = chunksInRadiusOfStart.stream().min(Comparator.comparingInt(c -> Math.round(HBUtil.ChunkUtil.chunkDist((String)c, (String)"0,0")))).get();
        int batchDimensions = (int)Math.ceil(Math.sqrt(chunks.size()));
        int spiralRadius = batchDimensions + MIN_SPACING_VALIDATOR_CUTOFF_RADIUS;
        LinkedHashSet<Object> localExistingClusters = new LinkedHashSet<Object>();
        this.localAreaClustersByType.values().stream().forEach(ids -> localExistingClusters.addAll((Collection<Object>)ids));
        int maxZ = 0;
        int maxX = 0;
        int minZ = 0;
        int minX = 0;
        for (String string : localExistingClusters) {
            class_1923 pos = HBUtil.ChunkUtil.getChunkPos((String)string);
            if (pos.field_9181 < minX) {
                minX = pos.field_9181;
            }
            if (pos.field_9181 > maxX) {
                maxX = pos.field_9181;
            }
            if (pos.field_9180 < minZ) {
                minZ = pos.field_9180;
            }
            if (pos.field_9180 <= maxZ) continue;
            maxZ = pos.field_9180;
        }
        float totalClusters = clusterCounts.values().stream().mapToInt(i -> i).sum();
        float f = (float)chunks.size() / totalClusters;
        float stdDev = Math.max((f - (float)minSpacing) / 3.0f, 0.0f);
        LinkedList<Object> chunksToBePopulated = new LinkedList<Object>();
        int chunkIndex = 0;
        while (chunkIndex < chunks.size()) {
            Object chunkId;
            chunkIndex = (int)Math.round(rng.nextGaussian() * (double)stdDev + (double)f) + chunkIndex;
            chunkIndex = chunkIndex < 0 ? 0 : chunkIndex;
            boolean openSpaceForCluster = false;
            block7: while (!openSpaceForCluster && chunkIndex < chunks.size()) {
                openSpaceForCluster = true;
                if (minSpacing == 0 || this.determinedChunks.contains(chunkId = chunks.get(chunkIndex++))) continue;
                if (minSpacing < MIN_SPACING_VALIDATOR_CUTOFF_RADIUS) {
                    LinkedHashSet<String> nearbyChunks = this.getChunkIdsInRadius((String)chunkId, minSpacing);
                    for (String nearbyChunk : nearbyChunks) {
                        if (!localExistingClusters.contains(nearbyChunk)) continue;
                        openSpaceForCluster = false;
                        continue block7;
                    }
                    continue;
                }
                if (!localExistingClusters.stream().anyMatch(arg_0 -> OreClusterCalculator.lambda$calculateClusterLocations$3((String)chunkId, minSpacing, arg_0))) continue;
                openSpaceForCluster = false;
            }
            if (chunkIndex >= chunks.size()) continue;
            chunkId = chunks.get(chunkIndex);
            chunksToBePopulated.add(chunkId);
            localExistingClusters.add(chunkId);
        }
        oreClusterTypes.sort(Comparator.comparingInt(o -> -1 * ((OreClusterConfigModel)clusterConfigs.get((Object)o)).oreClusterSpawnRate));
        LinkedHashSet<String> selectedChunks = new LinkedHashSet<String>();
        try {
            for (OreClusterConfigModel.OreClusterId oreType : oreClusterTypes) {
                OreClusterConfigModel config = (OreClusterConfigModel)clusterConfigs.get(oreType);
                HashSet allChunksWithClusterType = this.localAreaClustersByType.get(oreType).stream().collect(Collectors.toCollection(HashSet::new));
                int MIN_SPACING_SPECIFIC_CLUSTER_VALIDATOR_CUTOFF_RADIUS = Math.min(allChunksWithClusterType.size(), (int)Math.pow(config.minChunksBetweenOreClusters.intValue(), 2.0));
                int totalSpecificClusters = (Integer)clusterCounts.get(oreType);
                if (totalSpecificClusters == 0) continue;
                int clustersPlaced = 0;
                int specificMinSpacing = config.minChunksBetweenOreClusters;
                Iterator it = chunksToBePopulated.iterator();
                while (it.hasNext()) {
                    String chunkId = (String)it.next();
                    if (!selectedChunks.remove(chunkId)) continue;
                    it.remove();
                }
                LinkedList chunksToBePopulatedSpecificCopy = new LinkedList(chunksToBePopulated);
                Collections.shuffle(chunksToBePopulatedSpecificCopy, rng);
                boolean validCluster = false;
                while (clustersPlaced < totalSpecificClusters) {
                    ++clustersPlaced;
                    String candidateChunkId = null;
                    validCluster = false;
                    block12: while (!(validCluster || chunksToBePopulatedSpecificCopy.isEmpty() || this.determinedChunks.contains(candidateChunkId = (String)chunksToBePopulatedSpecificCopy.removeFirst()))) {
                        validCluster = true;
                        if (specificMinSpacing < MIN_SPACING_SPECIFIC_CLUSTER_VALIDATOR_CUTOFF_RADIUS) {
                            LinkedHashSet<String> nearbyChunks = this.getChunkIdsInRadius(candidateChunkId, specificMinSpacing);
                            for (String nearbyChunk : nearbyChunks) {
                                if (!allChunksWithClusterType.contains(nearbyChunk)) continue;
                                validCluster = false;
                                continue block12;
                            }
                            continue;
                        }
                        String id = candidateChunkId;
                        if (!allChunksWithClusterType.stream().anyMatch(c -> HBUtil.ChunkUtil.chunkDist((String)c, (String)id) < (float)specificMinSpacing)) continue;
                        validCluster = false;
                    }
                    if (!validCluster || candidateChunkId == null) continue;
                    selectedChunks.add(candidateChunkId);
                    allChunksWithClusterType.add(candidateChunkId);
                    if (clusterPositions.containsKey(candidateChunkId)) {
                        clusterPositions.get(candidateChunkId).add(oreType);
                        continue;
                    }
                    LinkedList<OreClusterConfigModel.OreClusterId> clusterMap = new LinkedList<OreClusterConfigModel.OreClusterId>();
                    clusterMap.add(oreType);
                    clusterPositions.put(candidateChunkId, clusterMap);
                }
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            clusterCounts.entrySet().forEach(ore -> sb.append(ore.getKey() + ": " + ore.getValue() + ", "));
            LoggerProject.logWarning("013001", "Unable to place all ore clusters: " + e.getMessage() + "Remaining Counts: " + sb.toString());
            e.printStackTrace();
        }
        long step4Time = System.nanoTime();
        Iterator<String> clusterPos = clusterPositions.keySet().iterator();
        while (clusterPos.hasNext()) {
            String chunkId = clusterPos.next();
            if (!this.determinedChunks.contains(chunkId)) continue;
            clusterPos.remove();
        }
        long step5Time = System.nanoTime();
        long endTime = System.nanoTime();
        return clusterPositions;
    }

    private LinkedHashSet<String> getChunkIdsInRadius(String chunkId, int radius) {
        LinkedHashSet<String> chunks = new LinkedHashSet<String>();
        class_1923 center = HBUtil.ChunkUtil.getChunkPos((String)chunkId);
        for (int x = center.field_9181 - radius; x <= center.field_9181 + radius; ++x) {
            for (int z = center.field_9180 - radius; z <= center.field_9180 + radius; ++z) {
                chunks.add(HBUtil.ChunkUtil.getId((int)x, (int)z));
            }
        }
        return chunks;
    }

    public boolean cleanChunkFindAllOres(ManagedOreClusterChunk chunk, Set<class_2680> COUNTABLE_ORES) {
        class_2818 levelChunk = chunk.getChunk(false);
        if (levelChunk == null) {
            return false;
        }
        class_2826[] sections = levelChunk.method_12006();
        int SECTION_SZ = 16;
        boolean count = false;
        int outerCount = 0;
        boolean TURN_OFF = false;
        for (int i = sections.length - 1; i >= 0; --i) {
            class_2826 section = sections[i];
            if (section == null || section.method_38292()) continue;
            class_2841 states = section.method_12265();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int sectionY;
                        OreClusterConfigModel.OreClusterId id;
                        ++outerCount;
                        class_2680 blockState = ((class_2680)states.method_12321(x, y, z)).method_26204().method_9564();
                        class_1959 localBiome = (class_1959)section.method_38293(x, 0, z).comp_349();
                        chunk.addBiome(localBiome);
                        if (!COUNTABLE_ORES.contains(blockState) || (id = chunk.chooseConfigId(this.level, localBiome, blockState, this.C)) == null || !chunk.sampleAddOre(id, sectionY = this.level.method_31604(i))) continue;
                        HBUtil.TripleInt relativePos = new HBUtil.TripleInt(x, y, z);
                        HBUtil.WorldPos pos = new HBUtil.WorldPos(relativePos, i, (class_2791)levelChunk);
                        chunk.addOre(id, pos.getWorldPos(), true);
                    }
                }
            }
        }
        return true;
    }

    public void cleanChunkSelectClusterPosition(ManagedOreClusterChunk chunk) {
        HashMap<OreClusterConfigModel.OreClusterId, class_2338> CLUSTER_TYPES = chunk.getClusterTypes();
        for (OreClusterConfigModel.OreClusterId b : CLUSTER_TYPES.keySet()) {
            class_2338 orePos;
            if (CLUSTER_TYPES.get(b) != null || (orePos = chunk.getOreClusterSourcePos(b)) == null) continue;
            CLUSTER_TYPES.put(b, orePos);
        }
    }

    public List<Pair<class_2680, class_2338>> generateCluster(ManagedOreClusterChunk chunk, OreClusterConfigModel.OreClusterId clusterId, class_2338 sourcePos) {
        List<class_2680> clusterBlockStates;
        OreClusterGeneratorUtility generator;
        HBUtil.Fast3DArray positions;
        OreClusterConfigModel config = this.C.getOreConfigs().get(clusterId);
        HBUtil.TripleInt VOL = config.oreClusterVolume;
        String SHAPE = config.oreClusterShape;
        int randSeed = HBUtil.BlockUtil.mapTo1DNumber((class_2338)sourcePos);
        List validShapes = OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_VALID_SHAPES.stream().toList();
        if (SHAPE.equals("ANY") || SHAPE.equals("NONE")) {
            int offset = validShapes.size();
            SHAPE = (String)validShapes.get(randSeed % offset);
        }
        if (SHAPE.equals("SPHERE")) {
            int radius = Math.min(VOL.x, VOL.z);
            positions = HBUtil.ShapeUtil.getSphere((int)radius, (int)VOL.y);
        } else {
            positions = HBUtil.ShapeUtil.getCube((int)VOL.x, (int)VOL.z, (int)VOL.y);
        }
        ArrayList<class_2338> blockPositions = new ArrayList<class_2338>(positions.size);
        ArrayList<Integer> Xs = new ArrayList<Integer>(positions.size);
        ArrayList<Integer> Ys = new ArrayList<Integer>(positions.size);
        ArrayList<Integer> Zs = new ArrayList<Integer>(positions.size);
        for (int i = 0; i < positions.size; ++i) {
            Xs.add(positions.getX(i));
            Ys.add(positions.getY(i));
            Zs.add(positions.getZ(i));
            int x = sourcePos.method_10263() + positions.getX(i);
            int y = sourcePos.method_10264() + positions.getY(i);
            int z = sourcePos.method_10260() + positions.getZ(i);
            blockPositions.add(new class_2338(x, y, z));
        }
        ArrayList<Pair<Integer, List<Integer>>> relativePosData = new ArrayList<Pair<Integer, List<Integer>>>();
        relativePosData.add(Pair.of((Object)VOL.x, Xs));
        relativePosData.add(Pair.of((Object)VOL.y, Ys));
        relativePosData.add(Pair.of((Object)VOL.z, Zs));
        try {
            generator = new OreClusterGeneratorUtility(chunk, clusterId, blockPositions, relativePosData);
        }
        catch (NullPointerException e) {
            return null;
        }
        HBUtil.TripleInt airOffset = new HBUtil.TripleInt(0, 0, 0);
        if (HBUtil.BlockUtil.blockToString((class_2248)clusterId.getBlock()).toLowerCase().contains("ore")) {
            airOffset = generator.calculateAvoidAirOffset();
        }
        if ((clusterBlockStates = generator.applyRadialDensityFunction()) == null) {
            return null;
        }
        ArrayList<Pair<class_2680, class_2338>> clusterBlockStatePositions = new ArrayList<Pair<class_2680, class_2338>>(positions.size);
        for (int i = 0; i < clusterBlockStates.size(); ++i) {
            if (clusterBlockStates.get(i) == null) continue;
            class_2680 state = clusterBlockStates.get(i);
            class_2338 pos = ((class_2338)blockPositions.get(i)).method_10069(airOffset.x, airOffset.y, airOffset.z);
            clusterBlockStatePositions.add((Pair<class_2680, class_2338>)Pair.of((Object)state, (Object)pos));
        }
        return clusterBlockStatePositions;
    }

    private static /* synthetic */ boolean lambda$calculateClusterLocations$3(String chunkId, int minSpacing, String c) {
        return HBUtil.ChunkUtil.chunkDist((String)c, (String)chunkId) < (float)minSpacing;
    }

    class OreClusterGeneratorUtility {
        private ManagedOreClusterChunk chunk;
        private class_2818 levelChunk;
        private Random randomGenerator;
        private List<class_2338> blockWorldPositions;
        private List<Pair<Integer, List<Integer>>> relativePositions;
        private OreClusterConfigModel.OreClusterId oreClusterId;
        private OreClusterConfigModel config;
        private HBUtil.TripleInt volume;
        private float expectedOreDensity;
        private List<class_2680> proportionedBlockStates;
        private class_6880<class_5216.class_5487> noiseParametersHolder;
        private class_6910.class_7270 noiseHolder;
        private class_6910 noise;
        private class_6910 linearXDensity;
        private class_6910 linearZDensity;
        private class_6910 linearYDensity;
        private class_6910 linearXZDensity;
        private class_6910 radialXZDensity;
        private class_6910 radialZXDensity;
        private class_6910.class_6911 densityFunctionContext;

        OreClusterGeneratorUtility(ManagedOreClusterChunk chunk, OreClusterConfigModel.OreClusterId id, List<class_2338> blockPositions, List<Pair<Integer, List<Integer>>> positions) {
            this.chunk = chunk;
            this.levelChunk = this.chunk.getChunk(false);
            this.randomGenerator = this.chunk.getChunkRandom();
            if (this.levelChunk == null) {
                throw new NullPointerException("LevelChunk for ManagedOreClusterChunk " + chunk.getId() + " is null");
            }
            this.blockWorldPositions = blockPositions;
            this.relativePositions = positions;
            this.oreClusterId = id;
            this.config = OreClusterCalculator.this.C.getOreConfigModel(id);
            this.volume = this.config.oreClusterVolume;
            this.expectedOreDensity = this.config.oreClusterDensity.floatValue();
            this.initOreDensityPortions();
            this.initDensityFunctions();
        }

        HBUtil.TripleInt calculateAvoidAirOffset() {
            float EDGE_PORTION_CONSTANT = 0.2f;
            Function<Integer, Integer> CALC_EDGE_SZ = size -> (int)Math.ceil((float)size.intValue() * 0.2f);
            ArrayList<Float> clusterEdgeAirPortions = new ArrayList<Float>(6);
            ArrayList<class_2338> nearEdges = new ArrayList<class_2338>();
            ArrayList<class_2338> farEdges = new ArrayList<class_2338>();
            for (Pair<Integer, List<Integer>> dimension : this.relativePositions) {
                if ((Integer)dimension.getLeft() == 0) continue;
                nearEdges.clear();
                farEdges.clear();
                int dimLength = (Integer)dimension.getLeft();
                int EDGE_SZ = CALC_EDGE_SZ.apply((Integer)dimension.getLeft());
                int NEAR_CUTOFF = dimLength - EDGE_SZ;
                int FAR_CUTOFF = -1 * dimLength + EDGE_SZ;
                List relativePos = (List)dimension.getRight();
                for (int i = 0; i < relativePos.size(); ++i) {
                    if ((Integer)relativePos.get(i) >= NEAR_CUTOFF) {
                        nearEdges.add(this.blockWorldPositions.get(i));
                        continue;
                    }
                    if ((Integer)relativePos.get(i) > FAR_CUTOFF) continue;
                    farEdges.add(this.blockWorldPositions.get(i));
                }
                clusterEdgeAirPortions.add(Float.valueOf(this.checkSideAirExposure(nearEdges)));
                clusterEdgeAirPortions.add(Float.valueOf(this.checkSideAirExposure(farEdges)));
            }
            HBUtil.TripleInt OFFSET = new HBUtil.TripleInt(0, 0, 0);
            for (int i = 0; i < clusterEdgeAirPortions.size(); i += 2) {
                int farOffset;
                int EDGE_SZ = CALC_EDGE_SZ.apply((Integer)this.relativePositions.get(i / 2).getLeft());
                Function<Float, Integer> getOffset = portion -> {
                    if (portion.floatValue() < 0.2f) {
                        return 0;
                    }
                    if (portion.floatValue() < 0.4f) {
                        return (int)Math.ceil((float)EDGE_SZ * 0.5f);
                    }
                    if (portion.floatValue() < 0.6f) {
                        return (int)Math.ceil((float)EDGE_SZ * 1.0f);
                    }
                    if (portion.floatValue() < 0.8f) {
                        return (int)Math.ceil((float)EDGE_SZ * 1.5f);
                    }
                    return (int)Math.ceil(portion.floatValue() * 2.0f);
                };
                int offset = 0;
                int nearOffset = getOffset.apply((Float)clusterEdgeAirPortions.get(i));
                if (nearOffset > 0) {
                    offset -= nearOffset;
                }
                if ((farOffset = getOffset.apply((Float)clusterEdgeAirPortions.get(i + 1)).intValue()) > 0) {
                    offset += farOffset;
                }
                if (i < 2) {
                    OFFSET.x = offset;
                    continue;
                }
                if (i < 4) {
                    OFFSET.y = offset;
                    continue;
                }
                OFFSET.z = offset;
            }
            return OFFSET;
        }

        private float checkSideAirExposure(List<class_2338> positions) {
            if (positions == null || positions.isEmpty()) {
                return 0.0f;
            }
            int count = 0;
            for (class_2338 pos : positions) {
                if (!this.levelChunk.method_8320(pos).method_26215()) continue;
                ++count;
            }
            return (float)count / (float)positions.size();
        }

        private void initOreDensityPortions() {
            ArrayList<class_2680> temp = new ArrayList<class_2680>(100);
            int density = (int)(this.expectedOreDensity * 100.0f);
            class_2338 clusterOrigin = this.chunk.getOreClusterSourcePos(this.oreClusterId);
            class_2248 blockAtClusterOrigin = this.levelChunk.method_8320(clusterOrigin).method_26204();
            class_2680 baseBlockState = this.config.oreClusterType;
            if (this.config.oreClusterType.method_26204().equals(blockAtClusterOrigin)) {
                baseBlockState = this.levelChunk.method_8320(clusterOrigin);
            }
            for (int i = 0; i < 100; ++i) {
                temp.add(baseBlockState);
            }
            List alternativeBlocks = this.config.oreClusterReplaceableEmptyBlocks.stream().toList();
            int partition = (int)((float)(100 - density) / (float)alternativeBlocks.size());
            int pos = density;
            block1: for (int i = 0; i < alternativeBlocks.size(); ++i) {
                for (int j = 0; j < partition; ++j) {
                    temp.set(pos++, (class_2680)alternativeBlocks.get(i));
                    if (pos >= 100) continue block1;
                }
            }
            class_2680[] states = new class_2680[201];
            for (int i = 0; i < 100; ++i) {
                states[100 - i] = (class_2680)temp.get(i);
                states[100 + i] = (class_2680)temp.get(i);
            }
            this.proportionedBlockStates = Arrays.asList(states);
        }

        private void initDensityFunctions() {
            long seed = this.randomGenerator.nextLong();
            int FIRST_OCTAVE = -2;
            List<Double> AMPLITUDES = Arrays.asList(1.0, 0.5, 0.25, 0.125);
            class_5216.class_5487 nParameters = new class_5216.class_5487(-2, AMPLITUDES);
            class_5819 rSource = class_5819.method_43049((long)seed);
            class_5216 perlinNoise = class_5216.method_38476((class_5819)rSource, (class_5216.class_5487)nParameters);
            UniformNoiseFunction uniformNoise = new UniformNoiseFunction(seed);
            int clusterVolume = this.volume.x * this.volume.y * this.volume.z;
            if (clusterVolume < 144) {
                this.noise = uniformNoise;
            } else {
                CustomNoiseFunction perlinDensity;
                double scaleFactor = clusterVolume < 168 ? 1.0 : Math.min(Math.sqrt(clusterVolume) / 10.0, 2.0);
                CustomNoiseFunction normalizedPerlin = perlinDensity = new CustomNoiseFunction(perlinNoise, 0.1 * scaleFactor, 1.0 * scaleFactor);
                class_6910 constant_p = class_6916.method_40480((double)1.0);
                this.noise = this.mul(class_6916.method_40486((class_6910)normalizedPerlin, (class_6910)uniformNoise), constant_p).method_40468(-1.0, 1.0);
            }
            int halfX = this.volume.x / 2;
            int halfY = this.volume.y / 2;
            int halfZ = this.volume.z / 2;
            class_6910 linearXFalloff = class_6916.method_40481((int)(-halfX), (int)halfX, (double)0.0, (double)1.0);
            class_6910 linearZFalloff = class_6916.method_40481((int)(-halfZ), (int)halfZ, (double)0.0, (double)1.0);
            class_6910 linearYFalloff = class_6916.method_40481((int)(-halfY), (int)halfY, (double)0.0, (double)1.0);
            RadialGradient radialXZFalloff = new RadialGradient(new HBUtil.TripleInt(0, 0, 0), (double)Math.max(this.volume.x, this.volume.z) / 2.0, 0.0, 1.0);
            RadialGradient radialZXFalloff = new RadialGradient(new HBUtil.TripleInt(0, 0, 0), (double)Math.max(this.volume.x, this.volume.z) / 2.0, 0.0, 1.0);
            this.densityFunctionContext = new class_6910.class_6911(){

                public class_6910.class_6912 method_40477(int index) {
                    HBUtil.TripleInt p = OreClusterGeneratorUtility.this.getRelativePos(index);
                    return new class_6910.class_6914(p.x, p.y, p.z);
                }

                public void method_40478(double[] values, class_6910 density) {
                    for (int i = 0; i < values.length; ++i) {
                        HBUtil.TripleInt p = OreClusterGeneratorUtility.this.getRelativePos(i);
                        class_6910.class_6914 context = new class_6910.class_6914(p.x, p.y, p.z);
                        values[i] = density.method_40464((class_6910.class_6912)context);
                    }
                }
            };
        }

        private HBUtil.TripleInt getRelativePos(int i) {
            return new HBUtil.TripleInt(((Integer)((List)this.relativePositions.get(0).getRight()).get(i)).intValue(), ((Integer)((List)this.relativePositions.get(1).getRight()).get(i)).intValue(), ((Integer)((List)this.relativePositions.get(2).getRight()).get(i)).intValue());
        }

        private class_6910 mul(class_6910 d1, class_6910 d2) {
            return class_6916.method_40500((class_6910)d1, (class_6910)d2);
        }

        List<class_2680> applyRadialDensityFunction() {
            int i;
            ArrayList<class_2680> blockStates = new ArrayList<class_2680>(this.blockWorldPositions.size());
            ArrayList blockStatesXZ = new ArrayList(this.blockWorldPositions.size());
            ArrayList blockStatesZX = new ArrayList(this.blockWorldPositions.size());
            int size = this.blockWorldPositions.size();
            Integer[] Xs = ((List)this.relativePositions.get(0).getRight()).toArray(new Integer[0]);
            Integer[] Ys = ((List)this.relativePositions.get(1).getRight()).toArray(new Integer[0]);
            Integer[] Zs = ((List)this.relativePositions.get(2).getRight()).toArray(new Integer[0]);
            for (i = 0; i < size; ++i) {
            }
            for (i = 0; i < size; ++i) {
            }
            for (i = 0; i < size; ++i) {
                blockStates.add(i, this.getBlockState(i, this.noise));
            }
            double[] sample = new double[size];
            this.densityFunctionContext.method_40478(sample, this.noise);
            return blockStates;
        }

        private class_2680 getBlockState(int i, class_6910 density) {
            HBUtil.TripleInt pos = this.getRelativePos(i);
            return this.getBlockState(pos.x, pos.y, pos.z, density);
        }

        private class_2680 getBlockState(int x, int y, int z, class_6910 density) {
            class_6910.class_6914 pos = new class_6910.class_6914(x, y, z);
            double densityVal = density.method_40464((class_6910.class_6912)pos);
            int index = (int)(densityVal * 99.0) + 100;
            return this.proportionedBlockStates.get(index);
        }

        private int abs(Number a) {
            return Math.abs(a.intValue());
        }
    }

    class RadialGradient
    implements class_6910.class_6913 {
        private final int centerX;
        private final int centerY;
        private final int centerZ;
        private final double radius;
        private final double fromValue;
        private final double toValue;

        public RadialGradient(HBUtil.TripleInt center, double radius, double fromValue, double toValue) {
            this.centerX = center.x;
            this.centerY = center.y;
            this.centerZ = center.z;
            this.radius = radius;
            this.fromValue = fromValue;
            this.toValue = toValue;
        }

        public double method_40464(class_6910.class_6912 context) {
            double dx = context.comp_371() - this.centerX;
            double dy = context.comp_372() - this.centerY;
            double dz = context.comp_373() - this.centerZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double t = Math.min(distance / this.radius, 1.0);
            double smoothT = 1.0 - t * t;
            return class_3532.method_16436((double)smoothT, (double)this.fromValue, (double)this.toValue);
        }

        public double comp_377() {
            return Math.min(this.fromValue, this.toValue);
        }

        public double comp_378() {
            return Math.max(this.fromValue, this.toValue);
        }

        public class_7243<? extends class_6910> method_41062() {
            return class_7243.method_42116((MapCodec)MapCodec.unit((Object)this));
        }
    }

    class CustomNoiseFunction
    implements class_6910.class_6913 {
        private final class_5216 noise;
        private final double xzScale;
        private final double yScale;

        public CustomNoiseFunction(class_5216 noise, double xzScale, double yScale) {
            this.noise = noise;
            this.xzScale = xzScale;
            this.yScale = yScale;
        }

        public double method_40464(class_6910.class_6912 context) {
            double x = (double)context.comp_371() * this.xzScale;
            double y = (double)context.comp_372() * this.yScale;
            double z = (double)context.comp_373() * this.xzScale;
            return this.noise.method_27406(x, y, z);
        }

        public double comp_377() {
            return -this.noise.method_40554();
        }

        public double comp_378() {
            return this.noise.method_40554();
        }

        public class_7243<? extends class_6910> method_41062() {
            return class_7243.method_42116((MapCodec)MapCodec.unit((Object)this));
        }
    }

    public class UniformNoiseFunction
    implements class_6910.class_6913 {
        private final long seed;

        public UniformNoiseFunction(long seed) {
            this.seed = seed;
        }

        public double method_40464(class_6910.class_6912 context) {
            long hash = this.hashCoords(context.comp_371(), context.comp_372(), context.comp_373());
            double noise = (double)(hash & Integer.MAX_VALUE) / 2.147483647E9;
            return noise * 2.0 - 1.0;
        }

        public double comp_377() {
            return -1.0;
        }

        public double comp_378() {
            return 1.0;
        }

        private long hashCoords(int x, int y, int z) {
            long h = this.seed;
            h = h * 31L + (long)x;
            h = h * 31L + (long)y;
            h = h * 31L + (long)z;
            return class_3532.method_15354((int)Long.valueOf(h).intValue());
        }

        public class_7243<? extends class_6910> method_41062() {
            return class_7243.method_42116((MapCodec)MapCodec.unit((Object)this));
        }
    }
}

