/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.core.OreClusterApi;
import com.holybuckets.orecluster.core.OreClusterManager;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import org.apache.commons.lang3.tuple.Pair;

public class OreClusterHealthCheck {
    private static OreClusterHealthCheck INSTANCE;
    private final Gson gson;
    private OreClusterApi oreClusterApi;
    private final Map<class_1936, OreClusterManager> managers;
    private final Deque<Pair<OreClusterManager, String>> chunkReloadTasks;
    private Thread statisticHealthCheckThread;
    private Thread chunkLoadedHealthCheckThread;
    private final ThreadPoolExecutor chunkReloadExecutor;
    private static final long CHUNK_LOADS_WAIT_PROCESSING_TIME;
    HBUtil.ChunkUtil c_util = new HBUtil.ChunkUtil();

    public OreClusterHealthCheck(EventRegistrar reg, OreClusterApi api, Map<class_1936, OreClusterManager> managers) {
        this.oreClusterApi = api;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.managers = managers;
        this.chunkReloadTasks = new LinkedList<Pair<OreClusterManager, String>>();
        this.chunkReloadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
        if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
            reg.registerOnServerTick(TickType.ON_1200_TICKS, this::onDailyTick);
        } else {
            reg.registerOnDailyTick(GeneralConfig.OVERWORLD_LOC, this::onDailyTick);
        }
        reg.registerOnServerStarted(this::onServerStarted);
        INSTANCE = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statisticHealthCheck() {
        try {
            for (OreClusterManager m : this.managers.values()) {
                JsonObject jsonHealthCheck = this.oreClusterApi.healthCheckStatistics(m);
                StringBuilder message = new StringBuilder("Manager Health Check for level: ");
                message.append(HBUtil.LevelUtil.toLevelId((class_1936)m.getLevel()));
                message.append("\n\n");
                message.append(this.gson.toJson((JsonElement)jsonHealthCheck));
                LoggerProject.logInfo("001001", message.toString());
            }
        }
        catch (Exception e) {
            LoggerProject.logWarning("061002", "Manager Health Check Thread Exception: " + e.getMessage());
        }
        finally {
            this.statisticHealthCheckThread = null;
        }
    }

    private void chunkLoadsHealthCheck() {
        for (OreClusterManager m : this.managers.values()) {
            GeneralConfig config = GeneralConfig.getInstance();
            List players = config.getServer().method_3760().method_14571();
            List<String> playerChunks = players.stream().filter(p -> p.method_51469() == m.getLevel()).map(p -> HBUtil.ChunkUtil.getId((class_1923)p.method_31476())).toList();
            ArrayList localAreaChunks = new ArrayList(playerChunks.size() * 10);
            playerChunks.stream().map(c -> HBUtil.ChunkUtil.getChunkPos((String)c)).forEach(cp -> localAreaChunks.addAll(HBUtil.ChunkUtil.getLocalChunkIds((class_1923)cp, (int)1)));
            Set<String> incompleteChunks = this.oreClusterApi.getIncompleteChunks(m);
            List<String> localIncompleteChunks = incompleteChunks.stream().filter(c -> localAreaChunks.contains(c)).toList();
            if (localIncompleteChunks.isEmpty()) continue;
            try {
                Thread.sleep(CHUNK_LOADS_WAIT_PROCESSING_TIME);
            }
            catch (InterruptedException e) {
                return;
            }
            incompleteChunks = this.oreClusterApi.getIncompleteChunks(m);
            incompleteChunks.stream().filter(c -> localIncompleteChunks.contains(c)).forEach(c -> this.chunkReloadTasks.addLast((Pair<OreClusterManager, String>)Pair.of((Object)m, (Object)c)));
            this.chunkReloadExecutor.submit(this::chunkLoadedHealthCheckExecutorThread);
        }
    }

    private void chunkLoadedHealthCheckExecutorThread() {
        try {
            while (!this.chunkReloadTasks.isEmpty()) {
                Pair<OreClusterManager, String> task = this.chunkReloadTasks.poll();
                OreClusterManager m = (OreClusterManager)task.getLeft();
                String chunkId = (String)task.getRight();
                AtomicBoolean succeeded = new AtomicBoolean(false);
                LoggerProject.logWarning("016003", "Chunk: " + chunkId + " failed to load properly, will be reloaded");
                Thread forceLoad = new Thread(() -> this.oreClusterApi.debugForceLoadChunk(m, chunkId, succeeded));
                forceLoad.start();
                forceLoad.join(10000L);
            }
        }
        catch (InterruptedException e) {
            LoggerProject.logError("002003", "OreClusterManager::onNewlyAddedChunk() thread interrupted: " + e.getMessage());
        }
    }

    private void chunkLoadedHealthCheckWatchThread() {
        try {
            while (this.managers.size() > 0) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (this.statisticHealthCheckThread != null) {
            this.statisticHealthCheckThread.interrupt();
            this.statisticHealthCheckThread = null;
        }
        if (this.chunkLoadedHealthCheckThread != null) {
            this.chunkLoadedHealthCheckThread.interrupt();
            this.chunkLoadedHealthCheckThread = null;
        }
        this.chunkReloadExecutor.shutdown();
    }

    private void onServerStarted(ServerStartedEvent event) {
        if (this.chunkLoadedHealthCheckThread == null) {
            this.chunkLoadedHealthCheckThread = new Thread(this::chunkLoadedHealthCheckWatchThread, "OreClusterAndRegenMain-ChunkLoadedHealthCheck");
            this.chunkLoadedHealthCheckThread.start();
        }
    }

    private void onDailyTick(ServerTickEvent event) {
        if (this.statisticHealthCheckThread == null) {
            this.statisticHealthCheckThread = new Thread(this::statisticHealthCheck, "OreClusterAndRegenMain-ManagerHealthCheck");
            this.statisticHealthCheckThread.start();
        }
    }

    static {
        CHUNK_LOADS_WAIT_PROCESSING_TIME = OreClustersAndRegenMain.DEBUG != false ? 30000L : 60000L;
    }
}

