/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastructure.ConcurrentLinkedSet;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.event.custom.TickType;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterCalculator;
import com.holybuckets.orecluster.core.OreClusterStatus;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;
import oshi.annotation.concurrent.ThreadSafe;

public class OreClusterManager {
    public static final String CLASS_ID = "002";
    public static final GeneralConfig GENERAL_CONFIG = GeneralConfig.getInstance();
    public static Map<class_1936, OreClusterManager> MANAGERS;
    private final ManagedChunkUtility chunkUtil;
    private static final Map<String, Boolean> WORKER_THREAD_ENABLED;
    final Map<String, List<Long>> THREAD_TIMES = new ConcurrentHashMap<String, List<Long>>(){
        {
            this.put("workerThreadLoadedChunk", new ArrayList());
            this.put("handleChunkInitialization", new ArrayList());
            this.put("handleChunkDetermination", new ArrayList());
            this.put("handleChunkCleaning", new ArrayList());
            this.put("handleChunkClusterPreGeneration", new ArrayList());
            this.put("handleChunkManifestation", new ArrayList());
        }
    };
    private Integer LOADS = 0;
    private Integer UNLOADS = 0;
    private final class_1937 level;
    private final ModRealTimeConfig config;
    private Random randSeqClusterPositionGen;
    private Random randSeqClusterBuildGen;
    final LinkedBlockingQueue<String> chunksPendingHandling;
    final LinkedBlockingQueue<String> chunksPendingDeterminations;
    final LinkedBlockingQueue<String> chunksPendingCleaning;
    final LinkedBlockingQueue<String> chunksPendingPreGeneration;
    final LinkedBlockingQueue<String> chunksPendingGeneration;
    final ConcurrentSet<String> chunksPendingRegeneration;
    final ConcurrentLinkedSet<String> determinedSourceChunks;
    final ConcurrentSet<String> determinedChunks;
    final ConcurrentSet<String> completeChunks;
    final ConcurrentHashMap<String, Integer> expiredChunks;
    final ConcurrentHashMap<String, class_2818> forceLoadedChunks;
    final ConcurrentHashMap<String, ManagedOreClusterChunk> loadedOreClusterChunks;
    final Set<String> initializedOreClusterChunks;
    final ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> existingClustersByType;
    final ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> tentativeClustersByType;
    final ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> removedClustersByType;
    final ConcurrentHashMap<String, Map<OreClusterConfigModel.OreClusterId, class_2338>> addedClustersByType;
    final ChunkGenerationOrderHandler mainSpiral;
    private OreClusterCalculator oreClusterCalculator;
    private volatile boolean managerRunning = false;
    private volatile boolean initializing = false;
    private final ConcurrentHashMap<String, Long> threadstarts = new ConcurrentHashMap();
    private Thread threadLoad;
    private Thread threadWatchManagedOreChunkLifetime;
    private final AtomicInteger loadedChunksCount = new AtomicInteger();
    private final AtomicInteger clusterDeterminationCount = new AtomicInteger();
    private final AtomicInteger clusterCleaningCount = new AtomicInteger();
    private final AtomicInteger clusterGeneratingCount = new AtomicInteger();
    private final AtomicInteger chunkEditingCount = new AtomicInteger();
    private static final Long MAX_DETERMINED_CHUNK_LIFETIME_MILLIS;
    private static final Long MIN_EXPIRATION_CHECK_TICK_ALIVE_COUNT;
    private static final Long SLEEP_TIME_PER_CHUNK_MILLIS;
    private static final Long MAX_EXPIRATIONS;
    private static final int MAX_LOADED_CHUNKS = 64000;
    private static final int MAX_FAILURES = 64;
    private static int totalCleaned;
    private static int missingOriginalsCleaned;
    private static Map<String, Integer> manifestUpdates;

    private void setOffWorkerThreads(String threadName) {
        WORKER_THREAD_ENABLED.put(threadName, false);
    }

    private ThreadFactory createThreadFactory(String namePrefix, AtomicInteger counter) {
        return r -> {
            Thread t = new Thread(r);
            t.setName(namePrefix + "-" + counter.incrementAndGet());
            return t;
        };
    }

    public OreClusterManager(class_1937 level, ModRealTimeConfig config) {
        this.level = level;
        this.config = config;
        this.chunkUtil = ManagedChunkUtility.getInstance((class_1936)level);
        MANAGERS.put((class_1936)level, this);
        this.existingClustersByType = new ConcurrentHashMap();
        this.tentativeClustersByType = new ConcurrentHashMap();
        this.addedClustersByType = new ConcurrentHashMap();
        this.removedClustersByType = new ConcurrentHashMap();
        this.loadedOreClusterChunks = new ConcurrentHashMap();
        this.determinedSourceChunks = new ConcurrentLinkedSet();
        this.determinedChunks = new ConcurrentSet();
        this.completeChunks = new ConcurrentSet();
        this.expiredChunks = new ConcurrentHashMap();
        this.forceLoadedChunks = new ConcurrentHashMap();
        this.chunksPendingHandling = new LinkedBlockingQueue();
        this.chunksPendingDeterminations = new LinkedBlockingQueue();
        this.chunksPendingCleaning = new LinkedBlockingQueue();
        this.chunksPendingPreGeneration = new LinkedBlockingQueue();
        this.chunksPendingGeneration = new LinkedBlockingQueue();
        this.chunksPendingRegeneration = new ConcurrentSet();
        this.initializedOreClusterChunks = new ConcurrentSet();
        this.mainSpiral = new ChunkGenerationOrderHandler(null);
        this.init((class_1936)level);
        LoggerProject.logInit("002000", this.getClass().getName());
    }

    public ModRealTimeConfig getConfig() {
        return this.config;
    }

    public Map<String, ManagedOreClusterChunk> getLoadedOreClusterChunks() {
        return this.loadedOreClusterChunks;
    }

    public ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> getTentativeClustersByType() {
        return this.tentativeClustersByType;
    }

    public ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> getExistingClustersByType() {
        return this.existingClustersByType;
    }

    public static void init(EventRegistrar reg) {
        MANAGERS = new HashMap<class_1936, OreClusterManager>();
        reg.registerOnDataSave(OreClusterManager::save, EventPriority.High);
        reg.registerOnServerTick(TickType.ON_SINGLE_TICK, OreClusterManager::onSingletick);
        reg.registerOnServerTick(TickType.ON_1200_TICKS, OreClusterManager::on1200Ticks);
    }

    private static void loadChunksNearPlayer(ServerTickEvent e) {
        class_3218 level = GeneralConfig.OVERWORLD;
        if (level.method_18456().isEmpty()) {
            return;
        }
        class_1657 p = (class_1657)level.method_18456().get(0);
        class_1923 playerChunkPos = new class_1923(p.method_24515());
        int radius = 5;
        List chunks = HBUtil.ChunkUtil.getLocalChunkIds((class_1923)playerChunkPos, (int)radius);
        String unloaded = chunks.stream().filter(arg_0 -> OreClusterManager.lambda$loadChunksNearPlayer$1((class_1937)level, arg_0)).collect(Collectors.joining(", "));
        LoggerProject.logInfo("002005", "player pos: " + playerChunkPos + "\n unloaded chunks: " + unloaded);
    }

    public void init(class_1936 level) {
        ManagedOreClusterChunk.CONFIG = this.config;
        if (ModRealTimeConfig.CLUSTER_SEED == null) {
            ModRealTimeConfig.CLUSTER_SEED = GENERAL_CONFIG.getWorldSeed();
        }
        long seed = ModRealTimeConfig.CLUSTER_SEED;
        this.randSeqClusterPositionGen = new Random(seed);
        this.oreClusterCalculator = new OreClusterCalculator(this);
        this.config.getOreConfigs().forEach((oreType, oreConfig) -> {
            this.existingClustersByType.put((OreClusterConfigModel.OreClusterId)oreType, new HashSet());
            this.tentativeClustersByType.put((OreClusterConfigModel.OreClusterId)oreType, new HashSet());
            this.removedClustersByType.put((OreClusterConfigModel.OreClusterId)oreType, new HashSet());
        });
        this.threadLoad = new Thread(this::load);
        this.threadLoad.start();
    }

    private void watchLoadedChunkExpiration() {
        boolean errorThrown = false;
        try {
            if (this.loadedOreClusterChunks.isEmpty()) {
                return;
            }
            Long systemTime = System.currentTimeMillis();
            Long currentTick = GeneralConfig.getInstance().getTotalTickCount();
            Set oldChunks = this.loadedOreClusterChunks.values().stream().filter(c -> currentTick - c.getTickLoaded() > MIN_EXPIRATION_CHECK_TICK_ALIVE_COUNT).map(ManagedOreClusterChunk::getId).collect(Collectors.toSet());
            List expired_chunks = this.loadedOreClusterChunks.values().stream().filter(c -> oldChunks.contains(c.getId())).filter(c -> !c.updateTimeLastLoaded(systemTime)).filter(c -> systemTime - c.getTimeLastLoaded() > MAX_DETERMINED_CHUNK_LIFETIME_MILLIS).limit(MAX_EXPIRATIONS).collect(Collectors.toList());
            if (!expired_chunks.stream().filter(c -> c.getId().equals("-1,0")).toList().isEmpty()) {
                boolean bl = false;
            }
            for (ManagedOreClusterChunk chunk : expired_chunks) {
                String id = chunk.getId();
                class_2818 levelChunk = this.chunkUtil.getChunk(id, false);
                if (levelChunk != null) {
                    levelChunk.method_12008(true);
                }
                Thread.sleep(SLEEP_TIME_PER_CHUNK_MILLIS);
            }
            for (ManagedOreClusterChunk chunk : expired_chunks) {
                LoggerProject.logDebug("002004", "Chunk " + chunk.getId() + " has expired");
                this.editManagedChunk(chunk, this::removeManagedChunk);
            }
        }
        catch (InterruptedException systemTime) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean i = false;
    }

    private void removeManagedChunk(ManagedOreClusterChunk c) {
        String chunkId = c.getId();
        if (!ManagedOreClusterChunk.isComplete(c)) {
            Integer expiryCount = this.expiredChunks.get(chunkId);
            if (expiryCount == null) {
                this.expiredChunks.put(chunkId, 0);
                expiryCount = 0;
            }
            this.expiredChunks.put(chunkId, expiryCount + 1);
        }
        this.loadedOreClusterChunks.remove(chunkId);
        this.chunksPendingHandling.remove(chunkId);
        this.chunksPendingDeterminations.remove(chunkId);
        this.chunksPendingCleaning.remove(chunkId);
        this.chunksPendingPreGeneration.remove(chunkId);
    }

    public void addOrUpdatedLoadedChunk(ManagedOreClusterChunk managedChunk) {
        String chunkId = managedChunk.getId();
        if (chunkId.equals("-1,0")) {
            boolean bl = false;
        }
        this.loadedOreClusterChunks.put(chunkId, managedChunk.getEarliest(this.loadedOreClusterChunks));
        this.chunksPendingHandling.add(managedChunk.getId());
    }

    public void onLoadedChunkId(String chunkId) {
        Integer n = this.LOADS;
        this.LOADS = this.LOADS + 1;
        this.chunksPendingHandling.add(chunkId);
    }

    public void onChunkUnloaded(class_2791 chunk) {
        String chunkId = HBUtil.ChunkUtil.getId((class_2791)chunk);
        ManagedOreClusterChunk managedChunk = this.loadedOreClusterChunks.get(chunkId);
        if (managedChunk != null) {
            managedChunk.setTimeUnloaded();
        }
        Integer n = this.UNLOADS;
        this.UNLOADS = this.UNLOADS + 1;
    }

    private void handleChunkLoaded(String chunkId) {
        ManagedOreClusterChunk chunk;
        if (chunkId.equals("-1,0")) {
            boolean bl = false;
        }
        if ((chunk = this.loadedOreClusterChunks.get(chunkId)) == null) {
            if (this.completeChunks.contains((Object)chunkId)) {
                return;
            }
            chunk = ManagedOreClusterChunk.getInstance((class_1936)this.level, chunkId);
            this.loadedOreClusterChunks.put(chunkId, chunk);
            if (this.determinedChunks.contains((Object)chunkId)) {
                chunk.setStatus(OreClusterStatus.DETERMINED);
            }
            this.handleChunkLoaded(chunkId);
            return;
        }
        if (chunk.hasClusters()) {
            chunk.getClusterTypes().forEach((oreType, pos) -> {
                if (pos != null) {
                    this.existingClustersByType.get(oreType).add(chunkId);
                }
            });
        }
        if (ManagedOreClusterChunk.isNoStatus(chunk)) {
            if (this.determinedChunks.contains((Object)chunkId)) {
                chunk.setStatus(OreClusterStatus.DETERMINED);
                this.handleChunkLoaded(chunkId);
                return;
            }
            this.chunksPendingDeterminations.add(chunkId);
        } else if (ManagedOreClusterChunk.isDetermined(chunk)) {
            if (chunk.hasClusters()) {
                chunk.getClusterTypes().forEach((oreType, pos) -> this.tentativeClustersByType.get(oreType).add(chunkId));
            }
            this.chunksPendingCleaning.add(chunkId);
        } else if (ManagedOreClusterChunk.isCleaned(chunk) || ManagedOreClusterChunk.isPregenerated(chunk) || ManagedOreClusterChunk.isRegenerated(chunk)) {
            if (chunk.hasClusters()) {
                if (ManagedOreClusterChunk.isRegenerated(chunk)) {
                    this.chunksPendingRegeneration.add((Object)chunkId);
                }
                this.chunksPendingPreGeneration.add(chunkId);
                chunk.setStatus(OreClusterStatus.CLEANED);
            }
        } else if (this.chunksPendingRegeneration.contains((Object)chunkId)) {
            this.triggerRegen(chunkId, false);
        } else if (!ManagedOreClusterChunk.isGenerated(chunk) && ManagedOreClusterChunk.isComplete(chunk)) {
            this.completeChunks.add((Object)chunkId);
            this.editManagedChunk(chunk, this::removeManagedChunk);
        }
    }

    private void workerThreadLoadedChunk() {
        if (!WORKER_THREAD_ENABLED.get("workerThreadLoadedChunk").booleanValue()) {
            return;
        }
        try {
            for (int tries = 0; this.managerRunning && tries < 64; ++tries) {
                String chunkId = this.chunksPendingHandling.poll();
                if (chunkId == null) {
                    return;
                }
                this.handleChunkLoaded(chunkId);
            }
        }
        catch (Exception e) {
            LoggerProject.logError("002003", "OreClusterManager::workerThreadLoadedChunk() thread interrupted: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerThreadDetermineClusters() {
        if (!WORKER_THREAD_ENABLED.get("workerThreadDetermineClusters").booleanValue()) {
            return;
        }
        Exception thrown = null;
        try {
            for (int tries = 0; this.managerRunning && tries < 64; ++tries) {
                String chunkId = this.chunksPendingDeterminations.poll();
                if (chunkId == null) continue;
                this.handleChunkDetermination(chunkId);
                if (!this.determinedChunks.contains((Object)chunkId)) {
                    this.chunksPendingDeterminations.add(chunkId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            thrown = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerThreadCleanClusters() {
        if (!WORKER_THREAD_ENABLED.get("workerThreadCleanClusters").booleanValue()) {
            return;
        }
        this.threadstarts.put("workerThreadCleanClusters", System.currentTimeMillis());
        Exception thrown = null;
        try {
            String chunkId = this.chunksPendingCleaning.poll();
            if (chunkId == null) {
                return;
            }
            ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
            if (chunk == null || !chunk.hasChunk()) {
                this.chunksPendingCleaning.add(chunkId);
                return;
            }
            this.editManagedChunk(chunk, this::handleChunkCleaning);
            if (!ManagedOreClusterChunk.isCleaned(chunk)) {
                this.chunksPendingCleaning.add(chunkId);
            }
        }
        catch (Exception e) {
            thrown = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerThreadGenerateClusters() {
        if (!WORKER_THREAD_ENABLED.get("workerThreadGenerateClusters").booleanValue()) {
            return;
        }
        this.threadstarts.put("workerThreadGenerateClusters", System.currentTimeMillis());
        Exception thrown = null;
        try {
            String chunkId = this.chunksPendingPreGeneration.poll();
            if (chunkId == null) {
                return;
            }
            ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
            if (chunk != null && chunk.hasReadyClusters()) {
                long start = System.nanoTime();
                this.editManagedChunk(chunk, this::handleChunkClusterPreGeneration);
                long end = System.nanoTime();
                if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
                    this.THREAD_TIMES.get("handleChunkClusterPreGeneration").add((end - start) / 1000000L);
                }
            }
        }
        catch (Exception e) {
            thrown = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerThreadManifestChunkEdits() {
        if (!WORKER_THREAD_ENABLED.get("workerThreadEditChunk").booleanValue()) {
            return;
        }
        this.threadstarts.put("workerThreadEditChunk", System.currentTimeMillis());
        Exception thrown = null;
        try {
            int tries = 0;
            while (this.managerRunning && tries < 64) {
                ++tries;
                String chunkId = this.chunksPendingGeneration.poll();
                if (chunkId == null) {
                    return;
                }
                ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
                if (chunk == null || !this.isChunkReady(chunk)) {
                    this.chunksPendingGeneration.add(chunkId);
                    continue;
                }
                chunk.setReady(true);
                long start = System.nanoTime();
                this.editManagedChunk(chunk, this::handleChunkManifestation);
                long end = System.nanoTime();
                if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
                    this.THREAD_TIMES.get("handleChunkManifestation").add((end - start) / 1000000L);
                }
                if (!chunk.isReady()) continue;
                this.chunksPendingGeneration.add(chunkId);
            }
        }
        catch (Exception e) {
            thrown = e;
        }
    }

    private boolean isChunkReady(ManagedOreClusterChunk chunk) {
        if (!chunk.hasChunk()) {
            return false;
        }
        if (!ManagedChunkUtility.isChunkFullyLoaded((class_1936)this.level, (String)chunk.getId())) {
            return false;
        }
        if (ManagedOreClusterChunk.isCleaned(chunk) && !chunk.hasClusters() && !chunk.checkClusterHarvested()) {
            return true;
        }
        return ManagedOreClusterChunk.isPregenerated(chunk) || ManagedOreClusterChunk.isRegenerated(chunk);
    }

    private void handleChunkDetermination(String chunkId) {
        ManagedOreClusterChunk managedChunk = this.loadedOreClusterChunks.get(chunkId);
        if (managedChunk == null) {
            return;
        }
        if (!this.chunkUtil.isChunkFullyLoaded(chunkId)) {
            return;
        }
        if (managedChunk.getBiomes().isEmpty() && !managedChunk.loadBiomes((class_2791)managedChunk.getChunk())) {
            return;
        }
        class_2818 chunk = managedChunk.getChunk();
        if (chunk == null) {
            return;
        }
        HashSet<OreClusterConfigModel.OreClusterId> validConfigs = new HashSet<OreClusterConfigModel.OreClusterId>();
        for (class_1959 b : managedChunk.getBiomes()) {
            validConfigs.addAll(this.config.getAllOreConfigIdsByBiome(this.level, b));
        }
        ArrayList<OreClusterConfigModel.OreClusterId> finalClusters = new ArrayList<OreClusterConfigModel.OreClusterId>();
        long loc = HBUtil.ChunkUtil.getChunkPos1DMap((String)chunkId);
        Random rand = new Random((loc + 31L) * (ModRealTimeConfig.CLUSTER_SEED + 31L));
        validConfigs.forEach(id -> {
            OreClusterConfigModel oreConfig = this.config.getOreConfig((OreClusterConfigModel.OreClusterId)id);
            if (oreConfig == null) {
                return;
            }
            double rate = (double)oreConfig.oreClusterSpawnRate.intValue() / (double)ModRealTimeConfig.CHUNK_NORMALIZATION_TOTAL.intValue();
            if (rand.nextDouble() < rate) {
                finalClusters.add((OreClusterConfigModel.OreClusterId)id);
            }
        });
        managedChunk.setStatus(OreClusterStatus.DETERMINED);
        this.determinedChunks.add((Object)chunkId);
        this.chunksPendingCleaning.add(chunkId);
        if (!finalClusters.isEmpty()) {
            managedChunk.addClusterTypes(finalClusters);
        }
        if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
            LoggerProject.logDebug("002008", "Queued " + chunkId + " for cluster determination");
        }
    }

    @Deprecated
    private void handleChunkDetermination(int batchSize, String chunkId) {
        LoggerProject.logDebug("002008", "Queued " + chunkId + " for cluster determination");
        this.determinedSourceChunks.add((Object)chunkId);
        LinkedHashSet<String> chunkIds = this.getBatchedChunkList(batchSize, chunkId);
        Map<String, List<OreClusterConfigModel.OreClusterId>> clusters = this.oreClusterCalculator.calculateClusterLocations(chunkIds.stream().toList(), this.randSeqClusterPositionGen);
        for (String string : chunkIds) {
            if (this.determinedChunks.contains((Object)string)) continue;
            if (string.equals("-1,0")) {
                boolean bl = false;
            }
            ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.getOrDefault(string, ManagedOreClusterChunk.getInstance((class_1936)this.level, string));
            this.loadedOreClusterChunks.put(string, chunk);
            if (clusters.get(string) != null) {
                chunk.addClusterTypes(clusters.get(string));
            }
            this.chunksPendingCleaning.add(string);
            this.determinedChunks.add((Object)string);
        }
        LoggerProject.logDebug("002010", "Added " + clusters.size() + " clusters to determinedChunks");
        for (Map.Entry entry : clusters.entrySet()) {
            if (entry.getValue() == null) continue;
            for (OreClusterConfigModel.OreClusterId clusterOreType : (List)entry.getValue()) {
                this.tentativeClustersByType.get(clusterOreType).add((String)entry.getKey());
            }
        }
        long end = System.nanoTime();
    }

    private void handleChunkCleaning(ManagedOreClusterChunk chunk) {
        if (chunk == null || chunk.getChunk() == null) {
            return;
        }
        try {
            Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> ORE_CONFIGS;
            Set COUNTABLE_ORES;
            if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
                class_2818 c = chunk.getChunk(false);
                if (c == null) {
                    return;
                }
                class_2338 pos = c.method_12004().method_8323();
                class_2338 constPos = pos.method_10069(0, 128, 0);
                chunk.addBlockStateUpdate(class_2246.field_10205.method_9564(), new class_2338(pos.method_10263(), 128, pos.method_10260()));
                HashMap<OreClusterConfigModel.OreClusterId, class_2338> hashMap = chunk.getClusterTypes();
            }
            if (!(COUNTABLE_ORES = (ORE_CONFIGS = this.config.getOreConfigs()).keySet().stream().filter(id -> this.config.doesLevelMatch((OreClusterConfigModel.OreClusterId)id, (class_1936)this.level)).filter(id -> this.config.clustersDoSpawn((OreClusterConfigModel.OreClusterId)id)).collect(Collectors.toSet())).isEmpty() || chunk.hasClusters()) {
                Set<OreClusterConfigModel.OreClusterId> clusterIds = chunk.getClusterTypes().keySet();
                Set<class_2680> COUNTABLE_BLOCKSTATES = chunk.getClusterTypes().keySet().stream().map(id -> id.getBlock().method_9564()).collect(Collectors.toSet());
                if (clusterIds.stream().anyMatch(o -> !chunk.hasOreClusterSourcePos((OreClusterConfigModel.OreClusterId)o))) {
                    if (chunk.getChunk() == null) {
                        return;
                    }
                    boolean isSuccessful = this.oreClusterCalculator.cleanChunkFindAllOres(chunk, COUNTABLE_BLOCKSTATES);
                    if (!isSuccessful) {
                        return;
                    }
                    List<OreClusterConfigModel.OreClusterId> noOresFoundOnClean = chunk.getClusterTypes().keySet().stream().filter(o -> !chunk.hasOreClusterSourcePos((OreClusterConfigModel.OreClusterId)o)).toList();
                    for (OreClusterConfigModel.OreClusterId b : noOresFoundOnClean) {
                        chunk.getClusterTypes().remove(b);
                        this.tentativeClustersByType.get(b).remove(chunk.getId());
                        this.removedClustersByType.get(b).add(chunk.getId());
                    }
                    ++missingOriginalsCleaned;
                }
                ++totalCleaned;
                if (chunk.hasClusters()) {
                    this.oreClusterCalculator.cleanChunkSelectClusterPosition(chunk);
                    this.chunksPendingPreGeneration.put(chunk.getId());
                }
            }
            chunk.setStatus(OreClusterStatus.CLEANED);
            if (!chunk.hasClusters()) {
                this.chunksPendingGeneration.add(chunk.getId());
            }
            chunk.clearOriginalOres();
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder();
            error.append("Error cleaning chunk: ");
            error.append(chunk.getId());
            error.append(" name | message: ");
            error.append(e.getClass());
            error.append(" | ");
            error.append(e.getMessage());
            error.append(" stacktrace: \n");
            error.append(Arrays.stream(e.getStackTrace()).toList().toString());
            LoggerProject.logError("002027.1", error.toString());
        }
    }

    private void handleChunkClusterPreGeneration(ManagedOreClusterChunk chunk) {
        if (chunk == null || chunk.getChunk(false) == null) {
            return;
        }
        if (chunk.getClusterTypes() == null || chunk.getClusterTypes().size() == 0) {
            return;
        }
        if (chunk.getId().equals("-1,0")) {
            boolean bl = false;
        }
        boolean onlyRegenerateOres = this.chunksPendingRegeneration.contains((Object)chunk.getId());
        String SKIPPED = null;
        for (OreClusterConfigModel.OreClusterId oreType : chunk.getClusterTypes().keySet()) {
            class_2338 sourcePos;
            if (onlyRegenerateOres) {
                OreClusterConfigModel config = this.config.getOreConfigModel(oreType);
                if (!config.oreClusterDoesRegenerate.booleanValue()) continue;
            }
            if ((sourcePos = chunk.getClusterTypes().get(oreType)) == null) {
                LoggerProject.logDebug("002032", "No source position for oreType: " + oreType);
                SKIPPED = HBUtil.BlockUtil.blockToString((class_2248)oreType.getBlock());
                chunk.setStatus(OreClusterStatus.DETERMINED);
                this.chunksPendingCleaning.add(chunk.getId());
                continue;
            }
            List<Pair<class_2680, class_2338>> clusterPos = this.oreClusterCalculator.generateCluster(chunk, oreType, sourcePos);
            if (clusterPos == null || clusterPos.size() == 0) {
                SKIPPED = HBUtil.BlockUtil.blockToString((class_2248)oreType.getBlock());
                continue;
            }
            class_2382 sourceOffset = new class_2382(0, 0, 0);
            for (Pair<class_2680, class_2338> pos : clusterPos) {
                chunk.addBlockStateUpdate((class_2680)pos.getLeft(), ((class_2338)pos.getRight()).method_10081(sourceOffset));
            }
            this.existingClustersByType.get(oreType).add(chunk.getId());
        }
        if (SKIPPED == null) {
            if (onlyRegenerateOres) {
                chunk.setStatus(OreClusterStatus.REGENERATED);
            } else {
                chunk.setStatus(OreClusterStatus.PREGENERATED);
            }
            this.chunksPendingGeneration.add(chunk.getId());
        }
    }

    private void handleChunkManifestation(ManagedOreClusterChunk chunk) {
        boolean bl;
        manifestUpdates.putIfAbsent(chunk.getId(), 0);
        if (manifestUpdates.get(chunk.getId()) > 50) {
            bl = false;
        }
        if (chunk.getId().equals("-1,0")) {
            bl = false;
        }
        boolean isSuccessful = false;
        if (!chunk.hasBlockUpdates()) {
            isSuccessful = true;
        } else {
            class_2818 levelChunk = chunk.getChunk(false);
            if (levelChunk == null) {
                return;
            }
            class_2680 state = chunk.getBlockStateUpdateType().orElse(null);
            if (state == null) {
                return;
            }
            LinkedHashSet<class_2338> positions = chunk.getBlockStateUpdates(state);
            isSuccessful = ManagedChunk.updateChunkBlockStates((class_1936)this.level, Map.of(state, new ArrayList<class_2338>(positions)));
            if (isSuccessful) {
                chunk.removeBlockStateUpdates(state);
                if (chunk.countUpdatesRemaining() > 0) {
                    isSuccessful = false;
                }
            }
        }
        if (isSuccessful) {
            chunk.setReady(false);
            chunk.clearBlockStateUpdates();
            if (chunk.hasClusters()) {
                chunk.setStatus(OreClusterStatus.GENERATED);
                this.chunksPendingRegeneration.remove((Object)chunk.getId());
            } else {
                chunk.setStatus(OreClusterStatus.COMPLETE);
                this.completeChunks.add((Object)chunk.getId());
                this.removeManagedChunk(chunk);
            }
        }
    }

    private void initSerializedChunks(List<String> chunkIds) {
        Long start = System.nanoTime();
        for (String id : chunkIds) {
            class_1923 pos = HBUtil.ChunkUtil.getChunkPos((String)id);
            HBUtil.ChunkUtil.getLevelChunk((class_1936)this.level, (int)pos.field_9181, (int)pos.field_9180, (boolean)false);
            while (!this.determinedChunks.contains((Object)id)) {
                try {
                    this.handleChunkInitialization(id);
                }
                catch (Exception e) {
                    LoggerProject.logError("002001.1", "Error in threadInitSerializedChunks, continuing: " + e.getMessage());
                }
            }
        }
        Long end = System.nanoTime();
        if (OreClustersAndRegenMain.DEBUG.booleanValue()) {
            this.THREAD_TIMES.get("handleChunkInitialization").add((end - start) / 1000000L);
        }
    }

    private void handleChunkInitialization(String chunkId) {
        int batchSize = ModRealTimeConfig.ORE_CLUSTER_DTRM_BATCH_SIZE_TOTAL;
        this.determinedSourceChunks.add((Object)chunkId);
        LinkedHashSet<String> chunkIds = this.getBatchedChunkList(batchSize, chunkId);
        Map<String, List<OreClusterConfigModel.OreClusterId>> clusters = this.oreClusterCalculator.calculateClusterLocations(chunkIds.stream().toList(), this.randSeqClusterPositionGen);
        for (String id : chunkIds) {
            this.determinedChunks.add((Object)id);
        }
        for (String id : clusters.keySet()) {
            List<OreClusterConfigModel.OreClusterId> clusterTypes = clusters.get(id);
            for (OreClusterConfigModel.OreClusterId ore : clusterTypes) {
                if (this.removedClustersByType.get(ore).contains(id)) continue;
                this.tentativeClustersByType.get(ore).add(id);
            }
        }
    }

    public boolean addNewCluster(OreClusterConfigModel.OreClusterId clusterType, String chunkId, class_2338 pos) {
        if (clusterType == null) {
            return false;
        }
        if (this.config.getOreConfigModel(clusterType) == null) {
            return false;
        }
        ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
        if (chunk == null) {
            this.expiredChunks.remove(chunkId);
            this.loadedOreClusterChunks.put(chunkId, ManagedOreClusterChunk.getInstance((class_1936)this.level, chunkId));
        } else if (!ManagedOreClusterChunk.isFinished(chunk)) {
            return false;
        }
        chunk = this.loadedOreClusterChunks.get(chunkId);
        if (this.addedClustersByType.get(chunkId) == null) {
            this.addedClustersByType.put(chunkId, new HashMap());
        }
        this.addedClustersByType.get(chunkId).put(clusterType, pos);
        chunk.addClusterTypes(this.addedClustersByType.get(chunkId));
        this.completeChunks.remove((Object)chunkId);
        return this.forceProcessChunk(chunkId, OreClusterStatus.CLEANED);
    }

    public boolean forceReloadChunk(String chunkId) {
        ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
        if (chunk != null) {
            return true;
        }
        int MAX_TRIES = 10;
        for (int count = 0; chunk == null && count < 10; ++count) {
            ManagedChunk parent = this.chunkUtil.getManagedChunk(chunkId);
            if (parent == null) {
                return false;
            }
            class_2818 l = parent.getCachedLevelChunk();
            if (l != null) {
                this.forceLoadedChunks.put(chunkId, l);
            }
            chunk = this.loadedOreClusterChunks.get(chunkId);
        }
        if (this.forceLoadedChunks.get(chunkId) == null) {
            return false;
        }
        return chunk != null;
    }

    public boolean forceProcessChunk(String chunkId) {
        return this.forceProcessChunk(chunkId, OreClusterStatus.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceProcessChunk(String chunkId, OreClusterStatus fromStatus) {
        if (this.completeChunks.contains((Object)chunkId)) {
            return true;
        }
        try {
            ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
            if (chunk == null) {
                if (!this.forceReloadChunk(chunkId)) {
                    boolean bl = false;
                    return bl;
                }
                chunk = this.loadedOreClusterChunks.getOrDefault(chunkId, ManagedOreClusterChunk.getInstance((class_1936)this.level, chunkId));
                fromStatus = OreClusterStatus.NONE;
                chunk.setStatus(OreClusterStatus.NONE);
            } else {
                chunk.setStatus(fromStatus);
            }
            this.removeManagedChunk(chunk);
            this.loadedOreClusterChunks.put(chunkId, chunk);
            ManagedOreClusterChunk CHUNK_REF = chunk;
            OreClusterStatus minStatus = fromStatus;
            Function<OreClusterStatus, Boolean> hasStatus = s -> s.ordinal() <= CHUNK_REF.getStatus().ordinal() || minStatus.ordinal() >= s.ordinal();
            if (!hasStatus.apply(OreClusterStatus.DETERMINED).booleanValue()) {
                HashMap<OreClusterConfigModel.OreClusterId, class_2338> clusters = new HashMap<OreClusterConfigModel.OreClusterId, class_2338>(32);
                this.tentativeClustersByType.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(chunkId)).forEach(e -> clusters.put((OreClusterConfigModel.OreClusterId)e.getKey(), null));
                chunk.addClusterTypes(clusters);
                if (ManagedOreClusterChunk.isNoStatus(chunk)) {
                    chunk.setStatus(OreClusterStatus.DETERMINED);
                }
            }
            int MAX_TRIES = 10;
            int count = 0;
            while (!hasStatus.apply(OreClusterStatus.CLEANED).booleanValue()) {
                this.editManagedChunk(chunk, this::handleChunkCleaning);
                if (count++ <= 10) continue;
                boolean bl = false;
                return bl;
            }
            count = 0;
            if (chunk.hasClusters()) {
                while (!hasStatus.apply(OreClusterStatus.PREGENERATED).booleanValue()) {
                    this.editManagedChunk(chunk, this::handleChunkClusterPreGeneration);
                    if (count++ <= 10) continue;
                    boolean bl = false;
                    return bl;
                }
                this.chunksPendingRegeneration.remove((Object)chunkId);
            }
            this.editManagedChunk(chunk, c -> c.setReady(true));
            boolean bl = false;
        }
        catch (Exception e2) {
            LoggerProject.logError("002017", "Error in force loading chunk: " + chunkId + "\n" + e2.getMessage());
            e2.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.forceLoadedChunks.remove(chunkId);
        }
        return true;
    }

    void triggerRegen() {
        this.clearHealthCheckData();
        LinkedHashSet regenableChunks = new LinkedHashSet();
        for (OreClusterConfigModel.OreClusterId clusterType : this.existingClustersByType.keySet()) {
            OreClusterConfigModel model = this.config.getOreConfigModel(clusterType);
            if (model == null || !model.oreClusterDoesRegenerate.booleanValue()) continue;
            regenableChunks.addAll(this.existingClustersByType.get(clusterType));
        }
        regenableChunks.forEach(c -> this.triggerRegen((String)c, false));
    }

    boolean triggerRegen(String chunkId, boolean force) {
        AtomicBoolean hasCluster = new AtomicBoolean(false);
        this.existingClustersByType.values().forEach(list -> {
            if (list.contains(chunkId)) {
                hasCluster.set(true);
            }
        });
        if (!hasCluster.get()) {
            LoggerProject.logWarning("002015", "Chunk " + chunkId + " does not have any clusters to regenerate. Rejected.");
            return false;
        }
        this.chunksPendingRegeneration.add((Object)chunkId);
        ManagedOreClusterChunk chunk = this.loadedOreClusterChunks.get(chunkId);
        if (chunk == null) {
            return false;
        }
        int REGENERATED = OreClusterStatus.REGENERATED.ordinal();
        if (chunk.getStatus().ordinal() < REGENERATED) {
            this.chunksPendingRegeneration.remove((Object)chunkId);
            return true;
        }
        this.chunksPendingPreGeneration.add(chunkId);
        if (force) {
            this.forceProcessChunk(chunkId, OreClusterStatus.CLEANED);
        }
        return true;
    }

    private void clearHealthCheckData() {
        if (OreClustersAndRegenMain.DEBUG.booleanValue() && this.THREAD_TIMES != null) {
            this.THREAD_TIMES.values().forEach(List::clear);
        }
    }

    private LinkedHashSet<String> getBatchedChunkList(int batchSize, String startId) {
        LinkedHashSet<String> chunkIds = new LinkedHashSet<String>();
        class_1923 pos = HBUtil.ChunkUtil.getChunkPos((String)startId);
        ChunkGenerationOrderHandler chunkIdGeneratorHandler = this.mainSpiral;
        if (this.mainSpiral.testMainSpiralRangeExceeded()) {
            chunkIdGeneratorHandler = new ChunkGenerationOrderHandler(pos);
        }
        for (int i = 0; i < batchSize; ++i) {
            class_1923 next = chunkIdGeneratorHandler.getNextSpiralChunk();
            chunkIds.add(HBUtil.ChunkUtil.getId((class_1923)next));
        }
        return chunkIds;
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public ManagedOreClusterChunk getLoadedChunk(String chunkId) {
        return this.loadedOreClusterChunks.get(chunkId);
    }

    public class_2818 getForceLoadedChunk(String chunkId) {
        return this.forceLoadedChunks.get(chunkId);
    }

    public LinkedHashSet<String> getRecentChunkIds(class_1923 start, int spiralArea) {
        if ((double)this.chunksPendingCleaning.size() < Math.pow(ModRealTimeConfig.ORE_CLUSTER_DTRM_RADIUS_STRATEGY_CHANGE.intValue(), 2.0)) {
            return this.chunksPendingCleaning.stream().limit(spiralArea).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        LinkedHashSet<String> chunkIds = new LinkedHashSet<String>();
        ChunkGenerationOrderHandler spiralHandler = new ChunkGenerationOrderHandler(start);
        try {
            for (int i = 0; i < spiralArea; ++i) {
                class_1923 next = spiralHandler.getNextSpiralChunk();
                chunkIds.add(HBUtil.ChunkUtil.getId((class_1923)next));
            }
        }
        catch (Exception e) {
            LoggerProject.logError("002016", "Error generating spiral chunk ids at startPos: " + start.toString() + " message " + e.getMessage());
        }
        return chunkIds;
    }

    @ThreadSafe
    private synchronized Optional<ManagedOreClusterChunk> editManagedChunk(ManagedOreClusterChunk chunk, Consumer<ManagedOreClusterChunk> consumer) {
        if (chunk == null) {
            return Optional.empty();
        }
        if (chunk.getLock().isLocked()) {
            return Optional.empty();
        }
        chunk.getLock().lock();
        consumer.accept(chunk);
        chunk.getLock().unlock();
        return Optional.ofNullable(chunk);
    }

    public void shutdown() {
        OreClusterManager.save(DatastoreSaveEvent.create());
        this.managerRunning = false;
        if (this.threadLoad != null) {
            this.threadLoad.interrupt();
        }
        if (this.threadWatchManagedOreChunkLifetime != null) {
            this.threadWatchManagedOreChunkLifetime.interrupt();
        }
    }

    private void load() {
        JsonArray ids;
        JsonElement regenChunks;
        JsonElement addedClusters;
        this.managerRunning = false;
        this.initializing = true;
        DataStore ds = GeneralConfig.getInstance().getDataStore();
        LevelSaveData levelData = ds.getOrCreateLevelSaveData("hbs_ore_cluster_and_regen", this.level);
        if (levelData.get("determinedSourceChunks") == null) {
            this.initializing = false;
            this.managerRunning = true;
            return;
        }
        JsonElement removedClusters = levelData.get("removedClusters");
        if (removedClusters != null && !removedClusters.isJsonNull()) {
            JsonObject json = removedClusters.getAsJsonObject();
            for (Object oreType : json.keySet()) {
                OreClusterConfigModel.OreClusterId id = this.config.getOreConfigId(Integer.parseInt((String)oreType));
                if (id == null) continue;
                JsonArray ids2 = json.get((String)oreType).getAsJsonArray();
                this.removedClustersByType.get(id).addAll(ids2.asList().stream().map(JsonElement::getAsString).toList());
            }
        }
        if ((addedClusters = levelData.get("addedClusters")) != null && !addedClusters.isJsonNull()) {
            JsonObject json = addedClusters.getAsJsonObject();
            for (String oreType : json.keySet()) {
                OreClusterConfigModel.OreClusterId oreClusterId = this.config.getOreConfigId(Integer.parseInt(oreType));
                if (oreClusterId == null) continue;
                JsonArray chunkIds = json.get(oreType).getAsJsonArray();
                this.tentativeClustersByType.get(oreClusterId).addAll(chunkIds.asList().stream().map(JsonElement::getAsString).toList());
                this.existingClustersByType.get(oreClusterId).addAll(chunkIds.asList().stream().map(JsonElement::getAsString).toList());
                List<String> listIds = chunkIds.asList().stream().map(JsonElement::getAsString).toList();
                for (String id : listIds) {
                    this.addedClustersByType.put(id, new HashMap());
                    this.addedClustersByType.get(id).put(oreClusterId, null);
                }
            }
        }
        if ((regenChunks = levelData.get("chunksPendingRegen")) != null && !regenChunks.isJsonNull()) {
            ids = regenChunks.getAsJsonArray();
            this.chunksPendingRegeneration.addAll(ids.asList().stream().map(JsonElement::getAsString).toList());
        }
        ids = levelData.get("determinedSourceChunks").getAsJsonArray();
        List<String> chunkIds = ids.asList().stream().map(JsonElement::getAsString).toList();
        for (OreClusterConfigModel.OreClusterId oreType : this.removedClustersByType.keySet()) {
            for (String id : this.removedClustersByType.get(oreType)) {
                this.tentativeClustersByType.get(oreType).remove(id);
            }
        }
        this.managerRunning = true;
    }

    private void save(DataStore ds) {
        if (ds == null) {
            return;
        }
        LevelSaveData levelData = ds.getOrCreateLevelSaveData("hbs_ore_cluster_and_regen", this.level);
        String[] ids = (String[])this.determinedSourceChunks.toArray((Object[])new String[0]);
        Function<class_2680, String> toName = bs -> HBUtil.BlockUtil.blockToString((class_2248)bs.method_26204());
        Function<Set, JsonElement> toArray = list -> HBUtil.FileIO.arrayToJson((String[])list.toArray(new String[0]));
        JsonObject removedClusters = new JsonObject();
        for (OreClusterConfigModel.OreClusterId clusterId : this.removedClustersByType.keySet()) {
            removedClusters.add(clusterId.getStringId(), toArray.apply(this.removedClustersByType.get(clusterId)));
        }
        JsonObject addedClusters = new JsonObject();
        HashMap addedClustersByOreClusterId = new HashMap();
        for (OreClusterConfigModel.OreClusterId ore : this.config.getOreConfigs().keySet()) {
            Set clusterIds = this.addedClustersByType.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(ore)).map(Map.Entry::getKey).collect(Collectors.toSet());
            addedClustersByOreClusterId.put(ore, clusterIds);
        }
        for (OreClusterConfigModel.OreClusterId ore : addedClustersByOreClusterId.keySet()) {
            addedClusters.add(ore.getStringId(), toArray.apply((Set)addedClustersByOreClusterId.get(ore)));
        }
        String[] regenIds = (String[])this.chunksPendingRegeneration.toArray((Object[])new String[0]);
        levelData.addProperty("chunksPendingRegen", HBUtil.FileIO.arrayToJson((String[])regenIds));
    }

    public static void onChunkLoad(ChunkLoadingEvent.Load event) {
        class_1936 level = event.getLevel();
        if (level == null || level.method_8608()) {
            return;
        }
        OreClusterManager manager = OreClustersAndRegenMain.getManagers().get(level);
        if (manager != null) {
            manager.onLoadedChunkId(HBUtil.ChunkUtil.getId((class_2791)event.getChunk()));
        }
    }

    public static void addManagedOreClusterChunk(ManagedOreClusterChunk managedChunk) {
        OreClusterManager manager = OreClustersAndRegenMain.getManagers().get(managedChunk.getLevel());
        if (manager != null) {
            manager.addOrUpdatedLoadedChunk(managedChunk);
        }
    }

    public static void onChunkUnload(ChunkLoadingEvent.Unload event) {
        OreClusterManager manager;
        class_1936 level = event.getLevel();
        if (!(level != null && level.method_8608() || (manager = OreClustersAndRegenMain.getManagers().get(level)) == null)) {
            manager.onChunkUnloaded(event.getChunk());
        }
    }

    public static ManagedOreClusterChunk getManagedOreClusterChunk(class_1936 level, class_2818 chunk) {
        OreClusterManager manager = OreClustersAndRegenMain.getManagers().get(level);
        if (manager == null) {
            return null;
        }
        return manager.getManagedOreClusterChunk((class_2791)chunk);
    }

    public static OreClusterManager getManager(class_1936 level) {
        return OreClustersAndRegenMain.getManagers().get(level);
    }

    public Set<String> getDeterminedChunks() {
        return this.determinedChunks;
    }

    public ManagedOreClusterChunk getManagedOreClusterChunk(class_2791 chunk) {
        return this.getManagedOreClusterChunk(HBUtil.ChunkUtil.getId((class_2791)chunk));
    }

    public ManagedOreClusterChunk getManagedOreClusterChunk(String chunkId) {
        this.loadedOreClusterChunks.putIfAbsent(chunkId, ManagedOreClusterChunk.getInstance((class_1936)this.level, chunkId));
        return this.loadedOreClusterChunks.get(chunkId);
    }

    private static void onSingletick(ServerTickEvent event) {
        for (OreClusterManager m : MANAGERS.values()) {
            if (!m.managerRunning) continue;
            if (WORKER_THREAD_ENABLED.get("workerThreadLoadedChunk").booleanValue()) {
                m.workerThreadLoadedChunk();
            }
            if (WORKER_THREAD_ENABLED.get("workerThreadDetermineClusters").booleanValue()) {
                m.workerThreadDetermineClusters();
            }
            if (WORKER_THREAD_ENABLED.get("workerThreadCleanClusters").booleanValue()) {
                m.workerThreadCleanClusters();
            }
            if (WORKER_THREAD_ENABLED.get("workerThreadGenerateClusters").booleanValue()) {
                m.workerThreadGenerateClusters();
            }
            if (!WORKER_THREAD_ENABLED.get("workerThreadEditChunk").booleanValue()) continue;
            m.workerThreadManifestChunkEdits();
        }
    }

    private static void save(DatastoreSaveEvent event) {
        for (OreClusterManager m : MANAGERS.values()) {
            m.save(event.getDataStore());
        }
    }

    private static void on1200Ticks(ServerTickEvent event) {
        for (OreClusterManager m : MANAGERS.values()) {
            if (m.threadWatchManagedOreChunkLifetime != null && m.threadWatchManagedOreChunkLifetime.isAlive()) continue;
            m.watchLoadedChunkExpiration();
        }
    }

    private static /* synthetic */ boolean lambda$loadChunksNearPlayer$1(class_1937 level, String c) {
        return !ManagedChunkUtility.isChunkFullyLoaded((class_1936)level, (String)c);
    }

    static {
        WORKER_THREAD_ENABLED = new HashMap<String, Boolean>(){
            {
                this.put("workerThreadLoadedChunk", true);
                this.put("workerThreadDetermineClusters", true);
                this.put("workerThreadCleanClusters", true);
                this.put("workerThreadGenerateClusters", true);
                this.put("workerThreadEditChunk", true);
            }
        };
        MAX_DETERMINED_CHUNK_LIFETIME_MILLIS = OreClustersAndRegenMain.DEBUG != false ? 30000L : 150000L;
        MIN_EXPIRATION_CHECK_TICK_ALIVE_COUNT = OreClustersAndRegenMain.DEBUG != false ? 120L : 1200L;
        SLEEP_TIME_PER_CHUNK_MILLIS = OreClustersAndRegenMain.DEBUG != false ? 100L : 100L;
        MAX_EXPIRATIONS = 100L;
        totalCleaned = 0;
        missingOriginalsCleaned = 0;
        manifestUpdates = new ConcurrentHashMap<String, Integer>();
    }

    private class ChunkGenerationOrderHandler {
        private static final int[] UP = new int[]{0, 1};
        private static final int[] RIGHT = new int[]{1, 0};
        private static final int[] DOWN = new int[]{0, -1};
        private static final int[] LEFT = new int[]{-1, 0};
        private static final int[][] DIRECTIONS = new int[][]{UP, RIGHT, DOWN, LEFT};
        private class_1923 currentPos;
        private int total;
        private int count;
        private int dirCount;
        private int[] dir;

        public ChunkGenerationOrderHandler(class_1923 start) {
            this.currentPos = start == null ? new class_1923(0, 0) : start;
            this.total = 0;
            this.count = 1;
            this.dirCount = 0;
            this.dir = UP;
        }

        public class_1923 getNextSpiralChunk() {
            if (this.total == 0) {
                ++this.total;
                return this.currentPos;
            }
            if (this.dirCount == this.count) {
                this.dir = this.getNextDirection();
                this.dirCount = 0;
                if (this.dir == UP || this.dir == DOWN) {
                    ++this.count;
                }
            }
            this.currentPos = HBUtil.ChunkUtil.posAdd((class_1923)this.currentPos, (int[])this.dir);
            ++this.total;
            ++this.dirCount;
            return this.currentPos;
        }

        private int[] getNextDirection() {
            int index = Arrays.asList(DIRECTIONS).indexOf(this.dir);
            return DIRECTIONS[(index + 1) % DIRECTIONS.length];
        }

        public boolean testMainSpiralRangeExceeded() {
            return (double)this.total >= Math.pow(ModRealTimeConfig.ORE_CLUSTER_DTRM_RADIUS_STRATEGY_CHANGE.intValue(), 2.0);
        }
    }
}

