/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core.model;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.modelInterface.IMangedChunkData;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.OreClusterStatus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedOreClusterChunk
implements IMangedChunkData {
    private static final String CLASS_ID = "003";
    private static final String NBT_KEY_HEADER = "managedOreClusterChunk";
    public static final String TEST_ID = "-1,0";
    public static final int MAX_ORIGINAL_ORES = 8;
    public static ModRealTimeConfig CONFIG;
    private class_1936 level;
    private String id;
    private class_1923 pos;
    private OreClusterStatus status;
    private long timeUnloaded;
    private long timeLastLoaded;
    private long tickLoaded;
    private boolean isReady;
    private HashMap<OreClusterConfigModel.OreClusterId, class_2338> clusterTypes;
    private Map<OreClusterConfigModel.OreClusterId, Pair<class_2338, MutableInt>> originalOres;
    private Map<class_2680, LinkedHashSet<class_2338>> blockStateUpdates;
    private int updatesSize;
    private LinkedHashSet<class_1959> biomes;
    private Random managedRandom;
    private ReentrantLock lock = new ReentrantLock();
    private static final OreClusterStatus current;
    private static final OreClusterStatus delinquent;
    private static Set<String> loadedIds;
    private static Set<String> deserializedIds;

    public static void registerManagedChunkData() {
        ManagedChunk.registerManagedChunkData(ManagedOreClusterChunk.class, () -> new ManagedOreClusterChunk(null));
    }

    private ManagedOreClusterChunk(class_1936 level) {
        this.level = level;
        this.id = null;
        this.pos = null;
        this.status = OreClusterStatus.NONE;
        this.timeUnloaded = -1L;
        this.timeLastLoaded = System.currentTimeMillis();
        this.tickLoaded = GeneralConfig.getInstance().getTotalTickCount();
        this.isReady = false;
        this.clusterTypes = null;
        this.blockStateUpdates = new ConcurrentHashMap<class_2680, LinkedHashSet<class_2338>>();
        this.updatesSize = 0;
        this.originalOres = new HashMap<OreClusterConfigModel.OreClusterId, Pair<class_2338, MutableInt>>();
        this.biomes = new LinkedHashSet();
    }

    private ManagedOreClusterChunk(class_1936 level, String id) {
        this(level);
        this.setId(id);
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)id);
    }

    public class_2818 getChunk(boolean forceLoad) {
        class_2818 c;
        OreClusterManager m = OreClusterManager.getManager(this.level);
        if (m != null && (c = m.getForceLoadedChunk(this.id)) != null) {
            return c;
        }
        ManagedChunk parent = ManagedOreClusterChunk.getParent(this.level, this.id);
        if (parent == null) {
            return null;
        }
        return parent.getLevelChunk();
    }

    public ManagedChunk getParent() {
        return ManagedOreClusterChunk.getParent(this.level, this.id);
    }

    public class_2818 getChunk() {
        return this.getChunk(false);
    }

    public boolean testChunkLoadedAndEditable() {
        ManagedChunk parent = this.getParent();
        if (parent == null || parent.util == null) {
            return false;
        }
        return parent.util.isChunkFullyLoaded(this.id);
    }

    public boolean hasChunk() {
        return this.getChunk(false) != null;
    }

    public class_1923 getChunkPos() {
        return this.pos;
    }

    public String getId() {
        return this.id;
    }

    public OreClusterStatus getStatus() {
        return this.status;
    }

    public HashMap<OreClusterConfigModel.OreClusterId, class_2338> getClusterTypes() {
        if (this.clusterTypes == null) {
            return new HashMap<OreClusterConfigModel.OreClusterId, class_2338>();
        }
        return this.clusterTypes;
    }

    public boolean hasClusters() {
        if (this.clusterTypes == null) {
            return false;
        }
        return this.clusterTypes.size() > 0;
    }

    public boolean hasReadyClusters() {
        if (!this.hasClusters()) {
            return false;
        }
        boolean ready = this.clusterTypes.values().stream().allMatch(pos -> pos != null);
        return ready;
    }

    public int countUpdatesRemaining() {
        return this.blockStateUpdates.size();
    }

    public Set<class_2680> getBlockStateUpdatesSet() {
        return this.blockStateUpdates.keySet();
    }

    public Map<class_2680, LinkedHashSet<class_2338>> getBlockStateUpdates() {
        return this.blockStateUpdates;
    }

    public Optional<class_2680> getBlockStateUpdateType() {
        return this.blockStateUpdates.keySet().stream().findFirst();
    }

    @Nullable
    public LinkedHashSet<class_2338> getBlockStateUpdates(class_2680 state) {
        return this.blockStateUpdates.get(state);
    }

    public void removeBlockStateUpdates(class_2680 state) {
        this.blockStateUpdates.remove(state);
    }

    public Map<OreClusterConfigModel.OreClusterId, Pair<class_2338, MutableInt>> getOriginalOres() {
        return this.originalOres;
    }

    public class_1936 getLevel() {
        return this.level;
    }

    public Long getTimeUnloaded() {
        return this.timeUnloaded;
    }

    public Long getTimeLastLoaded() {
        return this.timeLastLoaded;
    }

    public Long getTickLoaded() {
        return this.tickLoaded;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public Random getChunkRandom() {
        return ManagedChunkUtility.getChunkRandom((class_1923)this.pos, (Long)ModRealTimeConfig.CLUSTER_SEED);
    }

    public synchronized ReentrantLock getLock() {
        return this.lock;
    }

    public boolean hasBiome(class_1959 b) {
        if (b == null) {
            return false;
        }
        return this.biomes.contains(b);
    }

    public Set<class_1959> getBiomes() {
        return this.biomes;
    }

    public OreClusterConfigModel.OreClusterId chooseConfigId(class_1937 level, class_1959 localBiome, class_2680 blockState, ModRealTimeConfig C) {
        OreClusterConfigModel.OreClusterId id;
        block1: {
            class_1959 temp;
            id = C.getOreConfigId(level, localBiome, blockState.method_26204());
            if (localBiome != null && id != null) break block1;
            Iterator iterator = this.biomes.iterator();
            while (iterator.hasNext() && (id = C.getOreConfigId(level, temp = (class_1959)iterator.next(), blockState.method_26204())) == null) {
            }
        }
        return id;
    }

    public OreClusterConfigModel chooseConfig(class_1937 level, class_1959 localBiome, class_2680 blockState, ModRealTimeConfig C) {
        OreClusterConfigModel.OreClusterId id = this.chooseConfigId(level, localBiome, blockState, C);
        if (id == null) {
            return null;
        }
        return C.getOreConfigs().get(id);
    }

    public void setId(String id) {
        if (id == null) {
            return;
        }
        this.id = id;
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)id);
        this.managedRandom = this.getChunkRandom();
    }

    public void setLevel(class_1936 level) {
        this.level = level;
    }

    public void setStatus(OreClusterStatus status) {
        if (this.status != current || status == delinquent) {
            // empty if block
        }
        this.status = status;
    }

    public boolean sampleAddOre(OreClusterConfigModel.OreClusterId id, int sectionY) {
        if (this.originalOres == null) {
            return false;
        }
        if (!CONFIG.testValidYSpawn(id, sectionY)) {
            return false;
        }
        if (!this.originalOres.containsKey(id)) {
            this.originalOres.put(id, (Pair<class_2338, MutableInt>)Pair.of(null, (Object)new MutableInt(1)));
            return true;
        }
        MutableInt count = (MutableInt)this.originalOres.get(id).getRight();
        return this.managedRandom.nextFloat() <= 1.0f / (float)count.getAndAdd(1);
    }

    public void addOre(OreClusterConfigModel.OreClusterId config, class_2338 pos, boolean force) {
        Pair pair = this.originalOres.get(config);
        if (pair == null) {
            pair = Pair.of((Object)pos, (Object)new MutableInt(1));
            this.originalOres.put(config, (Pair<class_2338, MutableInt>)pair);
            return;
        }
        int sectionNumber = pos.method_10264() / 16 + pos.method_10264() % 16;
        if (force || this.sampleAddOre(config, sectionNumber)) {
            pair = Pair.of((Object)pos, (Object)((MutableInt)pair.getRight()));
            this.originalOres.put(config, (Pair<class_2338, MutableInt>)pair);
        }
    }

    public boolean hasOreClusterSourcePos(OreClusterConfigModel.OreClusterId b) {
        if (this.clusterTypes != null && this.clusterTypes.get(b) != null) {
            return true;
        }
        if (this.originalOres == null) {
            return false;
        }
        if (!this.originalOres.containsKey(b)) {
            return false;
        }
        return this.originalOres.get(b).getLeft() != null;
    }

    public class_2338 getOreClusterSourcePos(OreClusterConfigModel.OreClusterId b) {
        if (this.clusterTypes != null && this.clusterTypes.get(b) != null) {
            return this.clusterTypes.get(b);
        }
        if (this.originalOres == null) {
            return null;
        }
        if (!this.originalOres.containsKey(b)) {
            return null;
        }
        return (class_2338)this.originalOres.get(b).getLeft();
    }

    public void clearOriginalOres() {
        if (ManagedOreClusterChunk.isNoStatus(this) || ManagedOreClusterChunk.isDetermined(this)) {
            return;
        }
        if (this.originalOres == null) {
            return;
        }
        this.originalOres.clear();
        this.originalOres = null;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public void setTimeUnloaded() {
        this.timeUnloaded = System.currentTimeMillis();
    }

    public boolean updateTimeLastLoaded(Long currentTime) {
        ManagedChunk parent = this.getParent();
        if (parent == null || parent.util == null) {
            return false;
        }
        if (parent.util.isLoaded(this.id)) {
            this.timeLastLoaded = currentTime;
            return true;
        }
        return false;
    }

    public void addClusterTypes(List<OreClusterConfigModel.OreClusterId> clusters) {
        if (clusters == null) {
            return;
        }
        if (this.clusterTypes == null) {
            this.clusterTypes = new HashMap();
        }
        HashMap<OreClusterConfigModel.OreClusterId, class_2338> clusterMap = new HashMap<OreClusterConfigModel.OreClusterId, class_2338>();
        for (OreClusterConfigModel.OreClusterId id : clusters) {
            if (this.clusterTypes.containsKey(id)) continue;
            clusterMap.put(id, null);
        }
        this.addClusterTypes(clusterMap);
    }

    public void addClusterTypes(Map<OreClusterConfigModel.OreClusterId, class_2338> clusterMap) {
        if (clusterMap == null) {
            return;
        }
        if (clusterMap.size() == 0) {
            return;
        }
        if (this.clusterTypes == null) {
            this.clusterTypes = new HashMap();
        }
        this.clusterTypes.putAll(clusterMap);
    }

    public void addBlockStateUpdate(class_2680 block, class_2338 pos) {
        if (block.equals(ModBlocks.empty.method_9564())) {
            return;
        }
        LinkedHashSet<Object> positions = this.blockStateUpdates.get(block);
        if (positions == null) {
            positions = new LinkedHashSet();
            this.blockStateUpdates.put(block, positions);
        }
        positions.add(pos);
    }

    public void addBiome(class_1959 b) {
        if (b == null) {
            return;
        }
        this.biomes.add(b);
    }

    public boolean loadBiomes(class_2791 chunk) {
        if (chunk == null || chunk.method_12006().length == 0 || chunk.method_12006()[0] == null) {
            return false;
        }
        chunk.method_12006()[0].method_38294().method_39793(hb -> this.addBiome((class_1959)hb.comp_349()));
        return this.biomes.size() > 0;
    }

    public boolean checkClusterHarvested() {
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        if (this.status == OreClusterStatus.HARVESTED) {
            return true;
        }
        if (this.status != OreClusterStatus.GENERATED) {
            return false;
        }
        class_2818 chunk = this.getChunk(false);
        if (chunk == null) {
            return false;
        }
        for (class_2680 block : this.blockStateUpdates.keySet()) {
            for (class_2338 pos : this.blockStateUpdates.get(block)) {
                if (chunk.method_8320(pos).method_26204().equals(block)) continue;
                this.status = OreClusterStatus.HARVESTED;
                this.blockStateUpdates.clear();
                return true;
            }
        }
        return false;
    }

    public boolean hasBlockUpdates() {
        return this.blockStateUpdates != null && this.blockStateUpdates.size() > 0;
    }

    public void clearBlockStateUpdates() {
        this.blockStateUpdates.clear();
        this.updatesSize = 0;
    }

    public ManagedOreClusterChunk getEarliest(Map<String, ManagedOreClusterChunk> loadedChunks) {
        ManagedOreClusterChunk existing = loadedChunks.get(this.id);
        if (existing == null) {
            return this;
        }
        if (existing.getTickLoaded() < this.getTickLoaded()) {
            return existing;
        }
        return this;
    }

    public class_2680 mapBlockState(class_2680 state) {
        Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> ORE_CONFIGS = OreClusterManager.getManager(this.level).getConfig().getOreConfigs();
        class_2248[] replacements = ORE_CONFIGS.get((Object)state).oreClusterReplaceableEmptyBlocks.toArray(new class_2248[0]);
        Float modifier = ORE_CONFIGS.get((Object)state).oreVeinModifier;
        if (this.managedRandom.nextFloat() > modifier.floatValue()) {
            return replacements[this.managedRandom.nextInt(replacements.length)].method_9564();
        }
        return state;
    }

    public ManagedOreClusterChunk getStaticInstance(class_1936 level, String id) {
        if (id == null || level == null) {
            return null;
        }
        OreClusterManager manager = OreClustersAndRegenMain.getManagers().get(level);
        if (manager != null && manager.getLoadedChunk(id) != null) {
            return manager.getLoadedChunk(id);
        }
        ManagedOreClusterChunk chunk = ManagedOreClusterChunk.getInstance(level, id);
        return chunk;
    }

    public boolean isInit(String subClass) {
        return subClass.equals(ManagedOreClusterChunk.class.getName()) && this.id != null;
    }

    public void handleChunkLoaded(ChunkLoadingEvent.Load event) {
        loadedIds.add(this.id);
        this.level = event.getLevel();
        this.pos = event.getChunkPos();
        this.timeUnloaded = -1L;
        OreClusterManager.onChunkLoad(event);
    }

    public void handleChunkUnloaded(ChunkLoadingEvent.Unload event) {
        OreClusterManager.onChunkUnload(event);
    }

    public static ManagedOreClusterChunk getInstance(class_1936 level, class_2818 chunk) {
        return ManagedOreClusterChunk.getInstance(level, HBUtil.ChunkUtil.getId((class_2791)chunk));
    }

    public static ManagedOreClusterChunk getInstance(class_1936 level, String id) {
        ManagedChunk parent = ManagedOreClusterChunk.getParent(level, id);
        if (parent == null) {
            return new ManagedOreClusterChunk(level, id);
        }
        ManagedOreClusterChunk c = (ManagedOreClusterChunk)parent.getSubclass(ManagedOreClusterChunk.class);
        if (c == null) {
            return new ManagedOreClusterChunk(level, id);
        }
        return c;
    }

    public static ManagedChunk getParent(class_1936 level, String id) {
        ManagedChunkUtility instance = ManagedChunkUtility.getInstance((class_1936)level);
        return instance.getManagedChunk(id);
    }

    public static boolean isNoStatus(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.NONE;
    }

    public static boolean isDetermined(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.DETERMINED;
    }

    public static boolean isCleaned(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.CLEANED;
    }

    public static boolean isPregenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.PREGENERATED;
    }

    public static boolean isRegenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.REGENERATED;
    }

    public static boolean isGenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.GENERATED;
    }

    public static boolean isHarvested(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.HARVESTED;
    }

    public static boolean isComplete(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.COMPLETE;
    }

    public static boolean isReady(ManagedOreClusterChunk chunk) {
        return chunk.isReady;
    }

    public static boolean isLoaded(ManagedOreClusterChunk chunk) {
        if (chunk == null) {
            return false;
        }
        if (chunk.getParent() == null) {
            return false;
        }
        return chunk.getParent().util.isLoaded(chunk.getId());
    }

    public static boolean isFinished(ManagedOreClusterChunk c) {
        return ManagedOreClusterChunk.isComplete(c) || ManagedOreClusterChunk.isGenerated(c) || ManagedOreClusterChunk.isHarvested(c);
    }

    public class_2487 serializeNBT() {
        class_2487 details = new class_2487();
        details.method_10582("id", this.id);
        details.method_10544("tickLoaded", this.tickLoaded);
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        if (this.hasBlockUpdates()) {
            details.method_10582("status", OreClusterStatus.CLEANED.toString());
        } else {
            details.method_10582("status", this.status.toString());
        }
        if (this.clusterTypes == null || this.clusterTypes.size() == 0) {
            details.method_10566("clusterTypes", (class_2520)new class_2487());
        } else {
            class_2487 clusterTypesTag = new class_2487();
            this.clusterTypes.forEach((oreClusterId, pos) -> {
                String key = oreClusterId.getStringId();
                String serializedPositions = "";
                if (pos != null) {
                    serializedPositions = HBUtil.BlockUtil.serializeBlockPos(List.of(pos));
                }
                clusterTypesTag.method_10582(key, serializedPositions);
            });
            details.method_10566("clusterTypes", (class_2520)clusterTypesTag);
        }
        LoggerProject.logDebug("003007", "Serializing ManagedOreChunk: " + details);
        return details;
    }

    public void deserializeNBT(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return;
        }
        deserializedIds.add(this.id);
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)this.id);
        this.tickLoaded = tag.method_10537("tickLoaded");
        this.timeUnloaded = -1L;
        this.status = OreClusterStatus.valueOf(tag.method_10558("status"));
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        class_2487 clusterTypesTag = tag.method_10562("clusterTypes");
        this.clusterTypes = new HashMap();
        if (clusterTypesTag != null && !clusterTypesTag.method_33133()) {
            for (String key : clusterTypesTag.method_10541()) {
                OreClusterConfigModel.OreClusterId oreClusterId = CONFIG.getOreConfigId(Integer.parseInt(key));
                String serializedPositions = clusterTypesTag.method_10558(key);
                if (serializedPositions == "") {
                    this.clusterTypes.put(oreClusterId, null);
                    continue;
                }
                List positions = HBUtil.BlockUtil.deserializeBlockPos((String)serializedPositions);
                this.clusterTypes.put(oreClusterId, (class_2338)positions.get(0));
            }
        }
        OreClusterManager.addManagedOreClusterChunk(this);
    }

    static {
        current = OreClusterStatus.CLEANED;
        delinquent = OreClusterStatus.DETERMINED;
        loadedIds = new HashSet<String>();
        deserializedIds = new HashSet<String>();
    }
}

