/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.config.OreClusterConfig;
import com.holybuckets.orecluster.config.OreClusterConfigData;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.config.model.OreClusterJsonConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModRealTimeConfig {
    public static final String CLASS_ID = "000";
    private static final Set<LevelAccessor> levelInit = new HashSet<LevelAccessor>();
    private OreClusterConfigModel defaultConfig;
    private Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> oreConfigs;
    private List<OreClusterConfigModel> baseOreConfigs;
    private Map<String, OreClusterConfigModel.OreClusterId> baseConfigIds;
    private Set<BlockState> validOreClusterBlocks;
    public static final Integer CHUNK_NORMALIZATION_TOTAL = 1000;
    public static final Function<Integer, Double> CHUNK_DISTRIBUTION_STDV_FUNC = mean -> {
        if (mean < 8) {
            return (double)mean.intValue() / 2.0;
        }
        return (double)mean.intValue() / (Math.log(mean.intValue()) * 3.0);
    };
    public static final Integer ORE_CLUSTER_DTRM_BATCH_SIZE_TOTAL = 1000;
    public static final Integer ORE_CLUSTER_DTRM_RADIUS_STRATEGY_CHANGE = 128;
    public static Long CLUSTER_SEED = null;

    public ModRealTimeConfig(EventRegistrar reg) {
        reg.registerOnBeforeServerStarted(this::onBeforeServerStart, EventPriority.High);
        reg.registerOnLevelLoad(this::onLevelLoad, EventPriority.High);
        reg.registerOnServerStopped(this::onServerStopped, EventPriority.Low);
        this.oreConfigs = new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>();
        this.baseConfigIds = new HashMap<String, OreClusterConfigModel.OreClusterId>();
        this.baseOreConfigs = new ArrayList<OreClusterConfigModel>();
        this.validOreClusterBlocks = new HashSet<BlockState>();
        LoggerProject.logInit("000000", this.getClass().getName());
    }

    public void onBeforeServerStart(ServerStartingEvent event) {
        this.oreConfigs = new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>();
        this.baseConfigIds = new HashMap<String, OreClusterConfigModel.OreClusterId>();
        this.baseOreConfigs = new ArrayList<OreClusterConfigModel>();
        this.validOreClusterBlocks = new HashSet<BlockState>();
        OreClusterConfigData.COreClusters clusterConfig = OreClusterConfig.getActive().cOreClusters;
        this.defaultConfig = new OreClusterConfigModel(clusterConfig);
        this.defaultConfig.setConfigId();
        File configFile = new File(clusterConfig.oreClusterFileConfigPath);
        File defaultConfigFile = new File("config/HBOreClustersAndRegenConfigs.json");
        String jsonOreConfigData = HBUtil.FileIO.loadJsonConfigs((File)configFile, (File)defaultConfigFile, (IStringSerializable)OreClusterJsonConfig.DEFAULT_CONFIG);
        OreClusterJsonConfig jsonOreConfigs = new OreClusterJsonConfig(jsonOreConfigData);
        for (Block validOreClusterBlock : this.defaultConfig.validOreClusterOreBlocks.stream().toList()) {
            this.defaultConfig.setOreClusterType(validOreClusterBlock.m_49966_());
            OreClusterConfigModel oreConfig = new OreClusterConfigModel(OreClusterConfigModel.serialize(this.defaultConfig));
            this.baseOreConfigs.add(oreConfig);
        }
        this.defaultConfig.setOreClusterType((BlockState)null);
        if (!jsonOreConfigs.getOreClusterConfigs().isEmpty()) {
            this.baseOreConfigs.clear();
        }
        for (OreClusterConfigModel oreConfig : jsonOreConfigs.getOreClusterConfigs()) {
            oreConfig.setConfigId();
            this.baseOreConfigs.add(oreConfig);
        }
        this.validateClusterSpacingAndMinBlocks();
        CLUSTER_SEED = this.defaultConfig.subSeed != null ? this.defaultConfig.subSeed : GeneralConfig.getInstance().getWorldSeed();
        OreClusterJsonConfig newJsonOreConfigs = new OreClusterJsonConfig(this.baseOreConfigs);
        HBUtil.FileIO.serializeJsonConfigs((File)configFile, (String)newJsonOreConfigs.serialize());
    }

    private void onLevelLoad(LevelLoadingEvent.Load event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (levelInit.contains(event.getLevel())) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        List<OreClusterConfigModel> levelConfigs = this.baseOreConfigs.stream().filter(model -> model.inLevel((LevelAccessor)level)).toList();
        for (OreClusterConfigModel config : levelConfigs) {
            this.baseConfigIds.put(config.configId, OreClusterConfigModel.OreClusterId.createBaseConfigId(config));
            this.oreConfigs.put(this.baseConfigIds.get(config.configId), config);
            List<OreClusterConfigModel.OreClusterId> ids = OreClusterConfigModel.getIds(level, config);
            ids.forEach(id -> this.oreConfigs.put((OreClusterConfigModel.OreClusterId)id, config));
            this.validOreClusterBlocks.add(config.oreClusterType);
        }
        levelInit.add((LevelAccessor)level);
    }

    private void onServerStopped(ServerStoppedEvent event) {
        levelInit.clear();
        OreClusterConfigModel.OreClusterId.shutdown();
        this.oreConfigs.clear();
        this.baseConfigIds.clear();
        this.baseOreConfigs.clear();
        this.validOreClusterBlocks.clear();
    }

    public List<OreClusterConfigModel> getBaseOreConfigs() {
        return this.baseOreConfigs;
    }

    public Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> getOreConfigs() {
        return new HashMap<OreClusterConfigModel.OreClusterId, OreClusterConfigModel>(this.oreConfigs);
    }

    @Nullable
    public OreClusterConfigModel getOreConfigByOre(ResourceLocation ore) {
        OreClusterConfigModel.OreClusterId id = OreClusterConfigModel.OreClusterId.getId(null, null, ore);
        return this.oreConfigs.get(id);
    }

    public List<OreClusterConfigModel> getAllOreConfigByOre(Block b) {
        HashSet<OreClusterConfigModel> configs = new HashSet<OreClusterConfigModel>();
        for (OreClusterConfigModel config : this.baseOreConfigs) {
            if (config.oreClusterType == null || !config.oreClusterType.equals(b.m_49966_())) continue;
            configs.add(config);
        }
        return configs.stream().toList();
    }

    public OreClusterConfigModel getOreConfigModel(OreClusterConfigModel.OreClusterId id) {
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel.OreClusterId getOreConfigId(Level l, Biome b, Block bl) {
        return OreClusterConfigModel.OreClusterId.getId(l, b, bl);
    }

    public OreClusterConfigModel.OreClusterId getOreConfigId(int id) {
        if (this.oreConfigs == null) {
            return null;
        }
        for (OreClusterConfigModel.OreClusterId oreId : this.oreConfigs.keySet()) {
            if (oreId.getId() != id) continue;
            return oreId;
        }
        return null;
    }

    public OreClusterConfigModel getBaseOreConfig(String configId) {
        for (OreClusterConfigModel config : this.baseOreConfigs) {
            if (!config.configId.equals(configId)) continue;
            return config;
        }
        return null;
    }

    public OreClusterConfigModel.OreClusterId getBaseOreConfigId(String configId) {
        return this.baseConfigIds.get(configId);
    }

    public Set<OreClusterConfigModel.OreClusterId> getAllOreConfigIdsByOre(Block b) {
        return this.oreConfigs.keySet().stream().filter(id -> id.filter(b)).collect(Collectors.toSet());
    }

    public Set<OreClusterConfigModel.OreClusterId> getAllOreConfigIdsByBiome(Level l, Biome b) {
        return this.oreConfigs.keySet().stream().filter(id -> id.filter(l, b)).collect(Collectors.toSet());
    }

    public OreClusterConfigModel getDefaultConfigModel() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(OreClusterConfigModel defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    private void validateClusterSpacingAndMinBlocks() {
        int totalSpawnRatePerAreaSquared = 0;
        for (OreClusterConfigModel oreConfig : this.baseOreConfigs) {
            totalSpawnRatePerAreaSquared += oreConfig.oreClusterSpawnRate.intValue();
        }
        int reservedBlocksSquaredPerCluster = (int)Math.pow(this.defaultConfig.minChunksBetweenOreClusters.intValue(), 2.0);
        if (reservedBlocksSquaredPerCluster == 0 || totalSpawnRatePerAreaSquared == 0) {
            return;
        }
        int maxClustersPerAreaSquared = CHUNK_NORMALIZATION_TOTAL / reservedBlocksSquaredPerCluster;
        if (totalSpawnRatePerAreaSquared > maxClustersPerAreaSquared) {
            int newMinChunks = (int)Math.sqrt(CHUNK_NORMALIZATION_TOTAL / totalSpawnRatePerAreaSquared);
            StringBuilder warn = new StringBuilder();
            warn.append("The net ore cluster spawn rate exceeds the expected maximum number of clusters in a ");
            warn.append(CHUNK_NORMALIZATION_TOTAL);
            warn.append(" square chunk area: ");
            warn.append(maxClustersPerAreaSquared);
            warn.append(" square chunks alloted by ");
            warn.append(this.defaultConfig.minChunksBetweenOreClusters);
            warn.append(" chunks between clusters. While ");
            warn.append(totalSpawnRatePerAreaSquared);
            warn.append(" clusters are would be observed on average. minClustersBetweenChunks reduced to ");
            this.defaultConfig.minChunksBetweenOreClusters = (int)Math.sqrt(newMinChunks) - 1;
            warn.append(this.defaultConfig.minChunksBetweenOreClusters);
        }
    }

    public OreClusterConfigModel getOreConfig(Level l, Biome b, Block bl) {
        OreClusterConfigModel.OreClusterId id = OreClusterConfigModel.OreClusterId.getId(l, b, bl);
        if (id == null) {
            return null;
        }
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel getOreConfig(OreClusterConfigModel.OreClusterId id) {
        if (id == null) {
            return null;
        }
        return this.oreConfigs.get(id);
    }

    public OreClusterConfigModel getOreConfig(int id) {
        OreClusterConfigModel.OreClusterId oreId = this.getOreConfigId(id);
        if (oreId == null) {
            return null;
        }
        return this.oreConfigs.get(oreId);
    }

    public boolean testValidYSpawn(OreClusterConfigModel config, int sectionY) {
        if (config == null) {
            return true;
        }
        BlockPos pos = new BlockPos(0, sectionY * 16 + 8, 0);
        return ModRealTimeConfig.testValidYSpawn(config, pos);
    }

    public boolean testValidYSpawn(OreClusterConfigModel.OreClusterId id, int sectionY) {
        if (id == null || !this.oreConfigs.containsKey(id)) {
            return false;
        }
        return this.testValidYSpawn(this.oreConfigs.get(id), sectionY);
    }

    public static boolean testValidYSpawn(OreClusterConfigModel config, BlockPos pos) {
        if (config == null) {
            return true;
        }
        if (config.oreClusterMaxYLevelSpawn == null) {
            return true;
        }
        if (pos.m_123342_() > config.oreClusterMaxYLevelSpawn) {
            return false;
        }
        return pos.m_123342_() >= config.oreClusterMinYLevelSpawn;
    }

    public boolean clustersDoSpawn(Level l, Biome b, BlockState state) {
        return ModRealTimeConfig.clustersDoSpawn(this.getOreConfig(l, b, state.m_60734_()));
    }

    public static boolean clustersDoSpawn(OreClusterConfigModel config) {
        if (config == null) {
            return false;
        }
        return config.oreClusterSpawnRate > 0;
    }

    public static boolean doesLevelMatch(OreClusterConfigModel config, LevelAccessor level) {
        if (config == null) {
            return false;
        }
        if (config.oreClusterDimensionId == null) {
            return false;
        }
        if (level == null) {
            return false;
        }
        Level oreLevel = HBUtil.LevelUtil.toLevel((HBUtil.LevelUtil.LevelNameSpace)HBUtil.LevelUtil.LevelNameSpace.SERVER, (String)config.oreClusterDimensionId);
        return level.equals(oreLevel);
    }

    public boolean clustersDoSpawn(OreClusterConfigModel.OreClusterId id) {
        if (id == null) {
            return false;
        }
        OreClusterConfigModel config = this.oreConfigs.get(id);
        return ModRealTimeConfig.clustersDoSpawn(config);
    }

    public boolean doesLevelMatch(OreClusterConfigModel.OreClusterId id, LevelAccessor level) {
        if (id == null) {
            return false;
        }
        OreClusterConfigModel config = this.oreConfigs.get(id);
        return ModRealTimeConfig.doesLevelMatch(config, level);
    }

    public boolean maybeHasBlock(BlockState defaultState) {
        return this.validOreClusterBlocks.contains(defaultState);
    }
}

