/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.CommandRegistry;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.core.OreClusterApi;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.OreClusterInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CommandList {
    public static final String CLASS_ID = "010";
    private static final String PREFIX = "hbOreClusters";

    public static void register() {
        CommandRegistry.register(LocateClusters::noArgs);
        CommandRegistry.register(LocateClusters::limitCount);
        CommandRegistry.register(LocateClusters::limitCountSpecifyBlockType);
        CommandRegistry.register(GetConfig::noArgs);
        CommandRegistry.register(GetConfig::withConfigId);
        CommandRegistry.register(GetConfig::withConfigIdAndBiomes);
        CommandRegistry.register(AddCluster::register);
        CommandRegistry.register(TriggerRegen::register);
        CommandRegistry.register(HealthCheck::register);
    }

    private static String s(JsonObject object, String property) {
        if (!object.has(property) || object.get(property) == null || !object.get(property).isJsonPrimitive()) {
            return "null";
        }
        return object.getAsJsonPrimitive(property).getAsString();
    }

    private static class HealthCheck {
        private HealthCheck() {
        }

        private static LiteralArgumentBuilder<CommandSourceStack> register() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"healthCheck").executes(context -> HealthCheck.execute((CommandSourceStack)context.getSource(), null))).then(Commands.m_82129_((String)"dimensionId", (ArgumentType)StringArgumentType.string()).executes(context -> HealthCheck.execute((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"dimensionId")))));
        }

        private static int execute(CommandSourceStack source, String dimensionId) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.m_81352_((Component)Component.m_237113_((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                source.m_288197_(() -> Component.m_237113_((String)"Health Check Results:"), true);
                List levelIds = GeneralConfig.getInstance().getLevels().keySet().stream().toList();
                if (dimensionId != null) {
                    Level level = HBUtil.LevelUtil.toLevel((HBUtil.LevelUtil.LevelNameSpace)HBUtil.LevelUtil.LevelNameSpace.SERVER, (String)dimensionId);
                    if (level == null) {
                        source.m_81352_((Component)Component.m_237113_((String)("Dimension ID not found: " + dimensionId)));
                        source.m_288197_(() -> Component.m_237113_((String)("Available dimensions: \n  " + String.join((CharSequence)"\n  ", levelIds))), false);
                        return 1;
                    }
                    OreClusterManager manager = OreClusterManager.getManager((LevelAccessor)level);
                    JsonObject healthCheck = api.healthCheckStatistics(manager);
                    if (healthCheck != null) {
                        source.m_288197_(() -> Component.m_237113_((String)("Statistics for dimension " + dimensionId + ":")), false);
                        source.m_288197_(() -> Component.m_237113_((String)healthCheck.toString()), false);
                        LoggerProject.logInfo("010012", healthCheck.toString());
                    }
                } else {
                    for (OreClusterManager manager : OreClustersAndRegenMain.getManagers().values()) {
                        JsonObject healthCheck;
                        if (manager == null || (healthCheck = api.healthCheckStatistics(manager)) == null) continue;
                        String levelId = HBUtil.LevelUtil.toLevelId((LevelAccessor)manager.getLevel());
                        source.m_288197_(() -> Component.m_237113_((String)("Statistics for dimension " + levelId + ":")), false);
                        source.m_288197_(() -> Component.m_237113_((String)healthCheck.toString()), false);
                        LoggerProject.logInfo("010013", healthCheck.toString());
                    }
                }
                LoggerProject.logInfo("010011", "Health Check command completed successfully");
            }
            catch (Exception e) {
                LoggerProject.logError("010009", "Health Check Command exception: " + e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010010", "Health Check Command executed successfully");
            return 0;
        }
    }

    private static class AddCluster {
        private AddCluster() {
        }

        private static LiteralArgumentBuilder<CommandSourceStack> register() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"addCluster").then(Commands.m_82129_((String)"clusterConfigId", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> AddCluster.execute((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"clusterConfigId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), IntegerArgumentType.getInteger((CommandContext)context, (String)"y"), IntegerArgumentType.getInteger((CommandContext)context, (String)"z"))))))));
        }

        private static int execute(CommandSourceStack source, String configId, int x, int y, int z) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.m_81352_((Component)Component.m_237113_((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                ServerPlayer player = source.m_81375_();
                BlockPos pos = new BlockPos(x, y, z);
                boolean success = api.addCluster((LevelAccessor)player.m_9236_(), configId, pos);
                if (!success) {
                    source.m_81352_((Component)Component.m_237113_((String)"Failed to add cluster, check logs for more info"));
                    return 1;
                }
                source.m_288197_(() -> Component.m_237113_((String)"Successfully added cluster"), true);
            }
            catch (Exception e) {
                LoggerProject.logError("010005", "Add Cluster Command exception: " + e.getMessage());
                source.m_81352_((Component)Component.m_237113_((String)"Failed to add cluster, check logs for more info"));
                return 1;
            }
            LoggerProject.logDebug("010006", "Add Cluster Command executed successfully");
            return 0;
        }
    }

    private static class TriggerRegen {
        private TriggerRegen() {
        }

        private static LiteralArgumentBuilder<CommandSourceStack> register() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"triggerRegen").executes(context -> TriggerRegen.execute((CommandSourceStack)context.getSource(), null, null))).then(Commands.m_82129_((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TriggerRegen.execute((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"chunkZ"))))));
        }

        private static int execute(CommandSourceStack source, Integer chunkX, Integer chunkZ) {
            block6: {
                try {
                    OreClusterApi api = OreClusterApi.getInstance();
                    if (api == null) {
                        source.m_81352_((Component)Component.m_237113_((String)"oreClusterApi not initialized at this time"));
                        return 1;
                    }
                    if (chunkX == null || chunkZ == null) {
                        api.triggerRegen();
                        source.m_288197_(() -> Component.m_237113_((String)"Global regeneration triggered"), true);
                        break block6;
                    }
                    ServerPlayer player = source.m_81375_();
                    String chunkId = HBUtil.ChunkUtil.getId((int)chunkX, (int)chunkZ);
                    try {
                        api.triggerRegen((LevelAccessor)player.m_9236_(), chunkId);
                        source.m_288197_(() -> Component.m_237113_((String)("Regeneration triggered for chunk: " + chunkId)), true);
                    }
                    catch (Exception e) {
                        source.m_81352_((Component)Component.m_237113_((String)("Failed to trigger regeneration for chunk: " + chunkId)));
                        return 1;
                    }
                }
                catch (Exception e) {
                    LoggerProject.logError("010007", "Trigger Regen Command exception: " + e.getMessage());
                    return 1;
                }
            }
            LoggerProject.logDebug("010008", "Trigger Regen Command executed successfully");
            return 0;
        }
    }

    private static class GetConfig {
        private GetConfig() {
        }

        private static LiteralArgumentBuilder<CommandSourceStack> noArgs() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"config").executes(context -> GetConfig.execute((CommandSourceStack)context.getSource(), null, false)));
        }

        private static LiteralArgumentBuilder<CommandSourceStack> withConfigId() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"config").then(Commands.m_82129_((String)"configId", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String configId = StringArgumentType.getString((CommandContext)context, (String)"configId");
                return GetConfig.execute((CommandSourceStack)context.getSource(), configId, false);
            })));
        }

        private static LiteralArgumentBuilder<CommandSourceStack> withConfigIdAndBiomes() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"config").then(Commands.m_82129_((String)"configId", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"showBiomes", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
                String configId = StringArgumentType.getString((CommandContext)context, (String)"configId");
                boolean showBiomes = BoolArgumentType.getBool((CommandContext)context, (String)"showBiomes");
                return GetConfig.execute((CommandSourceStack)context.getSource(), configId, showBiomes);
            }))));
        }

        private static int execute(CommandSourceStack source, String configId, boolean showBiomes) {
            try {
                OreClusterApi api = OreClusterApi.getInstance();
                if (api == null) {
                    source.m_81352_((Component)Component.m_237113_((String)"oreClusterApi not initialized at this time"));
                    return 1;
                }
                JsonObject config = api.getConfig(configId, showBiomes);
                if (config == null) {
                    source.m_81352_((Component)Component.m_237113_((String)("No config found" + (String)(configId != null ? " for id: " + configId : ""))));
                    return 1;
                }
                String header = config.getAsJsonPrimitive("header").getAsString();
                source.m_243053_((Component)Component.m_237113_((String)header));
                for (JsonElement elem : config.getAsJsonArray("value")) {
                    JsonObject obj = elem.getAsJsonObject();
                    StringBuilder s = new StringBuilder(CommandList.s(obj, "header"));
                    for (String key : obj.keySet()) {
                        if (key.equals("header")) continue;
                        s.append("\n  ").append(key).append(": ").append(CommandList.s(obj, key));
                    }
                    s.append("\n");
                    source.m_243053_((Component)Component.m_237113_((String)s.toString()));
                }
                source.m_243053_((Component)Component.m_237113_((String)"---\n"));
                MutableComponent response = Component.m_237113_((String)"command /hbOreClusters config terminated succesfully: \n");
                source.m_288197_(() -> response, true);
            }
            catch (Exception e) {
                LoggerProject.logError("010003", "Get Config Command exception: " + e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010004", "Get Config Command executed successfully");
            return 0;
        }
    }

    private static class LocateClusters {
        private LocateClusters() {
        }

        private static LiteralArgumentBuilder<CommandSourceStack> noArgs() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"locateClusters").executes(context -> LocateClusters.execute((CommandSourceStack)context.getSource(), -1, null)));
        }

        private static LiteralArgumentBuilder<CommandSourceStack> limitCount() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(Commands.m_82127_((String)"locateClusters").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                return LocateClusters.execute((CommandSourceStack)context.getSource(), count, null);
            })));
        }

        private static LiteralArgumentBuilder<CommandSourceStack> limitCountSpecifyBlockType() {
            return (LiteralArgumentBuilder)Commands.m_82127_((String)CommandList.PREFIX).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"locateClusters").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"blockType", (ArgumentType)StringArgumentType.string()).executes(context -> {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
                String blockType = StringArgumentType.getString((CommandContext)context, (String)"blockType");
                return LocateClusters.execute((CommandSourceStack)context.getSource(), count, blockType);
            })))).then(Commands.m_82129_((String)"blockType", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String blockType = StringArgumentType.getString((CommandContext)context, (String)"blockType");
                return LocateClusters.execute((CommandSourceStack)context.getSource(), -1, blockType);
            })));
        }

        private static int execute(CommandSourceStack source, int count, String blockType) {
            OreClusterApi api = OreClusterApi.getInstance();
            if (api == null) {
                source.m_81352_((Component)Component.m_237113_((String)"oreClusterApi not initialized at this time"));
                return 1;
            }
            if (count == -1) {
                count = 5;
            }
            Block block = null;
            if (blockType != null && !blockType.isEmpty() && ((block = HBUtil.BlockUtil.blockNameToBlock((String)blockType)) == null || block.equals(Blocks.f_50016_))) {
                source.m_81352_((Component)Component.m_237113_((String)("Invalid block type: " + blockType)));
                return 1;
            }
            try {
                ServerPlayer player = source.m_81375_();
                BlockPos playerPos = player.m_20183_();
                List<OreClusterInfo> data = api.locateOreClusters((LevelAccessor)player.m_9236_(), playerPos, block, count);
                MutableComponent response = Component.m_237113_((String)"Found Clusters: ");
                for (OreClusterInfo cluster : data) {
                    response.m_130946_(LocateClusters.formatClusterMessage(cluster));
                }
                source.m_288197_(() -> response, true);
            }
            catch (Exception e) {
                LoggerProject.logError((String)"010002", (String)"Locate Clusters Command exception: ", (String)e.getMessage());
                return 1;
            }
            LoggerProject.logDebug("010001", "Locate Clusters Command");
            return 0;
        }

        private static String formatClusterMessage(OreClusterInfo cluster) {
            String ore = HBUtil.BlockUtil.blockToString((Block)cluster.oreType.getBlock());
            ore = ore.substring(ore.lastIndexOf(":") + 1);
            String pos = HBUtil.BlockUtil.positionToString((Vec3i)cluster.position);
            return "\n" + ore + " at " + pos;
        }

        private static Object getArgument(CommandContext<CommandSourceStack> context, String name, Class<?> type) {
            try {
                return context.getArgument(name, type);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

