/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.config;

import com.holybuckets.foundation.HBUtil;
import java.util.Arrays;
import java.util.HashSet;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.Config;
import net.blay09.mods.balm.api.config.IgnoreConfig;

@Config(value="hbs_ore_cluster_and_regen")
public class OreClusterConfigData
implements BalmConfigData {
    @Comment(value="NOTE: This is not the JSON config for specific clusters, these are generl configs for the mod and default configs for the clusters. The JSON belongs in the file specified by 'oreClusterFileConfigPath'")
    public COreClusters cOreClusters = new COreClusters();

    public static class COreClusters {
        @IgnoreConfig(value="Constant")
        public static final int DEF_ORE_CLUSTER_SPAWNRATE_AREA = 1000;
        public static final String DEF_SUB_SEED = "";
        public static final String DEF_VALID_ORE_CLUSTER_ORE_BLOCKS = "minecraft:iron_ore";
        public static final String DEF_ORE_CLUSTER_DIMENSION = "minecraft:overworld";
        public static final String DEF_ORE_CLUSTER_BIOME = "";
        public static final HBUtil.Validator.ConfigNumber<Integer> DEF_ORE_CLUSTER_SPAWN_RATE = new HBUtil.Validator.ConfigNumber("oreClusterSpawnrate", (Number)16, (Number)0, (Number)1000);
        public static final String DEF_ORE_CLUSTER_VOLUME = "8x8x4";
        public static final HBUtil.Validator.ConfigNumber<Float> DEF_ORE_CLUSTER_DENSITY = new HBUtil.Validator.ConfigNumber("oreClusterDensity", (Number)Float.valueOf(1.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));
        public static final String DEF_ORE_CLUSTER_SHAPE = "any";
        public static final HBUtil.Validator.ConfigNumber<Integer> DEF_ORE_CLUSTER_MAX_Y_LEVEL_SPAWN = new HBUtil.Validator.ConfigNumber("oreClusterMaxYLevelSpawn", (Number)256, (Number)-64000, (Number)64000);
        public static final HBUtil.Validator.ConfigNumber<Integer> DEF_ORE_CLUSTER_MIN_Y_LEVEL_SPAWN = new HBUtil.Validator.ConfigNumber("oreClusterMaxYLevelSpawn", (Number)-64000, (Number)-64000, (Number)64000);
        public static final HBUtil.Validator.ConfigNumber<Integer> DEF_MIN_CHUNKS_BETWEEN_ORE_CLUSTERS = new HBUtil.Validator.ConfigNumber("minChunksBetweenOreClusters", (Number)0, (Number)0, (Number)32);
        public static final HBUtil.Validator.ConfigNumber<Integer> DEF_MAX_CHUNKS_BETWEEN_ORE_CLUSTERS = new HBUtil.Validator.ConfigNumber("maxChunksBetweenOreClusters", (Number)2, (Number)2, (Number)32);
        public static final HBUtil.Validator.ConfigNumber<Float> DEF_ORE_VEIN_MODIFIER = new HBUtil.Validator.ConfigNumber("oreVeinModifier", (Number)Float.valueOf(1.0f), (Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));
        public static final String DEF_ORE_CLUSTER_NONREPLACEABLE_BLOCKS = "minecraft:end_portal_frame,minecraft:bedrock";
        public static final String DEF_ORE_CLUSTER_REPLACEABLE_EMPTY_BLOCKS = "hbs_foundation:empty_block";
        public static final boolean DEF_REGENERATE_ORE_CLUSTERS = true;
        public static final String DEF_REGENERATE_ORE_CLUSTER_PERIOD_LENGTHS = "16,24,16,8";
        public static final String DEF_REGENERATE_ORE_CLUSTER_UPGRADE_ITEMS = "default,minecraft:blaze_powder,minecraft:dragon_egg,minecraft:nether_star";
        public static final String DEF_ORE_CLUSTER_FILE_CONFIG_PATH = "config/HBOreClustersAndRegenConfigs.json";
        public static final String DEF_MIN_ORE_CLUSTER_VOLUME = "0x0x0";
        public static final String DEF_MAX_ORE_CLUSTER_VOLUME = "64x64x64";
        public static final HashSet<String> DEF_ORE_CLUSTER_VALID_SHAPES = new HashSet<String>(Arrays.asList("CUBE", "SPHERE", "ANY"));
        @Comment(value="Sub-seed used to generate random numbers for ore cluster generation - by default, Ore cluster generation uses the world seed to determine which chunks have ore clusters and their shape and size. By assigning a sub-seed, you can adjust this randomness for the same world")
        public String subSeed = "";
        @Comment(value="List of blocks that the mod will attempt to create clusters for upon chunk load. Clusters created from these blocks will take all default ore cluster parameters unless overridden. If you are going to override the default parameters for an ore anyways, you don't need to include it in this list")
        @IgnoreConfig(value="Too Confusing, will only use explicit list")
        public String validOreClusterOreBlocks = "minecraft:iron_ore";
        @Comment(value="Dimensions in which ore clusters will spawn. Use minecraft:overworld, minecraft:the_nether, minecraft:the_end or a mod specific dimension ID")
        public String oreClusterDimensionId = "minecraft:overworld";
        @Comment(value="Defines the default frequency of ore clusters. Integer number of expected ore clusters per 1000 chunks.")
        public int oreClusterSpawnRate = (Integer)DEF_ORE_CLUSTER_SPAWN_RATE.get();
        @Comment(value="Specifies the default dimensions of a cluster. <X>x<Y>x<Z>. The true cluster will always be smaller than this box because it will choose a shape that roughly fits inside it. MAX 64x64x64 else it will revert to the default 16x16x16")
        public String oreClusterVolume = "8x8x4";
        @Comment(value="Specifies the density of ore within a cluster. Blocks from 'oreClusterReplaceableEmptyBlocks' are mixed into this cluster randomly to reduce density")
        public float oreClusterDensity = ((Float)DEF_ORE_CLUSTER_DENSITY.get()).floatValue();
        @Comment(value="Defines the shape of the ore cluster. Options are 'SPHERE', 'CUBE', 'ANY'. Defaults to ANY, which takes a random shape each generation")
        public String oreClusterShape = "any";
        @Comment(value="Clusters will not spawn above this Y level")
        public int oreClusterMaxYLevelSpawn = (Integer)DEF_ORE_CLUSTER_MAX_Y_LEVEL_SPAWN.get();
        @Comment(value="Clusters will not spawn below this Y level")
        public int oreClusterMinYLevelSpawn = (Integer)DEF_ORE_CLUSTER_MIN_Y_LEVEL_SPAWN.get();
        @Comment(value="Minimum number of chunks between ore any clusters - AFFECTS ALL ORE CLUSTERS - this is a rough guideline, the random generation is not perfect")
        public int minChunksBetweenOreClusters = (Integer)DEF_MIN_CHUNKS_BETWEEN_ORE_CLUSTERS.get();
        @Comment(value="Maximum number of chunks between ore any clusters - AFFECTS ALL ORE CLUSTERS - this is a rough guideline, the random generation is not perfect")
        @IgnoreConfig(value="Not used")
        public int maxChunksBetweenOreClusters = (Integer)DEF_MAX_CHUNKS_BETWEEN_ORE_CLUSTERS.get();
        @Comment(value="Scales the presence of small (vanilla) ore veins between 0 and 1. This mod replaces existing ore veins in real time with the specified first block in 'oreClusterReplaceableEmptyBlocks' block e.g. replaces some iron_ore veins with stone on spawn")
        public float oreVeinModifier = ((Float)DEF_ORE_VEIN_MODIFIER.get()).floatValue();
        @Comment(value="List of blocks that should not be replaced by the specified ore during cluster generation. For example, if you don't want ore clusters to replace bedrock - which is very reasonable - you would add 'minecraft:bedrock' to this list")
        public String oreClusterNonreplaceableBlocks = "minecraft:end_portal_frame,minecraft:bedrock";
        @Comment(value="Blocks mixed into the ore cluster shape to reduce density of the primary block. Takes multiple comma seperated blocks. Only the first block in the list will be used to replace ore veins if ORE_VEIN_MODIFIER is below 1")
        public String oreClusterReplaceableEmptyBlocks = "hbs_foundation:empty_block";
        @Comment(value="Flag indicating if ore clusters should regenerate by default. Overriden by specific ore settings")
        public boolean regenerateOreClusters = true;
        @Comment(value="File path to .json file where the properties of one or more specific ore clusters are listed in a JSON array")
        public String oreClusterFileConfigPath = "config/HBOreClustersAndRegenConfigs.json";
        @Comment(value="Comma separated list of integer days it takes for clusters to regenerate their ores. All clusters will regenerate on the same schedule. After sacrificing the specified item in the array below, the period length is reduced")
        public String regenerateOreClusterPeriodLengths = "16,24,16,8";
        @Comment(value="Comma separated list of items that will be used to reduce the number of days between cluster regeneration. If the first value is NOT 'default', then clusters will not regenerate until the specified item has been sacrificed. In game, use the 'sacrificial altar' to sacrifice the specified item to trigger the next period length")
        @IgnoreConfig(value="Not implemented")
        public String regenerateOreClusterUpgradeItems = "default,minecraft:blaze_powder,minecraft:dragon_egg,minecraft:nether_star";
    }
}

