/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.config.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.config.OreClusterConfigData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OreClusterConfigModel {
    public static final String CLASS_ID = "004";
    public static Short ID_COUNTER = 0;
    public Long subSeed = null;
    public String configId;
    public BlockState oreClusterType = null;
    public HashSet<Block> validOreClusterOreBlocks;
    public Set<ResourceLocation> biomeWhitelist = new HashSet<ResourceLocation>();
    public Set<ResourceLocation> biomeBlacklist = new HashSet<ResourceLocation>();
    public String oreClusterDimensionId = "minecraft:overworld";
    public Integer oreClusterSpawnRate = (Integer)OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_SPAWN_RATE.get();
    public HBUtil.TripleInt oreClusterVolume = this.processVolume("8x8x4");
    public Float oreClusterDensity = (Float)OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_DENSITY.get();
    public String oreClusterShape = "any";
    public Integer oreClusterMaxYLevelSpawn = (Integer)OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_MAX_Y_LEVEL_SPAWN.get();
    public Integer oreClusterMinYLevelSpawn = (Integer)OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_MIN_Y_LEVEL_SPAWN.get();
    public Integer minChunksBetweenOreClusters = (Integer)OreClusterConfigData.COreClusters.DEF_MIN_CHUNKS_BETWEEN_ORE_CLUSTERS.get();
    public Integer maxChunksBetweenOreClusters = (Integer)OreClusterConfigData.COreClusters.DEF_MAX_CHUNKS_BETWEEN_ORE_CLUSTERS.get();
    public Float oreVeinModifier = (Float)OreClusterConfigData.COreClusters.DEF_ORE_VEIN_MODIFIER.get();
    public HashSet<BlockState> oreClusterNonReplaceableBlocks = OreClusterConfigModel.processStringIntoBlockStateList("minecraft:end_portal_frame,minecraft:bedrock").stream().collect(Collectors.toCollection(HashSet::new));
    public List<BlockState> oreClusterReplaceableEmptyBlocks = OreClusterConfigModel.processReplaceableEmptyBlocks("hbs_foundation:empty_block");
    public Boolean oreClusterDoesRegenerate = true;
    public LinkedHashMap<String, Integer> oreClusterRegenPeriods;
    private static final Gson gson = new GsonBuilder().create();
    private static final OreClusterConfigData.COreClusters oreClusterDefaultConfigs = new OreClusterConfigData.COreClusters();

    public OreClusterConfigModel(BlockState oreClusterBlockState) {
        this.oreClusterType = oreClusterBlockState;
    }

    public OreClusterConfigModel(String oreClusterJson) {
        this((BlockState)null);
        this.deserialize(oreClusterJson);
    }

    public OreClusterConfigModel(OreClusterConfigData.COreClusters cOreClusters) {
        this((BlockState)null);
        if (cOreClusters == null) {
            return;
        }
        this.subSeed = cOreClusters.subSeed != null && !cOreClusters.subSeed.isEmpty() ? Long.valueOf(cOreClusters.subSeed.hashCode()) : null;
        this.validOreClusterOreBlocks = new HashSet<Block>(OreClusterConfigModel.processValidOreClusterOreBlocks(cOreClusters.validOreClusterOreBlocks));
        this.oreClusterSpawnRate = cOreClusters.oreClusterSpawnRate;
        this.oreClusterDimensionId = cOreClusters.oreClusterDimensionId;
        this.oreClusterVolume = this.processVolume(cOreClusters.oreClusterVolume);
        this.oreClusterDensity = Float.valueOf(cOreClusters.oreClusterDensity);
        this.oreClusterShape = cOreClusters.oreClusterShape;
        this.oreClusterMaxYLevelSpawn = cOreClusters.oreClusterMaxYLevelSpawn;
        this.oreClusterMinYLevelSpawn = cOreClusters.oreClusterMinYLevelSpawn;
        this.minChunksBetweenOreClusters = cOreClusters.minChunksBetweenOreClusters;
        this.oreVeinModifier = Float.valueOf(cOreClusters.oreVeinModifier);
        this.oreClusterNonReplaceableBlocks = OreClusterConfigModel.processStringIntoBlockStateList(cOreClusters.oreClusterNonreplaceableBlocks).stream().collect(Collectors.toCollection(HashSet::new));
        this.oreClusterReplaceableEmptyBlocks = OreClusterConfigModel.processReplaceableEmptyBlocks(cOreClusters.oreClusterReplaceableEmptyBlocks);
        this.oreClusterDoesRegenerate = cOreClusters.regenerateOreClusters;
        this.oreClusterRegenPeriods = new LinkedHashMap();
        this.oreClusterRegenPeriods = this.processRegenPeriods(cOreClusters.regenerateOreClusterUpgradeItems.split(","), cOreClusters.regenerateOreClusterPeriodLengths.split(","));
    }

    private static Block blockNameToBlock(String blockName) {
        if (blockName == null || blockName.isEmpty()) {
            return ModBlocks.empty;
        }
        if (blockName.contains(":")) {
            String[] split = blockName.split(":");
            return HBUtil.BlockUtil.blockNameToBlock((String)split[0], (String)split[1]);
        }
        return HBUtil.BlockUtil.blockNameToBlock((String)"minecraft", (String)blockName);
    }

    public static List<Block> processValidOreClusterOreBlocks(String validOreClusterOreBlocks) {
        List<String> ores = Arrays.asList(validOreClusterOreBlocks.split(","));
        return ores.stream().map(OreClusterConfigModel::blockNameToBlock).collect(Collectors.toList());
    }

    public static List<BlockState> processStringIntoBlockStateList(String replaceableBlocks) {
        List blocks = Arrays.stream(replaceableBlocks.split(",")).map(OreClusterConfigModel::blockNameToBlock).collect(Collectors.toList());
        return blocks.stream().map(Block::m_49966_).collect(Collectors.toList());
    }

    public static List<BlockState> processReplaceableEmptyBlocks(String replaceableBlocks) {
        List<BlockState> blocks = OreClusterConfigModel.processStringIntoBlockStateList(replaceableBlocks);
        LoggerProject.logDebug("004000", "Blocks: " + blocks);
        if (blocks == null) {
            blocks = new ArrayList<BlockState>();
        }
        if (blocks.isEmpty() || blocks.contains(null)) {
            blocks.remove(null);
        }
        if (blocks.isEmpty()) {
            blocks.add(OreClusterConfigModel.blockNameToBlock("hbs_foundation:empty_block").m_49966_());
        }
        return blocks;
    }

    public HBUtil.TripleInt processVolume(String volume) {
        StringBuilder volumeNotParsedCorrectlyError = new StringBuilder();
        volumeNotParsedCorrectlyError.append("Volume value: ");
        volumeNotParsedCorrectlyError.append(volume);
        volumeNotParsedCorrectlyError.append(" is not formatted correctly ");
        StringBuilder volumeNotWithinBoundsError = new StringBuilder();
        volumeNotWithinBoundsError.append("Volume value: ");
        volumeNotWithinBoundsError.append(volume);
        volumeNotWithinBoundsError.append(" is out of bounds ");
        String[] volumeArray = volume.toLowerCase().split("x");
        if (volume == null || volume.isEmpty() || volumeArray.length != 3) {
            volumeArray = "8x8x4".split("x");
            OreClusterConfigModel.logPropertyWarning(volumeNotParsedCorrectlyError.toString(), this.oreClusterType, null, volumeArray.toString());
        }
        String[] mins = "0x0x0".split("x");
        String[] maxs = "64x64x64".split("x");
        for (int i = 0; i < 3; ++i) {
            int vol = Integer.parseInt(volumeArray[i]);
            int min = Integer.parseInt(mins[i]);
            int max = Integer.parseInt(maxs[i]);
            if (vol >= min && vol <= max) continue;
            volumeArray = "8x8x4".split("x");
            OreClusterConfigModel.logPropertyWarning(volumeNotWithinBoundsError.toString(), this.oreClusterType, null, volumeArray.toString());
            break;
        }
        return new HBUtil.TripleInt(Integer.parseInt(volumeArray[0]), Integer.parseInt(volumeArray[1]), Integer.parseInt(volumeArray[2]));
    }

    public LinkedHashMap<String, Integer> processRegenPeriods(String[] upgrades, String[] oreClusterRegenPeriodArray) {
        String numberFormatError = "Error parsing oreClusterRegenPeriods, use comma separated list of integers with no spaces";
        LinkedHashMap<String, Integer> oreClusterRegenPeriods = new LinkedHashMap<String, Integer>();
        int i = 0;
        try {
            for (String item : upgrades) {
                if (i < oreClusterRegenPeriodArray.length) {
                    oreClusterRegenPeriods.put(item, Integer.parseInt(oreClusterRegenPeriodArray[i].trim()));
                    ++i;
                    continue;
                }
                oreClusterRegenPeriods.put(item, Integer.parseInt(oreClusterRegenPeriodArray[i].trim()));
            }
        }
        catch (NumberFormatException e) {
            oreClusterRegenPeriods = new LinkedHashMap();
            upgrades = "default,minecraft:blaze_powder,minecraft:dragon_egg,minecraft:nether_star".split(",");
            oreClusterRegenPeriodArray = "16,24,16,8".split(",");
            i = 0;
            for (String item : upgrades) {
                oreClusterRegenPeriods.put(item, Integer.parseInt(oreClusterRegenPeriodArray[i]));
                ++i;
            }
            OreClusterConfigModel.logPropertyWarning(numberFormatError, this.oreClusterType, null, oreClusterRegenPeriods.toString());
        }
        return oreClusterRegenPeriods;
    }

    public boolean inLevel(LevelAccessor level) {
        return this.oreClusterDimensionId == "" || level == HBUtil.LevelUtil.toServerLevel((String)this.oreClusterDimensionId);
    }

    public void setConfigId() {
        if (this.oreClusterType == null) {
            ID_COUNTER = 0;
        }
        Object[] objectArray = new Object[1];
        Short s = ID_COUNTER;
        ID_COUNTER = (short)(ID_COUNTER + 1);
        objectArray[0] = s;
        this.configId = String.format("%04d", objectArray);
    }

    public void setOreClusterType(BlockState oreClusterType) {
        this.oreClusterType = oreClusterType;
    }

    public void setOreClusterType(String oreClusterTypeString) {
        this.oreClusterType = OreClusterConfigModel.blockNameToBlock(oreClusterTypeString).m_49966_();
    }

    public void setOreClusterSpawnRate(Integer oreClusterSpawnRate) {
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)oreClusterSpawnRate, OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_SPAWN_RATE, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            this.oreClusterSpawnRate = oreClusterSpawnRate;
        }
    }

    public void setOreClusterVolume(String oreClusterVolume) {
        HBUtil.TripleInt volume;
        this.oreClusterVolume = volume = this.processVolume(oreClusterVolume);
    }

    public void setOreClusterShape(String oreClusterShape) {
        String error = "Error setting oreClusterShape for ore: ";
        if (oreClusterShape == null || oreClusterShape.isEmpty()) {
            oreClusterShape = "any";
        }
        if (!OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_VALID_SHAPES.contains(oreClusterShape)) {
            oreClusterShape = "any";
            OreClusterConfigModel.logPropertyWarning(error, this.oreClusterType, null, oreClusterShape);
        }
        this.oreClusterShape = oreClusterShape;
    }

    public void setOreClusterDensity(Float oreClusterDensity) {
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)oreClusterDensity, OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_DENSITY, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            this.oreClusterDensity = oreClusterDensity;
        }
    }

    public void setOreClusterMaxYLevelSpawn(Integer oreClusterMaxYLevelSpawn) {
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)oreClusterMaxYLevelSpawn, OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_MAX_Y_LEVEL_SPAWN, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            this.oreClusterMaxYLevelSpawn = oreClusterMaxYLevelSpawn;
        }
    }

    public void setOreClusterMinYLevelSpawn(Integer oreClusterMinYLevelSpawn) {
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)oreClusterMinYLevelSpawn, OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_MIN_Y_LEVEL_SPAWN, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            this.oreClusterMinYLevelSpawn = oreClusterMinYLevelSpawn;
        }
    }

    public void setMinChunksBetweenOreClusters(Integer minChunksBetweenOreClusters) {
        String minChunksLogicError = "minChunksBetweenOreClusters is too high for the spawnrate of the cluster";
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)minChunksBetweenOreClusters, OreClusterConfigData.COreClusters.DEF_MIN_CHUNKS_BETWEEN_ORE_CLUSTERS, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            double mandatoryReservedAreaPerCluster = Math.pow(2 * minChunksBetweenOreClusters + 1, 2.0);
            double expectedAreaPerCluster = 1000 / this.oreClusterSpawnRate;
            if (expectedAreaPerCluster < mandatoryReservedAreaPerCluster) {
                int defaultSpawnRate = (Integer)OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_SPAWN_RATE.get();
                this.oreClusterSpawnRate = (int)((double)defaultSpawnRate / mandatoryReservedAreaPerCluster);
                OreClusterConfigModel.logPropertyWarning(minChunksLogicError, this.oreClusterType, "scaling down oreClusterSpawnrate to ", this.oreClusterSpawnRate.toString());
            }
            this.minChunksBetweenOreClusters = minChunksBetweenOreClusters;
        }
    }

    public void setMaxChunksBetweenOreClusters(Integer maxChunksBetweenOreClusters) {
        String maxChunksLogicError = "maxChunksBetweenOreClusters is too low for the spawnrate of the cluster ";
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)maxChunksBetweenOreClusters, OreClusterConfigData.COreClusters.DEF_MAX_CHUNKS_BETWEEN_ORE_CLUSTERS, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            double minimumClustersPerArea = 1000.0 / Math.pow(2 * maxChunksBetweenOreClusters + 1, 2.0);
            if ((double)(this.oreClusterSpawnRate / 2) < minimumClustersPerArea) {
                this.oreClusterSpawnRate = (int)minimumClustersPerArea * 2;
                OreClusterConfigModel.logPropertyWarning(maxChunksLogicError, this.oreClusterType, "scaling up oreClusterSpawnrate to ", this.oreClusterSpawnRate.toString());
            }
            this.maxChunksBetweenOreClusters = maxChunksBetweenOreClusters;
        }
    }

    public void setOreVeinModifier(Float oreVeinModifier) {
        Boolean validConfig = HBUtil.Validator.validateNumber((Number)oreVeinModifier, OreClusterConfigData.COreClusters.DEF_ORE_VEIN_MODIFIER, (String)("for ore: " + this.oreClusterType));
        if (validConfig.booleanValue()) {
            this.oreVeinModifier = oreVeinModifier;
        }
    }

    public void setOreClusterNonReplaceableBlocks(String oreClusterNonReplaceableBlocks) {
        this.oreClusterNonReplaceableBlocks = OreClusterConfigModel.processStringIntoBlockStateList(oreClusterNonReplaceableBlocks).stream().collect(Collectors.toCollection(HashSet::new));
    }

    public void setOreClusterReplaceableEmptyBlocks(String oreClusterReplaceableEmptyBlocks) {
        this.oreClusterReplaceableEmptyBlocks = OreClusterConfigModel.processReplaceableEmptyBlocks(oreClusterReplaceableEmptyBlocks);
    }

    public void setOreClusterDoesRegenerate(String oreClusterDoesRegenerate) {
        this.oreClusterDoesRegenerate = HBUtil.Validator.parseBoolean((String)oreClusterDoesRegenerate);
    }

    public void setOreClusterDimensionId(String oreClusterDimensionId) {
        if (oreClusterDimensionId == null || oreClusterDimensionId.isEmpty()) {
            this.oreClusterDimensionId = "minecraft:overworld";
            OreClusterConfigModel.logPropertyWarning("Invalid dimension", this.oreClusterType, null, this.oreClusterDimensionId);
        } else {
            this.oreClusterDimensionId = oreClusterDimensionId;
        }
    }

    private static void logPropertyWarning(String message, BlockState ore, String defaultMessage, String defaultValue) {
        if (defaultMessage == null) {
            defaultMessage = " Using default value of ";
        }
        StringBuilder error = new StringBuilder();
        error.append(message);
        error.append(" for ore: ");
        error.append(ore);
        error.append(defaultMessage);
        error.append(defaultValue);
        LoggerProject.logWarning("004001", error.toString());
    }

    public String serialize() {
        return OreClusterConfigModel.serialize(this);
    }

    public JsonObject serializeJson() {
        return OreClusterConfigModel.serializeJson(this);
    }

    public static String serialize(OreClusterConfigModel c) {
        return gson.toJson((JsonElement)OreClusterConfigModel.serializeJson(c));
    }

    public static JsonObject serializeJson(OreClusterConfigModel c) {
        JsonObject jsonObject = new JsonObject();
        String oreClusterTypeString = HBUtil.BlockUtil.blockToString((Block)c.oreClusterType.m_60734_());
        jsonObject.addProperty("oreClusterType", oreClusterTypeString);
        jsonObject.addProperty("oreClusterSpawnRate", (Number)c.oreClusterSpawnRate);
        jsonObject.addProperty("oreClusterDimension", c.oreClusterDimensionId);
        JsonArray whitelistArray = new JsonArray();
        for (ResourceLocation biome : c.biomeWhitelist) {
            whitelistArray.add(biome.toString());
        }
        jsonObject.add("biomeWhitelist", (JsonElement)whitelistArray);
        JsonArray blacklistArray = new JsonArray();
        for (ResourceLocation biome : c.biomeBlacklist) {
            blacklistArray.add(biome.toString());
        }
        jsonObject.add("biomeBlacklist", (JsonElement)blacklistArray);
        jsonObject.addProperty("oreClusterVolume", c.oreClusterVolume.x + "x" + c.oreClusterVolume.y + "x" + c.oreClusterVolume.z);
        jsonObject.addProperty("oreClusterDensity", (Number)c.oreClusterDensity);
        jsonObject.addProperty("oreClusterShape", c.oreClusterShape);
        jsonObject.addProperty("oreClusterMaxYLevelSpawn", (Number)c.oreClusterMaxYLevelSpawn);
        jsonObject.addProperty("oreClusterMinYLevelSpawn", (Number)c.oreClusterMinYLevelSpawn);
        jsonObject.addProperty("minChunksBetweenOreClusters", (Number)c.minChunksBetweenOreClusters);
        jsonObject.addProperty("oreVeinModifier", (Number)c.oreVeinModifier);
        jsonObject.addProperty("oreClusterNonReplaceableBlocks", c.oreClusterNonReplaceableBlocks.stream().map(bs -> bs.m_60734_()).map(HBUtil.BlockUtil::blockToString).collect(Collectors.joining(", ")));
        jsonObject.addProperty("oreClusterReplaceableEmptyBlocks", c.oreClusterReplaceableEmptyBlocks.stream().map(bs -> bs.m_60734_()).map(HBUtil.BlockUtil::blockToString).collect(Collectors.joining(", ")));
        jsonObject.addProperty("oreClusterDoesRegenerate", c.oreClusterDoesRegenerate);
        return jsonObject;
    }

    public void deserialize(String jsonString) {
        int i;
        JsonObject jsonObject = JsonParser.parseString((String)jsonString.replace("'".toCharArray()[0], '\"')).getAsJsonObject();
        try {
            String oreType = jsonObject.get("oreClusterType").getAsString();
            LoggerProject.logDebug("004000", "Deserealizing OreClusterType: " + oreType);
            this.setOreClusterType(oreType);
        }
        catch (Exception e) {
            LoggerProject.logError("004002", "Error parsing oreClusterType for an undefined ore" + e.getMessage());
        }
        try {
            this.setOreClusterSpawnRate(jsonObject.get("oreClusterSpawnRate").getAsInt());
        }
        catch (Exception e) {
            LoggerProject.logError("004003", "Error parsing oreClusterSpawnRate for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterVolume(jsonObject.get("oreClusterVolume").getAsString());
        }
        catch (Exception e) {
            LoggerProject.logError("004004", "Error parsing oreClusterVolume for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterDensity(Float.valueOf(jsonObject.get("oreClusterDensity").getAsFloat()));
        }
        catch (Exception e) {
            LoggerProject.logError("004005", "Error parsing oreClusterDensity for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterShape(jsonObject.get("oreClusterShape").getAsString());
        }
        catch (Exception e) {
            LoggerProject.logError("004006", "Error parsing oreClusterShape for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterMaxYLevelSpawn(jsonObject.get("oreClusterMaxYLevelSpawn").getAsInt());
        }
        catch (Exception e) {
            LoggerProject.logError("004007", "Error parsing oreClusterMaxYLevelSpawn for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterMinYLevelSpawn(jsonObject.get("oreClusterMinYLevelSpawn").getAsInt());
        }
        catch (Exception e) {
            LoggerProject.logError("004015", "Error parsing oreClusterMinYLevelSpawn for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setMinChunksBetweenOreClusters(jsonObject.get("minChunksBetweenOreClusters").getAsInt());
        }
        catch (Exception e) {
            LoggerProject.logError("004008", "Error parsing minChunksBetweenOreClusters for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreVeinModifier(Float.valueOf(jsonObject.get("oreVeinModifier").getAsFloat()));
        }
        catch (Exception e) {
            LoggerProject.logError("004010", "Error parsing oreVeinModifier for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterNonReplaceableBlocks(jsonObject.get("oreClusterNonReplaceableBlocks").getAsString());
        }
        catch (Exception e) {
            LoggerProject.logError("004011", "Error parsing oreClusterNonReplaceableBlocks for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterReplaceableEmptyBlocks(jsonObject.get("oreClusterReplaceableEmptyBlocks").getAsString());
        }
        catch (Exception e) {
            LoggerProject.logError("004012", "Error parsing oreClusterReplaceableEmptyBlocks for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.setOreClusterDoesRegenerate(jsonObject.get("oreClusterDoesRegenerate").getAsString());
        }
        catch (Exception e) {
            LoggerProject.logError("004013", "Error parsing oreClusterDoesRegenerate for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            if (jsonObject.get("oreClusterDimensionId") != null) {
                this.setOreClusterDimensionId(jsonObject.get("oreClusterDimensionId").getAsString());
            } else {
                this.setOreClusterDimensionId("minecraft:overworld");
            }
        }
        catch (Exception e) {
            LoggerProject.logError("004016", "Error parsing oreClusterBiome for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.biomeWhitelist.clear();
            if (jsonObject.has("biomeWhitelist")) {
                JsonArray whitelist = jsonObject.getAsJsonArray("biomeWhitelist");
                for (i = 0; i < whitelist.size(); ++i) {
                    this.biomeWhitelist.add(HBUtil.LevelUtil.toBiomeResourceLocation((String)whitelist.get(i).getAsString()));
                }
            }
        }
        catch (Exception e) {
            LoggerProject.logError("004017", "Error parsing biomeWhitelist for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        try {
            this.biomeBlacklist.clear();
            if (jsonObject.has("biomeBlacklist")) {
                JsonArray blacklist = jsonObject.getAsJsonArray("biomeBlacklist");
                for (i = 0; i < blacklist.size(); ++i) {
                    this.biomeBlacklist.add(HBUtil.LevelUtil.toBiomeResourceLocation((String)blacklist.get(i).getAsString()));
                }
            }
        }
        catch (Exception e) {
            LoggerProject.logError("004018", "Error parsing biomeBlacklist for ore: " + this.oreClusterType + ". " + e.getMessage());
        }
        StringBuilder complete = new StringBuilder();
        complete.append("OreClusterConfigModel for ");
        complete.append(this.oreClusterType);
        complete.append(" has been created with the following properties: \n");
        complete.append(OreClusterConfigModel.serialize(this));
        complete.append("\n\n");
        LoggerProject.logInfo("004014", complete.toString());
    }

    public static List<OreClusterId> getIds(ServerLevel level, OreClusterConfigModel config) {
        Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
        Set allBiomes = biomeRegistry.m_6566_();
        LinkedList<OreClusterId> ids = new LinkedList<OreClusterId>();
        Block block = config.oreClusterType.m_60734_();
        Set<ResourceLocation> whiteList = config.biomeWhitelist;
        Set<ResourceLocation> blackList = config.biomeBlacklist;
        allBiomes.forEach(biomeId -> {
            if (blackList.contains(biomeId)) {
                return;
            }
            if (whiteList.isEmpty() || whiteList.contains(biomeId)) {
                ids.add(new OreClusterId((Level)level, (Biome)biomeRegistry.m_7745_(biomeId), block));
            }
        });
        return ids;
    }

    public static class OreClusterId {
        private final int id;
        private final String stringId;
        private final Level level;
        private final Biome biome;
        private final Block block;
        static final ResourceLocation ORE_CLUSTERS = new ResourceLocation("hbs_ore_cluster_and_regen", "cluster_configs");
        private static final Map<String, OreClusterId> CACHE = new HashMap<String, OreClusterId>();

        public static OreClusterId createBaseConfigId(OreClusterConfigModel model) {
            return new OreClusterId(model);
        }

        private OreClusterId(OreClusterConfigModel model) {
            this.level = HBUtil.LevelUtil.toServerLevel((String)model.oreClusterDimensionId);
            this.biome = null;
            this.block = model.oreClusterType.m_60734_();
            this.id = (int)HBUtil.HBMath.getUUID((ResourceLocation)ORE_CLUSTERS, (String)model.configId, (int)5);
            this.stringId = "" + this.id;
            CACHE.put(model.configId, this);
        }

        OreClusterId(@Nullable Level level, @Nullable Biome biome, Block blockName) {
            this.level = level;
            this.biome = biome;
            this.block = blockName;
            String combined = OreClusterId.getUUID(level, biome, blockName);
            this.id = (int)HBUtil.HBMath.getUUID((ResourceLocation)ORE_CLUSTERS, (String)combined, (int)5);
            CACHE.put(combined, this);
            this.stringId = "" + this.id;
        }

        public String getFormattedId() {
            return String.format("%05d", this.id);
        }

        public int getId() {
            return this.id;
        }

        public String getStringId() {
            return this.stringId;
        }

        public Block getBlock() {
            return this.block;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public Level getLevel() {
            return this.level;
        }

        @Nullable
        public static OreClusterId getId(ResourceLocation level, ResourceLocation biome, ResourceLocation blockName) {
            return CACHE.get(OreClusterId.getUUID(level, biome, blockName));
        }

        public static OreClusterId getId(Level level, Biome biome, Block blockName) {
            ResourceLocation levelId = level != null ? level.m_46472_().m_135782_() : null;
            ResourceLocation biomeId = biome != null ? HBUtil.LevelUtil.toBiomeResourceLocation((Biome)biome) : null;
            ResourceLocation blockId = HBUtil.BlockUtil.getBlockResourceLocation((Block)blockName);
            return OreClusterId.getId(levelId, biomeId, blockId);
        }

        public static String getUUID(ResourceLocation level, ResourceLocation biome, ResourceLocation blockName) {
            return (level != null ? level.toString() : "") + "|" + (biome != null ? biome.toString() : "") + "|" + blockName;
        }

        public static String getUUID(Level level, Biome biome, Block blockName) {
            ResourceLocation levelId = level != null ? level.m_46472_().m_135782_() : null;
            ResourceLocation biomeId = biome != null ? HBUtil.LevelUtil.toBiomeResourceLocation((Biome)biome) : null;
            ResourceLocation blockId = HBUtil.BlockUtil.getBlockResourceLocation((Block)blockName);
            return OreClusterId.getUUID(levelId, biomeId, blockId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OreClusterId that = (OreClusterId)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean filter(Level l) {
            return this.filter(l, null, null);
        }

        public boolean filter(Level l, Biome b) {
            return this.filter(l, b, null);
        }

        public boolean filter(Block b) {
            return this.filter(null, null, b);
        }

        public boolean filter(Level l, Block b) {
            return this.filter(l, null, b);
        }

        public boolean filter(Biome b, Block block) {
            return this.filter(null, b, block);
        }

        public boolean filter(@Nullable Level l, @Nullable Biome b, @Nullable Block block) {
            if (this.level != null && l != null && !this.level.equals(l)) {
                return false;
            }
            if (this.biome != null && b != null && !this.biome.equals(b)) {
                return false;
            }
            if (this.block != null && block != null && !this.block.equals(block)) {
                return false;
            }
            if (this.level == null && l != null) {
                return false;
            }
            if (this.biome == null && b != null) {
                return false;
            }
            return this.block != null || block == null;
        }

        public static void shutdown() {
            CACHE.clear();
            HBUtil.HBMath.clearUUIDs((ResourceLocation)ORE_CLUSTERS);
        }
    }
}

