/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.config.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.modelInterface.IStringSerializable;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class OreClusterJsonConfig
implements IStringSerializable {
    public static final String CLASS_ID = "006";
    public static final OreClusterJsonConfig DEFAULT_CONFIG = new OreClusterJsonConfig();
    private List<JsonObject> oreClusterConfigs;
    private static final Set<BlockState> baseListNonReplaceable = Set.of(OreClusterJsonConfig.bs(Blocks.f_50258_), OreClusterJsonConfig.bs(Blocks.f_50752_));

    private OreClusterJsonConfig() {
    }

    public OreClusterJsonConfig(List<OreClusterConfigModel> configs) {
        this.initFromMap(configs);
    }

    public OreClusterJsonConfig(String jsonString) {
        this.initDefaults();
        this.deserialize(jsonString);
    }

    public List<OreClusterConfigModel> getOreClusterConfigs() {
        ArrayList<OreClusterConfigModel> oreClusterConfigModels = new ArrayList<OreClusterConfigModel>();
        for (JsonObject clusterConfig : this.oreClusterConfigs) {
            try {
                oreClusterConfigModels.add(new OreClusterConfigModel(clusterConfig.toString()));
            }
            catch (Exception e) {
                LoggerProject.logError("006000", "Error getting OreClusterConfigs: " + e.getMessage());
            }
        }
        return oreClusterConfigModels;
    }

    private void initFromMap(List<OreClusterConfigModel> configs) {
        this.oreClusterConfigs = new ArrayList<JsonObject>();
        for (OreClusterConfigModel model : configs) {
            this.oreClusterConfigs.add(model.serializeJson());
        }
    }

    private static BlockState bs(Block b) {
        return b.m_49966_();
    }

    private void initDefaults() {
        final OreClusterConfigModel IRON = new OreClusterConfigModel(Blocks.f_49996_.m_49966_());
        IRON.oreClusterSpawnRate = 8;
        IRON.oreClusterVolume = new HBUtil.TripleInt(16, 12, 16);
        IRON.oreClusterDensity = Float.valueOf(0.25f);
        IRON.oreClusterMaxYLevelSpawn = 64;
        IRON.oreClusterReplaceableEmptyBlocks = new ArrayList<BlockState>();
        IRON.oreClusterNonReplaceableBlocks = new HashSet<BlockState>(baseListNonReplaceable);
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50016_));
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50493_));
        IRON.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50034_));
        IRON.biomeWhitelist = Set.of(new ResourceLocation("minecraft:plains"), new ResourceLocation("minecraft:forest"), new ResourceLocation("minecraft:dark_forest"), new ResourceLocation("minecraft:sunflower_plains"), new ResourceLocation("minecraft:flower_forest"), new ResourceLocation("minecraft:birch_forest"), new ResourceLocation("minecraft:old_growth_birch_forest"), new ResourceLocation("minecraft:wooded_hills"), new ResourceLocation("minecraft:wooded_mountains"), new ResourceLocation("minecraft:taiga"), new ResourceLocation("minecraft:old_growth_pine_taiga"), new ResourceLocation("minecraft:old_growth_spruce_taiga"), new ResourceLocation("minecraft:snowy_taiga"), new ResourceLocation("minecraft:snowy_tundra"), new ResourceLocation("minecraft:snowy_mountains"));
        IRON.oreClusterDimensionId = "overworld";
        final OreClusterConfigModel COAL = new OreClusterConfigModel(Blocks.f_49997_.m_49966_());
        COAL.oreClusterSpawnRate = 32;
        COAL.oreClusterVolume = new HBUtil.TripleInt(8, 8, 8);
        COAL.oreClusterShape = "SPHERE";
        COAL.oreClusterDensity = Float.valueOf(0.4f);
        COAL.oreClusterMaxYLevelSpawn = 64;
        COAL.oreClusterReplaceableEmptyBlocks = List.of(OreClusterJsonConfig.bs(Blocks.f_50069_), OreClusterJsonConfig.bs(Blocks.f_50069_), OreClusterJsonConfig.bs(Blocks.f_50016_));
        COAL.oreClusterDoesRegenerate = false;
        COAL.oreClusterNonReplaceableBlocks = new HashSet<BlockState>(baseListNonReplaceable);
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50016_));
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50493_));
        COAL.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50034_));
        final OreClusterConfigModel DPSLT_DIAMOND = new OreClusterConfigModel(Blocks.f_152474_.m_49966_());
        DPSLT_DIAMOND.oreClusterSpawnRate = 2;
        DPSLT_DIAMOND.oreClusterVolume = new HBUtil.TripleInt(5, 4, 5);
        DPSLT_DIAMOND.oreClusterDensity = Float.valueOf(0.32f);
        DPSLT_DIAMOND.oreClusterMaxYLevelSpawn = -16;
        DPSLT_DIAMOND.oreClusterMinYLevelSpawn = -56;
        DPSLT_DIAMOND.oreClusterReplaceableEmptyBlocks = new ArrayList<BlockState>();
        DPSLT_DIAMOND.oreClusterReplaceableEmptyBlocks.add(Blocks.f_152550_.m_49966_());
        DPSLT_DIAMOND.oreClusterNonReplaceableBlocks = new HashSet<BlockState>(baseListNonReplaceable);
        DPSLT_DIAMOND.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50016_));
        final OreClusterConfigModel DPSLT_LAPIS = new OreClusterConfigModel(Blocks.f_152472_.m_49966_());
        DPSLT_LAPIS.oreClusterSpawnRate = 10;
        DPSLT_LAPIS.oreClusterShape = "SPHERE";
        DPSLT_LAPIS.oreClusterVolume = new HBUtil.TripleInt(4, 6, 4);
        DPSLT_LAPIS.oreClusterDensity = Float.valueOf(0.1f);
        DPSLT_LAPIS.oreClusterMaxYLevelSpawn = 0;
        DPSLT_LAPIS.oreClusterMinYLevelSpawn = -56;
        DPSLT_LAPIS.oreClusterReplaceableEmptyBlocks = List.of(OreClusterJsonConfig.bs(Blocks.f_152473_), OreClusterJsonConfig.bs(Blocks.f_152474_), OreClusterJsonConfig.bs(Blocks.f_152479_), OreClusterJsonConfig.bs(Blocks.f_152550_), OreClusterJsonConfig.bs(Blocks.f_152550_), OreClusterJsonConfig.bs(Blocks.f_152550_), OreClusterJsonConfig.bs(Blocks.f_152550_), OreClusterJsonConfig.bs(Blocks.f_152550_), OreClusterJsonConfig.bs(Blocks.f_152550_));
        DPSLT_LAPIS.oreClusterDoesRegenerate = false;
        DPSLT_LAPIS.oreClusterNonReplaceableBlocks = new HashSet<BlockState>(baseListNonReplaceable);
        DPSLT_LAPIS.oreClusterNonReplaceableBlocks.add(OreClusterJsonConfig.bs(Blocks.f_50016_));
        this.oreClusterConfigs = new ArrayList<JsonObject>(){
            {
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(IRON)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(COAL)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(DPSLT_DIAMOND)).getAsJsonObject());
                this.add(JsonParser.parseString((String)OreClusterConfigModel.serialize(DPSLT_LAPIS)).getAsJsonObject());
            }
        };
    }

    public String serialize() {
        return new Gson().toJson((Object)this);
    }

    public void deserialize(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
        try {
            ArrayList<JsonObject> oreClusterConfigs = new ArrayList<JsonObject>();
            if (!jsonObject.has("oreClusterConfigs")) {
                return;
            }
            JsonArray clusterConfigs = jsonObject.getAsJsonArray("oreClusterConfigs");
            for (int i = 0; i < clusterConfigs.size(); ++i) {
                try {
                    oreClusterConfigs.add(clusterConfigs.get(i).getAsJsonObject());
                    continue;
                }
                catch (Exception e) {
                    LoggerProject.logError("006001", "Error deserializing OreClusterJsonConfig: " + e.getMessage());
                }
            }
            this.oreClusterConfigs = oreClusterConfigs;
        }
        catch (Exception e) {
            LoggerProject.logError("006002", "Error deserializing OreClusterJsonConfig: " + e.getMessage());
        }
    }
}

