/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class OreClusterBlockStateTracker {
    ChunkAccess currentChunk;
    Map<LevelChunkSection, Integer> chunkSections;
    String chunkId;
    ServerLevel currentLevel;
    ManagedOreClusterChunk currentManagedOreClusterChunk;
    static ModRealTimeConfig CONFIG;
    static Map<Integer, ServerLevel> LEVELCHUNKSECTION_LEVEL_REF_MAP;
    static Map<ServerLevel, OreClusterBlockStateTracker> LEVEL_TRACKERS;
    static Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> trackingOreConfig;
    private static final int MAX_CHUNK_REFS;
    private static final int MAX_CHUNK_REFS_CLEAR;
    private static int chunkCount;
    private static long blockCount;

    public static void init(ModRealTimeConfig modRealTimeConfig) {
        LEVEL_TRACKERS = new ConcurrentHashMap<ServerLevel, OreClusterBlockStateTracker>();
        LEVELCHUNKSECTION_LEVEL_REF_MAP = Collections.synchronizedMap(new LinkedHashMap());
        CONFIG = modRealTimeConfig;
    }

    public static void setTrackingChunk(ServerLevel level, ChunkAccess chunk, BlockPos pos) {
        if (!LEVEL_TRACKERS.containsKey(level)) {
            LEVEL_TRACKERS.put(level, new OreClusterBlockStateTracker(level));
        }
        LEVEL_TRACKERS.get(level).setLevelTrackingChunk(chunk, pos);
    }

    public static void trackBlockState(LevelChunkSection section, BlockState state, int x, int y, int z) {
        if (!LEVELCHUNKSECTION_LEVEL_REF_MAP.containsKey(section.hashCode())) {
            return;
        }
        ServerLevel level = LEVELCHUNKSECTION_LEVEL_REF_MAP.get(section.hashCode());
        LEVEL_TRACKERS.get(level).trackLevelBlockState(section, state, x, y, z);
    }

    public OreClusterBlockStateTracker(ServerLevel level) {
        this.currentLevel = level;
        this.chunkSections = new ConcurrentHashMap<LevelChunkSection, Integer>();
        if (trackingOreConfig == null) {
            trackingOreConfig = CONFIG.getOreConfigs();
        }
    }

    public void setLevelTrackingChunk(ChunkAccess chunk, BlockPos pos) {
        OreClusterManager manager;
        this.currentChunk = chunk;
        this.chunkSections.clear();
        AtomicInteger count = new AtomicInteger(0);
        Arrays.stream(chunk.m_7103_()).forEach(section -> {
            this.chunkSections.put((LevelChunkSection)section, count.getAndIncrement());
            LEVELCHUNKSECTION_LEVEL_REF_MAP.put(section.hashCode(), this.currentLevel);
        });
        if (++chunkCount > MAX_CHUNK_REFS) {
            chunkCount = 0;
            Iterator<Map.Entry<Integer, ServerLevel>> it = LEVELCHUNKSECTION_LEVEL_REF_MAP.entrySet().iterator();
            for (int clearCount = 0; it.hasNext() && clearCount < MAX_CHUNK_REFS_CLEAR; ++clearCount) {
                it.next();
                it.remove();
            }
        }
        if ((manager = OreClusterManager.getManager((LevelAccessor)this.currentLevel)) == null) {
            return;
        }
        this.chunkId = HBUtil.ChunkUtil.getId((ChunkAccess)this.currentChunk);
        this.currentManagedOreClusterChunk = manager.getManagedOreClusterChunk(this.chunkId);
        if (this.currentManagedOreClusterChunk != null) {
            this.currentManagedOreClusterChunk.loadBiomes(chunk);
        }
    }

    public void trackLevelBlockState(LevelChunkSection section, BlockState state, int x, int y, int z) {
        if (trackingOreConfig == null) {
            return;
        }
        if (this.currentManagedOreClusterChunk == null) {
            return;
        }
        BlockState defaultState = state.m_60734_().m_49966_();
        if (!CONFIG.maybeHasBlock(defaultState)) {
            return;
        }
        ManagedOreClusterChunk chunk = this.currentManagedOreClusterChunk;
        Biome localBiome = (Biome)section.m_204433_(x, 0, z).m_203334_();
        OreClusterConfigModel.OreClusterId configId = chunk.chooseConfigId((Level)this.currentLevel, localBiome, defaultState, CONFIG);
        if (configId == null) {
            return;
        }
        OreClusterConfigModel config = trackingOreConfig.get(configId);
        if (!ModRealTimeConfig.doesLevelMatch(config, (LevelAccessor)this.currentLevel)) {
            return;
        }
        if (!ModRealTimeConfig.clustersDoSpawn(config)) {
            return;
        }
        ++blockCount;
        int secIndex = 0;
        if (!this.chunkSections.containsKey(section)) {
            return;
        }
        secIndex = this.chunkSections.get(section);
        int secY = this.currentLevel.m_151568_(secIndex);
        if (!chunk.sampleAddOre(configId, secY)) {
            return;
        }
        HBUtil.TripleInt relativePos = new HBUtil.TripleInt(x, y, z);
        HBUtil.WorldPos pos = new HBUtil.WorldPos(relativePos, secIndex, this.currentChunk);
        chunk.addOre(configId, pos.getWorldPos(), true);
    }

    static {
        MAX_CHUNK_REFS = (int)Math.pow(2.0, 12.0);
        MAX_CHUNK_REFS_CLEAR = (int)Math.pow(2.0, 10.0);
        chunkCount = 0;
        blockCount = 0L;
    }
}

