/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.config.OreClusterConfigData;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.model.ManagedOreClusterChunk;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.commons.lang3.tuple.Pair;

public class OreClusterCalculator {
    public static final String CLASS_ID = "003";
    private OreClusterManager manager;
    private Level level;
    private ModRealTimeConfig C;
    private Set<String> determinedChunks;
    private ConcurrentHashMap<OreClusterConfigModel.OreClusterId, Set<String>> localAreaClustersByType;

    public OreClusterCalculator(OreClusterManager manager) {
        this.manager = manager;
        this.level = manager.getLevel();
        this.C = manager.getConfig();
        this.determinedChunks = manager.getDeterminedChunks();
        this.localAreaClustersByType = manager.getTentativeClustersByType();
    }

    @Deprecated
    public Map<String, List<OreClusterConfigModel.OreClusterId>> calculateClusterLocations(List<String> chunks, Random rng) {
        HashMap<OreClusterConfigModel.OreClusterId, Object> clusterConfigs = new HashMap<OreClusterConfigModel.OreClusterId, Object>();
        for (OreClusterConfigModel.OreClusterId oreType : this.C.getOreConfigs().keySet()) {
            OreClusterConfigModel config = this.C.getOreConfigs().get(oreType);
            if (!ModRealTimeConfig.clustersDoSpawn(config)) continue;
            if (!ModRealTimeConfig.doesLevelMatch(config, (LevelAccessor)this.level)) continue;
            clusterConfigs.put(oreType, config);
        }
        HashMap<String, List<OreClusterConfigModel.OreClusterId>> clusterPositions = new HashMap<String, List<OreClusterConfigModel.OreClusterId>>();
        ArrayList oreClusterTypes = new ArrayList(clusterConfigs.keySet());
        if (oreClusterTypes.isEmpty()) {
            for (String chunkId : chunks) {
                clusterPositions.put(chunkId, null);
            }
            return clusterPositions;
        }
        HashMap<OreClusterConfigModel.OreClusterId, Integer> clusterCounts = new HashMap<OreClusterConfigModel.OreClusterId, Integer>();
        for (OreClusterConfigModel.OreClusterId oreType : oreClusterTypes) {
            int normalizedSpawnRate = ((OreClusterConfigModel)clusterConfigs.get((Object)oreType)).oreClusterSpawnRate;
            if (normalizedSpawnRate == 0) continue;
            double sigma = ModRealTimeConfig.CHUNK_DISTRIBUTION_STDV_FUNC.apply(normalizedSpawnRate);
            int numClusters = (int)Math.round(rng.nextGaussian() * sigma + (double)normalizedSpawnRate);
            clusterCounts.put(oreType, numClusters);
        }
        long step1Time = System.nanoTime();
        String startChunk = chunks.get(0);
        int minSpacing = this.C.getDefaultConfigModel().minChunksBetweenOreClusters;
        int MIN_SPACING_VALIDATOR_CUTOFF_RADIUS = Math.min(this.determinedChunks.size(), (int)Math.pow(minSpacing, 2.0));
        LinkedHashSet<String> chunksInRadiusOfStart = this.getChunkIdsInRadius(startChunk, Math.min(minSpacing, MIN_SPACING_VALIDATOR_CUTOFF_RADIUS));
        String closestToCenter = chunksInRadiusOfStart.stream().min(Comparator.comparingInt(c -> Math.round(HBUtil.ChunkUtil.chunkDist((String)c, (String)"0,0")))).get();
        int batchDimensions = (int)Math.ceil(Math.sqrt(chunks.size()));
        int spiralRadius = batchDimensions + MIN_SPACING_VALIDATOR_CUTOFF_RADIUS;
        LinkedHashSet<Object> localExistingClusters = new LinkedHashSet<Object>();
        this.localAreaClustersByType.values().stream().forEach(ids -> localExistingClusters.addAll((Collection<Object>)ids));
        int maxZ = 0;
        int maxX = 0;
        int minZ = 0;
        int minX = 0;
        for (String string : localExistingClusters) {
            ChunkPos pos = HBUtil.ChunkUtil.getChunkPos((String)string);
            if (pos.f_45578_ < minX) {
                minX = pos.f_45578_;
            }
            if (pos.f_45578_ > maxX) {
                maxX = pos.f_45578_;
            }
            if (pos.f_45579_ < minZ) {
                minZ = pos.f_45579_;
            }
            if (pos.f_45579_ <= maxZ) continue;
            maxZ = pos.f_45579_;
        }
        float totalClusters = clusterCounts.values().stream().mapToInt(i -> i).sum();
        float f = (float)chunks.size() / totalClusters;
        float stdDev = Math.max((f - (float)minSpacing) / 3.0f, 0.0f);
        LinkedList<Object> chunksToBePopulated = new LinkedList<Object>();
        int chunkIndex = 0;
        while (chunkIndex < chunks.size()) {
            Object chunkId;
            chunkIndex = (int)Math.round(rng.nextGaussian() * (double)stdDev + (double)f) + chunkIndex;
            chunkIndex = chunkIndex < 0 ? 0 : chunkIndex;
            boolean openSpaceForCluster = false;
            block7: while (!openSpaceForCluster && chunkIndex < chunks.size()) {
                openSpaceForCluster = true;
                if (minSpacing == 0 || this.determinedChunks.contains(chunkId = chunks.get(chunkIndex++))) continue;
                if (minSpacing < MIN_SPACING_VALIDATOR_CUTOFF_RADIUS) {
                    LinkedHashSet<String> nearbyChunks = this.getChunkIdsInRadius((String)chunkId, minSpacing);
                    for (String nearbyChunk : nearbyChunks) {
                        if (!localExistingClusters.contains(nearbyChunk)) continue;
                        openSpaceForCluster = false;
                        continue block7;
                    }
                    continue;
                }
                if (!localExistingClusters.stream().anyMatch(arg_0 -> OreClusterCalculator.lambda$calculateClusterLocations$3((String)chunkId, minSpacing, arg_0))) continue;
                openSpaceForCluster = false;
            }
            if (chunkIndex >= chunks.size()) continue;
            chunkId = chunks.get(chunkIndex);
            chunksToBePopulated.add(chunkId);
            localExistingClusters.add(chunkId);
        }
        oreClusterTypes.sort(Comparator.comparingInt(o -> -1 * ((OreClusterConfigModel)clusterConfigs.get((Object)o)).oreClusterSpawnRate));
        LinkedHashSet<String> selectedChunks = new LinkedHashSet<String>();
        try {
            for (OreClusterConfigModel.OreClusterId oreType : oreClusterTypes) {
                OreClusterConfigModel config = (OreClusterConfigModel)clusterConfigs.get(oreType);
                HashSet allChunksWithClusterType = this.localAreaClustersByType.get(oreType).stream().collect(Collectors.toCollection(HashSet::new));
                int MIN_SPACING_SPECIFIC_CLUSTER_VALIDATOR_CUTOFF_RADIUS = Math.min(allChunksWithClusterType.size(), (int)Math.pow(config.minChunksBetweenOreClusters.intValue(), 2.0));
                int totalSpecificClusters = (Integer)clusterCounts.get(oreType);
                if (totalSpecificClusters == 0) continue;
                int clustersPlaced = 0;
                int specificMinSpacing = config.minChunksBetweenOreClusters;
                Iterator it = chunksToBePopulated.iterator();
                while (it.hasNext()) {
                    String chunkId = (String)it.next();
                    if (!selectedChunks.remove(chunkId)) continue;
                    it.remove();
                }
                LinkedList chunksToBePopulatedSpecificCopy = new LinkedList(chunksToBePopulated);
                Collections.shuffle(chunksToBePopulatedSpecificCopy, rng);
                boolean validCluster = false;
                while (clustersPlaced < totalSpecificClusters) {
                    ++clustersPlaced;
                    String candidateChunkId = null;
                    validCluster = false;
                    block12: while (!(validCluster || chunksToBePopulatedSpecificCopy.isEmpty() || this.determinedChunks.contains(candidateChunkId = (String)chunksToBePopulatedSpecificCopy.removeFirst()))) {
                        validCluster = true;
                        if (specificMinSpacing < MIN_SPACING_SPECIFIC_CLUSTER_VALIDATOR_CUTOFF_RADIUS) {
                            LinkedHashSet<String> nearbyChunks = this.getChunkIdsInRadius(candidateChunkId, specificMinSpacing);
                            for (String nearbyChunk : nearbyChunks) {
                                if (!allChunksWithClusterType.contains(nearbyChunk)) continue;
                                validCluster = false;
                                continue block12;
                            }
                            continue;
                        }
                        String id = candidateChunkId;
                        if (!allChunksWithClusterType.stream().anyMatch(c -> HBUtil.ChunkUtil.chunkDist((String)c, (String)id) < (float)specificMinSpacing)) continue;
                        validCluster = false;
                    }
                    if (!validCluster || candidateChunkId == null) continue;
                    selectedChunks.add(candidateChunkId);
                    allChunksWithClusterType.add(candidateChunkId);
                    if (clusterPositions.containsKey(candidateChunkId)) {
                        clusterPositions.get(candidateChunkId).add(oreType);
                        continue;
                    }
                    LinkedList<OreClusterConfigModel.OreClusterId> clusterMap = new LinkedList<OreClusterConfigModel.OreClusterId>();
                    clusterMap.add(oreType);
                    clusterPositions.put(candidateChunkId, clusterMap);
                }
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            clusterCounts.entrySet().forEach(ore -> sb.append(ore.getKey() + ": " + ore.getValue() + ", "));
            LoggerProject.logWarning("013001", "Unable to place all ore clusters: " + e.getMessage() + "Remaining Counts: " + sb.toString());
            e.printStackTrace();
        }
        long step4Time = System.nanoTime();
        Iterator<String> clusterPos = clusterPositions.keySet().iterator();
        while (clusterPos.hasNext()) {
            String chunkId = clusterPos.next();
            if (!this.determinedChunks.contains(chunkId)) continue;
            clusterPos.remove();
        }
        long step5Time = System.nanoTime();
        long endTime = System.nanoTime();
        return clusterPositions;
    }

    private LinkedHashSet<String> getChunkIdsInRadius(String chunkId, int radius) {
        LinkedHashSet<String> chunks = new LinkedHashSet<String>();
        ChunkPos center = HBUtil.ChunkUtil.getChunkPos((String)chunkId);
        for (int x = center.f_45578_ - radius; x <= center.f_45578_ + radius; ++x) {
            for (int z = center.f_45579_ - radius; z <= center.f_45579_ + radius; ++z) {
                chunks.add(HBUtil.ChunkUtil.getId((int)x, (int)z));
            }
        }
        return chunks;
    }

    public boolean cleanChunkFindAllOres(ManagedOreClusterChunk chunk, Set<BlockState> COUNTABLE_ORES) {
        LevelChunk levelChunk = chunk.getChunk(false);
        if (levelChunk == null) {
            return false;
        }
        LevelChunkSection[] sections = levelChunk.m_7103_();
        int SECTION_SZ = 16;
        boolean count = false;
        int outerCount = 0;
        boolean TURN_OFF = false;
        for (int i = sections.length - 1; i >= 0; --i) {
            LevelChunkSection section = sections[i];
            if (section == null || section.m_188008_()) continue;
            PalettedContainer states = section.m_63019_();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int sectionY;
                        OreClusterConfigModel.OreClusterId id;
                        ++outerCount;
                        BlockState blockState = ((BlockState)states.m_63087_(x, y, z)).m_60734_().m_49966_();
                        Biome localBiome = (Biome)section.m_204433_(x, 0, z).m_203334_();
                        chunk.addBiome(localBiome);
                        if (!COUNTABLE_ORES.contains(blockState) || (id = chunk.chooseConfigId(this.level, localBiome, blockState, this.C)) == null || !chunk.sampleAddOre(id, sectionY = this.level.m_151568_(i))) continue;
                        HBUtil.TripleInt relativePos = new HBUtil.TripleInt(x, y, z);
                        HBUtil.WorldPos pos = new HBUtil.WorldPos(relativePos, i, (ChunkAccess)levelChunk);
                        chunk.addOre(id, pos.getWorldPos(), true);
                    }
                }
            }
        }
        return true;
    }

    public void cleanChunkSelectClusterPosition(ManagedOreClusterChunk chunk) {
        HashMap<OreClusterConfigModel.OreClusterId, BlockPos> CLUSTER_TYPES = chunk.getClusterTypes();
        for (OreClusterConfigModel.OreClusterId b : CLUSTER_TYPES.keySet()) {
            BlockPos orePos;
            if (CLUSTER_TYPES.get(b) != null || (orePos = chunk.getOreClusterSourcePos(b)) == null) continue;
            CLUSTER_TYPES.put(b, orePos);
        }
    }

    public List<Pair<BlockState, BlockPos>> generateCluster(ManagedOreClusterChunk chunk, OreClusterConfigModel.OreClusterId clusterId, BlockPos sourcePos) {
        List<BlockState> clusterBlockStates;
        OreClusterGeneratorUtility generator;
        HBUtil.Fast3DArray positions;
        OreClusterConfigModel config = this.C.getOreConfigs().get(clusterId);
        HBUtil.TripleInt VOL = config.oreClusterVolume;
        String SHAPE = config.oreClusterShape;
        int randSeed = HBUtil.BlockUtil.mapTo1DNumber((BlockPos)sourcePos);
        List validShapes = OreClusterConfigData.COreClusters.DEF_ORE_CLUSTER_VALID_SHAPES.stream().toList();
        if (SHAPE.equals("ANY") || SHAPE.equals("NONE")) {
            int offset = validShapes.size();
            SHAPE = (String)validShapes.get(randSeed % offset);
        }
        if (SHAPE.equals("SPHERE")) {
            int radius = Math.min(VOL.x, VOL.z);
            positions = HBUtil.ShapeUtil.getSphere((int)radius, (int)VOL.y);
        } else {
            positions = HBUtil.ShapeUtil.getCube((int)VOL.x, (int)VOL.z, (int)VOL.y);
        }
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>(positions.size);
        ArrayList<Integer> Xs = new ArrayList<Integer>(positions.size);
        ArrayList<Integer> Ys = new ArrayList<Integer>(positions.size);
        ArrayList<Integer> Zs = new ArrayList<Integer>(positions.size);
        for (int i = 0; i < positions.size; ++i) {
            Xs.add(positions.getX(i));
            Ys.add(positions.getY(i));
            Zs.add(positions.getZ(i));
            int x = sourcePos.m_123341_() + positions.getX(i);
            int y = sourcePos.m_123342_() + positions.getY(i);
            int z = sourcePos.m_123343_() + positions.getZ(i);
            blockPositions.add(new BlockPos(x, y, z));
        }
        ArrayList<Pair<Integer, List<Integer>>> relativePosData = new ArrayList<Pair<Integer, List<Integer>>>();
        relativePosData.add(Pair.of((Object)VOL.x, Xs));
        relativePosData.add(Pair.of((Object)VOL.y, Ys));
        relativePosData.add(Pair.of((Object)VOL.z, Zs));
        try {
            generator = new OreClusterGeneratorUtility(chunk, clusterId, blockPositions, relativePosData);
        }
        catch (NullPointerException e) {
            return null;
        }
        HBUtil.TripleInt airOffset = new HBUtil.TripleInt(0, 0, 0);
        if (HBUtil.BlockUtil.blockToString((Block)clusterId.getBlock()).toLowerCase().contains("ore")) {
            airOffset = generator.calculateAvoidAirOffset();
        }
        if ((clusterBlockStates = generator.applyRadialDensityFunction()) == null) {
            return null;
        }
        ArrayList<Pair<BlockState, BlockPos>> clusterBlockStatePositions = new ArrayList<Pair<BlockState, BlockPos>>(positions.size);
        for (int i = 0; i < clusterBlockStates.size(); ++i) {
            if (clusterBlockStates.get(i) == null) continue;
            BlockState state = clusterBlockStates.get(i);
            BlockPos pos = ((BlockPos)blockPositions.get(i)).m_7918_(airOffset.x, airOffset.y, airOffset.z);
            clusterBlockStatePositions.add((Pair<BlockState, BlockPos>)Pair.of((Object)state, (Object)pos));
        }
        return clusterBlockStatePositions;
    }

    private static /* synthetic */ boolean lambda$calculateClusterLocations$3(String chunkId, int minSpacing, String c) {
        return HBUtil.ChunkUtil.chunkDist((String)c, (String)chunkId) < (float)minSpacing;
    }

    class OreClusterGeneratorUtility {
        private ManagedOreClusterChunk chunk;
        private LevelChunk levelChunk;
        private Random randomGenerator;
        private List<BlockPos> blockWorldPositions;
        private List<Pair<Integer, List<Integer>>> relativePositions;
        private OreClusterConfigModel.OreClusterId oreClusterId;
        private OreClusterConfigModel config;
        private HBUtil.TripleInt volume;
        private float expectedOreDensity;
        private List<BlockState> proportionedBlockStates;
        private Holder<NormalNoise.NoiseParameters> noiseParametersHolder;
        private DensityFunction.NoiseHolder noiseHolder;
        private DensityFunction noise;
        private DensityFunction linearXDensity;
        private DensityFunction linearZDensity;
        private DensityFunction linearYDensity;
        private DensityFunction linearXZDensity;
        private DensityFunction radialXZDensity;
        private DensityFunction radialZXDensity;
        private DensityFunction.ContextProvider densityFunctionContext;

        OreClusterGeneratorUtility(ManagedOreClusterChunk chunk, OreClusterConfigModel.OreClusterId id, List<BlockPos> blockPositions, List<Pair<Integer, List<Integer>>> positions) {
            this.chunk = chunk;
            this.levelChunk = this.chunk.getChunk(false);
            this.randomGenerator = this.chunk.getChunkRandom();
            if (this.levelChunk == null) {
                throw new NullPointerException("LevelChunk for ManagedOreClusterChunk " + chunk.getId() + " is null");
            }
            this.blockWorldPositions = blockPositions;
            this.relativePositions = positions;
            this.oreClusterId = id;
            this.config = OreClusterCalculator.this.C.getOreConfigModel(id);
            this.volume = this.config.oreClusterVolume;
            this.expectedOreDensity = this.config.oreClusterDensity.floatValue();
            this.initOreDensityPortions();
            this.initDensityFunctions();
        }

        HBUtil.TripleInt calculateAvoidAirOffset() {
            float EDGE_PORTION_CONSTANT = 0.2f;
            Function<Integer, Integer> CALC_EDGE_SZ = size -> (int)Math.ceil((float)size.intValue() * 0.2f);
            ArrayList<Float> clusterEdgeAirPortions = new ArrayList<Float>(6);
            ArrayList<BlockPos> nearEdges = new ArrayList<BlockPos>();
            ArrayList<BlockPos> farEdges = new ArrayList<BlockPos>();
            for (Pair<Integer, List<Integer>> dimension : this.relativePositions) {
                if ((Integer)dimension.getLeft() == 0) continue;
                nearEdges.clear();
                farEdges.clear();
                int dimLength = (Integer)dimension.getLeft();
                int EDGE_SZ = CALC_EDGE_SZ.apply((Integer)dimension.getLeft());
                int NEAR_CUTOFF = dimLength - EDGE_SZ;
                int FAR_CUTOFF = -1 * dimLength + EDGE_SZ;
                List relativePos = (List)dimension.getRight();
                for (int i = 0; i < relativePos.size(); ++i) {
                    if ((Integer)relativePos.get(i) >= NEAR_CUTOFF) {
                        nearEdges.add(this.blockWorldPositions.get(i));
                        continue;
                    }
                    if ((Integer)relativePos.get(i) > FAR_CUTOFF) continue;
                    farEdges.add(this.blockWorldPositions.get(i));
                }
                clusterEdgeAirPortions.add(Float.valueOf(this.checkSideAirExposure(nearEdges)));
                clusterEdgeAirPortions.add(Float.valueOf(this.checkSideAirExposure(farEdges)));
            }
            HBUtil.TripleInt OFFSET = new HBUtil.TripleInt(0, 0, 0);
            for (int i = 0; i < clusterEdgeAirPortions.size(); i += 2) {
                int farOffset;
                int EDGE_SZ = CALC_EDGE_SZ.apply((Integer)this.relativePositions.get(i / 2).getLeft());
                Function<Float, Integer> getOffset = portion -> {
                    if (portion.floatValue() < 0.2f) {
                        return 0;
                    }
                    if (portion.floatValue() < 0.4f) {
                        return (int)Math.ceil((float)EDGE_SZ * 0.5f);
                    }
                    if (portion.floatValue() < 0.6f) {
                        return (int)Math.ceil((float)EDGE_SZ * 1.0f);
                    }
                    if (portion.floatValue() < 0.8f) {
                        return (int)Math.ceil((float)EDGE_SZ * 1.5f);
                    }
                    return (int)Math.ceil(portion.floatValue() * 2.0f);
                };
                int offset = 0;
                int nearOffset = getOffset.apply((Float)clusterEdgeAirPortions.get(i));
                if (nearOffset > 0) {
                    offset -= nearOffset;
                }
                if ((farOffset = getOffset.apply((Float)clusterEdgeAirPortions.get(i + 1)).intValue()) > 0) {
                    offset += farOffset;
                }
                if (i < 2) {
                    OFFSET.x = offset;
                    continue;
                }
                if (i < 4) {
                    OFFSET.y = offset;
                    continue;
                }
                OFFSET.z = offset;
            }
            return OFFSET;
        }

        private float checkSideAirExposure(List<BlockPos> positions) {
            if (positions == null || positions.isEmpty()) {
                return 0.0f;
            }
            int count = 0;
            for (BlockPos pos : positions) {
                if (!this.levelChunk.m_8055_(pos).m_60795_()) continue;
                ++count;
            }
            return (float)count / (float)positions.size();
        }

        private void initOreDensityPortions() {
            ArrayList<BlockState> temp = new ArrayList<BlockState>(100);
            int density = (int)(this.expectedOreDensity * 100.0f);
            BlockPos clusterOrigin = this.chunk.getOreClusterSourcePos(this.oreClusterId);
            Block blockAtClusterOrigin = this.levelChunk.m_8055_(clusterOrigin).m_60734_();
            BlockState baseBlockState = this.config.oreClusterType;
            if (this.config.oreClusterType.m_60734_().equals(blockAtClusterOrigin)) {
                baseBlockState = this.levelChunk.m_8055_(clusterOrigin);
            }
            for (int i = 0; i < 100; ++i) {
                temp.add(baseBlockState);
            }
            List alternativeBlocks = this.config.oreClusterReplaceableEmptyBlocks.stream().toList();
            int partition = (int)((float)(100 - density) / (float)alternativeBlocks.size());
            int pos = density;
            block1: for (int i = 0; i < alternativeBlocks.size(); ++i) {
                for (int j = 0; j < partition; ++j) {
                    temp.set(pos++, (BlockState)alternativeBlocks.get(i));
                    if (pos >= 100) continue block1;
                }
            }
            BlockState[] states = new BlockState[201];
            for (int i = 0; i < 100; ++i) {
                states[100 - i] = (BlockState)temp.get(i);
                states[100 + i] = (BlockState)temp.get(i);
            }
            this.proportionedBlockStates = Arrays.asList(states);
        }

        private void initDensityFunctions() {
            long seed = this.randomGenerator.nextLong();
            int FIRST_OCTAVE = -2;
            List<Double> AMPLITUDES = Arrays.asList(1.0, 0.5, 0.25, 0.125);
            NormalNoise.NoiseParameters nParameters = new NormalNoise.NoiseParameters(-2, AMPLITUDES);
            RandomSource rSource = RandomSource.m_216335_((long)seed);
            NormalNoise perlinNoise = NormalNoise.m_230511_((RandomSource)rSource, (NormalNoise.NoiseParameters)nParameters);
            UniformNoiseFunction uniformNoise = new UniformNoiseFunction(seed);
            int clusterVolume = this.volume.x * this.volume.y * this.volume.z;
            if (clusterVolume < 144) {
                this.noise = uniformNoise;
            } else {
                CustomNoiseFunction perlinDensity;
                double scaleFactor = clusterVolume < 168 ? 1.0 : Math.min(Math.sqrt(clusterVolume) / 10.0, 2.0);
                CustomNoiseFunction normalizedPerlin = perlinDensity = new CustomNoiseFunction(perlinNoise, 0.1 * scaleFactor, 1.0 * scaleFactor);
                DensityFunction constant_p = DensityFunctions.m_208264_((double)1.0);
                this.noise = this.mul(DensityFunctions.m_208293_((DensityFunction)normalizedPerlin, (DensityFunction)uniformNoise), constant_p).m_208220_(-1.0, 1.0);
            }
            int halfX = this.volume.x / 2;
            int halfY = this.volume.y / 2;
            int halfZ = this.volume.z / 2;
            DensityFunction linearXFalloff = DensityFunctions.m_208266_((int)(-halfX), (int)halfX, (double)0.0, (double)1.0);
            DensityFunction linearZFalloff = DensityFunctions.m_208266_((int)(-halfZ), (int)halfZ, (double)0.0, (double)1.0);
            DensityFunction linearYFalloff = DensityFunctions.m_208266_((int)(-halfY), (int)halfY, (double)0.0, (double)1.0);
            RadialGradient radialXZFalloff = new RadialGradient(new HBUtil.TripleInt(0, 0, 0), (double)Math.max(this.volume.x, this.volume.z) / 2.0, 0.0, 1.0);
            RadialGradient radialZXFalloff = new RadialGradient(new HBUtil.TripleInt(0, 0, 0), (double)Math.max(this.volume.x, this.volume.z) / 2.0, 0.0, 1.0);
            this.densityFunctionContext = new DensityFunction.ContextProvider(){

                public DensityFunction.FunctionContext m_207263_(int index) {
                    HBUtil.TripleInt p = OreClusterGeneratorUtility.this.getRelativePos(index);
                    return new DensityFunction.SinglePointContext(p.x, p.y, p.z);
                }

                public void m_207207_(double[] values, DensityFunction density) {
                    for (int i = 0; i < values.length; ++i) {
                        HBUtil.TripleInt p = OreClusterGeneratorUtility.this.getRelativePos(i);
                        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(p.x, p.y, p.z);
                        values[i] = density.m_207386_((DensityFunction.FunctionContext)context);
                    }
                }
            };
        }

        private HBUtil.TripleInt getRelativePos(int i) {
            return new HBUtil.TripleInt(((Integer)((List)this.relativePositions.get(0).getRight()).get(i)).intValue(), ((Integer)((List)this.relativePositions.get(1).getRight()).get(i)).intValue(), ((Integer)((List)this.relativePositions.get(2).getRight()).get(i)).intValue());
        }

        private DensityFunction mul(DensityFunction d1, DensityFunction d2) {
            return DensityFunctions.m_208363_((DensityFunction)d1, (DensityFunction)d2);
        }

        List<BlockState> applyRadialDensityFunction() {
            int i;
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>(this.blockWorldPositions.size());
            ArrayList blockStatesXZ = new ArrayList(this.blockWorldPositions.size());
            ArrayList blockStatesZX = new ArrayList(this.blockWorldPositions.size());
            int size = this.blockWorldPositions.size();
            Integer[] Xs = ((List)this.relativePositions.get(0).getRight()).toArray(new Integer[0]);
            Integer[] Ys = ((List)this.relativePositions.get(1).getRight()).toArray(new Integer[0]);
            Integer[] Zs = ((List)this.relativePositions.get(2).getRight()).toArray(new Integer[0]);
            for (i = 0; i < size; ++i) {
            }
            for (i = 0; i < size; ++i) {
            }
            for (i = 0; i < size; ++i) {
                blockStates.add(i, this.getBlockState(i, this.noise));
            }
            double[] sample = new double[size];
            this.densityFunctionContext.m_207207_(sample, this.noise);
            return blockStates;
        }

        private BlockState getBlockState(int i, DensityFunction density) {
            HBUtil.TripleInt pos = this.getRelativePos(i);
            return this.getBlockState(pos.x, pos.y, pos.z, density);
        }

        private BlockState getBlockState(int x, int y, int z, DensityFunction density) {
            DensityFunction.SinglePointContext pos = new DensityFunction.SinglePointContext(x, y, z);
            double densityVal = density.m_207386_((DensityFunction.FunctionContext)pos);
            int index = (int)(densityVal * 99.0) + 100;
            return this.proportionedBlockStates.get(index);
        }

        private int abs(Number a) {
            return Math.abs(a.intValue());
        }
    }

    class RadialGradient
    implements DensityFunction.SimpleFunction {
        private final int centerX;
        private final int centerY;
        private final int centerZ;
        private final double radius;
        private final double fromValue;
        private final double toValue;

        public RadialGradient(HBUtil.TripleInt center, double radius, double fromValue, double toValue) {
            this.centerX = center.x;
            this.centerY = center.y;
            this.centerZ = center.z;
            this.radius = radius;
            this.fromValue = fromValue;
            this.toValue = toValue;
        }

        public double m_207386_(DensityFunction.FunctionContext context) {
            double dx = context.m_207115_() - this.centerX;
            double dy = context.m_207114_() - this.centerY;
            double dz = context.m_207113_() - this.centerZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double t = Math.min(distance / this.radius, 1.0);
            double smoothT = 1.0 - t * t;
            return Mth.m_14139_((double)smoothT, (double)this.fromValue, (double)this.toValue);
        }

        public double m_207402_() {
            return Math.min(this.fromValue, this.toValue);
        }

        public double m_207401_() {
            return Math.max(this.fromValue, this.toValue);
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)this));
        }
    }

    class CustomNoiseFunction
    implements DensityFunction.SimpleFunction {
        private final NormalNoise noise;
        private final double xzScale;
        private final double yScale;

        public CustomNoiseFunction(NormalNoise noise, double xzScale, double yScale) {
            this.noise = noise;
            this.xzScale = xzScale;
            this.yScale = yScale;
        }

        public double m_207386_(DensityFunction.FunctionContext context) {
            double x = (double)context.m_207115_() * this.xzScale;
            double y = (double)context.m_207114_() * this.yScale;
            double z = (double)context.m_207113_() * this.xzScale;
            return this.noise.m_75380_(x, y, z);
        }

        public double m_207402_() {
            return -this.noise.m_210630_();
        }

        public double m_207401_() {
            return this.noise.m_210630_();
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)this));
        }
    }

    public class UniformNoiseFunction
    implements DensityFunction.SimpleFunction {
        private final long seed;

        public UniformNoiseFunction(long seed) {
            this.seed = seed;
        }

        public double m_207386_(DensityFunction.FunctionContext context) {
            long hash = this.hashCoords(context.m_207115_(), context.m_207114_(), context.m_207113_());
            double noise = (double)(hash & Integer.MAX_VALUE) / 2.147483647E9;
            return noise * 2.0 - 1.0;
        }

        public double m_207402_() {
            return -1.0;
        }

        public double m_207401_() {
            return 1.0;
        }

        private long hashCoords(int x, int y, int z) {
            long h = this.seed;
            h = h * 31L + (long)x;
            h = h * 31L + (long)y;
            h = h * 31L + (long)z;
            return Mth.m_14183_((int)Long.valueOf(h).intValue());
        }

        public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
            return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)this));
        }
    }
}

