/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.datastore.WorldSaveData;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.exception.InvalidId;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.core.OreClusterManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class OreClusterRegenManager {
    Long periodTickStart;
    Long periodTickEnd;
    Long periodTickLength;
    String periodCurrentStage;
    ExecutorService triggerRegenThreadExecutor;
    Map<LevelAccessor, OreClusterManager> managers;
    GeneralConfig generalConfig;
    ModRealTimeConfig config;
    private static boolean isLoaded = false;
    final int TICKS_PER_DAY = OreClustersAndRegenMain.DEBUG != false ? 2400 : (int)GeneralConfig.TICKS_PER_DAY;

    public OreClusterRegenManager(EventRegistrar reg, ModRealTimeConfig config, Map<LevelAccessor, OreClusterManager> managers) {
        this.triggerRegenThreadExecutor = Executors.newSingleThreadExecutor();
        this.managers = managers;
        this.config = config;
        this.generalConfig = GeneralConfig.getInstance();
        this.init(reg);
    }

    public void init(EventRegistrar reg) {
        reg.registerOnLevelLoad(this::onLevelLoad, EventPriority.Normal);
        reg.registerOnLevelUnload(this::onLevelUnload, EventPriority.Normal);
        reg.registerOnDataSave(this::save, EventPriority.High);
        reg.registerOnDailyTick(GeneralConfig.OVERWORLD_LOC, this::onDailyTick);
        LoggerProject.logInit("015000", this.getClass().getName());
    }

    public void setPeriodLength(@Nullable String item) throws InvalidId {
        LinkedHashMap<String, Integer> periodLengthByItem = this.config.getDefaultConfigModel().oreClusterRegenPeriods;
        if (item == null) {
            item = (String)periodLengthByItem.keySet().iterator().next();
        }
        if (!periodLengthByItem.containsKey(item)) {
            throw new InvalidId("Invalid item for period length: " + item);
        }
        int regenPeriodInDays = (Integer)periodLengthByItem.get(item);
        this.periodTickLength = (long)regenPeriodInDays * (long)this.TICKS_PER_DAY;
        this.periodCurrentStage = item;
        this.updatePeriod(this.periodTickLength);
    }

    public void updatePeriod(long length) {
        this.updatePeriod(this.generalConfig.getTotalTickCountWithSleep((Level)GeneralConfig.OVERWORLD), length);
    }

    public void updatePeriod(long start, long length) {
        this.periodTickLength = length;
        this.periodTickStart = start;
        this.periodTickEnd = start + length;
    }

    private void handleDailyTick(ServerTickEvent.DailyTickEvent event) {
        long currentTicks = event.getTickCountWithSleeps();
        if (currentTicks >= this.periodTickEnd) {
            this.triggerRegenThreadExecutor.submit(this::triggerGlobalRegen);
            this.updatePeriod(currentTicks, this.periodTickLength);
        }
    }

    public int getDaysUntilNewPeriod() {
        long currentTicks = this.generalConfig.getTotalTickCountWithSleep((Level)GeneralConfig.OVERWORLD);
        long remainingTicks = this.periodTickEnd - currentTicks;
        return (int)(remainingTicks / (long)this.TICKS_PER_DAY);
    }

    public int getDaysIntoPeriod() {
        long currentTicks = this.generalConfig.getTotalTickCountWithSleep((Level)GeneralConfig.OVERWORLD);
        long ticksProgressToNextPeriod = currentTicks - this.periodTickStart;
        return (int)(ticksProgressToNextPeriod / (long)this.TICKS_PER_DAY);
    }

    public int getDayPeriodLength() {
        return (int)(this.periodTickLength / (long)this.TICKS_PER_DAY);
    }

    public void triggerRegen() {
        this.triggerGlobalRegen();
    }

    public void triggerRegen(LevelAccessor level, String chunkId) throws InvalidId {
        this.triggerChunkRegen(level, chunkId);
    }

    private void triggerGlobalRegen() {
        for (OreClusterManager manager : this.managers.values()) {
            manager.triggerRegen();
        }
    }

    private void triggerChunkRegen(LevelAccessor level, String chunkId) throws InvalidId {
        OreClusterManager manager = this.managers.get(level);
        if (manager == null) {
            throw new InvalidId("Could not find manager for level" + HBUtil.LevelUtil.toLevelId((LevelAccessor)level));
        }
        manager.triggerRegen(chunkId, true);
    }

    public boolean load() {
        DataStore ds = GeneralConfig.getInstance().getDataStore();
        if (ds == null) {
            return false;
        }
        WorldSaveData worldSaveData = ds.getOrCreateWorldSaveData("hbs_ore_cluster_and_regen");
        JsonElement wrapper = worldSaveData.get("oreClusterRegenManager");
        if (wrapper == null || wrapper.isJsonNull()) {
            return false;
        }
        JsonObject object = wrapper.getAsJsonObject();
        if (!object.has("periodTickStart") || object.get("periodTickStart").isJsonNull()) {
            return false;
        }
        this.periodTickStart = object.get("periodTickStart").getAsLong();
        if (!object.has("periodTickEnd") || object.get("periodTickEnd").isJsonNull()) {
            return false;
        }
        this.periodTickEnd = object.get("periodTickEnd").getAsLong();
        if (!object.has("periodTickLength") || object.get("periodTickLength").isJsonNull()) {
            return false;
        }
        this.periodTickLength = object.get("periodTickLength").getAsLong();
        if (!object.has("periodCurrentStage") || object.get("periodCurrentStage").isJsonNull()) {
            return false;
        }
        this.periodCurrentStage = object.get("periodCurrentStage").getAsString();
        LinkedHashMap<String, Integer> periods = this.config.getDefaultConfigModel().oreClusterRegenPeriods;
        if (periods.containsKey(this.periodCurrentStage)) {
            this.periodTickLength = (Integer)periods.get(this.periodCurrentStage) * this.TICKS_PER_DAY;
            this.updatePeriod(this.periodTickStart, this.periodTickLength);
        } else {
            LoggerProject.logError("015003", "Invalid periodCurrentStage: " + this.periodCurrentStage + ". Using saved period length of " + this.periodTickLength);
        }
        return true;
    }

    public void save(DatastoreSaveEvent event) {
        DataStore ds = event.getDataStore();
        if (ds == null) {
            return;
        }
        JsonObject wrapper = new JsonObject();
        wrapper.addProperty("periodTickStart", (Number)this.periodTickStart);
        wrapper.addProperty("periodTickEnd", (Number)this.periodTickEnd);
        wrapper.addProperty("periodTickLength", (Number)this.periodTickLength);
        wrapper.addProperty("periodCurrentStage", this.periodCurrentStage);
        WorldSaveData worldSaveData = ds.getOrCreateWorldSaveData("hbs_ore_cluster_and_regen");
        worldSaveData.addProperty("oreClusterRegenManager", (JsonElement)wrapper);
    }

    public void shutdown() {
        try {
            this.triggerRegenThreadExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            this.triggerRegenThreadExecutor.shutdownNow();
        }
        catch (InterruptedException e) {
            LoggerProject.logWarning("015001", "Error shutting down OreClusterRegenManager, regen thread was in progress");
        }
        this.save(DatastoreSaveEvent.create());
    }

    public void onLevelLoad(LevelLoadingEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (isLoaded) {
            return;
        }
        this.triggerRegenThreadExecutor = Executors.newSingleThreadExecutor();
        boolean loadedFromFile = this.load();
        try {
            if (!loadedFromFile) {
                this.setPeriodLength(null);
            }
        }
        catch (InvalidId e) {
            LoggerProject.logError("015002", "Error setting period length for OreClusterRegenManager");
            return;
        }
        isLoaded = true;
    }

    public void onLevelUnload(LevelLoadingEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        isLoaded = false;
    }

    public void onDailyTick(ServerTickEvent.DailyTickEvent event) {
        this.handleDailyTick(event);
    }
}

