/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.orecluster.core.model;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.modelInterface.IMangedChunkData;
import com.holybuckets.orecluster.LoggerProject;
import com.holybuckets.orecluster.ModRealTimeConfig;
import com.holybuckets.orecluster.OreClustersAndRegenMain;
import com.holybuckets.orecluster.config.model.OreClusterConfigModel;
import com.holybuckets.orecluster.core.OreClusterManager;
import com.holybuckets.orecluster.core.OreClusterStatus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedOreClusterChunk
implements IMangedChunkData {
    private static final String CLASS_ID = "003";
    private static final String NBT_KEY_HEADER = "managedOreClusterChunk";
    public static final String TEST_ID = "-1,0";
    public static final int MAX_ORIGINAL_ORES = 8;
    public static ModRealTimeConfig CONFIG;
    private LevelAccessor level;
    private String id;
    private ChunkPos pos;
    private OreClusterStatus status;
    private long timeUnloaded;
    private long timeLastLoaded;
    private long tickLoaded;
    private boolean isReady;
    private HashMap<OreClusterConfigModel.OreClusterId, BlockPos> clusterTypes;
    private Map<OreClusterConfigModel.OreClusterId, Pair<BlockPos, MutableInt>> originalOres;
    private Map<BlockState, LinkedHashSet<BlockPos>> blockStateUpdates;
    private int updatesSize;
    private LinkedHashSet<Biome> biomes;
    private Random managedRandom;
    private ReentrantLock lock = new ReentrantLock();
    private static final OreClusterStatus current;
    private static final OreClusterStatus delinquent;
    private static Set<String> loadedIds;
    private static Set<String> deserializedIds;

    public static void registerManagedChunkData() {
        ManagedChunk.registerManagedChunkData(ManagedOreClusterChunk.class, () -> new ManagedOreClusterChunk(null));
    }

    private ManagedOreClusterChunk(LevelAccessor level) {
        this.level = level;
        this.id = null;
        this.pos = null;
        this.status = OreClusterStatus.NONE;
        this.timeUnloaded = -1L;
        this.timeLastLoaded = System.currentTimeMillis();
        this.tickLoaded = GeneralConfig.getInstance().getTotalTickCount();
        this.isReady = false;
        this.clusterTypes = null;
        this.blockStateUpdates = new ConcurrentHashMap<BlockState, LinkedHashSet<BlockPos>>();
        this.updatesSize = 0;
        this.originalOres = new HashMap<OreClusterConfigModel.OreClusterId, Pair<BlockPos, MutableInt>>();
        this.biomes = new LinkedHashSet();
    }

    private ManagedOreClusterChunk(LevelAccessor level, String id) {
        this(level);
        this.setId(id);
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)id);
    }

    public LevelChunk getChunk(boolean forceLoad) {
        LevelChunk c;
        OreClusterManager m = OreClusterManager.getManager(this.level);
        if (m != null && (c = m.getForceLoadedChunk(this.id)) != null) {
            return c;
        }
        ManagedChunk parent = ManagedOreClusterChunk.getParent(this.level, this.id);
        if (parent == null) {
            return null;
        }
        return parent.getLevelChunk();
    }

    public ManagedChunk getParent() {
        return ManagedOreClusterChunk.getParent(this.level, this.id);
    }

    public LevelChunk getChunk() {
        return this.getChunk(false);
    }

    public boolean testChunkLoadedAndEditable() {
        ManagedChunk parent = this.getParent();
        if (parent == null || parent.util == null) {
            return false;
        }
        return parent.util.isChunkFullyLoaded(this.id);
    }

    public boolean hasChunk() {
        return this.getChunk(false) != null;
    }

    public ChunkPos getChunkPos() {
        return this.pos;
    }

    public String getId() {
        return this.id;
    }

    public OreClusterStatus getStatus() {
        return this.status;
    }

    public HashMap<OreClusterConfigModel.OreClusterId, BlockPos> getClusterTypes() {
        if (this.clusterTypes == null) {
            return new HashMap<OreClusterConfigModel.OreClusterId, BlockPos>();
        }
        return this.clusterTypes;
    }

    public boolean hasClusters() {
        if (this.clusterTypes == null) {
            return false;
        }
        return this.clusterTypes.size() > 0;
    }

    public boolean hasReadyClusters() {
        if (!this.hasClusters()) {
            return false;
        }
        boolean ready = this.clusterTypes.values().stream().allMatch(pos -> pos != null);
        return ready;
    }

    public int countUpdatesRemaining() {
        return this.blockStateUpdates.size();
    }

    public Set<BlockState> getBlockStateUpdatesSet() {
        return this.blockStateUpdates.keySet();
    }

    public Map<BlockState, LinkedHashSet<BlockPos>> getBlockStateUpdates() {
        return this.blockStateUpdates;
    }

    public Optional<BlockState> getBlockStateUpdateType() {
        return this.blockStateUpdates.keySet().stream().findFirst();
    }

    @Nullable
    public LinkedHashSet<BlockPos> getBlockStateUpdates(BlockState state) {
        return this.blockStateUpdates.get(state);
    }

    public void removeBlockStateUpdates(BlockState state) {
        this.blockStateUpdates.remove(state);
    }

    public Map<OreClusterConfigModel.OreClusterId, Pair<BlockPos, MutableInt>> getOriginalOres() {
        return this.originalOres;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    public Long getTimeUnloaded() {
        return this.timeUnloaded;
    }

    public Long getTimeLastLoaded() {
        return this.timeLastLoaded;
    }

    public Long getTickLoaded() {
        return this.tickLoaded;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public Random getChunkRandom() {
        return ManagedChunkUtility.getChunkRandom((ChunkPos)this.pos, (Long)ModRealTimeConfig.CLUSTER_SEED);
    }

    public synchronized ReentrantLock getLock() {
        return this.lock;
    }

    public boolean hasBiome(Biome b) {
        if (b == null) {
            return false;
        }
        return this.biomes.contains(b);
    }

    public Set<Biome> getBiomes() {
        return this.biomes;
    }

    public OreClusterConfigModel.OreClusterId chooseConfigId(Level level, Biome localBiome, BlockState blockState, ModRealTimeConfig C) {
        OreClusterConfigModel.OreClusterId id;
        block1: {
            Biome temp;
            id = C.getOreConfigId(level, localBiome, blockState.m_60734_());
            if (localBiome != null && id != null) break block1;
            Iterator iterator = this.biomes.iterator();
            while (iterator.hasNext() && (id = C.getOreConfigId(level, temp = (Biome)iterator.next(), blockState.m_60734_())) == null) {
            }
        }
        return id;
    }

    public OreClusterConfigModel chooseConfig(Level level, Biome localBiome, BlockState blockState, ModRealTimeConfig C) {
        OreClusterConfigModel.OreClusterId id = this.chooseConfigId(level, localBiome, blockState, C);
        if (id == null) {
            return null;
        }
        return C.getOreConfigs().get(id);
    }

    public void setId(String id) {
        if (id == null) {
            return;
        }
        this.id = id;
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)id);
        this.managedRandom = this.getChunkRandom();
    }

    public void setLevel(LevelAccessor level) {
        this.level = level;
    }

    public void setStatus(OreClusterStatus status) {
        if (this.status != current || status == delinquent) {
            // empty if block
        }
        this.status = status;
    }

    public boolean sampleAddOre(OreClusterConfigModel.OreClusterId id, int sectionY) {
        if (this.originalOres == null) {
            return false;
        }
        if (!CONFIG.testValidYSpawn(id, sectionY)) {
            return false;
        }
        if (!this.originalOres.containsKey(id)) {
            this.originalOres.put(id, (Pair<BlockPos, MutableInt>)Pair.of(null, (Object)new MutableInt(1)));
            return true;
        }
        MutableInt count = (MutableInt)this.originalOres.get(id).getRight();
        return this.managedRandom.nextFloat() <= 1.0f / (float)count.getAndAdd(1);
    }

    public void addOre(OreClusterConfigModel.OreClusterId config, BlockPos pos, boolean force) {
        Pair pair = this.originalOres.get(config);
        if (pair == null) {
            pair = Pair.of((Object)pos, (Object)new MutableInt(1));
            this.originalOres.put(config, (Pair<BlockPos, MutableInt>)pair);
            return;
        }
        int sectionNumber = pos.m_123342_() / 16 + pos.m_123342_() % 16;
        if (force || this.sampleAddOre(config, sectionNumber)) {
            pair = Pair.of((Object)pos, (Object)((MutableInt)pair.getRight()));
            this.originalOres.put(config, (Pair<BlockPos, MutableInt>)pair);
        }
    }

    public boolean hasOreClusterSourcePos(OreClusterConfigModel.OreClusterId b) {
        if (this.clusterTypes != null && this.clusterTypes.get(b) != null) {
            return true;
        }
        if (this.originalOres == null) {
            return false;
        }
        if (!this.originalOres.containsKey(b)) {
            return false;
        }
        return this.originalOres.get(b).getLeft() != null;
    }

    public BlockPos getOreClusterSourcePos(OreClusterConfigModel.OreClusterId b) {
        if (this.clusterTypes != null && this.clusterTypes.get(b) != null) {
            return this.clusterTypes.get(b);
        }
        if (this.originalOres == null) {
            return null;
        }
        if (!this.originalOres.containsKey(b)) {
            return null;
        }
        return (BlockPos)this.originalOres.get(b).getLeft();
    }

    public void clearOriginalOres() {
        if (ManagedOreClusterChunk.isNoStatus(this) || ManagedOreClusterChunk.isDetermined(this)) {
            return;
        }
        if (this.originalOres == null) {
            return;
        }
        this.originalOres.clear();
        this.originalOres = null;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public void setTimeUnloaded() {
        this.timeUnloaded = System.currentTimeMillis();
    }

    public boolean updateTimeLastLoaded(Long currentTime) {
        ManagedChunk parent = this.getParent();
        if (parent == null || parent.util == null) {
            return false;
        }
        if (parent.util.isLoaded(this.id)) {
            this.timeLastLoaded = currentTime;
            return true;
        }
        return false;
    }

    public void addClusterTypes(List<OreClusterConfigModel.OreClusterId> clusters) {
        if (clusters == null) {
            return;
        }
        if (this.clusterTypes == null) {
            this.clusterTypes = new HashMap();
        }
        HashMap<OreClusterConfigModel.OreClusterId, BlockPos> clusterMap = new HashMap<OreClusterConfigModel.OreClusterId, BlockPos>();
        for (OreClusterConfigModel.OreClusterId id : clusters) {
            if (this.clusterTypes.containsKey(id)) continue;
            clusterMap.put(id, null);
        }
        this.addClusterTypes(clusterMap);
    }

    public void addClusterTypes(Map<OreClusterConfigModel.OreClusterId, BlockPos> clusterMap) {
        if (clusterMap == null) {
            return;
        }
        if (clusterMap.size() == 0) {
            return;
        }
        if (this.clusterTypes == null) {
            this.clusterTypes = new HashMap();
        }
        this.clusterTypes.putAll(clusterMap);
    }

    public void addBlockStateUpdate(BlockState block, BlockPos pos) {
        if (block.equals(ModBlocks.empty.m_49966_())) {
            return;
        }
        LinkedHashSet<Object> positions = this.blockStateUpdates.get(block);
        if (positions == null) {
            positions = new LinkedHashSet();
            this.blockStateUpdates.put(block, positions);
        }
        positions.add(pos);
    }

    public void addBiome(Biome b) {
        if (b == null) {
            return;
        }
        this.biomes.add(b);
    }

    public boolean loadBiomes(ChunkAccess chunk) {
        if (chunk == null || chunk.m_7103_().length == 0 || chunk.m_7103_()[0] == null) {
            return false;
        }
        chunk.m_7103_()[0].m_187996_().m_196879_(hb -> this.addBiome((Biome)hb.m_203334_()));
        return this.biomes.size() > 0;
    }

    public boolean checkClusterHarvested() {
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        if (this.status == OreClusterStatus.HARVESTED) {
            return true;
        }
        if (this.status != OreClusterStatus.GENERATED) {
            return false;
        }
        LevelChunk chunk = this.getChunk(false);
        if (chunk == null) {
            return false;
        }
        for (BlockState block : this.blockStateUpdates.keySet()) {
            for (BlockPos pos : this.blockStateUpdates.get(block)) {
                if (chunk.m_8055_(pos).m_60734_().equals(block)) continue;
                this.status = OreClusterStatus.HARVESTED;
                this.blockStateUpdates.clear();
                return true;
            }
        }
        return false;
    }

    public boolean hasBlockUpdates() {
        return this.blockStateUpdates != null && this.blockStateUpdates.size() > 0;
    }

    public void clearBlockStateUpdates() {
        this.blockStateUpdates.clear();
        this.updatesSize = 0;
    }

    public ManagedOreClusterChunk getEarliest(Map<String, ManagedOreClusterChunk> loadedChunks) {
        ManagedOreClusterChunk existing = loadedChunks.get(this.id);
        if (existing == null) {
            return this;
        }
        if (existing.getTickLoaded() < this.getTickLoaded()) {
            return existing;
        }
        return this;
    }

    public BlockState mapBlockState(BlockState state) {
        Map<OreClusterConfigModel.OreClusterId, OreClusterConfigModel> ORE_CONFIGS = OreClusterManager.getManager(this.level).getConfig().getOreConfigs();
        Block[] replacements = ORE_CONFIGS.get((Object)state).oreClusterReplaceableEmptyBlocks.toArray(new Block[0]);
        Float modifier = ORE_CONFIGS.get((Object)state).oreVeinModifier;
        if (this.managedRandom.nextFloat() > modifier.floatValue()) {
            return replacements[this.managedRandom.nextInt(replacements.length)].m_49966_();
        }
        return state;
    }

    public ManagedOreClusterChunk getStaticInstance(LevelAccessor level, String id) {
        if (id == null || level == null) {
            return null;
        }
        OreClusterManager manager = OreClustersAndRegenMain.getManagers().get(level);
        if (manager != null && manager.getLoadedChunk(id) != null) {
            return manager.getLoadedChunk(id);
        }
        ManagedOreClusterChunk chunk = ManagedOreClusterChunk.getInstance(level, id);
        return chunk;
    }

    public boolean isInit(String subClass) {
        return subClass.equals(ManagedOreClusterChunk.class.getName()) && this.id != null;
    }

    public void handleChunkLoaded(ChunkLoadingEvent.Load event) {
        loadedIds.add(this.id);
        this.level = event.getLevel();
        this.pos = event.getChunkPos();
        this.timeUnloaded = -1L;
        OreClusterManager.onChunkLoad(event);
    }

    public void handleChunkUnloaded(ChunkLoadingEvent.Unload event) {
        OreClusterManager.onChunkUnload(event);
    }

    public static ManagedOreClusterChunk getInstance(LevelAccessor level, LevelChunk chunk) {
        return ManagedOreClusterChunk.getInstance(level, HBUtil.ChunkUtil.getId((ChunkAccess)chunk));
    }

    public static ManagedOreClusterChunk getInstance(LevelAccessor level, String id) {
        ManagedChunk parent = ManagedOreClusterChunk.getParent(level, id);
        if (parent == null) {
            return new ManagedOreClusterChunk(level, id);
        }
        ManagedOreClusterChunk c = (ManagedOreClusterChunk)parent.getSubclass(ManagedOreClusterChunk.class);
        if (c == null) {
            return new ManagedOreClusterChunk(level, id);
        }
        return c;
    }

    public static ManagedChunk getParent(LevelAccessor level, String id) {
        ManagedChunkUtility instance = ManagedChunkUtility.getInstance((LevelAccessor)level);
        return instance.getManagedChunk(id);
    }

    public static boolean isNoStatus(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.NONE;
    }

    public static boolean isDetermined(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.DETERMINED;
    }

    public static boolean isCleaned(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.CLEANED;
    }

    public static boolean isPregenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.PREGENERATED;
    }

    public static boolean isRegenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.REGENERATED;
    }

    public static boolean isGenerated(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.GENERATED;
    }

    public static boolean isHarvested(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.HARVESTED;
    }

    public static boolean isComplete(ManagedOreClusterChunk chunk) {
        return chunk.getStatus() == OreClusterStatus.COMPLETE;
    }

    public static boolean isReady(ManagedOreClusterChunk chunk) {
        return chunk.isReady;
    }

    public static boolean isLoaded(ManagedOreClusterChunk chunk) {
        if (chunk == null) {
            return false;
        }
        if (chunk.getParent() == null) {
            return false;
        }
        return chunk.getParent().util.isLoaded(chunk.getId());
    }

    public static boolean isFinished(ManagedOreClusterChunk c) {
        return ManagedOreClusterChunk.isComplete(c) || ManagedOreClusterChunk.isGenerated(c) || ManagedOreClusterChunk.isHarvested(c);
    }

    public CompoundTag serializeNBT() {
        CompoundTag details = new CompoundTag();
        details.m_128359_("id", this.id);
        details.m_128356_("tickLoaded", this.tickLoaded);
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        if (this.hasBlockUpdates()) {
            details.m_128359_("status", OreClusterStatus.CLEANED.toString());
        } else {
            details.m_128359_("status", this.status.toString());
        }
        if (this.clusterTypes == null || this.clusterTypes.size() == 0) {
            details.m_128365_("clusterTypes", (Tag)new CompoundTag());
        } else {
            CompoundTag clusterTypesTag = new CompoundTag();
            this.clusterTypes.forEach((oreClusterId, pos) -> {
                String key = oreClusterId.getStringId();
                String serializedPositions = "";
                if (pos != null) {
                    serializedPositions = HBUtil.BlockUtil.serializeBlockPos(List.of(pos));
                }
                clusterTypesTag.m_128359_(key, serializedPositions);
            });
            details.m_128365_("clusterTypes", (Tag)clusterTypesTag);
        }
        LoggerProject.logDebug("003007", "Serializing ManagedOreChunk: " + details);
        return details;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return;
        }
        deserializedIds.add(this.id);
        this.pos = HBUtil.ChunkUtil.getChunkPos((String)this.id);
        this.tickLoaded = tag.m_128454_("tickLoaded");
        this.timeUnloaded = -1L;
        this.status = OreClusterStatus.valueOf(tag.m_128461_("status"));
        if (this.id.equals(TEST_ID)) {
            boolean bl = false;
        }
        CompoundTag clusterTypesTag = tag.m_128469_("clusterTypes");
        this.clusterTypes = new HashMap();
        if (clusterTypesTag != null && !clusterTypesTag.m_128456_()) {
            for (String key : clusterTypesTag.m_128431_()) {
                OreClusterConfigModel.OreClusterId oreClusterId = CONFIG.getOreConfigId(Integer.parseInt(key));
                String serializedPositions = clusterTypesTag.m_128461_(key);
                if (serializedPositions == "") {
                    this.clusterTypes.put(oreClusterId, null);
                    continue;
                }
                List positions = HBUtil.BlockUtil.deserializeBlockPos((String)serializedPositions);
                this.clusterTypes.put(oreClusterId, (BlockPos)positions.get(0));
            }
        }
        OreClusterManager.addManagedOreClusterChunk(this);
    }

    static {
        current = OreClusterStatus.CLEANED;
        delinquent = OreClusterStatus.DETERMINED;
        loadedIds = new HashSet<String>();
        deserializedIds = new HashSet<String>();
    }
}

