#version 150

// Function to calculate linear fog
vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    // Adjust fogStart and fogEnd as specified
    fogStart = fogStart / 3.5384349071477304492426263330319;
    fogEnd = fogEnd * 1.055456748719378155088324506632;

    if (vertexDistance <= fogStart) {
        return inColor;
    }

    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;
    vec4 blendedColor = mix(inColor, fogColor, fogValue);
    blendedColor.a = mix(inColor.a, 0.0, fogValue); // Adjust alpha to make objects fade away

    return blendedColor;
}

// Function to calculate fog fade
float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {
    // Adjust fogStart and fogEnd as specified
    fogStart = fogStart / 3.5384349071477304492426263330319;
    fogEnd = fogEnd * 1.055456748719378155088324506632;

    if (vertexDistance <= fogStart) {
        return 1.0;
    } else if (vertexDistance >= fogEnd) {
        return 0.0;
    }

    return smoothstep(fogEnd, fogStart, vertexDistance);
}

// Function to calculate fog distance
float fog_distance(vec3 pos, int shape) {
    if (shape == 0) {
        return length(pos);
    } else {
        float distXZ = length(pos.xz);
        float distY = abs(pos.y);
        return max(distXZ, distY);
    }
}

// Function to adjust depth values for clouds to reduce z-fighting and y-fighting
float adjust_depth_for_clouds(float depth, bool isCloud) {
    if (isCloud) {
        depth += 0.001; // Slightly adjust depth for clouds to reduce z-fighting
        depth += 0.001; // Slightly adjust depth for clouds to reduce y-fighting
    }
    return depth;
}
