/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck;

import fr.jachou.topluck.command.AdminCommand;
import fr.jachou.topluck.command.TopLuckCommand;
import fr.jachou.topluck.data.PlayerStats;
import fr.jachou.topluck.listener.OreMineListener;
import fr.jachou.topluck.manager.AlertManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Topluck
extends JavaPlugin {
    private final Map<UUID, PlayerStats> statsMap = new HashMap<UUID, PlayerStats>();
    private AlertManager alertManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.alertManager = new AlertManager(this);
        Bukkit.getPluginManager().registerEvents((Listener)new OreMineListener(this), (Plugin)this);
        PluginCommand cmd = this.getCommand("topluck");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new TopLuckCommand(this));
        } else {
            this.getLogger().warning("Command topluck not defined in plugin.yml");
        }
        PluginCommand adminCmd = this.getCommand("tlad");
        if (adminCmd != null) {
            adminCmd.setExecutor((CommandExecutor)new AdminCommand(this));
        } else {
            this.getLogger().warning("Command tlad not defined in plugin.yml");
        }
    }

    public void onDisable() {
        this.statsMap.clear();
    }

    public PlayerStats getStats(UUID uuid) {
        return this.statsMap.computeIfAbsent(uuid, PlayerStats::new);
    }

    public Collection<PlayerStats> getAllStats() {
        return this.statsMap.values();
    }

    public AlertManager getAlertManager() {
        return this.alertManager;
    }
}

