/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.command;

import fr.jachou.topluck.Topluck;
import fr.jachou.topluck.data.Alert;
import fr.jachou.topluck.data.PlayerStats;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminCommand
implements CommandExecutor {
    private final Topluck plugin;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public AdminCommand(Topluck plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("topluck.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "audit": {
                this.handleAudit(sender, args);
                break;
            }
            case "surveillance": {
                this.handleSurveillance(sender, args);
                break;
            }
            case "alerts": {
                this.handleAlerts(sender, args);
                break;
            }
            case "freeze": {
                this.handleFreeze(sender, args);
                break;
            }
            case "export": {
                this.handleExport(sender, args);
                break;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "=== Topluck Admin Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/tlad audit <player>" + String.valueOf(ChatColor.WHITE) + " - Show detailed audit report");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/tlad surveillance <player> <watch|clear> [reason]" + String.valueOf(ChatColor.WHITE) + " - Manage surveillance status");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/tlad alerts [player]" + String.valueOf(ChatColor.WHITE) + " - View alerts");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/tlad freeze <player>" + String.valueOf(ChatColor.WHITE) + " - Freeze/unfreeze a player");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/tlad export <player> <csv|json>" + String.valueOf(ChatColor.WHITE) + " - Export player stats");
    }

    private void handleAudit(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tlad audit <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        PlayerStats stats = this.plugin.getStats(target.getUniqueId());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "=== Audit Report for " + target.getName() + " ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total blocks mined: " + String.valueOf(ChatColor.WHITE) + stats.getTotalBlocksMined());
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Ore Statistics:");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "  Diamonds: " + stats.getDiamondOresMined() + String.format(" (%.2f%%)", stats.getPercentage(stats.getDiamondOresMined())));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "  Emeralds: " + stats.getEmeraldOresMined() + String.format(" (%.2f%%)", stats.getPercentage(stats.getEmeraldOresMined())));
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "  Gold: " + stats.getGoldOresMined() + String.format(" (%.2f%%)", stats.getPercentage(stats.getGoldOresMined())));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Iron: " + stats.getIronOresMined() + String.format(" (%.2f%%)", stats.getPercentage(stats.getIronOresMined())));
        sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "  Ancient Debris: " + stats.getAncientDebrisMined() + String.format(" (%.2f%%)", stats.getPercentage(stats.getAncientDebrisMined())));
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Suspicion Score: " + String.format("%.1f/100", stats.getSuspicionScore()));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Surveillance Status: " + String.valueOf(ChatColor.WHITE) + String.valueOf((Object)stats.getSurveillanceStatus()));
        if (stats.getSurveillanceStatus() != PlayerStats.SurveillanceStatus.NONE) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Reason: " + stats.getSurveillanceReason());
            if (stats.getSurveillanceStartDate() != null) {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Since: " + stats.getSurveillanceStartDate().format(DATE_FORMAT));
            }
        }
        List<Alert> alerts = this.plugin.getAlertManager().getAlertsForPlayer(target.getUniqueId());
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Total Alerts: " + alerts.size());
        double avgDiamond = this.plugin.getAllStats().stream().mapToDouble(s -> s.getPercentage(s.getDiamondOresMined())).average().orElse(0.0);
        double avgEmerald = this.plugin.getAllStats().stream().mapToDouble(s -> s.getPercentage(s.getEmeraldOresMined())).average().orElse(0.0);
        sender.sendMessage("");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Server Average Comparison:");
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Diamond: " + String.format("%.2f%% (avg: %.2f%%)", stats.getPercentage(stats.getDiamondOresMined()), avgDiamond));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  Emerald: " + String.format("%.2f%% (avg: %.2f%%)", stats.getPercentage(stats.getEmeraldOresMined()), avgEmerald));
    }

    private void handleSurveillance(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tlad surveillance <player> <watch|clear> [reason]");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        PlayerStats stats = this.plugin.getStats(target.getUniqueId());
        String action = args[2].toLowerCase();
        if (action.equals("watch")) {
            String reason = args.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : "Manual surveillance by admin";
            stats.setSurveillanceStatus(PlayerStats.SurveillanceStatus.UNDER_SURVEILLANCE, reason);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " is now under surveillance.");
        } else if (action.equals("clear")) {
            stats.setSurveillanceStatus(PlayerStats.SurveillanceStatus.CLEARED, "Cleared by admin");
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been cleared.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid action. Use 'watch' or 'clear'.");
        }
    }

    private void handleAlerts(CommandSender sender, String[] args) {
        List<Alert> alertsToShow;
        if (args.length > 1) {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
            alertsToShow = this.plugin.getAlertManager().getAlertsForPlayer(target.getUniqueId());
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "=== Alerts for " + target.getName() + " ===");
        } else {
            alertsToShow = this.plugin.getAlertManager().getPendingAlerts();
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "=== Pending Alerts ===");
        }
        if (alertsToShow.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No alerts found.");
            return;
        }
        int count = 0;
        for (Alert alert : alertsToShow) {
            if (count++ >= 10) {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "... and " + (alertsToShow.size() - 10) + " more");
                break;
            }
            String status = alert.getStatus() == Alert.AlertStatus.PENDING ? String.valueOf(ChatColor.RED) + "[PENDING]" : String.valueOf(ChatColor.GREEN) + "[" + String.valueOf((Object)alert.getStatus()) + "]";
            sender.sendMessage(status + String.valueOf(ChatColor.YELLOW) + " " + alert.getPlayerName() + String.valueOf(ChatColor.WHITE) + " - " + alert.getReason());
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Time: " + alert.getTimestamp().format(DATE_FORMAT));
        }
    }

    private void handleFreeze(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tlad freeze <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found or not online.");
            return;
        }
        if (target.getWalkSpeed() == 0.0f) {
            target.setWalkSpeed(0.2f);
            target.setFlySpeed(0.1f);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been unfrozen.");
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been unfrozen.");
        } else {
            target.setWalkSpeed(0.0f);
            target.setFlySpeed(0.0f);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been frozen.");
            target.sendMessage(String.valueOf(ChatColor.RED) + "You have been frozen by an administrator for investigation.");
        }
    }

    private void handleExport(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tlad export <player> <csv|json>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        String format = args[2].toLowerCase();
        if (!format.equals("csv") && !format.equals("json")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid format. Use 'csv' or 'json'.");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Export functionality is configured in config.yml");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Player: " + target.getName() + ", Format: " + format);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Stats would be exported to: plugins/Topluck/exports/");
    }
}

