/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.command;

import fr.jachou.topluck.Topluck;
import fr.jachou.topluck.data.PlayerStats;
import fr.jachou.topluck.menu.StatsMenu;
import java.util.Comparator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TopLuckCommand
implements CommandExecutor {
    private final Topluck plugin;

    public TopLuckCommand(Topluck plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                new StatsMenu(this.plugin).open(player);
            } else {
                this.showTop(sender);
            }
        } else {
            this.showPlayer(sender, args[0]);
        }
        return true;
    }

    private void showTop(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "-- Top Luck --");
        this.plugin.getAllStats().stream().sorted(Comparator.comparingInt(PlayerStats::getRareOresMined).reversed()).limit(10L).forEach(stats -> {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)stats.getUuid());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + String.valueOf(ChatColor.WHITE) + ": " + stats.getRareOresMined());
        });
    }

    private void showPlayer(CommandSender sender, String name) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)name);
        PlayerStats stats = this.plugin.getStats(target.getUniqueId());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Stats for " + target.getName());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total blocks mined: " + stats.getTotalBlocksMined());
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Diamonds: " + stats.getDiamondOresMined() + this.format(stats.getDiamondOresMined(), stats));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Emeralds: " + stats.getEmeraldOresMined() + this.format(stats.getEmeraldOresMined(), stats));
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Gold: " + stats.getGoldOresMined() + this.format(stats.getGoldOresMined(), stats));
        sender.sendMessage(String.valueOf(ChatColor.WHITE) + "Iron: " + stats.getIronOresMined() + this.format(stats.getIronOresMined(), stats));
        sender.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Ancient Debris: " + stats.getAncientDebrisMined() + this.format(stats.getAncientDebrisMined(), stats));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Rare ores mined: " + stats.getRareOresMined());
        sender.sendMessage("");
        double suspicion = stats.getSuspicionScore();
        ChatColor suspicionColor = suspicion > 50.0 ? ChatColor.RED : (suspicion > 20.0 ? ChatColor.YELLOW : ChatColor.GREEN);
        sender.sendMessage(String.valueOf(suspicionColor) + "Suspicion Score: " + String.format("%.1f/100", suspicion));
        if (stats.getSurveillanceStatus() != PlayerStats.SurveillanceStatus.NONE) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Surveillance: " + String.valueOf((Object)stats.getSurveillanceStatus()));
        }
    }

    private String format(int count, PlayerStats stats) {
        return String.format(" (%.2f%%)", stats.getPercentage(count));
    }
}

