/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.data;

import java.time.LocalDateTime;
import java.util.UUID;
import org.bukkit.Location;

public class Alert {
    private final UUID alertId = UUID.randomUUID();
    private final UUID playerUuid;
    private final String playerName;
    private final AlertType type;
    private final String reason;
    private final double percentage;
    private final LocalDateTime timestamp;
    private final Location location;
    private String handledBy;
    private LocalDateTime handledAt;
    private AlertStatus status;

    public Alert(UUID playerUuid, String playerName, AlertType type, String reason, double percentage, Location location) {
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.type = type;
        this.reason = reason;
        this.percentage = percentage;
        this.timestamp = LocalDateTime.now();
        this.location = location;
        this.status = AlertStatus.PENDING;
    }

    public UUID getAlertId() {
        return this.alertId;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public AlertType getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getHandledBy() {
        return this.handledBy;
    }

    public LocalDateTime getHandledAt() {
        return this.handledAt;
    }

    public AlertStatus getStatus() {
        return this.status;
    }

    public void markAsHandled(String adminName) {
        this.handledBy = adminName;
        this.handledAt = LocalDateTime.now();
        this.status = AlertStatus.HANDLED;
    }

    public void dismiss() {
        this.status = AlertStatus.DISMISSED;
    }

    public static enum AlertType {
        DIAMOND_THRESHOLD,
        EMERALD_THRESHOLD,
        ANCIENT_DEBRIS_THRESHOLD,
        RARE_COMBINED_THRESHOLD,
        SUSPICIOUS_LOCATION,
        SPIKE_DETECTION;

    }

    public static enum AlertStatus {
        PENDING,
        HANDLED,
        DISMISSED;

    }
}

