/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.data;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;

public class PlayerStats {
    private final UUID uuid;
    private int totalBlocksMined;
    private int diamondOresMined;
    private int emeraldOresMined;
    private int goldOresMined;
    private int ironOresMined;
    private int rareOresMined;
    private int ancientDebrisMined;
    private SurveillanceStatus surveillanceStatus;
    private String surveillanceReason;
    private LocalDateTime surveillanceStartDate;
    private final List<MiningEvent> miningHistory;

    public PlayerStats(UUID uuid) {
        this.uuid = uuid;
        this.surveillanceStatus = SurveillanceStatus.NONE;
        this.miningHistory = new ArrayList<MiningEvent>();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getTotalBlocksMined() {
        return this.totalBlocksMined;
    }

    public int getDiamondOresMined() {
        return this.diamondOresMined;
    }

    public int getEmeraldOresMined() {
        return this.emeraldOresMined;
    }

    public int getGoldOresMined() {
        return this.goldOresMined;
    }

    public int getIronOresMined() {
        return this.ironOresMined;
    }

    public int getAncientDebrisMined() {
        return this.ancientDebrisMined;
    }

    public void incrementBlock(Material type, Location location) {
        ++this.totalBlocksMined;
        switch (type) {
            case DIAMOND_ORE: 
            case DEEPSLATE_DIAMOND_ORE: {
                ++this.diamondOresMined;
                ++this.rareOresMined;
                this.miningHistory.add(new MiningEvent(type, location, LocalDateTime.now()));
                break;
            }
            case EMERALD_ORE: {
                ++this.emeraldOresMined;
                ++this.rareOresMined;
                this.miningHistory.add(new MiningEvent(type, location, LocalDateTime.now()));
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case NETHER_GOLD_ORE: {
                ++this.goldOresMined;
                break;
            }
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                ++this.ironOresMined;
                break;
            }
            case ANCIENT_DEBRIS: {
                ++this.ancientDebrisMined;
                ++this.rareOresMined;
                this.miningHistory.add(new MiningEvent(type, location, LocalDateTime.now()));
                break;
            }
        }
    }

    public double getPercentage(int count) {
        if (this.totalBlocksMined == 0) {
            return 0.0;
        }
        return (double)count * 100.0 / (double)this.totalBlocksMined;
    }

    public int getRareOresMined() {
        return this.rareOresMined;
    }

    public void incrementRareOre() {
        ++this.rareOresMined;
    }

    public SurveillanceStatus getSurveillanceStatus() {
        return this.surveillanceStatus;
    }

    public void setSurveillanceStatus(SurveillanceStatus status, String reason) {
        this.surveillanceStatus = status;
        this.surveillanceReason = reason;
        this.surveillanceStartDate = status != SurveillanceStatus.NONE ? LocalDateTime.now() : null;
    }

    public String getSurveillanceReason() {
        return this.surveillanceReason;
    }

    public LocalDateTime getSurveillanceStartDate() {
        return this.surveillanceStartDate;
    }

    public List<MiningEvent> getMiningHistory() {
        return new ArrayList<MiningEvent>(this.miningHistory);
    }

    public double getSuspicionScore() {
        if (this.totalBlocksMined < 100) {
            return 0.0;
        }
        double score = 0.0;
        double diamondPct = this.getPercentage(this.diamondOresMined);
        double emeraldPct = this.getPercentage(this.emeraldOresMined);
        double debrisPct = this.getPercentage(this.ancientDebrisMined);
        if (diamondPct > 1.0) {
            score += (diamondPct - 1.0) * 10.0;
        }
        if (emeraldPct > 0.5) {
            score += (emeraldPct - 0.5) * 15.0;
        }
        if (debrisPct > 0.5) {
            score += (debrisPct - 0.5) * 12.0;
        }
        return Math.min(100.0, score);
    }

    public static enum SurveillanceStatus {
        NONE,
        UNDER_SURVEILLANCE,
        CLEARED;

    }

    public static class MiningEvent {
        private final Material material;
        private final Location location;
        private final LocalDateTime timestamp;

        public MiningEvent(Material material, Location location, LocalDateTime timestamp) {
            this.material = material;
            this.location = location;
            this.timestamp = timestamp;
        }

        public Material getMaterial() {
            return this.material;
        }

        public Location getLocation() {
            return this.location;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }
    }
}

