/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.manager;

import fr.jachou.topluck.Topluck;
import fr.jachou.topluck.data.Alert;
import fr.jachou.topluck.data.PlayerStats;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class AlertManager {
    private final Topluck plugin;
    private final List<Alert> alerts;
    private final File alertLogFile;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public AlertManager(Topluck plugin) {
        File alertDir;
        this.plugin = plugin;
        this.alerts = new ArrayList<Alert>();
        File dataFolder = plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!(alertDir = new File(dataFolder, "alerts")).exists()) {
            alertDir.mkdirs();
        }
        this.alertLogFile = new File(alertDir, "alerts.log");
    }

    public void checkAndCreateAlerts(Player player, PlayerStats stats, Location location) {
        if (!this.plugin.getConfig().getBoolean("alerts.enabled", true)) {
            return;
        }
        int minBlocks = this.plugin.getConfig().getInt("minimum-blocks", 100);
        if (stats.getTotalBlocksMined() < minBlocks) {
            return;
        }
        double diamondThreshold = this.plugin.getConfig().getDouble("thresholds.diamond", 5.0);
        double emeraldThreshold = this.plugin.getConfig().getDouble("thresholds.emerald", 3.0);
        double debrisThreshold = this.plugin.getConfig().getDouble("thresholds.ancient_debris", 2.0);
        double rareCombinedThreshold = this.plugin.getConfig().getDouble("thresholds.rare_combined", 8.0);
        double diamondPct = stats.getPercentage(stats.getDiamondOresMined());
        double emeraldPct = stats.getPercentage(stats.getEmeraldOresMined());
        double debrisPct = stats.getPercentage(stats.getAncientDebrisMined());
        double rarePct = stats.getPercentage(stats.getRareOresMined());
        if (diamondPct > diamondThreshold) {
            this.createAlert(player.getUniqueId(), player.getName(), Alert.AlertType.DIAMOND_THRESHOLD, "Diamond mining percentage (" + String.format("%.2f", diamondPct) + "%) exceeds threshold", diamondPct, location);
        }
        if (emeraldPct > emeraldThreshold) {
            this.createAlert(player.getUniqueId(), player.getName(), Alert.AlertType.EMERALD_THRESHOLD, "Emerald mining percentage (" + String.format("%.2f", emeraldPct) + "%) exceeds threshold", emeraldPct, location);
        }
        if (debrisPct > debrisThreshold) {
            this.createAlert(player.getUniqueId(), player.getName(), Alert.AlertType.ANCIENT_DEBRIS_THRESHOLD, "Ancient Debris mining percentage (" + String.format("%.2f", debrisPct) + "%) exceeds threshold", debrisPct, location);
        }
        if (rarePct > rareCombinedThreshold) {
            this.createAlert(player.getUniqueId(), player.getName(), Alert.AlertType.RARE_COMBINED_THRESHOLD, "Combined rare ore percentage (" + String.format("%.2f", rarePct) + "%) exceeds threshold", rarePct, location);
        }
    }

    public void createAlert(UUID playerUuid, String playerName, Alert.AlertType type, String reason, double percentage, Location location) {
        Alert alert = new Alert(playerUuid, playerName, type, reason, percentage, location);
        this.alerts.add(alert);
        if (this.plugin.getConfig().getBoolean("alerts.log-to-file", true)) {
            this.logAlertToFile(alert);
        }
        if (this.plugin.getConfig().getBoolean("alerts.notify-admins", true)) {
            this.notifyAdmins(alert);
        }
    }

    private void logAlertToFile(Alert alert) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.alertLogFile, true));){
            String logEntry = String.format("[%s] ALERT - Player: %s, Type: %s, Reason: %s, Percentage: %.2f%%, Location: %s%n", new Object[]{alert.getTimestamp().format(DATE_FORMAT), alert.getPlayerName(), alert.getType(), alert.getReason(), alert.getPercentage(), this.formatLocation(alert.getLocation())});
            writer.write(logEntry);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to write alert to log file: " + e.getMessage());
        }
    }

    private void notifyAdmins(Alert alert) {
        String message = String.valueOf(ChatColor.RED) + "[ALERT] " + String.valueOf(ChatColor.YELLOW) + alert.getPlayerName() + String.valueOf(ChatColor.WHITE) + " - " + alert.getReason();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("topluck.alerts")) continue;
            player.sendMessage(message);
        }
    }

    private String formatLocation(Location loc) {
        if (loc == null) {
            return "Unknown";
        }
        return String.format("%s (%.1f, %.1f, %.1f)", loc.getWorld() != null ? loc.getWorld().getName() : "Unknown", loc.getX(), loc.getY(), loc.getZ());
    }

    public List<Alert> getAlerts() {
        return new ArrayList<Alert>(this.alerts);
    }

    public List<Alert> getAlertsForPlayer(UUID playerUuid) {
        return this.alerts.stream().filter(a -> a.getPlayerUuid().equals(playerUuid)).collect(Collectors.toList());
    }

    public List<Alert> getPendingAlerts() {
        return this.alerts.stream().filter(a -> a.getStatus() == Alert.AlertStatus.PENDING).collect(Collectors.toList());
    }

    public void handleAlert(UUID alertId, String adminName) {
        this.alerts.stream().filter(a -> a.getAlertId().equals(alertId)).findFirst().ifPresent(alert -> alert.markAsHandled(adminName));
    }

    public void dismissAlert(UUID alertId) {
        this.alerts.stream().filter(a -> a.getAlertId().equals(alertId)).findFirst().ifPresent(Alert::dismiss);
    }
}

