/*
 * Decompiled with CFR 0.152.
 */
package fr.jachou.topluck.menu;

import fr.jachou.topluck.Topluck;
import fr.jachou.topluck.data.PlayerStats;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class StatsMenu {
    private final Topluck plugin;

    public StatsMenu(Topluck plugin) {
        this.plugin = plugin;
    }

    public void open(Player viewer) {
        Collection players = Bukkit.getOnlinePlayers();
        int size = Math.max(9, ((players.size() - 1) / 9 + 1) * 9);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.DARK_GREEN) + "TopLuck Stats"));
        int index = 0;
        for (Player p : players) {
            PlayerStats stats = this.plugin.getStats(p.getUniqueId());
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer((OfflinePlayer)p);
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + p.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "Total mined: " + stats.getTotalBlocksMined());
                lore.add(String.valueOf(ChatColor.AQUA) + "Diamonds: " + stats.getDiamondOresMined() + this.formatPercent(stats.getDiamondOresMined(), stats));
                lore.add(String.valueOf(ChatColor.GREEN) + "Emeralds: " + stats.getEmeraldOresMined() + this.formatPercent(stats.getEmeraldOresMined(), stats));
                lore.add(String.valueOf(ChatColor.GOLD) + "Gold: " + stats.getGoldOresMined() + this.formatPercent(stats.getGoldOresMined(), stats));
                lore.add(String.valueOf(ChatColor.WHITE) + "Iron: " + stats.getIronOresMined() + this.formatPercent(stats.getIronOresMined(), stats));
                lore.add(String.valueOf(ChatColor.DARK_PURPLE) + "Ancient Debris: " + stats.getAncientDebrisMined() + this.formatPercent(stats.getAncientDebrisMined(), stats));
                lore.add("");
                double suspicion = stats.getSuspicionScore();
                ChatColor suspicionColor = suspicion > 50.0 ? ChatColor.RED : (suspicion > 20.0 ? ChatColor.YELLOW : ChatColor.GREEN);
                lore.add(String.valueOf(suspicionColor) + "Suspicion: " + String.format("%.1f/100", suspicion));
                if (stats.getSurveillanceStatus() != PlayerStats.SurveillanceStatus.NONE) {
                    lore.add(String.valueOf(ChatColor.RED) + "Status: " + String.valueOf((Object)stats.getSurveillanceStatus()));
                }
                meta.setLore(lore);
                head.setItemMeta((ItemMeta)meta);
            }
            inv.setItem(index++, head);
        }
        viewer.openInventory(inv);
    }

    private String formatPercent(int count, PlayerStats stats) {
        double pct = stats.getPercentage(count);
        ChatColor color = ChatColor.WHITE;
        if (pct > 5.0) {
            color = ChatColor.RED;
        } else if (pct > 2.0) {
            color = ChatColor.YELLOW;
        }
        return String.valueOf(color) + String.format(" (%.2f%%)", pct);
    }
}

