/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.personal_mana;

import io.yukkuric.hexop.personal_mana.PersonalManaHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;

public class PersonalManaEvents {
    private static final List<Consumer<EventBody>> onInsert = new ArrayList<Consumer<EventBody>>();
    private static final List<Consumer<EventBody>> onExtract = new ArrayList<Consumer<EventBody>>();

    public static void resetAll() {
        onInsert.clear();
        onExtract.clear();
    }

    static void OnInsert(EventBody event) {
        for (Consumer<EventBody> callback : onInsert) {
            callback.accept(event);
        }
    }

    static void OnExtract(EventBody event) {
        for (Consumer<EventBody> callback : onExtract) {
            callback.accept(event);
        }
    }

    public static void AddOnInsert(Consumer<EventBody> callback) {
        onInsert.add(callback);
    }

    public static void AddOnExtract(Consumer<EventBody> callback) {
        onExtract.add(callback);
    }

    public static class EventBody {
        public final PersonalManaHolder holder;
        public final class_1657 player;
        public final long target;
        public final long actual;

        public EventBody(PersonalManaHolder holder, long target, long actual) {
            this.holder = holder;
            this.player = holder.getPlayer();
            this.target = target;
            this.actual = actual;
        }

        public long getDropped() {
            return this.target - this.actual;
        }

        public String toString() {
            return "[p=%s,t=%s,a=%s]".formatted(this.player.method_5476().getString(), this.target, this.actual);
        }
    }
}

