/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.personal_mana;

import io.yukkuric.hexop.personal_mana.PersonalManaHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;

public class PersonalManaEvents {
    private static final List<Consumer<EventBody>> onInsert = new ArrayList<Consumer<EventBody>>();
    private static final List<Consumer<EventBody>> onExtract = new ArrayList<Consumer<EventBody>>();

    public static void resetAll() {
        onInsert.clear();
        onExtract.clear();
    }

    static void OnInsert(EventBody event) {
        for (Consumer<EventBody> callback : onInsert) {
            callback.accept(event);
        }
    }

    static void OnExtract(EventBody event) {
        for (Consumer<EventBody> callback : onExtract) {
            callback.accept(event);
        }
    }

    public static void AddOnInsert(Consumer<EventBody> callback) {
        onInsert.add(callback);
    }

    public static void AddOnExtract(Consumer<EventBody> callback) {
        onExtract.add(callback);
    }

    public static class EventBody {
        public final Player player;
        public final PersonalManaHolder holder;
        public final int target;
        public final int actual;

        public EventBody(PersonalManaHolder holder, int target, int actual) {
            this.holder = holder;
            this.player = holder.getPlayer();
            this.target = target;
            this.actual = actual;
        }

        public long getDropped() {
            return this.target - this.actual;
        }

        public String toString() {
            return "[p=%s,t=%s,a=%s]".formatted(this.player.m_5446_().getString(), this.target, this.actual);
        }
    }
}

