/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.mixin.personal_mana;

import com.mojang.authlib.GameProfile;
import io.yukkuric.hexop.HexOPConfig;
import io.yukkuric.hexop.HexOverpowered;
import io.yukkuric.hexop.personal_mana.PersonalManaHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinManaRegen
extends Player {
    private final boolean isSelfFake = HexOverpowered.IsFakePlayer(this);

    public MixinManaRegen(Level level, BlockPos blockPos, float f, GameProfile gameProfile, @Nullable ProfilePublicKey profilePublicKey) {
        super(level, blockPos, f, gameProfile, profilePublicKey);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void regenTick(CallbackInfo ci) {
        if (!PersonalManaHolder.enablesManaForPlayer(this)) {
            return;
        }
        if (this.isSelfFake && HexOPConfig.FakePlayerDontRegenMedia()) {
            return;
        }
        int checkStep = Math.max(1, HexOPConfig.PersonalMediaRegenInterval());
        if (!HexOPConfig.EnablesPersonalMediaPool() || this.f_19797_ % checkStep > 0) {
            return;
        }
        PersonalManaHolder holder = PersonalManaHolder.get(this);
        holder.insertMedia(holder.getMediaRegenStep(), false);
    }
}

