/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.forge.mekanism;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import io.yukkuric.hexop.forge.HexOPConfigForge;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.StorageUtils;
import net.minecraft.world.item.ItemStack;

public class MekasuitMediaHolder
implements ADMediaHolder {
    final IEnergyContainer source;

    public MekasuitMediaHolder(ItemStack target) {
        this.source = StorageUtils.getEnergyContainer((ItemStack)target, (int)0);
    }

    long Joule2Media(FloatingLong raw) {
        FloatingLong FE = raw.multiply(0.4);
        return FE.multiply(HexOPConfigForge.MekasuitConversionRatio()).longValue();
    }

    public long getMedia() {
        return this.Joule2Media(this.source.getEnergy());
    }

    public long getMaxMedia() {
        return this.Joule2Media(this.source.getMaxEnergy());
    }

    public void setMedia(long newVal) {
        double rate = HexOPConfigForge.MekasuitConversionRatio();
        if (rate <= 0.0) {
            return;
        }
        newVal = Math.max(0L, newVal);
        FloatingLong FE = FloatingLong.create((double)((double)newVal / rate));
        this.source.setEnergy(FE.multiply(2.5));
    }

    public boolean canRecharge() {
        return false;
    }

    public boolean canProvide() {
        return HexOPConfigForge.MekasuitConversionRatio() > 0.0;
    }

    public int getConsumptionPriority() {
        return 3999;
    }

    public boolean canConstructBattery() {
        return false;
    }
}

