/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.forge.mekanism;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.text.DecimalFormat;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class MekTooltip {
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");
    private static final DecimalFormat DUST_AMOUNT = new DecimalFormat("###,###.##");

    public static void handleMekasuitTooltip(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (!(stack.m_41720_() instanceof ItemMekaSuitArmor)) {
            return;
        }
        ADMediaHolder mediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(stack);
        if (mediaHolder == null) {
            return;
        }
        long maxMedia = mediaHolder.getMaxMedia();
        if (maxMedia > 0L) {
            long media = mediaHolder.getMedia();
            float fullness = (float)media / (float)maxMedia;
            TextColor color = TextColor.m_131266_((int)MediaHelper.mediaBarColor((long)media, (long)maxMedia));
            MutableComponent mediamount = Component.m_237113_((String)DUST_AMOUNT.format((float)media / 10000.0f));
            MutableComponent percentFull = Component.m_237113_((String)(PERCENTAGE.format(100.0f * fullness) + "%"));
            MutableComponent maxCapacity = Component.m_237110_((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format((float)maxMedia / 10000.0f)});
            mediamount.m_130938_(style -> style.m_131148_(ItemMediaHolder.HEX_COLOR));
            maxCapacity.m_130938_(style -> style.m_131148_(ItemMediaHolder.HEX_COLOR));
            percentFull.m_130938_(style -> style.m_131148_(color));
            e.getToolTip().add(Component.m_237110_((String)"hexcasting.tooltip.media_amount.advanced", (Object[])new Object[]{mediamount, maxCapacity, percentFull}));
        }
    }
}

