/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.hexal;

import io.yukkuric.hexop.HexOPConfig;
import io.yukkuric.hexop.hexal.MoteChestContainer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.mediafieditems.ItemRecord;
import ram.talia.hexal.common.blocks.entity.BlockEntityMediafiedStorage;

public class CachedNexusInventory
implements AutoCloseable {
    protected final BlockEntityMediafiedStorage source;
    protected Map<Integer, ItemRecord> srcMap;
    static final Field fIdx;
    protected final int maxTypes;
    protected int cachedCurIdx = -1;
    protected List<Integer> cachedKeys = List.of();
    protected int emptyCounter = 0;
    boolean oldEmpty;

    public CachedNexusInventory(BlockEntityMediafiedStorage be) {
        this.source = be;
        this.maxTypes = HexalConfig.getServer().getMaxRecordsInMediafiedStorage();
    }

    protected int getIdx() {
        try {
            return (Integer)fIdx.get(this.source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void doForceRefresh() {
        this.cachedCurIdx = -1;
        this.refreshCache();
        this.source.sync();
    }

    public void refreshCache() {
        int newIdx;
        if (this.srcMap == null) {
            this.srcMap = this.source.getStoredItems();
        }
        if ((newIdx = this.getIdx()) == this.cachedCurIdx) {
            return;
        }
        this.cachedCurIdx = newIdx;
        this.cachedKeys = this.srcMap.keySet().stream().toList();
        this.emptyCounter = 0;
    }

    protected ItemRecord get(int slot) {
        this.refreshCache();
        if (slot >= this.cachedKeys.size()) {
            return null;
        }
        Integer idx = this.cachedKeys.get(slot);
        return this.srcMap.getOrDefault(idx, null);
    }

    protected class_1799 makeItem(ItemRecord record) {
        return record.toStack((int)record.getCount());
    }

    protected boolean matches(ItemRecord record, class_1799 stack) {
        if (record.getItem() != stack.method_7909()) {
            return false;
        }
        class_2487 tag = record.getTag();
        class_2487 newTag = stack.method_7969();
        if (tag == null) {
            return newTag == null;
        }
        return tag.equals((Object)newTag);
    }

    protected CachedNexusInventory checkEmptyChange() {
        this.oldEmpty = this.isEmpty();
        return this;
    }

    @Override
    public void close() {
        if (this.oldEmpty != this.isEmpty()) {
            this.source.sync();
        }
        if (this.shouldFlushForContainer()) {
            this.doForceRefresh();
        }
    }

    public int getSlots() {
        this.refreshCache();
        return Math.min(1 + this.cachedKeys.size(), this.maxTypes);
    }

    @NotNull
    public class_1799 getStackInSlot(int slot) {
        if (slot >= this.maxTypes) {
            return class_1799.field_8037;
        }
        ItemRecord record = this.get(slot);
        if (record == null) {
            return class_1799.field_8037;
        }
        return this.makeItem(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        if (slot >= this.maxTypes || stack.method_7960() || !HexOPConfig.EnablesMoteItemHandler()) {
            return stack;
        }
        ItemRecord record = this.get(slot);
        if (record == null) {
            if (!simulate) {
                try (CachedNexusInventory self = this.checkEmptyChange();){
                    Map<Integer, ItemRecord> map = this.srcMap;
                    synchronized (map) {
                        if (slot < this.cachedKeys.size()) {
                            this.srcMap.put(this.cachedKeys.get(slot), new ItemRecord(stack));
                            if (slot < 54) {
                                --this.emptyCounter;
                            }
                        } else {
                            this.source.assignItem(new ItemRecord(stack));
                        }
                    }
                }
            }
            return class_1799.field_8037;
        }
        if (!this.matches(record, stack)) {
            return stack;
        }
        if (!simulate) {
            record.addCount((long)stack.method_7947());
        }
        return class_1799.field_8037;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public class_1799 extractItem(int slot, int count, boolean simulate) {
        if (slot >= this.maxTypes || !HexOPConfig.EnablesMoteItemHandler()) {
            return class_1799.field_8037;
        }
        ItemRecord record = this.get(slot);
        if (record == null) {
            return class_1799.field_8037;
        }
        if ((count = (int)Math.min((long)count, record.getCount())) <= 0) {
            return class_1799.field_8037;
        }
        class_1799 item = this.makeItem(record);
        item.method_7939(count);
        if (!simulate) {
            record.addCount((long)(-count));
            if (record.getCount() <= 0L) {
                try (CachedNexusInventory self = this.checkEmptyChange();){
                    Map<Integer, ItemRecord> map = this.srcMap;
                    synchronized (map) {
                        this.srcMap.remove(this.cachedKeys.get(slot));
                        if (slot < 54) {
                            ++this.emptyCounter;
                        }
                    }
                }
            }
        }
        return item;
    }

    public int getSlotLimit(int slot) {
        if (slot >= this.maxTypes) {
            return 0;
        }
        ItemRecord record = this.get(slot);
        if (record == null) {
            return 64;
        }
        return (int)Math.min(Integer.MAX_VALUE, record.getCount() + 64L);
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        if (slot >= this.maxTypes || !HexOPConfig.EnablesMoteItemHandler()) {
            return false;
        }
        ItemRecord record = this.get(slot);
        return record == null || this.matches(record, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        if (slot >= this.maxTypes || !HexOPConfig.EnablesMoteItemHandler()) {
            return;
        }
        this.refreshCache();
        Map<Integer, ItemRecord> map = this.srcMap;
        synchronized (map) {
            if (stack.method_7960()) {
                if (slot < this.cachedKeys.size()) {
                    this.srcMap.remove(this.cachedKeys.get(slot));
                }
            } else {
                ItemRecord replace = new ItemRecord(stack);
                if (slot >= this.cachedKeys.size()) {
                    this.source.assignItem(replace);
                } else {
                    this.srcMap.put(this.cachedKeys.get(slot), replace);
                }
            }
        }
    }

    public void clearContent() {
        if (!HexOPConfig.EnablesMoteItemHandler()) {
            return;
        }
        try (CachedNexusInventory self = this.checkEmptyChange();){
            this.srcMap.clear();
        }
    }

    public boolean isEmpty() {
        return this.srcMap.isEmpty();
    }

    public boolean isFull() {
        return this.srcMap.size() >= this.maxTypes;
    }

    public boolean shouldFlushForContainer() {
        return this.emptyCounter >= 45 && this.cachedKeys.size() > 54;
    }

    static {
        try {
            fIdx = BlockEntityMediafiedStorage.class.getDeclaredField("currentItemIndex");
            fIdx.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Control {
        public CachedNexusInventory getAPI();

        public MoteChestContainer wrapForChest();
    }
}

