/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hexop.mixin.circle;

import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapNotEnoughMedia;
import at.petrak.hexcasting.api.casting.mishaps.circle.MishapNoSpellCircle;
import com.mojang.datafixers.util.Pair;
import io.yukkuric.hexop.HexOPConfig;
import java.util.EnumSet;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BuddingAmethystBlock.class})
public class AmethystCircle
extends Block
implements ICircleComponent {
    private static LegacyRandomSource BUDDING_CHARGER = new LegacyRandomSource(114514L){
        private int cnt = 0;

        public int m_188503_(int i) {
            if (i == 5) {
                return 0;
            }
            this.cnt = (this.cnt + 1) % i;
            return this.cnt;
        }
    };

    public AmethystCircle(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ICircleComponent.ControlFlow acceptControlFlow(CastingImage imageIn, CircleCastEnv env, Direction enterDir, BlockPos pos, BlockState state, ServerLevel world) {
        int fullLevel;
        if (!state.m_60713_(Blocks.f_152491_)) {
            this.fakeThrowMishap(pos, state, imageIn, env, (Mishap)new MishapNoSpellCircle());
            return new ICircleComponent.ControlFlow.Stop();
        }
        int singleCost = HexOPConfig.AmethystCircleSingleChargeCost();
        int maxCost = singleCost * (fullLevel = HexOPConfig.AmethystCircleFullPowerLevel());
        int growthStrength = maxCost <= 0 ? fullLevel : (int)Math.floor((float)((long)maxCost - env.extractMedia((long)maxCost, true)) / (float)singleCost);
        if (growthStrength < 1) {
            world.m_46597_(pos, Blocks.f_152490_.m_49966_());
            this.fakeThrowMishap(pos, state, imageIn, env, (Mishap)new MishapNotEnoughMedia((long)singleCost));
            return new ICircleComponent.ControlFlow.Stop();
        }
        env.extractMedia((long)singleCost, false);
        for (int i = 0; i < growthStrength; ++i) {
            Blocks.f_152491_.m_213898_(state, world, pos, (RandomSource)BUDDING_CHARGER);
        }
        EnumSet<Direction> exitDirsSet = this.possibleExitDirections(pos, state, (Level)world);
        exitDirsSet.remove(enterDir.m_122424_());
        Stream<Pair> exitDirs = exitDirsSet.stream().map(dir -> this.exitPositionFromDirection(pos, (Direction)dir));
        return new ICircleComponent.ControlFlow.Continue(imageIn, exitDirs.toList());
    }

    public boolean canEnterFromDirection(Direction direction, BlockPos blockPos, BlockState blockState, ServerLevel serverLevel) {
        return HexOPConfig.EnablesAmethystCircle() && blockState.m_60713_(Blocks.f_152491_);
    }

    public EnumSet<Direction> possibleExitDirections(BlockPos blockPos, BlockState blockState, Level level) {
        return EnumSet.allOf(Direction.class);
    }

    public BlockState startEnergized(BlockPos blockPos, BlockState blockState, Level level) {
        return blockState;
    }

    public boolean isEnergized(BlockPos blockPos, BlockState blockState, Level level) {
        return false;
    }

    public BlockState endEnergized(BlockPos blockPos, BlockState blockState, Level level) {
        return blockState;
    }
}

