/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.amarong.common.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import survivalblock.amarong.common.Amarong;
import survivalblock.amarong.common.component.BoomerangComponent;
import survivalblock.amarong.common.init.AmarongDamageTypes;
import survivalblock.amarong.common.init.AmarongEntityComponents;
import survivalblock.amarong.common.init.AmarongEntityTypes;
import survivalblock.amarong.common.init.AmarongItems;
import survivalblock.amarong.mixin.boomerang.ProjectileEntityAccessor;

public class PhasingBoomerangEntity
extends class_1665 {
    public static final double VELOCITY_MULTIPLIER = 0.95;
    public static final int MAX_AGE = 120;
    public static final int HALF_MAX_AGE = 60;
    public static final String INFINITY_KEY = "amarongBoomerangInfinity";
    public static final String SLOT_KEY = "shotFromInventorySlot";
    private int slot = 0;
    private boolean infinity;
    private final Set<Integer> hitEntities = new HashSet<Integer>();

    public PhasingBoomerangEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public PhasingBoomerangEntity(class_1309 owner, class_1937 world, class_1799 stack, int slot) {
        super(AmarongEntityTypes.BOOMERANG, owner, world, stack, stack.method_7972());
        this.slot = slot;
        this.getBoomerangComponent().setEnchanted(stack.method_7958());
    }

    public BoomerangComponent getBoomerangComponent() {
        return (BoomerangComponent)AmarongEntityComponents.BOOMERANG_COMPONENT.get((Object)this);
    }

    public boolean isReturning() {
        return this.getBoomerangComponent().isReturning();
    }

    public void setInfinity(boolean infinity) {
        this.infinity = infinity;
    }

    protected class_1799 method_57314() {
        return AmarongItems.AMARONG_BOOMERANG.method_7854();
    }

    public void method_5773() {
        this.hitEntities.clear();
        super.method_5773();
        this.method_7433(true);
        this.method_36456(this.field_6012);
        class_1937 world = this.method_37908();
        if (!world.method_8608()) {
            if (this.field_6012 > 120) {
                if (!this.isReturning() || !this.isOwnerAlive() || this.method_5739(this.method_24921()) > 32.0f) {
                    this.dropAndDiscard();
                }
            } else if (this.field_6012 > 60) {
                this.getBoomerangComponent().setReturning(true);
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                ArrayList entities = new ArrayList();
                serverWorld.atmospheric_api$getAndAddEntitiesToCollection(entity -> entity.method_5829().method_994(this.method_5829()), entities);
                if (!entities.isEmpty()) {
                    for (class_1297 entity2 : entities) {
                        this.method_7454(new class_3966(entity2));
                    }
                }
            }
        }
        if (this.isReturning()) {
            if (!this.isOwnerAlive()) {
                this.dropAndDiscard();
            } else {
                class_1297 entity3 = Objects.requireNonNull(this.method_24921());
                class_243 vec3d = entity3.method_33571().method_1020(this.method_19538());
                int loyalty = 3;
                double d = 0.05 * (double)loyalty;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
            }
        }
    }

    private void dropAndDiscard() {
        if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
            this.method_5699(this.method_7445(), 0.1f);
        }
        this.method_31472();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    protected boolean method_34713(class_1657 player) {
        if (!((ProjectileEntityAccessor)((Object)this)).amarong$getLeftOwner()) {
            return false;
        }
        if (this.method_34714((class_1297)player)) {
            if (class_1665.class_1666.field_7594.equals((Object)this.field_7572)) {
                return true;
            }
            if (this.infinity) {
                return true;
            }
            class_1661 inventory = player.method_31548();
            try {
                class_1799 stack = inventory.method_5438(this.slot);
                if (stack == null || stack.method_7960()) {
                    inventory.method_5447(this.slot, this.method_7445());
                    return true;
                }
                return inventory.method_7394(this.method_7445());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Amarong.LOGGER.error("An error occurred when picking up an Amarong Boomerang!", (Throwable)e);
                return inventory.method_7394(this.method_7445());
            }
        }
        return false;
    }

    public void method_5694(class_1657 player) {
        if (this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556(INFINITY_KEY, this.infinity);
        nbt.method_10569(SLOT_KEY, this.slot);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(INFINITY_KEY)) {
            this.infinity = nbt.method_10577(INFINITY_KEY);
        }
        if (nbt.method_10545(SLOT_KEY)) {
            this.slot = nbt.method_10550(SLOT_KEY);
        }
    }

    protected float method_7436() {
        return 1.0f;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        int id = entity.method_5628();
        if (this.hitEntities.contains(id)) {
            return;
        }
        double damage = this.method_7448();
        class_1297 owner = this.method_24921();
        if (Objects.equals(entity, owner)) {
            return;
        }
        this.hitEntities.add(id);
        boolean isOwnerNull = owner == null;
        class_1937 world = this.method_37908();
        class_6880.class_6883 reference = world.atmospheric_api$getEntryFromKey(class_7924.field_42534, AmarongDamageTypes.BOOMERANG_HIT);
        class_1282 damageSource = new class_1282((class_6880)reference, (class_1297)this, (class_1297)(isOwnerNull ? this : owner));
        class_3218 serverWorld = null;
        if (this.method_59958() != null && this.method_37908() instanceof class_3218) {
            serverWorld = (class_3218)world;
            damage = class_1890.method_60120((class_3218)serverWorld, (class_1799)this.method_59958(), (class_1297)entity, (class_1282)damageSource, (float)((float)damage));
        }
        if (entity.method_5643(damageSource, (float)damage)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (serverWorld != null) {
                class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }
    }

    protected class_3414 method_7440() {
        return class_3417.field_42593;
    }
}

