/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.amarong.common.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2765;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import survivalblock.amarong.common.AmarongUtil;
import survivalblock.amarong.common.init.AmarongDamageTypes;
import survivalblock.amarong.common.init.AmarongDataComponentTypes;
import survivalblock.amarong.common.init.AmarongEntityTypes;
import survivalblock.amarong.common.init.AmarongItems;
import survivalblock.amarong.common.init.AmarongParticleTypes;
import survivalblock.amarong.common.init.AmarongSounds;
import survivalblock.atmosphere.atmospheric_api.not_mixin.entity.StacklessPersistentProjectile;
import survivalblock.atmosphere.atmospheric_api.not_mixin.particle.DirectionalParticleS2CPayload;

public class RailgunEntity
extends class_1297
implements class_8046,
StacklessPersistentProjectile {
    public static final int FIRING_TICKS = 40;
    public static final int MAX_ITERATIONS = 384;
    @Nullable
    protected UUID ownerUuid;
    @Nullable
    protected class_1297 owner;
    protected class_1799 stack;
    protected boolean hasWarned = false;

    public RailgunEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public RailgunEntity(class_1937 world, class_1297 owner, class_1799 stack) {
        this(AmarongEntityTypes.RAILGUN, world);
        this.method_33574(owner.method_33571());
        this.method_36456(owner.method_5791());
        this.method_36457(owner.method_36455());
        this.setOwner(owner);
        this.stack = stack.method_7972();
    }

    public void setOwner(@Nullable class_1297 entity) {
        if (entity != null) {
            this.ownerUuid = entity.method_5667();
            this.owner = entity;
        }
    }

    @Nullable
    public class_1297 method_24921() {
        class_1937 var2;
        if (this.owner != null && !this.owner.method_31481()) {
            return this.owner;
        }
        if (this.ownerUuid != null && (var2 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var2;
            this.owner = serverWorld.method_14190(this.ownerUuid);
            return this.owner;
        }
        return null;
    }

    public int getFiringTicks() {
        return this.noDelay() ? 0 : 40;
    }

    public boolean noDelay() {
        if (this.stack == null || this.stack.method_7960()) {
            return false;
        }
        return (Boolean)this.stack.method_57825(AmarongDataComponentTypes.NO_RAILGUN_DELAY, (Object)false);
    }

    public void method_5773() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.field_6012 > this.getFiringTicks() + 10) {
                this.method_31472();
                return;
            }
            this.tickFiring(serverWorld);
        }
        super.method_5773();
    }

    protected void tickFiring(class_3218 serverWorld) {
        class_1282 source;
        if (!this.hasWarned && !this.noDelay()) {
            this.hasWarned = true;
            List players = serverWorld.method_18456();
            class_6880 registryEntry = class_7923.field_41172.method_47983((Object)AmarongSounds.RAILGUN_CHARGES);
            this.raycastParticle((encountered, pitch, yaw, currentRaycastPosition, iterations) -> {
                for (class_3222 player : players) {
                    serverWorld.method_14166(player, (class_2394)class_2398.field_11207, true, currentRaycastPosition.field_1352, currentRaycastPosition.field_1351, currentRaycastPosition.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    if (!(player.method_19538().method_1025(currentRaycastPosition) < 25.0) || encountered.contains(player)) continue;
                    player.field_13987.method_14364((class_2596)new class_2765(registryEntry, this.method_5634(), (class_1297)player, 1.0f, 1.0f, this.method_59922().method_43055()));
                    encountered.add(player);
                }
            });
            return;
        }
        if (this.field_6012 < this.getFiringTicks()) {
            return;
        }
        List players = serverWorld.method_18456();
        float particleDistSquared = 262144.0f;
        double boxRadius = 1.25;
        HashSet entities = new HashSet(1024);
        HashSet boxes = new HashSet(100);
        this.raycastParticle((encountered, pitch, yaw, currentRaycastPosition, iterations) -> {
            DirectionalParticleS2CPayload payload = new DirectionalParticleS2CPayload.Builder().particleEffect((class_2394)new AmarongParticleTypes.RailgunParticleEffect(pitch, yaw)).pos(currentRaycastPosition).direction(pitch, yaw).deltaPos(0.1, 0.1, 0.1).force(true).build();
            class_2596 packet = ServerPlayNetworking.createS2CPacket((class_8710)payload);
            for (class_3222 player : players) {
                if (!(player.method_5707(currentRaycastPosition) < 262144.0)) continue;
                player.field_13987.method_14364(packet);
            }
            class_243 lowerCorner = currentRaycastPosition.method_1023(1.25, 1.25, 1.25);
            class_243 upperCorner = currentRaycastPosition.method_1031(1.25, 1.25, 1.25);
            boxes.add(new class_238(lowerCorner, upperCorner));
        });
        serverWorld.atmospheric_api$getAndAddEntitiesToCollection(entity -> {
            for (class_238 box : boxes) {
                if (!entity.method_5829().method_994(box)) continue;
                return true;
            }
            return false;
        }, entities);
        class_1297 owner = this.method_24921();
        class_6880.class_6883 reference = serverWorld.atmospheric_api$getEntryFromKey(class_7924.field_42534, AmarongDamageTypes.RAILGUN_HIT);
        if (owner instanceof class_1309) {
            class_1309 living = (class_1309)owner;
            source = new class_1282((class_6880)reference, (class_1297)this, (class_1297)living);
        } else {
            source = new class_1282((class_6880)reference, (class_1297)this);
        }
        if (owner != null) {
            entities.remove(owner);
        }
        entities.remove((Object)this);
        float playerDamage = this.getPlayerDamage();
        entities.forEach(entity -> {
            if (AmarongUtil.shouldDamageWithAmarong(entity)) {
                entity.method_5643(source, entity instanceof class_1657 ? playerDamage : 50.0f);
            }
        });
    }

    private float getPlayerDamage() {
        if (this.stack == null || this.stack.method_7960()) {
            return 17.5f;
        }
        if (AmarongUtil.shouldRetainCharge(this.stack)) {
            return 20.0f;
        }
        return 17.5f;
    }

    public class_243 raycastParticle(IRailgunRaycast step) {
        float pitch = this.method_36455();
        float yaw = this.method_36454();
        class_243 vec3d = class_243.method_1030((float)pitch, (float)yaw).method_1029();
        class_243 raycast = this.method_33571();
        HashSet<class_1657> encountered = new HashSet<class_1657>();
        for (int iterations = 0; !this.method_37908().method_8320(class_2338.method_49638((class_2374)raycast)).method_51367() && iterations <= 384; ++iterations) {
            raycast = raycast.method_1019(vec3d);
            step.step(encountered, pitch, yaw, raycast, iterations);
        }
        return raycast;
    }

    public void method_5878(class_1297 original) {
        super.method_5878(original);
        if (original instanceof RailgunEntity) {
            RailgunEntity railgunEntity = (RailgunEntity)original;
            this.setOwner(railgunEntity.method_24921());
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
            this.owner = null;
        }
        this.stack = nbt.method_10573("item", 10) ? class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt.method_10562("item")).orElse(this.getDefaultItemStack()) : this.getDefaultItemStack();
    }

    public class_1799 getDefaultItemStack() {
        return AmarongItems.AMARONG_VERYLONGSWORD.method_7854();
    }

    protected void method_5652(class_2487 nbt) {
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
        if (this.stack != null && !this.stack.method_7960()) {
            nbt.method_10566("item", this.stack.method_57358((class_7225.class_7874)this.method_56673()));
        }
    }

    @FunctionalInterface
    public static interface IRailgunRaycast {
        public void step(Set<class_1657> var1, float var2, float var3, class_243 var4, int var5);
    }
}

