/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.amarong.mixin.coreblock;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalLongRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2580;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import survivalblock.amarong.common.Amarong;
import survivalblock.amarong.common.AmarongUtil;
import survivalblock.amarong.common.block.StainableAmarongCoreWrapper;
import survivalblock.amarong.common.compat.config.AmarongConfig;
import survivalblock.amarong.common.compat.config.BeaconBeamDebugMode;
import survivalblock.amarong.common.init.AmarongBlocks;

@Mixin(value={class_2580.class})
public class BeaconBlockEntityMixin {
    @Unique
    private static long amarong$prevWorldTime = 0L;

    @Inject(method={"method_16896(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2580;)V"}, at={@At(value="HEAD")})
    private static void captureWorldTime(class_1937 world, class_2338 pos, class_2680 state, class_2580 blockEntity, CallbackInfo ci, @Share(value="time") LocalLongRef longReference) {
        longReference.set(world.method_8510());
    }

    @ModifyExpressionValue(method={"method_16896(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2580;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26204()Lnet/minecraft/class_2248;")})
    private static class_2248 captureBlock(class_2248 original, @Share(value="block") LocalRef<class_2248> blockReference) {
        blockReference.set((Object)original);
        if (AmarongBlocks.AMARONG_CORE.equals(original)) {
            return StainableAmarongCoreWrapper.INSTANCE;
        }
        return original;
    }

    @ModifyExpressionValue(method={"method_16896(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2580;)V"}, at={@At(value="CONSTANT", args={"intValue=10"})})
    private static int amarongCoreChange(int original, @Local(argsOnly=true) class_1937 world) {
        return world.method_8608() ? AmarongConfig.maxBeaconBeamIterations() : original;
    }

    @ModifyExpressionValue(method={"method_16896(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2580;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1767;method_7787()I")})
    private static int rainbowInstead(int original, @Local(argsOnly=true) class_1937 world, @Local(ordinal=1) class_2338 blockPos, @Share(value="block") LocalRef<class_2248> blockReference, @Share(value="time") LocalLongRef longReference) {
        if (AmarongBlocks.AMARONG_CORE.equals(blockReference.get())) {
            return AmarongUtil.getCoreColor(world, blockPos, longReference.get());
        }
        return original;
    }

    @Inject(method={"method_16896(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2580;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/class_2580;field_19177:Ljava/util/List;", opcode=181)})
    private static void injectWhenBeamSegmentsAreSet(class_1937 world, class_2338 pos, class_2680 state, class_2580 blockEntity, CallbackInfo ci) {
        if (!world.method_8608()) {
            return;
        }
        if (!AmarongConfig.verboseLogging()) {
            return;
        }
        long time = world.method_8510();
        BeaconBlockEntityMixin.amarong$logBeaconTick(time);
        amarong$prevWorldTime = time;
    }

    @Unique
    private static void amarong$logBeaconTick(long time) {
        BeaconBeamDebugMode debugMode = AmarongConfig.debugBeaconBeams();
        if (BeaconBeamDebugMode.NEVER.equals((Object)debugMode)) {
            return;
        }
        long difference = time - amarong$prevWorldTime;
        if (BeaconBeamDebugMode.ABNORMAL_ONLY.equals((Object)debugMode) && difference == 1L) {
            return;
        }
        Amarong.LOGGER.info("Beam segments set! World time was {}, prevTime was {}, difference was {}", new Object[]{time, amarong$prevWorldTime, difference});
    }
}

