/*
 * Decompiled with CFR 0.152.
 */
package net.i_no_am.viewmodel.version;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.i_no_am.viewmodel.Global;
import net.i_no_am.viewmodel.config.Config;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_410;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class Version
implements Global {
    private static final Map<String, Double> versionCache = new HashMap<String, Double>();
    @NotNull
    private final String api;
    @NotNull
    private final String download;
    private static boolean bl = false;
    private final double version;

    private Version(@NotNull String api, @NotNull String download) throws Exception {
        this.api = api;
        this.download = download;
        this.version = Config.shouldCheck ? this.getVApi() : 0.0;
    }

    public static Version create(String apiLink, String downloadLink) {
        try {
            return new Version(apiLink, downloadLink);
        }
        catch (Exception e) {
            Utils.log(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void notifyUpdate(boolean printVersions) {
        if (!bl && Version.mc.field_1755 == null && Version.mc.field_1724 != null && !this.isUpdated() && Config.shouldCheck) {
            if (printVersions) {
                Utils.log("Versions: \nCurrent Version: " + Version.getSelf() + "\nOnline Version: " + this.getApi() + "\nisUpdated() state: " + this.isUpdated());
            }
            mc.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    class_156.method_668().method_673(URI.create(this.download));
                    Version.mc.field_1724.method_3137();
                }
                Version.mc.field_1724.method_3137();
            }, class_2561.method_30163((String)(String.valueOf(class_124.field_1061) + "You are using an outdated version of View Model")), class_2561.method_30163((String)("Please download the latest version from " + String.valueOf(class_124.field_1060) + "Modrinth")), class_2561.method_30163((String)"Download"), class_2561.method_30163((String)"Continue playing")));
            bl = true;
        }
    }

    private boolean isUpdated() {
        return Version.getSelf() >= this.getApi();
    }

    private double getApi() {
        return this.version;
    }

    private static double getSelf() {
        String versionString = ((ModContainer)FabricLoader.getInstance().getModContainer("viewmodel").orElseThrow(() -> new RuntimeException("viewmodel Isn't loaded"))).getMetadata().getVersion().getFriendlyString();
        return Version.parseVersion(versionString);
    }

    private static int parseVersion(String version) {
        String[] parts;
        for (String part : parts = version.split("-")) {
            if (part.matches("\\d+\\.\\d+\\.\\d+")) {
                String[] versionNumbers = part.split("\\.");
                int major = Integer.parseInt(versionNumbers[0]);
                int minor = Integer.parseInt(versionNumbers[1]);
                int patch = Integer.parseInt(versionNumbers[2]);
                return major * 10000 + minor * 100 + patch;
            }
            if (!part.matches("\\d+\\.\\d+")) continue;
            String[] versionNumbers = part.split("\\.");
            int major = Integer.parseInt(versionNumbers[0]);
            int minor = Integer.parseInt(versionNumbers[1]);
            return major * 10000 + minor * 100;
        }
        return 0;
    }

    private double getVApi() throws Exception {
        HttpRequest request;
        if (versionCache.containsKey(this.api)) {
            return versionCache.get(this.api);
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.api)).timeout(Duration.ofSeconds(600L)).header("Accept", "application/vnd.github.v3+json").build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to fetch latest version: " + response.statusCode());
        }
        JsonObject jsonResponse = JsonParser.parseString((String)response.body()).getAsJsonObject();
        String versionString = jsonResponse.get("tag_name").getAsString();
        double parsedVersion = Version.parseVersion(versionString);
        versionCache.put(this.api, parsedVersion);
        return parsedVersion;
    }

    public static class Utils {
        private static final File logFile = new File(String.valueOf(Global.mc.field_1697) + "/logs", "view-model.log");
        private static boolean wroteLaunchHeader = false;

        public static void log(String message) {
            if (Global.isDev) {
                System.out.println("[ViewModel] " + message);
            }
            try (FileWriter writer = new FileWriter(logFile, true);){
                if (!wroteLaunchHeader) {
                    writer.write("=== Launch at " + Utils.getTimestamp(true) + " ===\n");
                    wroteLaunchHeader = true;
                }
                writer.write(Utils.getTimestamp(false) + " " + message + "\n");
            }
            catch (IOException e) {
                System.err.println("Failed to write to view-model.log: " + e.getMessage());
            }
        }

        private static String getTimestamp(boolean includeFullDate) {
            DateTimeFormatter fullDate = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
            DateTimeFormatter timeOnly = DateTimeFormatter.ofPattern("HH:mm:ss:SSS");
            return LocalDateTime.now().format(includeFullDate ? fullDate : timeOnly);
        }

        static {
            try {
                logFile.getParentFile().mkdirs();
                if (logFile.exists()) {
                    logFile.delete();
                }
            }
            catch (Exception e) {
                System.err.println("[View-Model] Failed to prepare log file: " + e.getMessage());
            }
        }
    }
}

