/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations.processing;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CommandContainerVisitor
implements ElementVisitor<Void, Void> {
    private static final Collection<String> PERMITTED_CONSTRUCTOR_PARAMETER_TYPES = Arrays.asList("cloud.commandframework.annotations.AnnotationParser");
    private final ProcessingEnvironment processingEnvironment;
    private final Collection<String> validTypes;
    private boolean suitableConstructorFound;

    CommandContainerVisitor(@NonNull ProcessingEnvironment processingEnvironment, @NonNull Collection<@NonNull String> validTypes) {
        this.processingEnvironment = processingEnvironment;
        this.validTypes = validTypes;
        this.suitableConstructorFound = false;
    }

    @Override
    public Void visit(Element e) {
        return this.visit(e, null);
    }

    @Override
    public Void visit(Element e, Void unused) {
        return null;
    }

    @Override
    public Void visitPackage(PackageElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitType(TypeElement e, Void unused) {
        if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@CommandMethod annotated class must be public (%s)", e.getSimpleName()), e);
        }
        for (Element element : e.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            element.accept(this, null);
            if (!this.suitableConstructorFound) continue;
            break;
        }
        if (!this.suitableConstructorFound) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@CommandMethod must have a suitable constructor (%s)", e.getSimpleName()), e);
        }
        this.validTypes.add(e.asType().toString());
        return null;
    }

    @Override
    public Void visitVariable(VariableElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void unused) {
        if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return null;
        }
        boolean containsIllegalParameter = e.getParameters().stream().map(parameter -> parameter.asType().toString()).map(typeString -> typeString.split(" ")).map(parts -> parts[((String[])parts).length - 1]).map(part -> part.split("<")[0]).anyMatch(type -> !PERMITTED_CONSTRUCTOR_PARAMETER_TYPES.contains(type));
        if (containsIllegalParameter) {
            return null;
        }
        this.suitableConstructorFound = true;
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitUnknown(Element e, Void unused) {
        return null;
    }
}

