/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations.processing;

import cloud.commandframework.annotations.Argument;
import cloud.commandframework.annotations.ArgumentMode;
import cloud.commandframework.annotations.CommandMethod;
import cloud.commandframework.annotations.SyntaxFragment;
import cloud.commandframework.annotations.SyntaxParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.NonNull;

class CommandMethodVisitor
implements ElementVisitor<Void, Void> {
    private final ProcessingEnvironment processingEnvironment;
    private final SyntaxParser syntaxParser;

    CommandMethodVisitor(@NonNull ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.syntaxParser = new SyntaxParser();
    }

    @Override
    public Void visit(Element e) {
        return this.visit(e, null);
    }

    @Override
    public Void visit(Element e, Void unused) {
        return null;
    }

    @Override
    public Void visitPackage(PackageElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitType(TypeElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitVariable(VariableElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void unused) {
        if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("@CommandMethod annotated methods should be public (%s)", e.getSimpleName()), e);
        }
        if (e.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@CommandMethod annotated methods should be non-static (%s)", e.getSimpleName()), e);
        }
        if (e.getReturnType().toString().equals("Void")) {
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@CommandMethod annotated methods should return void (%s)", e.getSimpleName()), e);
        }
        CommandMethod commandMethod = e.getAnnotation(CommandMethod.class);
        List parameterArgumentNames = e.getParameters().stream().map(parameter -> parameter.getAnnotation(Argument.class)).filter(Objects::nonNull).map(Argument::value).collect(Collectors.toList());
        ArrayList<String> parsedArgumentNames = new ArrayList<String>(parameterArgumentNames.size());
        List<SyntaxFragment> syntaxFragments = this.syntaxParser.apply(commandMethod.value());
        boolean foundOptional = false;
        for (SyntaxFragment fragment : syntaxFragments) {
            if (fragment.getArgumentMode() == ArgumentMode.LITERAL) continue;
            if (!parameterArgumentNames.contains(fragment.getMajor())) {
                this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@Argument(\"%s\") is missing from @CommandMethod (%s)", fragment.getMajor(), e.getSimpleName()), e);
            }
            if (fragment.getArgumentMode() == ArgumentMode.REQUIRED) {
                if (foundOptional) {
                    this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Required argument '%s' cannot succeed an optional argument (%s)", fragment.getMajor(), e.getSimpleName()), e);
                }
            } else {
                foundOptional = true;
            }
            parsedArgumentNames.add(fragment.getMajor());
        }
        for (String argument : parameterArgumentNames) {
            if (parsedArgumentNames.contains(argument)) continue;
            this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Argument '%s' is missing from the @CommandMethod syntax (%s)", argument, e.getSimpleName()), e);
        }
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Void unused) {
        return null;
    }

    @Override
    public Void visitUnknown(Element e, Void unused) {
        return null;
    }
}

