/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.meta;

import cloud.commandframework.keys.CloudKey;
import cloud.commandframework.meta.SimpleCommandMeta;
import cloud.commandframework.meta.SimpleKey;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public abstract class CommandMeta {
    private static final Key<String> LEGACY_HIDDEN = Key.of(String.class, "hidden");
    public static final Key<String> DESCRIPTION = Key.of(String.class, "description");
    public static final Key<String> LONG_DESCRIPTION = Key.of(String.class, "long-description");
    public static final Key<Boolean> HIDDEN = Key.of(Boolean.class, "cloud:hidden", meta -> Boolean.valueOf(meta.getOrDefault(LEGACY_HIDDEN, "false")));

    public static @NonNull SimpleCommandMeta.Builder simple() {
        return SimpleCommandMeta.builder();
    }

    public final @NonNull String toString() {
        return "";
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.3.0")
    public abstract @NonNull Optional<String> getValue(@NonNull String var1);

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.3.0")
    public abstract @NonNull String getOrDefault(@NonNull String var1, @NonNull String var2);

    @API(status=API.Status.STABLE, since="1.3.0")
    public abstract <V> @NonNull Optional<V> get(@NonNull Key<V> var1);

    @API(status=API.Status.STABLE, since="1.3.0")
    public abstract <V> @NonNull V getOrDefault(@NonNull Key<V> var1, @NonNull V var2);

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.3.0")
    public abstract @NonNull Map<@NonNull String, @NonNull String> getAll();

    @API(status=API.Status.STABLE, since="1.3.0")
    public abstract @NonNull Map<@NonNull String, @NonNull ?> getAllValues();

    @API(status=API.Status.STABLE, since="1.3.0")
    public static interface Key<V>
    extends CloudKey<V> {
        public static <T> @NonNull Key<T> of(@NonNull Class<T> type, @NonNull String key) {
            if (GenericTypeReflector.isMissingTypeParameters(type)) {
                throw new IllegalArgumentException("Raw type " + type + " is prohibited");
            }
            return new SimpleKey<T>(TypeToken.get(Objects.requireNonNull(type, "type")), Objects.requireNonNull(key, "key"), null);
        }

        public static <T> @NonNull Key<T> of(@NonNull TypeToken<T> type, @NonNull String key) {
            return new SimpleKey<T>(Objects.requireNonNull(type, "type"), Objects.requireNonNull(key, "key"), null);
        }

        public static <T> @NonNull Key<T> of(@NonNull Class<T> type, @NonNull String key, @NonNull Function<@NonNull CommandMeta, @Nullable T> fallbackDerivation) {
            return new SimpleKey<T>(TypeToken.get(Objects.requireNonNull(type, "type")), Objects.requireNonNull(key, "key"), fallbackDerivation);
        }

        public static <T> @NonNull Key<T> of(@NonNull TypeToken<T> type, @NonNull String key, @NonNull Function<@NonNull CommandMeta, @Nullable T> fallbackDerivation) {
            return new SimpleKey<T>(Objects.requireNonNull(type, "type"), Objects.requireNonNull(key, "key"), fallbackDerivation);
        }

        @Override
        default public @NonNull TypeToken<@NonNull V> getType() {
            return this.getValueType();
        }

        public @NonNull TypeToken<V> getValueType();

        @Override
        public @NonNull String getName();

        public @Nullable Function<@NonNull CommandMeta, @Nullable V> getFallbackDerivation();
    }
}

