/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.tasks;

import cloud.commandframework.tasks.TaskConsumer;
import cloud.commandframework.tasks.TaskFunction;
import cloud.commandframework.tasks.TaskRecipeStep;
import cloud.commandframework.tasks.TaskSynchronizer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TaskRecipe {
    private final TaskSynchronizer synchronizer;
    private final LinkedHashMap<TaskRecipeStep, Boolean> recipeSteps = new LinkedHashMap();

    TaskRecipe(@NonNull TaskSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public <I> @NonNull TaskRecipeComponentOutputting<I, I> begin(@NonNull I input) {
        this.addAsynchronous(TaskFunction.identity());
        return new TaskRecipeComponentOutputting(input);
    }

    private void addAsynchronous(TaskRecipeStep taskRecipeStep) {
        this.recipeSteps.put(taskRecipeStep, false);
    }

    private void addSynchronous(TaskRecipeStep taskRecipeStep) {
        this.recipeSteps.put(taskRecipeStep, true);
    }

    private void execute(@NonNull Object initialInput, @NonNull Runnable callback) {
        Iterator<Map.Entry<TaskRecipeStep, Boolean>> iterator2 = new LinkedHashMap<TaskRecipeStep, Boolean>(this.recipeSteps).entrySet().iterator();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(initialInput);
        completableFuture.whenComplete(this.execute(iterator2, callback));
    }

    private BiConsumer execute(@NonNull Iterator<Map.Entry<TaskRecipeStep, Boolean>> iterator2, @NonNull Runnable callback) {
        return (o, o2) -> {
            if (iterator2.hasNext()) {
                CompletableFuture<Object> other;
                Map.Entry entry = (Map.Entry)iterator2.next();
                boolean synchronous = (Boolean)entry.getValue();
                if (entry.getKey() instanceof TaskFunction) {
                    TaskFunction function = (TaskFunction)entry.getKey();
                    other = synchronous ? this.synchronizer.runSynchronous(o, function) : this.synchronizer.runAsynchronous(o, function);
                } else {
                    TaskConsumer consumer = (TaskConsumer)entry.getKey();
                    other = synchronous ? this.synchronizer.runSynchronous(o, consumer) : this.synchronizer.runAsynchronous(o, consumer);
                }
                other.whenComplete(this.execute(iterator2, callback));
            } else {
                callback.run();
            }
        };
    }

    public final class TaskRecipeComponentOutputting<I, O> {
        private final Object initialInput;

        private TaskRecipeComponentOutputting(Object initialInput) {
            this.initialInput = initialInput;
        }

        public <T> TaskRecipeComponentOutputting<O, T> synchronous(@NonNull TaskFunction<O, T> function) {
            TaskRecipe.this.addSynchronous(function);
            return new TaskRecipeComponentOutputting<I, O>(this.initialInput);
        }

        public <T> TaskRecipeComponentOutputting<O, T> asynchronous(@NonNull TaskFunction<O, T> function) {
            TaskRecipe.this.addAsynchronous(function);
            return new TaskRecipeComponentOutputting<I, O>(this.initialInput);
        }

        public TaskRecipeComponentVoid<O> synchronous(@NonNull TaskConsumer<O> consumer) {
            TaskRecipe.this.addSynchronous(consumer);
            return new TaskRecipeComponentVoid(this.initialInput);
        }

        public TaskRecipeComponentVoid<O> asynchronous(@NonNull TaskConsumer<O> consumer) {
            TaskRecipe.this.addAsynchronous(consumer);
            return new TaskRecipeComponentVoid(this.initialInput);
        }

        public void execute(@NonNull Runnable callback) {
            TaskRecipe.this.execute(this.initialInput, callback);
        }

        public void execute() {
            this.execute(() -> {});
        }
    }

    public final class TaskRecipeComponentVoid<I> {
        private final Object initialInput;

        private TaskRecipeComponentVoid(Object initialInput) {
            this.initialInput = initialInput;
        }

        public TaskRecipeComponentVoid<I> synchronous(@NonNull TaskConsumer<I> consumer) {
            TaskRecipe.this.addSynchronous(consumer);
            return new TaskRecipeComponentVoid<I>(this.initialInput);
        }

        public TaskRecipeComponentVoid<I> asynchronous(@NonNull TaskConsumer<I> consumer) {
            TaskRecipe.this.addSynchronous(consumer);
            return new TaskRecipeComponentVoid<I>(this.initialInput);
        }

        public void execute(@NonNull Runnable callback) {
            TaskRecipe.this.execute(this.initialInput, callback);
        }

        public void execute() {
            this.execute(() -> {});
        }
    }
}

