/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.faweschematiccloud.commands;

import cloud.commandframework.annotations.Argument;
import cloud.commandframework.annotations.CommandMethod;
import cloud.commandframework.annotations.CommandPermission;
import cloud.commandframework.annotations.specifier.Greedy;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.util.MainUtil;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import dev.themeinerlp.faweschematiccloud.FAWESchematicCloud;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0007J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/themeinerlp/faweschematiccloud/commands/LoadCommand;", "", "faweSchematicCloud", "Ldev/themeinerlp/faweschematiccloud/FAWESchematicCloud;", "<init>", "(Ldev/themeinerlp/faweschematiccloud/FAWESchematicCloud;)V", "uuidRegex", "Lkotlin/text/Regex;", "fileRegex", "apiDownloadBaseUrl", "", "Lorg/jetbrains/annotations/Nullable;", "loadSchem", "", "player", "Lorg/bukkit/entity/Player;", "rawFormatName", "rawFilename", "load", "FaweSchematicCloud"})
@SourceDebugExtension(value={"SMAP\nLoadCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadCommand.kt\ndev/themeinerlp/faweschematiccloud/commands/LoadCommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,135:1\n37#2:136\n36#2,3:137\n*S KotlinDebug\n*F\n+ 1 LoadCommand.kt\ndev/themeinerlp/faweschematiccloud/commands/LoadCommand\n*L\n79#1:136\n79#1:137,3\n*E\n"})
public final class LoadCommand {
    @NotNull
    private final FAWESchematicCloud faweSchematicCloud;
    @NotNull
    private final Regex uuidRegex;
    @NotNull
    private final Regex fileRegex;
    @NotNull
    private final String apiDownloadBaseUrl;

    public LoadCommand(@NotNull FAWESchematicCloud faweSchematicCloud) {
        Intrinsics.checkNotNullParameter((Object)faweSchematicCloud, "faweSchematicCloud");
        this.faweSchematicCloud = faweSchematicCloud;
        this.uuidRegex = new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
        this.fileRegex = new Regex(".*\\.[\\w].*");
        String string = this.faweSchematicCloud.getConfig().getString("arkitektonika.downloadUrl");
        if (string == null) {
            throw new NullPointerException("Arkitektonika Download Url not found");
        }
        this.apiDownloadBaseUrl = string;
    }

    @CommandMethod(value="/schem load <filename> [format]")
    @CommandPermission(value="worldedit.schematic.load")
    public final void loadSchem(@NotNull Player player, @Argument(value="format", defaultValue="fast") @Greedy @NotNull String rawFormatName, @Argument(value="filename") @NotNull String rawFilename) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(rawFormatName, "rawFormatName");
        Intrinsics.checkNotNullParameter(rawFilename, "rawFilename");
        this.load(player, rawFormatName, rawFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CommandMethod(value="/schematic load <filename> [format]")
    @CommandPermission(value="worldedit.schematic.load")
    public final void load(@NotNull Player player, @Argument(value="format", defaultValue="fast") @Greedy @NotNull String rawFormatName, @Argument(value="filename") @NotNull String rawFilename) {
        ClipboardFormat clipboardFormat;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(rawFormatName, "rawFormatName");
        Intrinsics.checkNotNullParameter(rawFilename, "rawFilename");
        LocalConfiguration localConfiguration = WorldEdit.getInstance().getConfiguration();
        Intrinsics.checkNotNullExpressionValue(localConfiguration, "getConfiguration(...)");
        LocalConfiguration config = localConfiguration;
        BukkitPlayer actor = BukkitAdapter.adapt((Player)player);
        ClipboardFormat format = null;
        String filename = rawFilename;
        String formatName = rawFormatName;
        URI uri = null;
        InputStream in = null;
        try {
            Object[] saveDir;
            block42: {
                Object[] objectArray;
                File file;
                Object dir;
                block46: {
                    ClipboardFormat clipboardFormat2;
                    block43: {
                        String[] stringArray;
                        block45: {
                            block44: {
                                Serializable webUrl;
                                block41: {
                                    ClipboardFormat clipboardFormat3;
                                    if (StringsKt.startsWith(rawFormatName, "url:", true)) {
                                        filename = rawFormatName;
                                        formatName = rawFilename;
                                    }
                                    if (!StringsKt.startsWith(filename, "url:", true)) break block41;
                                    if (!actor.hasPermission("worldedit.schematic.load.web")) {
                                        Object[] objectArray2 = new Object[]{"worldedit.schematic.load.web"};
                                        actor.print((Component)Caption.of((String)"fawe.error.no-perm", (Object[])objectArray2));
                                        return;
                                    }
                                    String accessKey = StringsKt.substringAfterLast$default(filename, '/', null, 2, null);
                                    clipboardFormat = ClipboardFormats.findByAlias((String)formatName);
                                    if (clipboardFormat == null) {
                                        return;
                                    }
                                    format = clipboardFormat3;
                                    webUrl = new URL(StringsKt.replace$default(this.apiDownloadBaseUrl, "{key}", accessKey, false, 4, null));
                                    ReadableByteChannel readableByteChannel = Channels.newChannel(((URL)webUrl).openStream());
                                    Intrinsics.checkNotNullExpressionValue(readableByteChannel, "newChannel(...)");
                                    ReadableByteChannel byteChannel = readableByteChannel;
                                    in = Channels.newInputStream(byteChannel);
                                    URI uRI = ((URL)webUrl).toURI();
                                    Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
                                    uri = uRI;
                                    break block42;
                                }
                                webUrl = WorldEdit.getInstance().getWorkingDirectoryPath(config.saveDir).toFile();
                                Intrinsics.checkNotNullExpressionValue(webUrl, "toFile(...)");
                                saveDir = webUrl;
                                dir = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File((File)saveDir, actor.getUniqueId().toString()) : saveDir;
                                file = null;
                                if (!StringsKt.startsWith$default(filename, "#", false, 2, null)) break block43;
                                ClipboardFormat clipboardFormat4 = ClipboardFormats.findByAlias((String)formatName);
                                Intrinsics.checkNotNull(clipboardFormat4);
                                format = clipboardFormat4;
                                stringArray = format.getFileExtensions();
                                if (stringArray == null) break block44;
                                Collection $this$toTypedArray$iv = (Collection)stringArray;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                stringArray = thisCollection$iv.toArray(new String[0]);
                                if (stringArray != null) break block45;
                            }
                            stringArray = ClipboardFormats.getFileExtensionArray();
                        }
                        String[] extensions = stringArray;
                        File file2 = actor.openFileOpenDialog(extensions);
                        Intrinsics.checkNotNullExpressionValue(file2, "openFileOpenDialog(...)");
                        file = file2;
                        if (!file.exists()) {
                            Object[] objectArray3 = new Object[]{TextComponent.of((String)filename)};
                            actor.print((Component)Caption.of((String)"worldedit.schematic.load.does-not-exist", (Object[])objectArray3));
                            return;
                        }
                        break block46;
                    }
                    if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && !actor.hasPermission("worldedit.schematic.load.other") && this.uuidRegex.containsMatchIn(filename)) {
                        Object[] objectArray4 = new Object[]{"worldedit.schematic.load.other"};
                        actor.print((Component)Caption.of((String)"fawe.error.no-perm", (Object[])objectArray4));
                        return;
                    }
                    objectArray = (Object[])filename;
                    if (this.fileRegex.matches((CharSequence)objectArray)) {
                        String string = filename.substring(StringsKt.lastIndexOf$default((CharSequence)filename, '.', 0, false, 6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        ClipboardFormat clipboardFormat5 = ClipboardFormats.findByExtension((String)string);
                        clipboardFormat2 = clipboardFormat5;
                        Intrinsics.checkNotNull(clipboardFormat5);
                    } else {
                        clipboardFormat2 = ClipboardFormats.findByAlias((String)formatName);
                    }
                    format = clipboardFormat2;
                    File file3 = MainUtil.resolve((File)dir, (String)filename, (ClipboardFormat)format, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue(file3, "resolve(...)");
                    file = file3;
                }
                if (!file.exists() && !StringsKt.contains$default((CharSequence)filename, "../", false, 2, null)) {
                    File file4 = WorldEdit.getInstance().getWorkingDirectoryPath(config.saveDir).toFile();
                    Intrinsics.checkNotNullExpressionValue(file4, "toFile(...)");
                    dir = file4;
                    File file5 = MainUtil.resolve((File)dir, (String)filename, (ClipboardFormat)format, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue(file5, "resolve(...)");
                    file = file5;
                }
                if (!file.exists() || !MainUtil.isInSubDirectory((File)saveDir, (File)file)) {
                    actor.printError((Component)TextComponent.of((String)("Schematic " + filename + " does not exist! (" + file.exists() + "|" + file + "|" + MainUtil.isInSubDirectory((File)saveDir, (File)file) + ")")));
                    return;
                }
                format = ClipboardFormats.findByFile((File)file);
                if (format == null) {
                    objectArray = new Object[]{TextComponent.of((String)formatName)};
                    actor.print((Component)Caption.of((String)"worldedit.schematic.unknown-format", (Object[])objectArray));
                    return;
                }
                in = new FileInputStream(file);
                URI uRI = file.toURI();
                Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
                uri = uRI;
            }
            format.hold((Actor)actor, uri, in);
            saveDir = new Object[]{filename};
            actor.print((Component)Caption.of((String)"fawe.worldedit.schematic.schematic.loaded", (Object[])saveDir));
            return;
        }
        catch (IllegalArgumentException e) {
            clipboardFormat = new Object[]{TextComponent.of((String)filename)};
            actor.print((Component)Caption.of((String)"worldedit.schematic.unknown-filename", (Object[])clipboardFormat));
            return;
        }
        catch (URISyntaxException e) {
            clipboardFormat = new Object[]{TextComponent.of((String)Objects.toString(e.getMessage()))};
            actor.print((Component)Caption.of((String)"worldedit.schematic.file-not-exist", (Object[])clipboardFormat));
            return;
        }
        catch (IOException e) {
            clipboardFormat = new Object[]{TextComponent.of((String)Objects.toString(e.getMessage()))};
            actor.print((Component)Caption.of((String)"worldedit.schematic.file-not-exist", (Object[])clipboardFormat));
            this.faweSchematicCloud.getLog4JLogger().warn("Failed to load a saved clipboard", (Throwable)e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

