/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.forge.config;

import com.sergo467.disablefog.config.FogConfigDefault;
import com.sergo467.disablefog.config.IFogConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeFogConfig
implements IFogConfig {
    public final ForgeConfigSpec.BooleanValue enabled;
    private final ForgeConfigSpec.BooleanValue terrain;
    private final ForgeConfigSpec.BooleanValue atmospheric;
    private final ForgeConfigSpec.BooleanValue thick;
    private final ForgeConfigSpec.BooleanValue dimensionOrBoss;
    private final ForgeConfigSpec.BooleanValue water;
    private final ForgeConfigSpec.BooleanValue lava;
    private final ForgeConfigSpec.BooleanValue powderSnow;
    private final ForgeConfigSpec.BooleanValue blindness;
    private final ForgeConfigSpec.BooleanValue darkness;

    public ForgeFogConfig(ForgeConfigSpec.Builder builder) {
        FogConfigDefault defaults = new FogConfigDefault();
        builder.comment("DisableFog configuration settings");
        this.enabled = builder.comment("Enables or disables the mod, affecting all fog settings").translation("config.disablefog.enabled").define("enabled", defaults.isEnabled());
        this.terrain = builder.comment("Toggles terrain fog visibility, improving visibility of distant landscapes").translation("config.disablefog.terrain").define("terrain", defaults.isTerrainEnabled());
        this.atmospheric = builder.comment("Toggles haze that covers the world and also changes the sky's appearance").translation("config.disablefog.atmospheric").define("atmospheric", defaults.isAtmosphericEnabled());
        this.thick = builder.comment("Toggles thick fog visibility in the Nether, enhancing Nether visibility").translation("config.disablefog.thick").define("thick", defaults.isThickEnabled());
        this.dimensionOrBoss = builder.comment("Toggles are specific fog modifiers related to bosses or dimensions").translation("config.disablefog.dimension_or_boss").define("dimensionOrBoss", defaults.isDimensionOrBossEnabled());
        this.water = builder.comment("Toggles underwater fog visibility, improving visibility below water").translation("config.disablefog.water").define("water", defaults.isWaterEnabled());
        this.lava = builder.comment("Toggles lava fog visibility, improving visibility beneath lava").translation("config.disablefog.lava").define("lava", defaults.isLavaEnabled());
        this.powderSnow = builder.comment("Toggles fog visibility when sinking into powder snow, improving visibility in snowy areas").translation("config.disablefog.powder_snow").define("powderSnow", defaults.isPowderSnowEnabled());
        this.blindness = builder.comment("Toggles blindness fog visibility, improving visibility during the blindness effect").translation("config.disablefog.blindness").define("blindness", defaults.isBlindnessEnabled());
        this.darkness = builder.comment("Toggles darkness fog visibility, improving visibility during the darkness effect").translation("config.disablefog.darkness").define("darkness", defaults.isDarknessEnabled());
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    @Override
    public boolean isTerrainEnabled() {
        return (Boolean)this.terrain.get();
    }

    @Override
    public boolean isAtmosphericEnabled() {
        return (Boolean)this.atmospheric.get();
    }

    @Override
    public boolean isThickEnabled() {
        return (Boolean)this.thick.get();
    }

    @Override
    public boolean isDimensionOrBossEnabled() {
        return (Boolean)this.dimensionOrBoss.get();
    }

    @Override
    public boolean isWaterEnabled() {
        return (Boolean)this.water.get();
    }

    @Override
    public boolean isLavaEnabled() {
        return (Boolean)this.lava.get();
    }

    @Override
    public boolean isPowderSnowEnabled() {
        return (Boolean)this.powderSnow.get();
    }

    @Override
    public boolean isBlindnessEnabled() {
        return (Boolean)this.blindness.get();
    }

    @Override
    public boolean isDarknessEnabled() {
        return (Boolean)this.darkness.get();
    }
}

