/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.forge.gui.components;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomStringWidget
extends AbstractStringWidget {
    private int maxWidth = 0;
    private int cachedWidth = 0;
    private boolean cachedWidthDirty = true;
    private TextOverflow textOverflow = TextOverflow.CLAMPED;

    public CustomStringWidget(int width, int height, Component message, Font font) {
        this(0, 0, width, height, message, font);
    }

    public CustomStringWidget(int x, int y, int width, int height, Component message, Font font) {
        super(x, y, width, height, message, font);
        this.active = false;
    }

    public CustomStringWidget setColor(int color) {
        super.setColor(color);
        return this;
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.setWidth(this.getFont().width(message.getVisualOrderText()));
        this.cachedWidthDirty = true;
    }

    public CustomStringWidget setMaxWidth(int maxWidth) {
        return this.setMaxWidth(maxWidth, TextOverflow.CLAMPED);
    }

    public CustomStringWidget setMaxWidth(int maxWidth, TextOverflow overflow) {
        this.maxWidth = maxWidth;
        this.textOverflow = overflow;
        return this;
    }

    public int getWidth() {
        if (this.maxWidth > 0) {
            if (this.cachedWidthDirty) {
                this.cachedWidth = Math.min(this.maxWidth, this.getFont().width(this.getMessage().getVisualOrderText()));
                this.cachedWidthDirty = false;
            }
            return this.cachedWidth;
        }
        return super.getWidth();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        boolean flag;
        Component message = this.getMessage();
        Font font = this.getFont();
        int i = this.maxWidth > 0 ? this.maxWidth : this.getWidth();
        int j = font.width((FormattedText)message);
        int k = this.getX();
        int l = this.getY() + (this.getHeight() - 9) / 2;
        boolean bl = flag = j > i;
        if (flag) {
            switch (this.textOverflow.ordinal()) {
                case 0: {
                    graphics.drawString(font, this.clipText(message, i), k, l, this.getColor());
                    break;
                }
                case 1: {
                    this.renderScrollingString(graphics, font, 2, this.getColor());
                }
            }
        } else {
            graphics.drawString(font, message.getVisualOrderText(), k, l, this.getColor());
        }
    }

    private FormattedCharSequence clipText(Component text, int maxWidth) {
        Font font = this.getFont();
        FormattedText formattedtext = font.substrByWidth((FormattedText)text, maxWidth - font.width((FormattedText)CommonComponents.ELLIPSIS));
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{formattedtext, CommonComponents.ELLIPSIS}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TextOverflow {
        CLAMPED,
        SCROLLING;

    }
}

