/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.forge.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.sergo467.disablefog.forge.gui.components.CustomOptionsList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public class ConfigurationScreen
extends OptionsSubScreen {
    protected final Screen lastScreen;
    protected final ForgeConfigSpec spec;
    protected final Set<? extends UnmodifiableConfig.Entry> entries;
    protected final Map<String, Object> valueSpecs;
    protected final Runnable saveAction;
    protected boolean changed = false;
    protected Button resetButton;
    protected final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build();
    protected ArrayList<String> keylist;
    protected final ModContainer mod;
    protected CustomOptionsList list;
    private static final String LANG_PREFIX = "forgeconfigscreen.config.uitext.";
    private static final String RANGE_TOOLTIP = "forgeconfigscreen.config.uitext.rangetooltip";
    private static final ChatFormatting RANGE_TOOLTIP_STYLE = ChatFormatting.GRAY;
    public static final Component RESET = Component.translatable((String)"forgeconfigscreen.config.uitext.reset");
    public static final Component RESET_TOOLTIP = Component.translatable((String)"forgeconfigscreen.config.uitext.reset.tooltip");
    public static final Component BUTTON_ON = Component.translatable((String)"options.on").withStyle(ChatFormatting.GREEN);
    public static final Component BUTTON_OFF = Component.translatable((String)"options.off").withStyle(ChatFormatting.RED);
    public static final Component UNSUPPORTED_ELEMENT = Component.translatable((String)"forgeconfigscreen.config.uitext.unsupportedelement").withStyle(ChatFormatting.RED);
    private static final MutableComponent EMPTY_LINE = Component.literal((String)"\n\n");
    protected static final long MAX_SLIDER_SIZE = 256L;

    public ConfigurationScreen(ModContainer mod, Screen lastScreen, ForgeConfigSpec spec) {
        this(mod, lastScreen, spec, () -> ((ForgeConfigSpec)spec).save(), (Component)Component.translatable((String)(mod.getModId() + ".config.title")));
    }

    public ConfigurationScreen(ModContainer mod, Screen lastScreen, ForgeConfigSpec spec, Runnable saveAction, Component title) {
        super(lastScreen, Minecraft.getInstance().options, title);
        this.mod = mod;
        this.lastScreen = lastScreen;
        this.spec = spec;
        this.saveAction = saveAction;
        this.entries = spec.getValues().entrySet();
        this.valueSpecs = spec.getSpec().valueMap();
    }

    protected void init() {
        super.init();
    }

    protected void addFooter() {
        if (this.resetButton != null) {
            LinearLayout linearlayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
            if (this.resetButton != null) {
                linearlayout.addChild((LayoutElement)this.resetButton);
            }
            linearlayout.addChild((LayoutElement)this.doneButton);
        } else {
            super.addFooter();
        }
    }

    protected void addContents() {
        this.list = (CustomOptionsList)this.layout.addToContents((LayoutElement)new CustomOptionsList(this.minecraft, this.width, this));
        this.addOptions();
        AbstractWidget abstractWidget = this.list.findOption(this.options.narrator());
        if (abstractWidget instanceof CycleButton) {
            CycleButton cyclebutton;
            this.narratorButton = cyclebutton = (CycleButton)abstractWidget;
            this.narratorButton.active = this.minecraft.getNarrator().isActive();
        }
    }

    protected void addOptions() {
        this.rebuild();
    }

    protected ConfigurationScreen rebuild() {
        if (this.list != null) {
            this.list.clearEntries();
            for (UnmodifiableConfig.Entry entry : this.entries) {
                String key = entry.getKey();
                Object raw = entry.getRawValue();
                if (!(raw instanceof ForgeConfigSpec.ConfigValue)) continue;
                ForgeConfigSpec.ConfigValue cv = (ForgeConfigSpec.ConfigValue)raw;
                ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
                Element element = null;
                if (valueSpec != null) {
                    ForgeConfigSpec.ConfigValue configValue;
                    Objects.requireNonNull(cv);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ForgeConfigSpec.BooleanValue.class, ForgeConfigSpec.IntValue.class, ForgeConfigSpec.LongValue.class, ForgeConfigSpec.DoubleValue.class}, (Object)configValue, n)) {
                        case 0: {
                            ForgeConfigSpec.BooleanValue v = (ForgeConfigSpec.BooleanValue)configValue;
                            Element element2 = this.createBooleanValue(key, valueSpec, () -> ((ForgeConfigSpec.BooleanValue)v).get(), arg_0 -> ((ForgeConfigSpec.BooleanValue)v).set(arg_0));
                            break;
                        }
                        case 1: {
                            ForgeConfigSpec.IntValue v = (ForgeConfigSpec.IntValue)configValue;
                            Element element2 = this.createIntegerValue(key, valueSpec, () -> ((ForgeConfigSpec.IntValue)v).get(), arg_0 -> ((ForgeConfigSpec.IntValue)v).set(arg_0));
                            break;
                        }
                        case 2: {
                            ForgeConfigSpec.LongValue v = (ForgeConfigSpec.LongValue)configValue;
                            Element element2 = this.createLongValue(key, valueSpec, () -> ((ForgeConfigSpec.LongValue)v).get(), arg_0 -> ((ForgeConfigSpec.LongValue)v).set(arg_0));
                            break;
                        }
                        case 3: {
                            ForgeConfigSpec.DoubleValue v = (ForgeConfigSpec.DoubleValue)configValue;
                            Element element2 = this.createDoubleValue(key, valueSpec, () -> ((ForgeConfigSpec.DoubleValue)v).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)v).set(arg_0));
                            break;
                        }
                        default: {
                            Element element2 = element = this.createOtherValue(key, cv);
                        }
                    }
                }
                if (element == null) continue;
                if (element.name() == null) {
                    this.list.addSmall((AbstractWidget)new StringWidget(150, 20, (Component)Component.empty(), this.font), element.getWidget(this.options));
                    continue;
                }
                StringWidget label = new StringWidget(150, 20, element.name, this.font);
                label.setTooltip(Tooltip.create((Component)element.tooltip));
                this.list.addSmall((AbstractWidget)label, element.getWidget(this.options));
            }
        }
        if (this.resetButton == null) {
            this.createResetButton();
        }
        return this;
    }

    @Nullable
    protected Element createLongValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Long> source, Consumer<Long> target) {
        return this.createNumberBox(key, spec, source, target, null, Long::decode, 0L);
    }

    @Nullable
    protected Element createDoubleValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Double> source, Consumer<Double> target) {
        return this.createNumberBox(key, spec, source, target, null, Double::parseDouble, 0.0);
    }

    @Nullable
    protected Element createIntegerValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Integer> source, Consumer<Integer> target) {
        int max;
        ForgeConfigSpec.Range range = spec.getRange();
        int min = range != null ? (Integer)range.getMin() : 0;
        int n = max = range != null ? (Integer)range.getMax() : Integer.MAX_VALUE;
        if ((long)max - (long)min < 256L) {
            return this.createSlider(key, source, target, (ForgeConfigSpec.Range<Integer>)range);
        }
        return this.createNumberBox(key, spec, source, target, null, Integer::decode, 0);
    }

    @Nullable
    protected <T extends Number> Element createNumberBox(String key, ForgeConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target, @Nullable Predicate<T> tester, Function<String, T> parser, T zero) {
        ForgeConfigSpec.Range range = spec.getRange();
        EditBox box = new EditBox(this.font, 150, 20, (Component)this.getTranslationComponent(key));
        box.setEditable(true);
        box.setFilter(newValueString -> {
            try {
                parser.apply((String)newValueString);
                return true;
            }
            catch (NumberFormatException e) {
                return this.isPartialNumber((String)newValueString, range == null || ((Comparable)((Object)((Number)((Object)range.getMin())))).compareTo(zero) < 0);
            }
        });
        box.setTooltip(Tooltip.create((Component)this.getTooltipComponent(key, range)));
        box.setValue(String.valueOf(source.get()));
        box.setResponder(newValueString -> {
            try {
                Number newValue = (Number)parser.apply((String)newValueString);
                if (tester != null ? tester.test(newValue) : newValue != null && (range == null || range.test((Object)newValue)) && spec.test((Object)newValue)) {
                    if (!newValue.equals(source.get())) {
                        target.accept(newValue);
                        this.onChanged();
                    }
                    box.setTextColor(-2039584);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            box.setTextColor(-65536);
        });
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)box);
    }

    protected boolean isPartialNumber(String value, boolean allowNegative) {
        return switch (value) {
            case "" -> true;
            case "0" -> true;
            case "0x" -> true;
            case "0X" -> true;
            case "#" -> true;
            case "-" -> allowNegative;
            case "-0" -> allowNegative;
            case "-0x" -> allowNegative;
            case "-0X" -> allowNegative;
            default -> false;
        };
    }

    @Nullable
    protected Element createSlider(String key, Supplier<Integer> source, Consumer<Integer> target, @Nullable ForgeConfigSpec.Range<Integer> range) {
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new OptionInstance(this.getTranslationKey(key), this.getTooltip(key, range), (caption, displayvalue) -> Component.literal((String)("" + displayvalue)), (OptionInstance.ValueSet)new OptionInstance.IntRange(range != null ? (Integer)range.getMin() : 0, range != null ? (Integer)range.getMax() : Integer.MAX_VALUE), null, (Object)source.get(), newValue -> {
            if (!newValue.equals(source.get())) {
                target.accept((Integer)newValue);
                this.onChanged();
            }
        }));
    }

    @Nullable
    protected Element createBooleanValue(String key, ForgeConfigSpec.ValueSpec spec, Supplier<Boolean> source, Consumer<Boolean> target) {
        MutableComponent label = this.getTranslationComponent(key);
        Component tooltip = this.getTooltipComponent(key, null);
        CycleButton button = CycleButton.booleanBuilder((Component)BUTTON_ON, (Component)BUTTON_OFF).withInitialValue((Object)source.get()).displayOnlyValue().create(0, 0, 150, 20, (Component)Component.empty(), (btn, newValue) -> {
            target.accept((Boolean)newValue);
            this.onChanged();
        });
        button.setTooltip(Tooltip.create((Component)tooltip));
        return new Element((Component)label, tooltip, (AbstractWidget)button);
    }

    @Nullable
    protected Element createOtherValue(String key, ForgeConfigSpec.ConfigValue<?> value) {
        StringWidget label = new StringWidget(150, 20, (Component)Component.literal((String)Objects.toString(value.get())), this.font);
        label.setTooltip(Tooltip.create((Component)UNSUPPORTED_ELEMENT));
        return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)label);
    }

    protected <T> OptionInstance.TooltipSupplier<T> getTooltip(String key, @Nullable ForgeConfigSpec.Range<?> range) {
        return OptionInstance.cachedConstantTooltip((Component)this.getTooltipComponent(key, range));
    }

    protected Component getTooltipComponent(String key, @Nullable ForgeConfigSpec.Range<?> range) {
        String tooltipKey = this.getTranslationKey(key) + ".tooltip";
        String comment = this.getComment(key);
        MutableComponent component = Component.empty().append((Component)this.getTranslationComponent(key).withStyle(ChatFormatting.BOLD));
        if (!Strings.isBlank((String)comment)) {
            component = component.append((Component)EMPTY_LINE).append((Component)Component.translatableWithFallback((String)tooltipKey, (String)comment));
        }
        if (range != null) {
            component = component.append((Component)EMPTY_LINE).append((Component)Component.translatable((String)RANGE_TOOLTIP, (Object[])new Object[]{range.toString()}).withStyle(RANGE_TOOLTIP_STYLE));
        }
        return component;
    }

    protected String getComment(String key) {
        ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
        return valueSpec != null ? this.getValueSpec(key).getComment() : this.spec.getLevelComment(this.makeKeyList(key));
    }

    protected String getTranslationKey(String key) {
        ForgeConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
        String result = valueSpec != null ? valueSpec.getTranslationKey() : this.spec.getLevelTranslationKey(this.makeKeyList(key));
        return result != null ? result : this.mod.getModId() + ".config." + key;
    }

    protected MutableComponent getTranslationComponent(String key) {
        return Component.translatable((String)this.getTranslationKey(key));
    }

    private ArrayList<String> makeKeyList(String key) {
        ArrayList<String> result = new ArrayList<String>(this.keylist);
        result.add(key);
        return result;
    }

    protected void createResetButton() {
        this.resetButton = Button.builder((Component)RESET, button -> {
            for (UnmodifiableConfig.Entry entry : this.entries) {
                ForgeConfigSpec.ConfigValue cv;
                Object patt0$temp = entry.getRawValue();
                if (!(patt0$temp instanceof ForgeConfigSpec.ConfigValue) || !this.isNonDefault(cv = (ForgeConfigSpec.ConfigValue)patt0$temp)) continue;
                String key = entry.getKey();
                cv.set(cv.getDefault());
                this.onChanged();
            }
            this.rebuild();
        }).tooltip(Tooltip.create((Component)RESET_TOOLTIP)).width(120).build();
    }

    protected void setResetButtonstate(boolean state) {
        if (this.resetButton != null) {
            this.resetButton.active = state;
        }
    }

    protected void onChanged() {
        this.changed = true;
    }

    protected boolean isNonDefault(ForgeConfigSpec.ConfigValue<?> cv) {
        return !Objects.equals(cv.get(), cv.getDefault());
    }

    protected boolean isAnyNondefault() {
        for (UnmodifiableConfig.Entry entry : this.entries) {
            ForgeConfigSpec.ConfigValue cv;
            Object object = entry.getRawValue();
            if (!(object instanceof ForgeConfigSpec.ConfigValue) || !this.isNonDefault(cv = (ForgeConfigSpec.ConfigValue)object)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected ForgeConfigSpec.ValueSpec getValueSpec(String key) {
        Object object = this.valueSpecs.get(key);
        if (object instanceof ForgeConfigSpec.ValueSpec) {
            ForgeConfigSpec.ValueSpec vs = (ForgeConfigSpec.ValueSpec)object;
            return vs;
        }
        return null;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setResetButtonstate(this.isAnyNondefault());
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        if (this.changed) {
            this.saveAction.run();
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    public record Element(@Nullable Component name, @Nullable Component tooltip, @Nullable AbstractWidget widget, @Nullable OptionInstance<?> option) {
        public Element(@Nullable Component name, @Nullable Component tooltip, AbstractWidget widget) {
            this(name, tooltip, widget, null);
        }

        public Element(Component name, Component tooltip, OptionInstance<?> option) {
            this(name, tooltip, null, option);
        }

        public AbstractWidget getWidget(Options options) {
            return this.widget != null ? this.widget : this.option.createButton(options);
        }

        @Nullable
        public Object any() {
            return this.widget != null ? this.widget : this.option;
        }
    }
}

