/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.mixin;

import com.sergo467.disablefog.config.ConfigManager;
import com.sergo467.disablefog.config.IFogConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Inject(method={"doesMobEffectBlockSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableBlindnessSkyBlock(Camera camera, CallbackInfoReturnable<Boolean> cir) {
        IFogConfig config = ConfigManager.getConfig();
        if (!config.isEnabled()) {
            return;
        }
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            cir.setReturnValue((Object)false);
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.hasEffect(MobEffects.BLINDNESS) && config.isBlindnessEnabled()) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (living.hasEffect(MobEffects.DARKNESS) && config.isDarknessEnabled()) {
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }
}

