/*
 * Decompiled with CFR 0.152.
 */
package com.sergo467.disablefog.forge.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.sergo467.disablefog.DisableFogMod;
import com.sergo467.disablefog.config.IConfigManager;
import com.sergo467.disablefog.config.IFogConfig;
import com.sergo467.disablefog.forge.config.ForgeFogConfig;
import com.sergo467.disablefog.forge.gui.screens.ConfigurationScreen;
import java.nio.file.Path;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Logger;

public class ForgeConfigManager
implements IConfigManager {
    private final ForgeConfigSpec spec;
    private final IFogConfig config;
    private final CommentedFileConfig fileConfig;
    private static final Logger LOGGER = DisableFogMod.LOGGER;

    public ForgeConfigManager(ModContainer modContainer) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.config = new ForgeFogConfig(builder);
        this.spec = builder.build();
        this.fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("disablefog.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> new ConfigurationScreen(modContainer, (Screen)parent, this.spec, this::saveConfig, (Component)Component.m_237115_((String)"config.disablefog.title"))));
        this.fileConfig.load();
        this.spec.setConfig((CommentedConfig)this.fileConfig);
        LOGGER.debug("Loaded config from file.");
    }

    @Override
    public IFogConfig getConfig() {
        return this.config;
    }

    public void saveConfig() {
        this.fileConfig.save();
    }
}

